/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDGrammarNode;
import asd.ASDGrammarSuccessor;
import asd.ASDInputException;
import asd.ASDTokenReader;
import asd.ASDWordEntry;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class ASDGrammarReader {
    private static final int DEFAULT_CAPACITY = 101;
    HttpURLConnection urlConnection;
    InputStream urlStream = null;
    private ASDTokenReader reader;
    private String currentToken;
    private boolean includePixelCoords;

    public ASDGrammarReader(String fileName) throws IOException, MalformedURLException, URISyntaxException {
        this(fileName, false);
    }

    public ASDGrammarReader(String fileName, boolean includeCoords) throws IOException, MalformedURLException, URISyntaxException {
        this.includePixelCoords = includeCoords;
        fileName = fileName.trim();
        this.urlConnection = null;
        this.urlStream = null;
        if (fileName.substring(0, 5).equalsIgnoreCase("http:")) {
            URI fileURI = new URI(fileName);
            URL fileURL = fileURI.toURL();
            this.urlConnection = (HttpURLConnection)fileURL.openConnection();
            this.urlStream = this.urlConnection.getInputStream();
            this.reader = new ASDTokenReader(new BufferedReader(new InputStreamReader(this.urlStream)));
        } else {
            this.reader = new ASDTokenReader(new FileReader(fileName));
        }
    }

    public void close() throws IOException {
        if (this.urlConnection != null) {
            this.urlStream.close();
            this.urlConnection.disconnect();
        }
    }

    public HashMap<String, ArrayList<ASDGrammarNode>> getGrammar() throws IOException, ASDInputException {
        ASDWordEntry wordEntry;
        HashMap<String, ArrayList<ASDGrammarNode>> result = new HashMap<String, ArrayList<ASDGrammarNode>>(101);
        while ((wordEntry = this.getWordEntry()) != null) {
            result.put(wordEntry.getWord(), wordEntry.getInstances());
        }
        this.reader.close();
        return result;
    }

    private ASDWordEntry getWordEntry() throws IOException, ASDInputException {
        ASDGrammarNode node;
        ArrayList<ASDGrammarNode> instances = new ArrayList<ASDGrammarNode>();
        this.currentToken = this.reader.getToken();
        if (this.currentToken.length() == 0) {
            return null;
        }
        if (!this.currentToken.equals("(")) {
            this.reader.close();
            throw new ASDInputException("missing ( at beginning of a word entry");
        }
        String word = this.reader.getToken();
        if (word.equals("(") || word.equals(")")) {
            this.reader.close();
            throw new ASDInputException("missing word in a word entry");
        }
        this.currentToken = this.reader.getToken();
        if (!this.currentToken.equals("(")) {
            this.reader.close();
            throw new ASDInputException("missing ( around list of instance entries\nfor word " + word);
        }
        while ((node = this.getInstanceEntry(word)) != null) {
            instances.add(node);
        }
        this.reader.getRightParenthesis();
        return new ASDWordEntry(word, instances);
    }

    private ASDGrammarNode getInstanceEntry(String word) throws IOException, ASDInputException {
        int j;
        char ch;
        boolean begins;
        ArrayList<String> beginsTypes = null;
        ArrayList<ASDGrammarSuccessor> successors = null;
        ArrayList<String> successorTypes = null;
        String phraseType = null;
        String semanticValue = null;
        String semanticAction = null;
        boolean endOfEntry = false;
        short xCoord = 0;
        short yCoord = 0;
        this.currentToken = this.reader.getToken();
        if (this.currentToken.equals(")")) {
            return null;
        }
        String instance = this.reader.getPseudoWord();
        this.currentToken = this.reader.getToken();
        if (this.currentToken.equalsIgnoreCase("nil") || this.currentToken.equalsIgnoreCase("null") || this.currentToken.equalsIgnoreCase("false")) {
            begins = false;
        } else if (this.currentToken.equalsIgnoreCase("t") || this.currentToken.equalsIgnoreCase("true")) {
            begins = true;
            beginsTypes = null;
        } else {
            if (!this.currentToken.equals("(")) {
                this.reader.close();
                throw new ASDInputException("missing parenthesis at start of 'begins' field\nfor word " + word + " instance " + instance);
            }
            this.currentToken = this.reader.getToken();
            if (this.currentToken.equals(")")) {
                begins = false;
            } else {
                begins = true;
                beginsTypes = new ArrayList<String>();
                do {
                    if ((ch = this.currentToken.charAt(0)) == '(' || ch == '\"' || ch == '\'' || Character.isDigit(ch)) {
                        this.reader.close();
                        throw new ASDInputException("expected phrase type name missing in 'begins' field\nfor word " + word + " instance " + instance + "\nInstead found a token beginning with " + ch);
                    }
                    beginsTypes.add(this.currentToken);
                    this.currentToken = this.reader.getToken();
                    if (this.currentToken.length() != 0) continue;
                    this.reader.close();
                    throw new ASDInputException("missing ) at end of 'begins' list\nfor word " + word + " instance " + instance);
                } while (!this.currentToken.equals(")"));
            }
        }
        this.currentToken = this.reader.getToken();
        if (this.currentToken.equals(")") || this.currentToken.length() == 0) {
            this.reader.close();
            throw new ASDInputException("successors field missing\nfor word " + word + " instance " + instance);
        }
        if (this.currentToken.equals("(")) {
            successors = new ArrayList<ASDGrammarSuccessor>();
            this.currentToken = this.reader.getToken();
            while (!this.currentToken.equals(")")) {
                if (!this.currentToken.equals("(")) {
                    this.reader.close();
                    throw new ASDInputException("missing ( at start of a (word instance ... ) entry\nin successors list for word " + word + " instance " + instance);
                }
                ASDGrammarSuccessor successor = new ASDGrammarSuccessor(this.reader.getPseudoWord(), this.reader.getPseudoWord());
                if (this.includePixelCoords) {
                    short xEdgeCoord = 0;
                    short yEdgeCoord = 0;
                    this.currentToken = this.reader.getToken();
                    char ch2 = this.currentToken.charAt(0);
                    if (Character.isDigit(ch2)) {
                        try {
                            xEdgeCoord = Short.parseShort(this.currentToken);
                        }
                        catch (NumberFormatException e) {
                            this.reader.close();
                            throw new ASDInputException("invalid edge pixel coordinate \"" + this.currentToken + "\"\nin successors list for word " + word + " instance " + instance);
                        }
                        this.currentToken = this.reader.getToken();
                        try {
                            yEdgeCoord = Short.parseShort(this.currentToken);
                        }
                        catch (NumberFormatException e) {
                            this.reader.close();
                            throw new ASDInputException("invalid or missing edge pixel coordinate\nin successors list for word " + word + " instance " + instance);
                        }
                        successor.setXCoordinate(xEdgeCoord);
                        successor.setYCoordinate(yEdgeCoord);
                        this.currentToken = this.reader.getToken();
                    }
                } else {
                    for (j = 0; j < 3; ++j) {
                        this.currentToken = this.reader.getToken();
                        if (this.currentToken.equals(")")) break;
                    }
                }
                if (!this.currentToken.equals(")")) {
                    this.reader.close();
                    throw new ASDInputException("missing ) at end of (word instance ... ) entry\nin successors list for word " + word + " instance " + instance);
                }
                successors.add(successor);
                this.currentToken = this.reader.getToken();
            }
        } else {
            phraseType = this.currentToken;
        }
        this.currentToken = this.reader.getToken();
        if (this.currentToken.equals(")")) {
            endOfEntry = true;
            if (successors != null) {
                successorTypes = new ArrayList<String>(0);
            }
        } else if (!this.currentToken.equalsIgnoreCase("t")) {
            successorTypes = new ArrayList();
            if (!this.currentToken.equalsIgnoreCase("nil") && !this.currentToken.equalsIgnoreCase("null")) {
                if (this.currentToken.equals("(")) {
                    this.currentToken = this.reader.getToken();
                    while (!this.currentToken.equals(")")) {
                        ch = this.currentToken.charAt(0);
                        if (ch == '(' || ch == '\"' || ch == '\'' || Character.isDigit(ch)) {
                            this.reader.close();
                            throw new ASDInputException("expected phrase type name missing or starts with digit character in 'successorTypes' field\nfor word " + word + " instance " + instance);
                        }
                        successorTypes.add(this.currentToken);
                        this.currentToken = this.reader.getToken();
                        if (this.currentToken.length() != 0) continue;
                        this.reader.close();
                        throw new ASDInputException("missing )  at end of 'successorTypes' list\nfor word " + word + " instance " + instance);
                    }
                } else if (this.currentToken.length() > 0) {
                    ch = this.currentToken.charAt(0);
                    if (ch != '\"' && ch != '\'') {
                        this.reader.close();
                        throw new ASDInputException("missing quote at beginning of semantic value field\nfor word " + word + " instance " + instance);
                    }
                    semanticValue = this.currentToken.substring(1, this.currentToken.length() - 1);
                }
            }
        }
        if (!endOfEntry) {
            this.currentToken = this.reader.getToken();
            if (!this.currentToken.equals(")")) {
                ch = this.currentToken.charAt(0);
                if (!this.currentToken.equalsIgnoreCase("nil") && !this.currentToken.equalsIgnoreCase("null")) {
                    if (ch != '\"' && ch != '\'') {
                        this.reader.close();
                        throw new ASDInputException("missing quote at beginning of semantic action field\nfor word " + word + " instance " + instance);
                    }
                    semanticAction = this.currentToken.substring(1, this.currentToken.length() - 1);
                }
                if (this.includePixelCoords) {
                    xCoord = 0;
                    yCoord = 0;
                    this.currentToken = this.reader.getToken();
                    if (this.currentToken.length() == 0) {
                        this.reader.close();
                        throw new ASDInputException("unexpected end of grammar file in entry for word " + word + "instance " + instance);
                    }
                    if (Character.isDigit(this.currentToken.charAt(0))) {
                        try {
                            xCoord = Short.parseShort(this.currentToken);
                        }
                        catch (NumberFormatException e) {
                            this.reader.close();
                            throw new ASDInputException("invalid edge pixel coordinate \"" + this.currentToken + "\"\nin entry for word " + word + " instance " + instance);
                        }
                        this.currentToken = this.reader.getToken();
                        if (this.currentToken.length() == 0) {
                            this.reader.close();
                            throw new ASDInputException("unexpected end of grammar file in entry for word " + word + "instance " + instance);
                        }
                        try {
                            yCoord = Short.parseShort(this.currentToken);
                        }
                        catch (NumberFormatException e) {
                            this.reader.close();
                            throw new ASDInputException("invalid or missing pixel coordinate\nin entry for word " + word + " instance " + instance);
                        }
                        this.currentToken = this.reader.getToken();
                    }
                } else {
                    for (j = 0; j < 3; ++j) {
                        this.currentToken = this.reader.getToken();
                        if (this.currentToken.equals(")")) break;
                    }
                }
                if (!this.currentToken.equals(")")) {
                    this.reader.close();
                    throw new ASDInputException("missing ) at end of a word instance entry\nfor word " + word + " instance " + instance);
                }
            }
        }
        ASDGrammarNode result = new ASDGrammarNode(word, instance, begins, beginsTypes, successors, successorTypes, phraseType, semanticValue, semanticAction);
        if (this.includePixelCoords) {
            result.setXCoordinate(xCoord);
            result.setYCoordinate(yCoord);
        }
        return result;
    }
}

