/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDGrammar;
import asd.ASDGrammarNode;
import asd.ASDGrammarSuccessor;
import asd.ASDParseChoice;
import asd.ASDParseState;
import asd.ASDPhraseNode;
import asd.ASDSemantics;
import asd.ASDSubphraseStack;
import asd.ASDSubphraseStackFrame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;

public class ASDParser
implements ASDSemantics {
    public String ANYTHING = "ANYTHING";
    public String CLOSEQUOTE = "\"";
    public String DUMMYWORD = ASDGrammar.DUMMYWORD;
    public String NOADVANCE;
    public String NO = this.NOADVANCE = "B";
    public String NUMBER = "NUMBER";
    public String OPENQUOTE = "\"";
    public String QUIT = "Q";
    public String SPACECHARS = " \t\n\r";
    public String SPECIALCHARS = ",.;:?!$@#%&*()[]{}+=<>/~\\";
    public String STRING = "STRING";
    public String SUCCEED = "S";
    public static String UNKNOWN = "UNKNOWN";
    private static final char INITIAL = 'I';
    private static final char FINAL = 'F';
    private static final char DUMMY = 'D';
    private static final char NONDUMMY = 'N';
    private String stringToBeParsed;
    private Stack<ASDParseState> backstack;
    private ArrayList<String> expectedTypes;
    private ASDGrammar ASDLexicon;
    private int currentParseStepNumber;
    private boolean saveUniquelyParsedSubphrases;
    private ASDParseState state;
    private ASDSemantics semantics;
    private Object application;

    public ASDParser() {
        this.semantics = null;
        this.application = null;
        this.setSaveUniquelyParsedSubphrases(true);
    }

    public ASDParser(Object app) {
        this.semantics = this;
        this.application = app;
        this.setSaveUniquelyParsedSubphrases(true);
    }

    public ASDParser(Object app, ASDSemantics semanticsInstance) {
        this.semantics = semanticsInstance;
        this.application = app;
        this.setSaveUniquelyParsedSubphrases(true);
    }

    public ASDPhraseNode currentNode() {
        return this.state.currentNode;
    }

    public ArrayList<String> expectedTypes() {
        return this.expectedTypes;
    }

    public HashMap<String, Object> features() {
        return this.state.features;
    }

    public Object get(String featureName) {
        return this.state.features.get(featureName);
    }

    public ASDGrammar lexicon() {
        return this.ASDLexicon;
    }

    public ASDPhraseNode phraseStructure() {
        return this.state.phraseStructure;
    }

    public int parseStepNumber() {
        return this.currentParseStepNumber;
    }

    public void set(String featureName, Object value) {
        this.state.features.put(featureName, value);
    }

    public Object valueOf(String featureName) {
        return this.state.features.get(featureName);
    }

    public void initialize(String aString, ArrayList<String> expected) {
        this.stringToBeParsed = aString;
        this.backstack = new Stack();
        this.expectedTypes = expected;
        this.currentParseStepNumber = 0;
        this.state = new ASDParseState();
        this.state.beginning = 0;
        this.state.features = new HashMap(10);
        this.state.currentChoices = null;
        this.state.currentNode = this.state.phraseStructure = this.segment(aString);
        this.state.unique = false;
        this.state.subphraseStack = new ASDSubphraseStack();
        this.state.nextNodeSubphrase = null;
        this.state.advanceCase = (char)32;
    }

    public String advance() {
        if (this.state.currentChoices == null) {
            this.state.currentChoices = this.choices(true, null);
        }
        if (this.state.currentChoices.size() == 0) {
            return this.NOADVANCE;
        }
        ASDParseChoice tryChoice = this.state.currentChoices.remove(0);
        this.state.advanceCase = tryChoice.advanceType;
        if (this.state.currentChoices.size() > 0) {
            this.state.unique = false;
            this.state.nextNodeSubphrase = this.state.currentNode.nextNode() != null ? this.state.currentNode.nextNode().subphrase() : null;
            this.backstack.push((ASDParseState)this.state.clone());
        }
        if (this.state.advanceCase == 'F') {
            String val = this.advanceFinal(tryChoice.completedType);
            if (val == this.NOADVANCE || val == this.QUIT) {
                return val;
            }
        } else {
            String resultOfAction;
            if (this.state.advanceCase == 'N') {
                this.advanceNonDummy(tryChoice.nextNode);
            } else if (this.state.advanceCase == 'D') {
                this.advanceDummy(tryChoice.nextNode);
            } else if (this.state.advanceCase == 'I') {
                this.advanceInitial(tryChoice.nextNode);
            }
            String action = tryChoice.nextNode.semanticAction();
            if (this.semantics != null && action != null && action.length() > 0 && ((resultOfAction = this.semantics.semanticAction(action)) == this.NOADVANCE || resultOfAction == this.QUIT)) {
                return resultOfAction;
            }
        }
        ++this.currentParseStepNumber;
        return this.SUCCEED;
    }

    void advanceDummy(ASDGrammarNode tryNode) {
        ASDPhraseNode dummy = new ASDPhraseNode();
        dummy.setWord(this.DUMMYWORD);
        dummy.setInstance(tryNode);
        dummy.setNextNode(this.state.currentNode.nextNode());
        if (this.backstack.empty()) {
            this.state.currentNode.setNextNode(dummy);
        } else {
            ASDPhraseNode temp = (ASDPhraseNode)this.state.phraseStructure.clone();
            this.state.phraseStructure = temp;
            for (ASDPhraseNode oldNode = this.state.phraseStructure; oldNode != this.state.currentNode; oldNode = oldNode.nextNode()) {
                ASDPhraseNode prev = temp;
                temp = (ASDPhraseNode)oldNode.clone();
                prev.setNextNode(temp);
            }
            temp.setNextNode(dummy);
        }
        this.state.currentNode = dummy;
        this.state.currentChoices = null;
    }

    String advanceFinal(String phraseType) {
        String val = this.state.currentNode.instance().semanticValue();
        Object computedValue = null;
        Object computedString = null;
        computedValue = this.semantics != null && val != null && val.length() > 0 ? this.semantics.semanticValue(val) : val;
        if (computedValue instanceof String && (computedValue == this.NOADVANCE || computedValue == this.QUIT)) {
            return (String)computedValue;
        }
        ASDPhraseNode prev = this.state.phraseStructure;
        for (int j = 1; j < this.state.beginning; ++j) {
            prev = prev.nextNode();
        }
        ASDPhraseNode first = prev.nextNode();
        if (!this.saveUniquelyParsedSubphrases || !this.state.unique && !this.backstack.empty()) {
            ASDPhraseNode oldNode;
            newNode = new ASDPhraseNode();
            newNode.setWord(phraseType);
            newNode.setValue(computedValue);
            newNode.setNextNode(this.state.currentNode.nextNode());
            ASDPhraseNode temp = (ASDPhraseNode)first.clone();
            newNode.setSubphrase(temp);
            for (oldNode = first; oldNode != this.state.currentNode; oldNode = oldNode.nextNode()) {
                prev = temp;
                temp = (ASDPhraseNode)oldNode.clone();
                prev.setNextNode(temp);
            }
            temp.setNextNode(null);
            temp = (ASDPhraseNode)this.state.phraseStructure.clone();
            oldNode = this.state.phraseStructure;
            this.state.phraseStructure = temp;
            while (oldNode.nextNode() != first) {
                oldNode = oldNode.nextNode();
                prev = temp;
                temp = (ASDPhraseNode)oldNode.clone();
                prev.setNextNode(temp);
            }
            temp.setNextNode(newNode);
            this.state.currentNode = temp;
        } else {
            newNode = (ASDPhraseNode)first.clone();
            first.setWord(phraseType);
            first.setInstance(null);
            first.setSubphrase(newNode);
            first.setValue(computedValue);
            first.setNextNode(this.state.currentNode.nextNode());
            if (this.state.currentNode == first) {
                newNode.setNextNode(null);
            } else if (this.backstack.empty()) {
                this.state.currentNode.setNextNode(null);
            } else if (first != this.state.currentNode) {
                ASDPhraseNode oldNode;
                ASDPhraseNode temp = (ASDPhraseNode)oldNode.clone();
                newNode.setNextNode(temp);
                ASDPhraseNode prevTemp = null;
                for (oldNode = newNode.nextNode(); oldNode != this.state.currentNode; oldNode = oldNode.nextNode()) {
                    prevTemp = temp;
                    temp = (ASDPhraseNode)oldNode.clone();
                    prevTemp.setNextNode(temp);
                }
                temp.setNextNode(null);
            }
            this.state.currentNode = prev;
        }
        ASDSubphraseStackFrame popped = (ASDSubphraseStackFrame)this.state.subphraseStack.pop();
        this.state.unique = popped.unique && this.state.unique;
        this.state.features = popped.features;
        this.state.beginning = popped.beginning;
        this.state.currentChoices = this.done() ? null : this.choices(false, null);
        return this.SUCCEED;
    }

    void advanceInitial(ASDGrammarNode tryNode) {
        this.state.currentNode = this.state.currentNode.nextNode();
        this.state.currentNode.setInstance(tryNode);
        this.state.subphraseStack.push(new ASDSubphraseStackFrame(this.state.beginning, this.state.features, this.state.unique));
        this.state.beginning = 0;
        for (ASDPhraseNode node = this.state.phraseStructure; node != this.state.currentNode; node = node.nextNode()) {
            ++this.state.beginning;
        }
        this.state.features = new HashMap(10);
        this.state.unique = !tryNode.hasIncomingEdges() && this.ASDLexicon.uniqueInstance(this.state.currentNode.word());
        this.state.currentChoices = null;
    }

    void advanceNonDummy(ASDGrammarNode tryNode) {
        this.state.currentNode = this.state.currentNode.nextNode();
        this.state.currentNode.setInstance(tryNode);
        this.state.currentChoices = null;
        this.state.unique = this.state.unique && this.ASDLexicon.uniqueInstance(this.state.currentNode.word());
    }

    public boolean backup() {
        if (this.backstack.empty()) {
            return false;
        }
        this.state = this.backstack.pop();
        if (this.state.currentNode.nextNode() != null && this.state.currentNode.nextNode().subphrase() != this.state.nextNodeSubphrase) {
            if (this.state.advanceCase == 'D') {
                ArrayList<ASDGrammarNode> dummyNodes = new ArrayList<ASDGrammarNode>(10);
                for (int j = 0; j < this.state.currentChoices.size(); ++j) {
                    ASDParseChoice choice = this.state.currentChoices.get(j);
                    if (choice.advanceType != 'D') continue;
                    dummyNodes.add(choice.nextNode);
                }
                this.state.currentChoices = this.choices(true, dummyNodes);
            } else {
                for (int j = this.state.currentChoices.size() - 1; j >= 0; --j) {
                    ASDParseChoice choice = this.state.currentChoices.get(j);
                    if (choice.advanceType == 'D') continue;
                    this.state.currentChoices.remove(j);
                }
            }
        }
        ++this.currentParseStepNumber;
        return true;
    }

    public String bracketPhrase() {
        return this.bracketPhrase(this.state.phraseStructure.nextNode());
    }

    public String bracketPhrase(ASDPhraseNode p) {
        if (p.nextNode() == null) {
            if (p.subphrase() == null) {
                return p.word();
            }
            return this.bracketPhrase(p.subphrase());
        }
        int nonDummyCount = 0;
        ASDPhraseNode nonDummyNode = null;
        for (ASDPhraseNode node = p; node != null; node = node.nextNode()) {
            if (node.word().equals(this.DUMMYWORD)) continue;
            if (nonDummyCount == 0) {
                nonDummyCount = 1;
                nonDummyNode = node;
                continue;
            }
            nonDummyCount = 2;
        }
        if (nonDummyCount == 1 && nonDummyNode != null) {
            if (nonDummyNode.subphrase() == null) {
                return nonDummyNode.word();
            }
            return this.bracketPhrase(nonDummyNode.subphrase());
        }
        StringBuilder buffer = new StringBuilder(100);
        int ch = 40;
        for (ASDPhraseNode next = p; next != null; next = next.nextNode()) {
            if (next.subphrase() == null) {
                String nextWord = next.word();
                if (!nextWord.equals(this.DUMMYWORD)) {
                    buffer.append((char)ch);
                    buffer.append(nextWord);
                }
            } else {
                buffer.append((char)ch);
                buffer.append(this.bracketPhrase(next.subphrase()));
            }
            ch = 32;
        }
        buffer.append(')');
        return buffer.toString();
    }

    ArrayList<ASDParseChoice> choices(boolean includeDummies, ArrayList<ASDGrammarNode> dummies) {
        boolean initialsIn = false;
        if (this.state.currentNode == this.state.phraseStructure) {
            ArrayList<ASDParseChoice> result = this.initialsForTypes(this.state.currentNode.nextNode().word(), this.expectedTypes);
            ArrayList<ASDParseChoice> more = this.initialsForTypes(this.ANYTHING, this.expectedTypes);
            for (int j = 0; j < more.size(); ++j) {
                result.add(more.get(j));
            }
            return result;
        }
        ArrayList<ASDParseChoice> result = new ArrayList<ASDParseChoice>(10);
        ASDGrammarNode grammarNode = this.state.currentNode.instance();
        if (grammarNode == null) {
            System.out.println("*** grammarNode unexpectedly null in ASDParser choices");
            System.exit(0);
        }
        if (grammarNode.isFinal()) {
            ASDParseChoice choice = new ASDParseChoice();
            choice.advanceType = (char)70;
            choice.completedType = grammarNode.phraseType();
            result.add(choice);
            return result;
        }
        ASDPhraseNode next = this.state.currentNode.nextNode();
        ArrayList<String> types = grammarNode.successorTypes();
        ArrayList<ASDGrammarSuccessor> successors = grammarNode.successors();
        if (successors == null) {
            System.out.println("*** successors unexpectedly null for ASD grammar entry for word\n'" + grammarNode.word() + "' and instance " + grammarNode.instance());
            System.exit(0);
        }
        for (int j = 0; j < successors.size(); ++j) {
            int k;
            ASDGrammarNode successorState;
            ASDGrammarSuccessor successor = successors.get(j);
            if (successor.getWord().equals(this.DUMMYWORD)) {
                if (!includeDummies) continue;
                successorState = this.ASDLexicon.lookupInstance(successor);
                boolean includeState = false;
                if (dummies == null) {
                    includeState = true;
                } else {
                    for (int k2 = 0; !includeState && k2 < dummies.size(); ++k2) {
                        if (successorState != dummies.get(k2)) continue;
                        includeState = true;
                    }
                }
                if (!includeState) continue;
                ASDParseChoice choice = new ASDParseChoice();
                choice.advanceType = (char)68;
                choice.nextNode = successorState;
                result.add(choice);
                continue;
            }
            if (next == null) continue;
            if (next.word().equals(successor.getWord()) || successor.getWord().equals(this.ANYTHING)) {
                successorState = this.ASDLexicon.lookupInstance(successor);
                ASDParseChoice choice = new ASDParseChoice();
                choice.advanceType = (char)78;
                choice.nextNode = successorState;
                result.add(choice);
            }
            if (initialsIn) continue;
            ArrayList<ASDParseChoice> initialsToAdd = null;
            ArrayList<ASDParseChoice> moreInitialsToAdd = null;
            if (types == null) {
                initialsIn = true;
                initialsToAdd = this.initialsForTypes(next.word(), null);
                moreInitialsToAdd = this.initialsForTypes(this.ANYTHING, null);
            } else {
                boolean typeMatch = false;
                for (int k3 = 0; !typeMatch && k3 < types.size(); ++k3) {
                    if (!successor.getWord().equals(types.get(k3))) continue;
                    typeMatch = true;
                }
                if (typeMatch) {
                    initialsToAdd = this.initialsForTypes(next.word(), types);
                    moreInitialsToAdd = this.initialsForTypes(this.ANYTHING, types);
                    initialsIn = true;
                }
            }
            if (initialsToAdd != null) {
                for (k = 0; k < initialsToAdd.size(); ++k) {
                    result.add(initialsToAdd.get(k));
                }
            }
            if (moreInitialsToAdd == null) continue;
            for (k = 0; k < moreInitialsToAdd.size(); ++k) {
                result.add(moreInitialsToAdd.get(k));
            }
        }
        return result;
    }

    public boolean done() {
        boolean result = false;
        if (this.state.currentNode == this.state.phraseStructure && this.state.phraseStructure.nextNode().nextNode() == null) {
            int n = this.expectedTypes.size();
            String word = this.state.phraseStructure.nextNode().word();
            for (int j = 0; !result && j < n; ++j) {
                if (!this.expectedTypes.get(j).equals(word)) continue;
                result = true;
            }
        }
        return result;
    }

    ArrayList<ASDParseChoice> initialsForTypes(String aWord, ArrayList<String> expected) {
        ArrayList<ASDParseChoice> result = new ArrayList<ASDParseChoice>(5);
        ArrayList<ASDGrammarNode> wordEntry = this.ASDLexicon.lookupWord(aWord);
        if (wordEntry == null && !aWord.equals(this.ANYTHING)) {
            boolean isNumeric = true;
            try {
                Integer.parseInt(aWord);
            }
            catch (NumberFormatException e) {
                isNumeric = false;
            }
            wordEntry = isNumeric ? this.ASDLexicon.lookupWord(this.NUMBER) : (aWord.indexOf(this.OPENQUOTE) == 0 ? this.ASDLexicon.lookupWord(this.STRING) : this.ASDLexicon.lookupWord(UNKNOWN));
        }
        if (wordEntry == null) {
            return result;
        }
        for (int index = 0; index < wordEntry.size(); ++index) {
            ASDParseChoice choice;
            ASDGrammarNode wordInstance = wordEntry.get(index);
            if (!wordInstance.isInitial()) continue;
            ArrayList<String> beginsTypes = wordInstance.beginsTypes();
            if (beginsTypes == null) {
                choice = new ASDParseChoice();
                choice.advanceType = (char)73;
                choice.nextNode = wordInstance;
                result.add(choice);
                continue;
            }
            boolean noMatch = true;
            if (expected == null) {
                noMatch = false;
            } else {
                for (int expectedIndex = 0; noMatch && expectedIndex < expected.size(); ++expectedIndex) {
                    String expectedType = expected.get(expectedIndex);
                    for (int beginsIndex = 0; noMatch && beginsIndex < beginsTypes.size(); ++beginsIndex) {
                        if (!expectedType.equals(beginsTypes.get(beginsIndex))) continue;
                        noMatch = false;
                    }
                }
            }
            if (noMatch) continue;
            choice = new ASDParseChoice();
            choice.advanceType = (char)73;
            choice.nextNode = wordInstance;
            result.add(choice);
        }
        return result;
    }

    public boolean parse() {
        String advanceResult;
        while ((advanceResult = this.advance()) != this.QUIT) {
            if (advanceResult == this.SUCCEED) {
                if (!this.done()) continue;
                return true;
            }
            if (advanceResult == this.NOADVANCE) {
                if (this.backup()) continue;
                return false;
            }
            System.out.println("Invalid result of ASDParser advance():" + advanceResult);
            System.exit(0);
        }
        return false;
    }

    public int parse(int maxSteps) {
        int steps;
        for (steps = 0; steps < maxSteps; ++steps) {
            String advanceResult = this.advance();
            if (advanceResult == this.QUIT) {
                return -steps;
            }
            if (advanceResult == this.SUCCEED) {
                if (!this.done()) continue;
                return steps;
            }
            if (advanceResult == this.NOADVANCE) {
                if (this.backup()) continue;
                return -steps;
            }
            System.out.println("Invalid result of ASDParser advance(maxSteps):" + advanceResult);
            System.exit(0);
        }
        return -steps;
    }

    public void raiseFeatures() {
        if (!(this.currentNode().value() instanceof Map)) {
            return;
        }
        Set entries = ((Map)this.currentNode().value()).entrySet();
        for (Map.Entry entry : entries) {
            this.set((String)entry.getKey(), entry.getValue());
        }
    }

    public String raiseFeaturesChecking() {
        if (!(this.currentNode().value() instanceof Map)) {
            return this.QUIT;
        }
        Set entries = ((Map)this.currentNode().value()).entrySet();
        for (Map.Entry entry : entries) {
            String feature = (String)entry.getKey();
            Object existingValue = this.valueOf(feature);
            if (existingValue != null && !existingValue.equals(entry.getValue())) {
                return this.NOADVANCE;
            }
            this.set((String)entry.getKey(), entry.getValue());
        }
        return this.SUCCEED;
    }

    ASDPhraseNode segment(String aString) {
        ASDPhraseNode phraseStructure = new ASDPhraseNode();
        phraseStructure.setWord("nil");
        ASDPhraseNode lastNode = phraseStructure;
        boolean inString = false;
        String lastToken = "";
        Object quotedString = null;
        StringTokenizer tokenizer = new StringTokenizer(aString, this.SPACECHARS + this.SPECIALCHARS + this.OPENQUOTE + this.CLOSEQUOTE, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (inString) {
                if (token.length() == 0) {
                    token = " ";
                    if (!lastToken.equals(" ")) {
                        quotedString = (String)quotedString + token;
                    }
                } else {
                    quotedString = quotedString + token;
                }
                if (token.equals(this.CLOSEQUOTE)) {
                    inString = false;
                    newNode = new ASDPhraseNode();
                    newNode.setWord((String)quotedString);
                    lastNode.setNextNode(newNode);
                    lastNode = newNode;
                }
            } else if (token.length() > 0) {
                if (token.equals(this.OPENQUOTE)) {
                    inString = true;
                    quotedString = token;
                } else {
                    newNode = new ASDPhraseNode();
                    newNode.setWord(token);
                    lastNode.setNextNode(newNode);
                    lastNode = newNode;
                }
            }
            lastToken = token;
        }
        return phraseStructure;
    }

    @Override
    public String semanticAction(String action) {
        Method m = null;
        try {
            m = this.application.getClass().getMethod(action, null);
        }
        catch (NoSuchMethodException e) {
            System.out.println("Error invoking method " + action);
            return null;
        }
        if (m != null) {
            try {
                return (String)m.invoke(this.application, (Object[])null);
            }
            catch (InvocationTargetException e) {
                System.out.println("InvocationTargetException invoking method \"" + action + "\"");
                return null;
            }
            catch (IllegalAccessException e) {
                System.out.println("IllegalAccessException invoking method " + action);
                return null;
            }
        }
        return null;
    }

    @Override
    public Object semanticValue(String value) {
        boolean numericValue = true;
        long integerValue = 0L;
        try {
            integerValue = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            numericValue = false;
        }
        if (numericValue) {
            try {
                return this.valueOf(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (value.length() >= 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            return value.substring(1, value.length() - 1);
        }
        Method m = null;
        try {
            m = this.application.getClass().getMethod(value, null);
        }
        catch (NoSuchMethodException e) {
            System.out.println("No such method found: " + value);
            return null;
        }
        if (m != null) {
            try {
                return m.invoke(this.application, (Object[])null);
            }
            catch (InvocationTargetException e) {
                System.out.println("InvocationTargetException invoking method \"" + value + "\"");
                return null;
            }
            catch (IllegalAccessException e) {
                System.out.println("IllegalAccessException invoking method " + value);
                return null;
            }
        }
        return null;
    }

    public void setANYTHING(String newValue) {
        this.ANYTHING = newValue;
    }

    public void setCLOSEQUOTE(String newValue) {
        this.CLOSEQUOTE = newValue;
    }

    public void setNOADVANCE(String newValue) {
        this.NO = this.NOADVANCE = newValue;
    }

    public void setDUMMYWORD(String newValue) {
        this.DUMMYWORD = newValue;
    }

    public void setNUMBER(String newValue) {
        this.NUMBER = newValue;
    }

    public void setOPENQUOTE(String newValue) {
        this.OPENQUOTE = newValue;
    }

    public void setQUIT(String newValue) {
        this.QUIT = newValue;
    }

    public void setSaveUniquelyParsedSubphrases(boolean save) {
        this.saveUniquelyParsedSubphrases = save;
    }

    public void setSPACECHARS(String newValue) {
        this.SPACECHARS = newValue;
    }

    public void setSPECIALCHARS(String newValue) {
        this.SPECIALCHARS = newValue;
    }

    public void setSTRING(String newValue) {
        this.STRING = newValue;
    }

    public void setSUCCEED(String newValue) {
        this.SUCCEED = newValue;
    }

    public void setUNKNOWN(String newValue) {
        UNKNOWN = newValue;
    }

    public void showTree() {
        this.state.phraseStructure.showTree(this.state.currentNode);
    }

    public void stepParse(int maxSteps) {
        int steps = 0;
        BufferedReader keyboard = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("\nInitial phrase structure:");
        this.showTree();
        block4: while (steps < maxSteps) {
            System.out.print("\nStep " + ++steps + ": ");
            String advanceResult = this.advance();
            if (advanceResult == this.QUIT) {
                System.out.println("parse quit with structure:");
                this.showTree();
                return;
            }
            if (advanceResult == this.SUCCEED) {
                String in;
                System.out.println("parse advanced to:");
                this.showTree();
                if (this.done()) {
                    System.out.println("\nSuccessful parse in " + steps + " steps, to:");
                    this.showTree();
                    in = null;
                    do {
                        System.out.print("\nDo you want to try for an alternative parse (y or n)? ");
                        try {
                            in = keyboard.readLine();
                        }
                        catch (IOException e) {
                            System.out.println("IOException occurred in ASDParser stepParse");
                            System.exit(0);
                        }
                        if (in.equalsIgnoreCase("y")) continue block4;
                    } while (!in.equalsIgnoreCase("n"));
                    return;
                }
                System.out.print("\nPress Enter key to advance the parse. ");
                try {
                    in = keyboard.readLine();
                }
                catch (IOException e) {
                    System.out.println("IOException occurred in ASDParser stepParse");
                    System.exit(0);
                }
                continue;
            }
            if (advanceResult == this.NOADVANCE) {
                if (this.backup()) {
                    System.out.println("parse backed up to:");
                    this.showTree();
                    continue;
                }
                System.out.println("failed parse in " + steps + " steps, left with:");
                this.showTree();
                return;
            }
            System.out.println("Invalid result of ASDParser advance(maxSteps):" + advanceResult);
            return;
        }
    }

    public boolean useGrammar(ASDGrammar grammar) {
        if (grammar == null) {
            return false;
        }
        this.ASDLexicon = grammar;
        if (!this.ASDLexicon.nodesWithIncomingEdgesMarked()) {
            this.ASDLexicon.markNodesWithIncomingEdges();
        }
        return true;
    }

    public boolean useGrammar(String fileName) {
        try {
            this.ASDLexicon = new ASDGrammar(fileName, false, true);
        }
        catch (IOException e) {
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }
}

