/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDParser;
import asd.ASDPhraseNode;
import asd.PopupListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ASDTester {
    static final int MAXSTEPS = 10000;
    static final String VERSION = "1.06";
    static final Font FONT = new Font("Monospaced", 0, 12);
    private ASDTesterWindow window = new ASDTesterWindow(this);
    private ASDParser parser;
    private boolean grammarLoaded = false;
    private boolean phraseInitialized = false;
    private ArrayList<String> expectedTypes;
    private int steps = 0;
    private int stepsSincePause = 0;
    private int stepsThisTry = 0;
    private int backupSteps = 0;
    private int backupStepsThisTry = 0;
    private int maximumSteps = 10000;
    private String utterance;

    public static void main(String[] args) {
        int maxSteps = 0;
        maxSteps = args.length == 0 ? 10000 : Integer.parseInt(args[0]);
        ASDTester thisTester = new ASDTester(maxSteps);
    }

    ASDTester(int maxSteps) {
        this.window.setTitle("Augmented Syntax Diagram Tester - version 1.06");
        this.window.setVisible(true);
        this.maximumSteps = maxSteps;
        this.parser = new ASDParser();
    }

    void advance() {
        if (!this.grammarLoaded) {
            JOptionPane.showMessageDialog(this.window, "No grammar file is currently loaded.");
            this.window.clearGrammarFileNameField();
            return;
        }
        if (this.utterance == null || this.utterance.equals("")) {
            return;
        }
        String advanceResult = this.parser.advance();
        if (advanceResult.equals(this.parser.QUIT)) {
            this.window.getOutputPane().append("\nParse quit after " + this.stepsThisTry + " new and " + this.steps + " total advance steps,\nand " + this.backupStepsThisTry + " new and " + this.backupSteps + " total backup steps, leaving structure:\n");
            this.showPhraseStructure();
            this.stepsThisTry = 0;
            this.backupStepsThisTry = 0;
            this.stepsSincePause = 0;
        } else if (advanceResult.equals(this.parser.SUCCEED)) {
            ++this.steps;
            ++this.stepsThisTry;
            ++this.stepsSincePause;
            this.window.getOutputPane().append("\n" + this.steps + " - parse advanced to:\n");
            this.showPhraseStructure();
            if (this.parser.done()) {
                this.window.getOutputPane().append("\nSuccessful parse after " + this.stepsThisTry + " new and " + this.steps + " total advance steps,\nand " + this.backupStepsThisTry + " new and " + this.backupSteps + " total backup steps.\n");
                this.stepsThisTry = 0;
                this.backupStepsThisTry = 0;
                this.stepsSincePause = 0;
            }
        } else if (advanceResult.equals(this.parser.NOADVANCE)) {
            if (this.parser.backup()) {
                ++this.backupSteps;
                ++this.backupStepsThisTry;
                this.window.getOutputPane().append("\nparse backed up to:\n");
                this.showPhraseStructure();
            } else {
                this.window.getOutputPane().append("\nParse failed after " + this.stepsThisTry + " new and " + this.steps + " total advance steps,\nand " + this.backupStepsThisTry + " new and " + this.backupSteps + " total backup steps, leaving structure:\n");
                this.showPhraseStructure();
                this.stepsThisTry = 0;
                this.backupStepsThisTry = 0;
                this.stepsSincePause = 0;
            }
        } else {
            this.window.getOutputPane().append("\nInvalid result of ASDParser advance(maxSteps):" + advanceResult + "\n");
        }
    }

    void allParses() {
        if (!this.grammarLoaded) {
            JOptionPane.showMessageDialog(this.window, "No grammar file is currently loaded.");
            this.window.clearGrammarFileNameField();
            return;
        }
        if (this.utterance == null || this.utterance.equals("")) {
            return;
        }
        while (this.completeParse()) {
        }
    }

    boolean completeParse() {
        if (!this.grammarLoaded) {
            JOptionPane.showMessageDialog(this.window, "No grammar file is currently loaded.");
            this.window.clearGrammarFileNameField();
            return false;
        }
        if (this.utterance == null || this.utterance.equals("")) {
            return false;
        }
        while (this.stepsSincePause < this.maximumSteps) {
            String advanceResult = this.parser.advance();
            if (advanceResult.equals(this.parser.QUIT)) {
                this.window.getOutputPane().append("\nParse quit after " + this.stepsThisTry + " new and " + this.steps + " total advance steps,\nand " + this.backupStepsThisTry + " new and " + this.backupSteps + " total backup steps, leaving structure:\n");
                this.showPhraseStructure();
                this.stepsThisTry = 0;
                this.backupStepsThisTry = 0;
                this.stepsSincePause = 0;
                return false;
            }
            if (advanceResult.equals(this.parser.SUCCEED)) {
                ++this.steps;
                ++this.stepsThisTry;
                ++this.stepsSincePause;
                if (!this.parser.done()) continue;
                this.window.getOutputPane().append("\nSuccessful parse in " + this.stepsThisTry + " new and " + this.steps + " total advance steps,\nand " + this.backupStepsThisTry + " new and " + this.backupSteps + " total backup steps.\n");
                this.showPhraseStructure();
                this.stepsThisTry = 0;
                this.backupStepsThisTry = 0;
                this.stepsSincePause = 0;
                return true;
            }
            if (advanceResult.equals(this.parser.NOADVANCE)) {
                if (this.parser.backup()) {
                    ++this.backupSteps;
                    ++this.backupStepsThisTry;
                    continue;
                }
                this.window.getOutputPane().append("\nParse failed after " + this.stepsThisTry + " new and " + this.steps + " total advance steps,\nand " + this.backupStepsThisTry + " new and " + this.backupSteps + " total backup steps, leaving structure:\n");
                this.showPhraseStructure();
                this.stepsThisTry = 0;
                this.backupStepsThisTry = 0;
                this.stepsSincePause = 0;
                return false;
            }
            this.window.getOutputPane().append("Invalid result of ASDParser advance(maxSteps):" + this.steps);
            return false;
        }
        this.window.getOutputPane().append("\nAttempt to Complete parse or to find All Remaining parses \npaused after advance step " + this.steps + ", " + this.maximumSteps + " advance steps since start or last pause.\nIt can be resumed by menu selection.\n");
        this.stepsSincePause = 0;
        return false;
    }

    ASDParser getParser() {
        return this.parser;
    }

    boolean initializeParse() {
        if (!this.grammarLoaded) {
            JOptionPane.showMessageDialog(this.window, "No grammar file is currently loaded.");
            this.window.clearGrammarFileNameField();
            return false;
        }
        if (this.utterance == null || this.utterance.length() == 0) {
            JOptionPane.showMessageDialog(this.window, "The phrase to be parsed must not be empty.");
            return false;
        }
        if (this.expectedTypes == null || this.expectedTypes.size() == 0) {
            JOptionPane.showMessageDialog(this.window, "The list of expected phrase types must not be empty.");
            return false;
        }
        this.parser.initialize(this.utterance, this.expectedTypes);
        this.phraseInitialized = true;
        this.steps = 0;
        this.stepsThisTry = 0;
        this.stepsSincePause = 0;
        this.backupSteps = 0;
        this.backupStepsThisTry = 0;
        this.window.getOutputPane().append("\nInitialized phrase structure:\n");
        this.showPhraseStructure();
        return true;
    }

    void setExpectedTypeList(String types) {
        if (!this.grammarLoaded) {
            JOptionPane.showMessageDialog(this.window, "No grammar file is currently loaded.");
            this.window.clearGrammarFileNameField();
            this.window.clearExpectedTypeListField();
            return;
        }
        this.expectedTypes = new ArrayList();
        if (types == null || types.length() == 0) {
            JOptionPane.showMessageDialog(this.window, "The list of expected phrase types must not be empty.");
            return;
        }
        StringTokenizer st = new StringTokenizer(types);
        while (st.hasMoreTokens()) {
            this.expectedTypes.add(st.nextToken());
        }
        if (this.utterance != null && this.utterance.length() > 0) {
            this.initializeParse();
        }
    }

    void setHyphenAsSpecialCharacter(boolean useHyphen) {
        String special = this.parser.SPECIALCHARS;
        if (useHyphen && special.indexOf("-") < 0) {
            this.parser.setSPECIALCHARS("-" + special);
        } else if (!useHyphen) {
            int hyphenPos = special.indexOf("-");
            if (hyphenPos < 0) {
                return;
            }
            this.parser.setSPECIALCHARS(special.substring(0, hyphenPos) + special.substring(hyphenPos + 1));
        }
        if (this.grammarLoaded && this.utterance != null && this.utterance.length() > 0) {
            this.initializeParse();
        }
    }

    void setSaveUniquelyParsedSubphrases(boolean save) {
        this.parser.setSaveUniquelyParsedSubphrases(save);
    }

    void setUtterance(String newUtterance) {
        if (!this.grammarLoaded) {
            JOptionPane.showMessageDialog(this.window, "No grammar file is currently loaded.");
            this.window.clearGrammarFileNameField();
            this.window.clearUtteranceField();
            return;
        }
        this.utterance = newUtterance;
        if (this.utterance == null || this.utterance.length() == 0) {
            JOptionPane.showMessageDialog(this.window, "The phrase to be parsed must not be empty.");
            return;
        }
        this.initializeParse();
    }

    void setUtteranceNull() {
        this.utterance = null;
    }

    void showAboutInfo() {
        JOptionPane.showMessageDialog(this.window, "ASDTester version 1.06\nAuthor: James A. Mason\nEmail: jmason@yorku.ca\nhttp://www.yorku.ca/jmason/");
    }

    void showBracketedPhrase() {
        if (this.phraseInitialized) {
            this.window.getOutputPane().append("\nAfter advance step " + this.steps + ":");
            this.window.getOutputPane().append("\n" + this.parser.bracketPhrase() + "\n");
        } else {
            JOptionPane.showMessageDialog(this.window, "No phrase has been initialized.");
        }
    }

    void showPhraseStructure() {
        if (!this.phraseInitialized) {
            JOptionPane.showMessageDialog(this.window, "No phrase has been initialized.");
        } else {
            this.window.getOutputPane().append("\n" + this.parser.bracketPhrase());
            ASDPhraseNode head = this.parser.phraseStructure();
            ASDPhraseNode currentNode = this.parser.currentNode();
            this.window.showTree(head, currentNode);
        }
    }

    void showTree() {
        if (this.phraseInitialized) {
            this.window.getOutputPane().append("\nAfter advance step " + this.steps + ":");
            ASDPhraseNode head = this.parser.phraseStructure();
            ASDPhraseNode currentNode = this.parser.currentNode();
            this.window.showTree(head, currentNode);
        } else {
            JOptionPane.showMessageDialog(this.window, "No phrase has been initialized.");
        }
    }

    boolean useGrammar(String fileName) {
        if (this.parser.useGrammar(fileName)) {
            this.grammarLoaded = true;
            return true;
        }
        JOptionPane.showMessageDialog(this.window, "Grammar file with that name could not be loaded.");
        this.grammarLoaded = false;
        this.expectedTypes = null;
        this.utterance = null;
        return false;
    }

    private class ASDTesterWindow
    extends JFrame {
        static final int DEFAULT_WIDTH = 800;
        static final int DEFAULT_HEIGHT = 600;
        private ASDTester tester;
        private JTextField grammarFileNameField;
        private JTextField expectedTypeListField;
        private JTextField utteranceField;
        private JCheckBox hyphenAsLexicalItemBox;
        private JCheckBox uniquelyParsedSubphrasesBox;
        private JPanel middlePanel;
        private JTextArea outputPane;

        ASDTesterWindow(ASDTester givenTester) {
            this.tester = givenTester;
            this.grammarFileNameField = new JTextField(40);
            this.grammarFileNameField.addActionListener(new GrammarFileNameFieldListener(ASDTester.this, this));
            this.expectedTypeListField = new JTextField(40);
            this.expectedTypeListField.addActionListener(new ExpectedTypeListFieldListener(ASDTester.this, this));
            this.utteranceField = new JTextField(40);
            this.utteranceField.addActionListener(new UtteranceFieldListener(ASDTester.this, this));
            this.hyphenAsLexicalItemBox = new JCheckBox("Treat hyphens (-) in words as separate lexical items");
            this.hyphenAsLexicalItemBox.addActionListener(new HyphenAsLexicalItemBoxListener(ASDTester.this, this));
            this.hyphenAsLexicalItemBox.setSelected(false);
            this.uniquelyParsedSubphrasesBox = new JCheckBox("Save all uniquely-parsed subphrases");
            this.uniquelyParsedSubphrasesBox.addActionListener(new UniquelyParsedSubphrasesBoxListener(ASDTester.this, this));
            this.uniquelyParsedSubphrasesBox.setSelected(true);
            JPanel pane = new JPanel();
            pane.setLayout(new BoxLayout(pane, 1));
            pane.add(new LabeledTextField("Grammar file:    ", this.grammarFileNameField));
            pane.add(new LabeledTextField("Expected types:", this.expectedTypeListField));
            pane.add(new LabeledTextField("Phrase parsed: ", this.utteranceField));
            this.middlePanel = new JPanel();
            this.middlePanel.add(this.hyphenAsLexicalItemBox);
            this.middlePanel.add(this.uniquelyParsedSubphrasesBox);
            this.middlePanel.setMaximumSize(new Dimension(800, 20));
            pane.add(this.middlePanel);
            this.outputPane = new JTextArea();
            this.outputPane.setMinimumSize(new Dimension(800, 600));
            this.outputPane.setFont(FONT);
            OutputPaneMenu menu = new OutputPaneMenu(this.outputPane, this.tester);
            PopupListener popupListener = new PopupListener(menu);
            this.outputPane.addMouseListener(popupListener);
            pane.add(new JScrollPane(this.outputPane));
            this.getContentPane().add((Component)pane, "Center");
            this.addWindowListener(new WindowCloser(ASDTester.this, this));
            this.setDefaultCloseOperation(2);
            this.setSize(800, 600);
            JMenuBar menuBar = new JMenuBar();
            this.setJMenuBar(menuBar);
            ActionMenu aMenu = new ActionMenu(this);
            aMenu.setMnemonic(65);
            menuBar.add(aMenu);
            HelpMenu hMenu = new HelpMenu(this);
            hMenu.setMnemonic(72);
            menuBar.add(hMenu);
        }

        void clearExpectedTypeListField() {
            this.expectedTypeListField.setText("");
        }

        void clearGrammarFileNameField() {
            this.grammarFileNameField.setText("");
        }

        void clearUtteranceField() {
            this.utteranceField.setText("");
        }

        JTextField getExpectedTypeListField() {
            return this.expectedTypeListField;
        }

        JTextField getGrammarFileNameField() {
            return this.grammarFileNameField;
        }

        JTextArea getOutputPane() {
            return this.outputPane;
        }

        ASDTester getTester() {
            return this.tester;
        }

        JTextField getUtteranceField() {
            return this.utteranceField;
        }

        void grammarFileNameFieldChanged() {
            this.clearUtteranceField();
            this.tester.setUtteranceNull();
            if (!this.tester.useGrammar(this.grammarFileNameField.getText().trim())) {
                this.clearExpectedTypeListField();
                return;
            }
            Set<String> expectedTypes = this.tester.getParser().lexicon().phraseTypes();
            Object expected = "";
            for (String type : expectedTypes) {
                expected = (String)expected + type + " ";
            }
            this.expectedTypeListField.setText((String)expected);
            this.expectedTypeListFieldChanged();
        }

        void expectedTypeListFieldChanged() {
            this.tester.setExpectedTypeList(this.expectedTypeListField.getText().trim());
        }

        void hyphenAsLexicalItemBoxChanged() {
            this.tester.setHyphenAsSpecialCharacter(this.hyphenAsLexicalItemBox.isSelected());
        }

        void uniquelyParsedSubphrasesBoxChanged() {
            this.tester.setSaveUniquelyParsedSubphrases(this.uniquelyParsedSubphrasesBox.isSelected());
        }

        void utteranceFieldChanged() {
            this.tester.setUtterance(this.utteranceField.getText().trim());
        }

        void showTree(ASDPhraseNode head, ASDPhraseNode currentNode) {
            this.showTreeMark(head, "", currentNode);
            this.outputPane.append("\n");
        }

        private void showTreeMark(ASDPhraseNode givenNode, String indentString, ASDPhraseNode markNode) {
            this.outputPane.append("\n");
            if (givenNode == markNode) {
                this.outputPane.append("*->");
            } else {
                this.outputPane.append("   ");
            }
            this.outputPane.append(indentString + givenNode.word() + " ");
            if (givenNode.instance() != null) {
                this.outputPane.append(givenNode.instance().instance());
            } else {
                this.outputPane.append("nil");
            }
            if (givenNode.subphrase() != null) {
                this.showTreeMark(givenNode.subphrase(), indentString + "   ", markNode);
            }
            if (givenNode.nextNode() != null) {
                this.showTreeMark(givenNode.nextNode(), indentString, markNode);
            }
        }
    }

    class HelpMenu
    extends JMenu
    implements ActionListener {
        ASDTester tester;
        ASDTesterWindow window;

        HelpMenu(ASDTesterWindow w) {
            super("Help");
            this.window = w;
            this.tester = this.window.getTester();
            JMenuItem aboutMenuItem = new JMenuItem("About ASDTester", 65);
            this.add(aboutMenuItem);
            aboutMenuItem.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("About ASDTester")) {
                this.tester.showAboutInfo();
            }
        }
    }

    class ActionMenu
    extends JMenu
    implements ActionListener {
        ASDTester tester;
        ASDTesterWindow window;
        JTextArea outputPane;

        ActionMenu(ASDTesterWindow w) {
            super("Action");
            this.window = w;
            this.tester = this.window.getTester();
            this.outputPane = this.window.getOutputPane();
            JMenuItem initializeMenuItem = new JMenuItem("Initialize parse", 73);
            initializeMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 8));
            this.add(initializeMenuItem);
            initializeMenuItem.addActionListener(this);
            JMenuItem advanceMenuItem = new JMenuItem("Advance one Step", 83);
            advanceMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 8));
            this.add(advanceMenuItem);
            advanceMenuItem.addActionListener(this);
            JMenuItem completeParseMenuItem = new JMenuItem("Complete Parse", 80);
            completeParseMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 8));
            this.add(completeParseMenuItem);
            completeParseMenuItem.addActionListener(this);
            JMenuItem remainingMenuItem = new JMenuItem("All Remaining Parses", 82);
            remainingMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 8));
            remainingMenuItem.addActionListener(this);
            this.add(remainingMenuItem);
            this.addSeparator();
            JMenuItem showBracketsMenuItem = new JMenuItem("Show bracketed phrase", 66);
            showBracketsMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 8));
            showBracketsMenuItem.addActionListener(this);
            this.add(showBracketsMenuItem);
            JMenuItem showTreeMenuItem = new JMenuItem("Show phrase structure tree", 84);
            showTreeMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 8));
            showTreeMenuItem.addActionListener(this);
            this.add(showTreeMenuItem);
            this.addSeparator();
            JMenuItem copyAllMenuItem = new JMenuItem("Select All of output pane", 65);
            copyAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            copyAllMenuItem.addActionListener(this);
            this.add(copyAllMenuItem);
            JMenuItem copySelectionMenuItem = new JMenuItem("Copy Selection", 67);
            copySelectionMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            copySelectionMenuItem.addActionListener(this);
            this.add(copySelectionMenuItem);
            this.addSeparator();
            JMenuItem eraseMenuItem = new JMenuItem("Erase output pane", 69);
            eraseMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
            eraseMenuItem.addActionListener(this);
            this.add(eraseMenuItem);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("Initialize parse")) {
                this.tester.initializeParse();
            } else if (command.equals("Advance one Step")) {
                this.tester.advance();
            } else if (command.equals("Complete Parse")) {
                this.tester.completeParse();
            } else if (command.equals("All Remaining Parses")) {
                this.tester.allParses();
            } else if (command.equals("Show bracketed phrase")) {
                this.tester.showBracketedPhrase();
            } else if (command.equals("Show phrase structure tree")) {
                this.tester.showTree();
            } else if (command.equals("Select All of output pane")) {
                this.outputPane.requestFocus();
                this.outputPane.selectAll();
            } else if (command.equals("Copy Selection")) {
                this.outputPane.copy();
            } else if (command.equals("Erase output pane")) {
                this.outputPane.setText("");
            }
        }
    }

    private class OutputPaneMenu
    extends JPopupMenu
    implements ActionListener {
        ASDTester tester;
        JTextArea pane;

        OutputPaneMenu(JTextArea p, ASDTester t) {
            this.pane = p;
            this.tester = t;
            this.setInvoker(this.pane);
            JMenuItem initializeItem = new JMenuItem("Initialize parse");
            initializeItem.addActionListener(this);
            this.add(initializeItem);
            this.addSeparator();
            JMenuItem advanceItem = new JMenuItem("Advance one step");
            advanceItem.addActionListener(this);
            this.add(advanceItem);
            JMenuItem completeParseItem = new JMenuItem("Complete parse");
            completeParseItem.addActionListener(this);
            this.add(completeParseItem);
            JMenuItem allParsesItem = new JMenuItem("All remaining parses");
            allParsesItem.addActionListener(this);
            this.add(allParsesItem);
            this.addSeparator();
            JMenuItem showBracketsItem = new JMenuItem("Show bracketed phrase");
            showBracketsItem.addActionListener(this);
            this.add(showBracketsItem);
            JMenuItem showTreeItem = new JMenuItem("Show phrase structure tree");
            showTreeItem.addActionListener(this);
            this.add(showTreeItem);
            this.addSeparator();
            JMenuItem selectAllItem = new JMenuItem("Select all");
            selectAllItem.addActionListener(this);
            this.add(selectAllItem);
            JMenuItem copyItem = new JMenuItem("Copy selection");
            copyItem.addActionListener(this);
            this.add(copyItem);
            this.addSeparator();
            JMenuItem clearItem = new JMenuItem("Erase output pane");
            clearItem.addActionListener(this);
            this.add(clearItem);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.tester == null) {
                return;
            }
            String command = e.getActionCommand();
            if (command.equals("Initialize parse")) {
                this.tester.initializeParse();
            } else if (command.equals("Advance one step")) {
                this.tester.advance();
            } else if (command.equals("All remaining parses")) {
                this.tester.allParses();
            } else if (command.equals("Complete parse")) {
                this.tester.completeParse();
            } else if (command.equals("Show bracketed phrase")) {
                this.tester.showBracketedPhrase();
            } else if (command.equals("Show phrase structure tree")) {
                this.tester.showTree();
            } else if (command.equals("Select all")) {
                this.pane.requestFocus();
                this.pane.selectAll();
            } else if (command.equals("Copy selection")) {
                this.pane.copy();
            } else if (command.equals("Erase output pane")) {
                this.pane.setText("");
            }
        }
    }

    private class UniquelyParsedSubphrasesBoxListener
    implements ActionListener {
        private ASDTesterWindow window;

        UniquelyParsedSubphrasesBoxListener(ASDTester aSDTester, ASDTesterWindow w) {
            this.window = w;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.window.uniquelyParsedSubphrasesBoxChanged();
        }
    }

    private class HyphenAsLexicalItemBoxListener
    implements ActionListener {
        private ASDTesterWindow window;

        HyphenAsLexicalItemBoxListener(ASDTester aSDTester, ASDTesterWindow w) {
            this.window = w;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.window.hyphenAsLexicalItemBoxChanged();
        }
    }

    private class UtteranceFieldListener
    implements ActionListener {
        private ASDTesterWindow window;

        UtteranceFieldListener(ASDTester aSDTester, ASDTesterWindow w) {
            this.window = w;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.window.utteranceFieldChanged();
        }
    }

    private class ExpectedTypeListFieldListener
    implements ActionListener {
        private ASDTesterWindow window;

        ExpectedTypeListFieldListener(ASDTester aSDTester, ASDTesterWindow w) {
            this.window = w;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.window.expectedTypeListFieldChanged();
        }
    }

    private class GrammarFileNameFieldListener
    implements ActionListener {
        private ASDTesterWindow window;

        GrammarFileNameFieldListener(ASDTester aSDTester, ASDTesterWindow w) {
            this.window = w;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.window.grammarFileNameFieldChanged();
        }
    }

    class WindowCloser
    extends WindowAdapter {
        ASDTesterWindow window;

        WindowCloser(ASDTester this$0, ASDTesterWindow w) {
            this.window = w;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }

    private class LabeledTextField
    extends JPanel {
        LabeledTextField(String labelText, JTextField textField) {
            this.setMaximumSize(new Dimension(800, 10));
            this.setLayout(new BoxLayout(this, 0));
            JLabel label = new JLabel(labelText);
            textField.setFont(FONT);
            this.add(label);
            this.add(textField);
        }
    }
}

