/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDInputException;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

class ASDTokenReader
extends PushbackReader {
    public ASDTokenReader(Reader in) {
        super(in);
    }

    public String getToken() throws IOException {
        this.skipWhitespace();
        int ch = this.read();
        if (ch < 0 || ch == 65535) {
            return "";
        }
        char cha = (char)ch;
        if (cha == '(') {
            return "(";
        }
        if (cha == ')') {
            return ")";
        }
        this.unread(ch);
        if (cha == '\'' || cha == '\"') {
            return this.getQuotedString();
        }
        return this.getPseudoWord();
    }

    private void skipWhitespace() throws IOException {
        int ch = this.read();
        while (ch >= 0 && Character.isWhitespace((char)ch)) {
            ch = this.read();
        }
        this.unread(ch);
    }

    public char getLeftParenthesis() throws IOException, ASDInputException {
        int ch = this.read();
        char cha = (char)ch;
        if (cha == '(') {
            return cha;
        }
        this.unread(ch);
        throw new ASDInputException("missing ( where expected");
    }

    public char getRightParenthesis() throws IOException, ASDInputException {
        int ch = this.read();
        char cha = (char)ch;
        if (cha == ')') {
            return cha;
        }
        this.unread(ch);
        throw new ASDInputException("missing ) where expected");
    }

    public String getQuotedString() throws IOException, ASDInputException {
        StringBuffer buffer = new StringBuffer();
        this.skipWhitespace();
        int ch = this.read();
        char quote = (char)ch;
        if (quote != '\"' && quote != '\'') {
            throw new ASDInputException("missing quote character at beginning of expected quoted string");
        }
        return this.getQuotedString(quote);
    }

    public String getQuotedString(char quote) throws IOException, ASDInputException {
        int ch;
        StringBuffer buffer = new StringBuffer();
        buffer.append(quote);
        while (true) {
            if ((ch = this.read()) < 0) {
                throw new ASDInputException("missing quote at end of quoted string ending at end of input");
            }
            char cha = (char)ch;
            if (cha == quote) break;
            buffer.append(cha);
            if (cha != '\\') continue;
            ch = this.read();
            if (ch < 0) {
                throw new ASDInputException("unexpected end of input after \\ character");
            }
            buffer.append((char)ch);
        }
        buffer.append((char)ch);
        return buffer.toString();
    }

    public String getPseudoWord() throws IOException, ASDInputException {
        StringBuffer buffer = new StringBuffer();
        this.skipWhitespace();
        int ch = this.read();
        char cha = (char)ch;
        if (cha == '(' || cha == ')' || cha == '\"') {
            throw new ASDInputException("character " + cha + " found where a word or number was expected");
        }
        buffer.append(cha);
        ch = this.read();
        while (ch >= 0 && !Character.isWhitespace(cha = (char)ch) && cha != '(' && cha != ')' && cha != '\"') {
            buffer.append(cha);
            ch = this.read();
        }
        if (ch >= 0) {
            this.unread(ch);
        }
        return buffer.toString();
    }

    @Override
    public int read() throws IOException {
        for (int j = 10000; !this.ready() && j > 0; --j) {
        }
        return super.read();
    }
}

