/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDEditNode;
import asd.ASDEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class EditNodeMenu
extends JPopupMenu
implements ActionListener {
    ASDEditNode eNode;

    EditNodeMenu(ASDEditNode node) {
        this.eNode = node;
        this.setInvoker(this.eNode);
        JMenuItem editActionMenuItem = new JMenuItem("Edit semantic action");
        editActionMenuItem.addActionListener(this);
        this.add(editActionMenuItem);
        if (this.eNode.getGrammarNode().isFinal()) {
            JMenuItem editValueMenuItem = new JMenuItem("Edit semantic value");
            editValueMenuItem.addActionListener(this);
            this.add(editValueMenuItem);
        }
        JMenuItem initialMenuItem = new JMenuItem("Toggle Initial node");
        initialMenuItem.addActionListener(this);
        this.add(initialMenuItem);
        JMenuItem finalMenuItem = new JMenuItem("Toggle Final node");
        finalMenuItem.addActionListener(this);
        this.add(finalMenuItem);
        JMenuItem deleteMenuItem = new JMenuItem("Delete node");
        deleteMenuItem.addActionListener(this);
        this.add(deleteMenuItem);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ASDEditor editor = this.eNode.getEditor();
        if (editor == null) {
            return;
        }
        String command = e.getActionCommand();
        if (command.equals("Edit semantic action")) {
            editor.editAction(this.eNode);
        } else if (command.equals("Edit semantic value")) {
            editor.editValue(this.eNode);
        } else if (command.equals("Toggle Initial node")) {
            editor.toggleInitial(this.eNode);
        } else if (command.equals("Toggle Final node")) {
            editor.toggleFinal(this.eNode);
            this.eNode.changePopupMenu();
        } else if (command.equals("Delete node")) {
            editor.deleteNode(this.eNode);
        }
    }
}

