/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDEditor;
import asd.WordInstanceChooser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class InstanceListMenu
extends JPopupMenu
implements ActionListener {
    ASDEditor editor;
    WordInstanceChooser chooser;
    JList wordList;
    JList instanceList;

    InstanceListMenu(JList wList, JList iList, ASDEditor ed, WordInstanceChooser ch) {
        this.wordList = wList;
        this.instanceList = iList;
        this.editor = ed;
        this.chooser = ch;
        this.setInvoker(iList);
        JMenuItem addMenuItem = new JMenuItem("Add instance");
        addMenuItem.addActionListener(this);
        this.add(addMenuItem);
        JMenuItem deleteMenuItem = new JMenuItem("Delete instance");
        deleteMenuItem.addActionListener(this);
        this.add(deleteMenuItem);
        this.addSeparator();
        JMenuItem initialMenuItem = new JMenuItem("Toggle Initial instance");
        initialMenuItem.addActionListener(this);
        this.add(initialMenuItem);
        JMenuItem finalMenuItem = new JMenuItem("Toggle Final instance");
        finalMenuItem.addActionListener(this);
        this.add(finalMenuItem);
        this.addSeparator();
        JMenuItem editActionMenuItem = new JMenuItem("Edit semantic action");
        editActionMenuItem.addActionListener(this);
        this.add(editActionMenuItem);
        JMenuItem editValueMenuItem = new JMenuItem("Edit semantic value");
        editValueMenuItem.addActionListener(this);
        this.add(editValueMenuItem);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.editor == null) {
            return;
        }
        String command = e.getActionCommand();
        String word = (String)this.wordList.getSelectedValue();
        if (command.equals("Add instance")) {
            this.editor.addInstanceOf(word, this.chooser);
            return;
        }
        String instance = (String)this.instanceList.getSelectedValue();
        if (command.equals("Edit semantic action")) {
            this.editor.editAction(word, instance);
        } else if (command.equals("Edit semantic value")) {
            this.editor.editValue(word, instance);
        } else if (command.equals("Toggle Initial instance")) {
            this.editor.toggleInitial(word, instance, this.chooser);
        } else if (command.equals("Toggle Final instance")) {
            this.editor.toggleFinal(word, instance, this.chooser);
        } else if (command.equals("Delete instance")) {
            this.editor.deleteInstance(word, instance, this.chooser);
        }
    }
}

