/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDEditEdge;
import asd.ASDEditNode;
import asd.ASDEditor;
import asd.NetPanelMenu;
import asd.PopupListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;

class NetPanel
extends JPanel {
    private ASDEditor editor;
    private HashSet<ASDEditEdge> displayedEdges;
    private HashSet<ASDEditNode> displayedNodes;
    Color backgroundColor = Color.green;

    public NetPanel(ASDEditor e) {
        this.setBackground(this.backgroundColor);
        this.editor = e;
        this.displayedEdges = new HashSet();
        this.displayedNodes = new HashSet();
        NetPanelMenu menu = new NetPanelMenu(this, this.editor);
        PopupListener popupListener = new PopupListener(menu);
        this.addMouseListener(popupListener);
    }

    public void addEdge(ASDEditEdge eEdge) {
        eEdge.setEditor(this.editor);
        this.add(eEdge);
        this.displayedEdges.add(eEdge);
        eEdge.setContext(this);
    }

    public void addNode(ASDEditNode eNode) {
        eNode.setEditor(this.editor);
        this.add((Component)eNode, 0);
        if (eNode.getRightLabel() != null) {
            this.add((Component)eNode.getRightLabel(), 0);
        }
        this.displayedNodes.add(eNode);
        eNode.setContext(this);
    }

    void clear() {
        this.removeAll();
        this.displayedEdges = new HashSet();
        this.displayedNodes = new HashSet();
        this.repaint();
    }

    public Set getDisplayedEdges() {
        return this.displayedEdges;
    }

    public ASDEditor getEditor() {
        return this.editor;
    }

    boolean isDisplaying(ASDEditEdge e) {
        return this.displayedEdges.contains(e);
    }

    boolean isDisplaying(ASDEditNode n) {
        return this.displayedNodes.contains(n);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.displayedEdges != null) {
            int buttonRadius = 6;
            for (ASDEditEdge eEdge : this.displayedEdges) {
                ASDEditNode fromNode = eEdge.getFromNode();
                ASDEditNode toNode = eEdge.getToNode();
                g.drawLine(fromNode.rightConnectorX(), fromNode.rightConnectorY(), eEdge.getX() + buttonRadius, eEdge.getY() + buttonRadius);
                g.drawLine(eEdge.getX() + buttonRadius, eEdge.getY() + buttonRadius, toNode.leftConnectorX(), toNode.leftConnectorY());
            }
        }
    }

    void print() {
        PrintJob job = Toolkit.getDefaultToolkit().getPrintJob(this.editor.getWindow(), this.editor.getInputFileName(), null);
        if (job != null) {
            Graphics g = job.getGraphics();
            if (g != null) {
                this.setBackground(Color.white);
                this.paintComponent(g);
                this.print(g);
                g.dispose();
            }
            job.end();
            this.setBackground(Color.green);
        }
    }

    public void removeEdge(ASDEditEdge eEdge) {
        this.displayedEdges.remove(eEdge);
        this.remove(eEdge);
        eEdge.setContext(null);
        this.repaint();
    }

    public void removeNode(ASDEditNode eNode) {
        this.remove(eNode);
        if (eNode.getRightLabel() != null) {
            this.remove(eNode.getRightLabel());
        }
        this.displayedNodes.remove(eNode);
        eNode.setContext(null);
        this.repaint();
    }

    void straightenEdges() {
        Iterator<ASDEditEdge> it = this.displayedEdges.iterator();
        while (it.hasNext()) {
            it.next().setDefaultCoordinates();
        }
        this.editor.setGrammarChanged(true);
        this.repaint();
    }

    void toggleBackgroundColor() {
        this.backgroundColor = this.backgroundColor == Color.green ? Color.white : Color.green;
        this.setBackground(this.backgroundColor);
    }
}

