/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDEditor;
import asd.ASDGrammar;
import asd.InstanceListMenu;
import asd.InstanceListModel;
import asd.InstanceSelectionListener;
import asd.PopupListener;
import asd.WordListMenu;
import asd.WordListModel;
import asd.WordListSelectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

class WordInstanceChooser
extends JComponent {
    static final int DIVIDER_LOCATION = 200;
    private boolean tellEditor = true;
    private ASDGrammar grammar;
    private ASDEditor editor;
    private JList wordList;
    private String wordSelected;
    private JList instanceList;
    private String instanceSelected;
    private JScrollPane instanceScrollPane;
    private JSplitPane graphicView;

    WordInstanceChooser(ASDEditor givenEditor, ASDGrammar givenGrammar) {
        this.editor = givenEditor;
        this.setGrammar(givenGrammar);
    }

    void setGrammar(ASDGrammar newGrammar) {
        this.grammar = newGrammar;
        this.wordList = new JList(new WordListModel(this.grammar));
        this.wordList.setSelectionMode(0);
        this.wordList.getSelectionModel().addListSelectionListener(new WordListSelectionListener(this));
        WordListMenu menu = new WordListMenu(this.wordList, this.editor, this);
        PopupListener popupListener = new PopupListener(menu);
        this.wordList.addMouseListener(popupListener);
        JScrollPane wordScrollPane = new JScrollPane(this.wordList);
        JPanel labeledWordList = new JPanel();
        labeledWordList.setLayout(new BorderLayout());
        labeledWordList.add((Component)new JLabel("Words/Phrase Types"), "North");
        labeledWordList.add((Component)wordScrollPane, "Center");
        this.instanceScrollPane = new JScrollPane();
        JPanel labeledInstanceList = new JPanel();
        labeledInstanceList.setLayout(new BorderLayout());
        labeledInstanceList.add((Component)new JLabel("Instances"), "North");
        labeledInstanceList.add((Component)this.instanceScrollPane, "Center");
        this.graphicView = new JSplitPane(1, labeledWordList, labeledInstanceList);
        this.graphicView.setDividerLocation(200);
        this.repaint();
    }

    JSplitPane getGraphic() {
        return this.graphicView;
    }

    String getInstanceSelected() {
        return this.instanceSelected;
    }

    String getWordSelected() {
        return this.wordSelected;
    }

    void setInstanceSelected(String newInstance, boolean tell) {
        this.tellEditor = tell;
        this.instanceList.setSelectedValue(newInstance, true);
    }

    void setWordSelected(String newWord, boolean tell) {
        this.tellEditor = tell;
        this.wordList.setSelectedValue(newWord, true);
    }

    void newInstanceSelected() {
        this.instanceSelected = (String)this.instanceList.getSelectedValue();
        if (this.tellEditor) {
            this.editor.wordInstanceChooserChanged(this);
        }
        this.tellEditor = true;
    }

    void newWordSelected() {
        this.wordSelected = (String)this.wordList.getSelectedValue();
        this.instanceList = new JList(new InstanceListModel(this.grammar, this.wordSelected));
        this.instanceList.setSelectionMode(0);
        this.instanceList.getSelectionModel().addListSelectionListener(new InstanceSelectionListener(this));
        InstanceListMenu menu = new InstanceListMenu(this.wordList, this.instanceList, this.editor, this);
        PopupListener popupListener = new PopupListener(menu);
        this.instanceList.addMouseListener(popupListener);
        this.instanceScrollPane.getViewport().setView(this.instanceList);
        this.instanceSelected = null;
        if (this.tellEditor) {
            this.editor.wordInstanceChooserChanged(this);
        }
        this.tellEditor = true;
    }
}

