      SUBROUTINE DWG_OPEN(DNAME,STATUS,LG,LT,ISTAT)
C======================================================================C
C
C  Opens drawing files DNAME.dwg and DNAME.dwt on units LG and LT.
C  If STATUS='OLD' or 'READONLY', existing files will be opened.
C  If STATUS='NEW' or 'NEW+', new files will be opened.
C
C  Attempting to open a new set of drawing files when one with the 
C  same name already exists results in the following behaviour:
C    STATUS='NEW'      new version made only if confirmed by the user
C    STATUS='NEW+'     new version made automatically (used by EDGR)
C  Under Unix, if STATUS='NEW' the existing files will be renamed as
C  drawing_name.dw*~.
C
C  Modified 19-OCT-92 by FWJ: flag MXDWG added to indicate that the
C  drawing name was obtained from a Motif file selector.  In this
C  case there is no user confirmation when opening new versions of
C  existing files.
C
C  Modified 27-MAR-95 by FWJ: HP-UX requires record length in bytes
C
C  Modified 28-JUN-00 by FWJ: BEHAVIOUR CHANGED for existing files
C    If STATUS='NEW' user is prompted for opening new version
C    If STATUS='NEW+' new version is automatically opened
C
C======================================================================C
      CHARACTER*80 DNAME
      CHARACTER*(*) STATUS
      LOGICAL ISTAT

      COMMON/PLOT_INPUT_UNIT/IINS
      COMMON/DWG_MX/MXDWG
      LOGICAL MXDWG

#ifdef VMS
      CHARACTER*80 DWGEX
#else
      LOGICAL IST
#endif
      CHARACTER*3 STATUS1
      CHARACTER*1 ANS

      ISTAT=.FALSE.

C Make sure there is no extension on the file name:
#ifdef VMS
      ISTART=INDEX(DNAME,']')+1
      IF(INDEX(DNAME(ISTART:),'.').NE.0)THEN
        WRITE(*,*)'Drawing name cannot include a file type.'
        RETURN
      ENDIF
#endif

      NC=LENSIG(DNAME)
C Check if the drawing exists:
#ifdef VMS
      ICONTEXT=0
      IST=LIB$FIND_FILE(DNAME(1:NC)//'.DWG',DWGEX,ICONTEXT)
#else
      INQUIRE(FILE=DNAME(1:NC)//'.dwg',EXIST=IST)
#endif

      IF(IST)THEN
        IF(STATUS.EQ.'NEW'.AND..NOT.MXDWG)THEN
          WRITE(*,*)'Drawing ',DNAME(1:NC),' already exists.'
          WRITE(*,1000)
 1000     FORMAT(' Open new version?  y/N > ',$)
          ANS='N'
          READ(IINS,2000,IOSTAT=IERR)ANS
 2000     FORMAT(A1)
          IF(ANS.NE.'Y'.AND.ANS.NE.'y')RETURN
        ENDIF
#ifdef unix
        CALL SYSTEM('/bin/mv '//DNAME(1:NC)//'.dwg '//
     &      DNAME(1:NC)//'.dwg~')
        CALL SYSTEM('/bin/mv '//DNAME(1:NC)//'.dwt '//
     &      DNAME(1:NC)//'.dwt~')
#endif
      ENDIF
      STATUS1=STATUS

C Open the DWG file:
      CALL FIND_UNIT(LG)
      IF(STATUS.EQ.'READONLY')THEN
#ifdef VMS
        OPEN(UNIT=LG,FILE=DNAME(1:NC)//'.dwg',STATUS='OLD',READONLY,
     &     ORGANIZATION='RELATIVE',ACCESS='DIRECT',
     &     RECL=3,FORM='UNFORMATTED',IOSTAT=IERR)
#elif __hpux
        OPEN(UNIT=LG,FILE=DNAME(1:NC)//'.dwg',STATUS='OLD',READONLY,
     &     ORGANIZATION='RELATIVE',ACCESS='DIRECT',
     &     RECL=12,FORM='UNFORMATTED',IOSTAT=IERR)
#elif g77
        OPEN(UNIT=LG,FILE=DNAME(1:NC)//'.dwg',STATUS='OLD',
     &     ACCESS='DIRECT',
     &     RECL=12,FORM='UNFORMATTED',IOSTAT=IERR)
#elif gfortran
        OPEN(UNIT=LG,FILE=DNAME(1:NC)//'.dwg',STATUS='OLD',
     &     ACCESS='DIRECT',
     &     RECL=12,FORM='UNFORMATTED',IOSTAT=IERR)
#elif _AIX
        OPEN(UNIT=LG,FILE=DNAME(1:NC)//'.dwg',STATUS='OLD',
     &     ACCESS='DIRECT',
     &     RECL=3,FORM='UNFORMATTED',IOSTAT=IERR)
#else
        OPEN(UNIT=LG,FILE=DNAME(1:NC)//'.dwg',STATUS='OLD',READONLY,
     &     ORGANIZATION='RELATIVE',ACCESS='DIRECT',
     &     RECL=3,FORM='UNFORMATTED',IOSTAT=IERR)
#endif
      ELSE
#ifdef VMS
        OPEN(UNIT=LG,FILE=DNAME(1:NC)//'.dwg',STATUS=STATUS1,
     &     ORGANIZATION='RELATIVE',ACCESS='DIRECT',
     &     RECL=3,FORM='UNFORMATTED',IOSTAT=IERR)
#elif __hpux
        OPEN(UNIT=LG,FILE=DNAME(1:NC)//'.dwg',STATUS=STATUS1,
     &     ORGANIZATION='RELATIVE',ACCESS='DIRECT',
     &     RECL=12,FORM='UNFORMATTED',IOSTAT=IERR)
#elif g77
        OPEN(UNIT=LG,FILE=DNAME(1:NC)//'.dwg',STATUS=STATUS1,
     &     ACCESS='DIRECT',
     &     RECL=12,FORM='UNFORMATTED',IOSTAT=IERR)
#elif gfortran
        OPEN(UNIT=LG,FILE=DNAME(1:NC)//'.dwg',STATUS=STATUS1,
     &     ACCESS='DIRECT',
     &     RECL=12,FORM='UNFORMATTED',IOSTAT=IERR)
#elif _AIX
        OPEN(UNIT=LG,FILE=DNAME(1:NC)//'.dwg',STATUS=STATUS1,
     &     ACCESS='DIRECT',
     &     RECL=3,FORM='UNFORMATTED',IOSTAT=IERR)
#else
        OPEN(UNIT=LG,FILE=DNAME(1:NC)//'.dwg',STATUS=STATUS1,
     &     ORGANIZATION='RELATIVE',ACCESS='DIRECT',
     &     RECL=3,FORM='UNFORMATTED',IOSTAT=IERR)
#endif
      ENDIF

      IF(IERR.NE.0)THEN
        WRITE(*,*)'Error opening ',DNAME(1:NC)//'.dwg'
        CALL FORMSG
        RETURN
      ENDIF

C Open the DWT file:
      CALL FIND_UNIT(LT)
      IF(STATUS.EQ.'READONLY')THEN
#ifdef VMS
        OPEN(UNIT=LT,FILE=DNAME(1:NC)//'.dwt',STATUS='OLD',READONLY,
     &     ORGANIZATION='RELATIVE',ACCESS='DIRECT',
     &     RECL=37,FORM='UNFORMATTED',IOSTAT=IERR)
#elif __hpux
        OPEN(UNIT=LT,FILE=DNAME(1:NC)//'.dwt',STATUS='OLD',READONLY,
     &     ORGANIZATION='RELATIVE',ACCESS='DIRECT',
     &     RECL=148,FORM='UNFORMATTED',IOSTAT=IERR)
#elif g77
        OPEN(UNIT=LT,FILE=DNAME(1:NC)//'.dwt',STATUS='OLD',
     &     ACCESS='DIRECT',
     &     RECL=148,FORM='UNFORMATTED',IOSTAT=IERR)
#elif gfortran
        OPEN(UNIT=LT,FILE=DNAME(1:NC)//'.dwt',STATUS='OLD',
     &     ACCESS='DIRECT',
     &     RECL=148,FORM='UNFORMATTED',IOSTAT=IERR)
#elif _AIX
        OPEN(UNIT=LT,FILE=DNAME(1:NC)//'.dwt',STATUS='OLD',
     &     ACCESS='DIRECT',
     &     RECL=37,FORM='UNFORMATTED',IOSTAT=IERR)
#else
        OPEN(UNIT=LT,FILE=DNAME(1:NC)//'.dwt',STATUS='OLD',READONLY,
     &     ORGANIZATION='RELATIVE',ACCESS='DIRECT',
     &     RECL=37,FORM='UNFORMATTED',IOSTAT=IERR)
#endif
      ELSE
#ifdef VMS
        OPEN(UNIT=LT,FILE=DNAME(1:NC)//'.dwt',STATUS=STATUS1,
     &     ORGANIZATION='RELATIVE',ACCESS='DIRECT',
     &     RECL=37,FORM='UNFORMATTED',IOSTAT=IERR)
#elif __hpux
        OPEN(UNIT=LT,FILE=DNAME(1:NC)//'.dwt',STATUS=STATUS1,
     &     ORGANIZATION='RELATIVE',ACCESS='DIRECT',
     &     RECL=148,FORM='UNFORMATTED',IOSTAT=IERR)
#elif g77
        OPEN(UNIT=LT,FILE=DNAME(1:NC)//'.dwt',STATUS=STATUS1,
     &     ACCESS='DIRECT',
     &     RECL=148,FORM='UNFORMATTED',IOSTAT=IERR)
#elif gfortran
        OPEN(UNIT=LT,FILE=DNAME(1:NC)//'.dwt',STATUS=STATUS1,
     &     ACCESS='DIRECT',
     &     RECL=148,FORM='UNFORMATTED',IOSTAT=IERR)
#elif _AIX
        OPEN(UNIT=LT,FILE=DNAME(1:NC)//'.dwt',STATUS=STATUS1,
     &     ACCESS='DIRECT',
     &     RECL=37,FORM='UNFORMATTED',IOSTAT=IERR)
#else
        OPEN(UNIT=LT,FILE=DNAME(1:NC)//'.dwt',STATUS=STATUS1,
     &     ORGANIZATION='RELATIVE',ACCESS='DIRECT',
     &     RECL=37,FORM='UNFORMATTED',IOSTAT=IERR)
#endif
      ENDIF
      IF(IERR.NE.0)THEN
        WRITE(*,*)'Error opening ',DNAME(1:NC)//'.dwt'
        CALL FORMSG
        CLOSE(UNIT=LG)      !close DWG file
        RETURN
      ENDIF
      ISTAT=.TRUE.
      RETURN
      END
