      SUBROUTINE GENERIC_TERMINAL_SETUP( * )

C  Modified 06-MAY-92 by FWJ: fixed output format for PRINT_BUFFER
C  and changed all '+' formats to ' ' for UNIX compatibility.
C  Modified by J.Chuma, 20Mar97 for g77
C    can't have intrinsic functions inside a PARAMETER statement

      CHARACTER LINE*255, STRING*132, NAME*132
     &         ,ESC*1, CR*1, US*1, FS*1, SUB*1, CAN*1, FF*1, GS*1
     &         ,NULLS*60
#ifdef VMS
#else
      CHARACTER*132 UPPER_CASE
#endif
C
      CHARACTER GRAPHICS_CLEAR*132
     &         ,TRANSPARENT_CLEAR*132
     &         ,ENTER_TRANS_MODE*132
     &         ,ENTER_GRAPH_MODE*132
     &         ,PLOT_MODE(0:2)*132
     &         ,XHAIR_LOAD1*132, XHAIR_LOAD2*132
     &         ,COLOURS(0:20)*132
     &         ,VIDEO_OFF*132
     &         ,VIDEO_ON*132
     &         ,VECTOR_INIT_MODE*132
     &         ,VECTOR_MODE*132
     &         ,ALPHA_MODE*132
     &         ,POINT_MODE*132
      REAL*4    XMIN, XMAX, YMIN, YMAX
     &         ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &         ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &         ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
      INTEGER*4 LEN_PLV(0:2), LEN_CLR(0:20), INITCLR, NUMCLR, TERMTYPE
     &         ,LEN_VMODE, LEN_AMODE, LEN_PMODE
      COMMON /GENERIC_TERMINAL/ 
     &   TERMTYPE
     &  ,XMIN, XMAX, YMIN, YMAX
     &  ,GRAPHICS_CLEAR,    LEN_GCL
     &  ,TRANSPARENT_CLEAR, LEN_TCL
     &  ,ENTER_TRANS_MODE,  LEN_TRM
     &  ,ENTER_GRAPH_MODE,  LEN_GRM
     &  ,PLOT_MODE,         LEN_PLV
     &  ,XHAIR_LOAD1,       LEN_XLD1
     &  ,XHAIR_LOAD2,       LEN_XLD2
     &  ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &  ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &  ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
     &  ,COLOURS,           LEN_CLR, INITCLR, NUMCLR
     &  ,VIDEO_OFF,         LEN_VDF
     &  ,VIDEO_ON,          LEN_VDN
     &  ,VECTOR_INIT_MODE,  LEN_VIMODE
     &  ,VECTOR_MODE,       LEN_VMODE
     &  ,ALPHA_MODE,        LEN_AMODE
     &  ,POINT_MODE,        LEN_PMODE
C
      COMMON /PLOTMONITOR/ IMONITOR, IOUTM
C
      LOGICAL IN_GRAPH_MODE
      COMMON /GRAPH_MODE/ IN_GRAPH_MODE
C
C TEK precision set externally:
C
      LOGICAL TEK4014
      COMMON /TEK_PRECISION/ TEK4014
C
C      INCLUDE '($SSDEF)'
CCC
      do i = 1, 60
        nulls(i:i) = char(0)
      end do
      ESC = CHAR(27)
      CR = CHAR(13)
      US = CHAR(31)
      SUB = CHAR(26)
      CAN = CHAR(24)
      FF = CHAR(12)
      GS = CHAR(29)
      FS = CHAR(28)
C
C   Find a free logical unit number,
C   and open the terminal characteristics file
C
      CALL FIND_UNIT( IUNIT )
#ifdef VMS
      OPEN( FILE='TRIUMF$GENTERM', UNIT=IUNIT
     & ,READONLY, SHARED, TYPE='OLD', ERR=998 )
#else
      CALL GETENV('TRIUMF_GENTERM',NAME)
      OPEN( FILE=NAME, UNIT=IUNIT,
     &    STATUS='OLD', ERR=998 )
#endif
C
C The terminal characteristic defaults usually are VT640 settings
C
C   The terminal type: TERMTYPE= 1  ==>  TEK4010 type
C                      TERMTYPE= 2  ==>  TEK4014 type
C                      TERMTYPE= 3  ==>  REGIS   type
C
20    TERMTYPE = 1
C
C   These are the size of the terminal screen in pixels
C
      XMIN =   0.0
      XMAX = 640.0
      YMIN =   0.0
      YMAX = 479.0
C
C   Turn pixels on
C
      PLOT_MODE(0) = ESC//'/0d'
      LEN_PLV(0)   = 5
C
C   Turn pixels off
C
      PLOT_MODE(1) = ESC//'/1d'
      LEN_PLV(1)   = 5
C
C   Complement pixels
C
      PLOT_MODE(2) = ESC//'/2d'
      LEN_PLV(2)   = 5
C
C   Clear graphics terminal screen
C
      GRAPHICS_CLEAR = ESC//FF
      LEN_GCL        = 2
C
C   Clear transparent terminal screen
C
      TRANSPARENT_CLEAR = CAN//ESC//'[2J'//ESC//'[1;1H'
      LEN_TCL           = 11
C
C   Enter transparent mode 
C
      ENTER_TRANS_MODE = CAN
      LEN_TRM          = 1
C
C    Enter graphics screen mode
C
      ENTER_GRAPH_MODE = ' '
      LEN_GRM          = 0
C
C   Loading the crosshairs requires two sequences
C   The first, XHAIR_LOAD1, is followed by the HI y and x and LO y and x
C   followed by XHAIR_LOAD2
C
      XHAIR_LOAD1 = NULLS//GS
      LEN_XLD1    = 61
      XHAIR_LOAD2 = ESC//'/f'//ESC//SUB
      LEN_XLD2    = 5
C
C   Conversion factors for CROSSHAIR_R and for PLOT_MONITOR
C
      XHAIR_XFRAC_1 = 1.60          !   = 1024/640
      XHAIR_XOFF_1  = 0.0           !   no offset
      XHAIR_YFRAC_1 = 1.625         !   =  780/480
      XHAIR_YOFF_1  = 0.0           !   no offset
      XHAIR_XFRAC_2 = 0.625         !   =  640/1024
      XHAIR_XOFF_2  = 0.6           !   
      XHAIR_YFRAC_2 = 0.615384615   !   =  480/780
      XHAIR_YOFF_2  = 0.6           !   
C
C   Conversion factors for plot_monitor 
C
      PMON_XFRAC = 1.60          !   = 1024/640
      PMON_XOFF  = 0.5           !   offset
      PMON_YFRAC = 1.625         !   =  780/480
      PMON_YOFF  = 0.5           !   offset
C
C   Number of colours available
C
      NUMCLR = 0
C
C   If a terminal has colour:
C     INITCLR = initial colour number 
C               (on a CIT467: INITCLR = 0, NUMCLR = 7)
C     The maximum allowable number of colours is 0 to 20
C     and the sequences for the colours are in COLOURS(I)(1:LEN_CLR(I))
C
C   Toggle graphics off and on, without clearing 
C
      LEN_VDF = 0
      LEN_VDN = 0
C
C   Initialize vector mode
C
      VECTOR_INIT_MODE = ' '
      LEN_VIMODE = 0
C
C   Enter vector mode
C
      VECTOR_MODE = GS
      LEN_VMODE   = 1
C
C   Enter alpha mode
C
      ALPHA_MODE = US
      LEN_AMODE  = 1
C
C   Enter point mode
C
      POINT_MODE = FS
      LEN_PMODE  = 1
C
C   Read the file, one line at a time, and determine what is contained
C   on each line, comment lines start with a `!'
C
      NLINE = 0
40    READ( IUNIT, 50, ERR=991, END=98 )LINE
50    FORMAT(A)
      NLINE = NLINE + 1
      CALL GENERIC_SCANNER( LINE, STRING, LENS, IER )
      IF( IER .EQ. -1 )GO TO 991   ! an error occured
      IF( IER .EQ.  1 )GO TO 40    ! a comment line
#ifdef VMS
      CALL STR$UPCASE(STRING(1:LENS),STRING(1:LENS))
#else
      STRING(1:LENS)=UPPER_CASE(STRING(1:LENS))
#endif
C
      IF( STRING(1:LENS) .EQ. 'RANGE' )THEN
        READ( IUNIT, *, ERR=991, END=98 )XMIN, XMAX, YMIN, YMAX
        NLINE = NLINE + 1
      ELSE IF( STRING(1:LENS) .EQ. 'GRAPHICS_CLEAR' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, GRAPHICS_CLEAR, LEN_GCL, IER )
        IF( IER .EQ. -1 )GO TO 991
      ELSE IF( STRING(1:LENS) .EQ. 'TRANSPARENT_CLEAR' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, TRANSPARENT_CLEAR, LEN_TCL, IER )
        IF( IER .EQ. -1 )GO TO 991
      ELSE IF( STRING(1:LENS) .EQ. 'ENTER_TRANS_MODE' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, ENTER_TRANS_MODE, LEN_TRM, IER )
        IF( IER .EQ. -1 )GO TO 991
      ELSE IF( STRING(1:LENS) .EQ. 'ENTER_GRAPH_MODE' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, ENTER_GRAPH_MODE, LEN_GRM, IER )
        IF( IER .EQ. -1 )GO TO 991
      ELSE IF( STRING(1:LENS) .EQ. 'DOTS_ON' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, PLOT_MODE(0), LEN_PLV(0), IER )
        IF( IER .EQ. -1 )GO TO 991
      ELSE IF( STRING(1:LENS) .EQ. 'DOTS_OFF' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, PLOT_MODE(1), LEN_PLV(1), IER )
        IF( IER .EQ. -1 )GO TO 991
      ELSE IF( STRING(1:LENS) .EQ. 'DOTS_COMPLEMENT' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, PLOT_MODE(2), LEN_PLV(2), IER )
        IF( IER .EQ. -1 )GO TO 991
      ELSE IF( STRING(1:LENS) .EQ. 'CROSSHAIRS' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, XHAIR_LOAD1, LEN_XLD1, IER )
        IF( IER .EQ. -1 )GO TO 991
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, XHAIR_LOAD2, LEN_XLD2, IER )
        IF( IER .EQ. -1 )GO TO 991
        READ( IUNIT, *, ERR=997, END=98 )XHAIR_XFRAC_1,XHAIR_XOFF_1
        NLINE = NLINE + 1
        READ( IUNIT, *, ERR=997, END=98 )XHAIR_YFRAC_1,XHAIR_YOFF_1
        NLINE = NLINE + 1
        READ( IUNIT, *, ERR=997, END=98 )XHAIR_XFRAC_2,XHAIR_XOFF_2
        NLINE = NLINE + 1
        READ( IUNIT, *, ERR=997, END=98 )XHAIR_YFRAC_2,XHAIR_YOFF_2
        NLINE = NLINE + 1
      ELSE IF( STRING(1:LENS) .EQ. 'SPECIAL' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, STRING, LENL, IER )
        IF( IER .EQ. -1 )GO TO 991
        WRITE(IOUTM,60)STRING(1:LENL)
C60     FORMAT('+',A,$)
60      FORMAT(' ',A,$)
      ELSE IF( STRING(1:LENS) .EQ. 'COLOURS' )THEN
        READ( IUNIT, *, ERR=991, END=98 )INITCLR, NUMCLR
        NLINE = NLINE + 1
        IF( INITCLR .LT. 0 )GO TO 994
        IF( INITCLR .GT. NUMCLR )GO TO 995
        DO I = INITCLR, NUMCLR
          READ( IUNIT, 50, ERR=991, END=993 )LINE
          NLINE = NLINE + 1
          CALL GENERIC_SCANNER( LINE, COLOURS(I), LEN_CLR(I), IER )
          IF( IER .EQ. -1 )GO TO 991
        END DO
      ELSE IF( STRING(1:LENS) .EQ. 'VIDEO_OFF' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, VIDEO_OFF, LEN_VDF, IER )
        IF( IER .EQ. -1 )GO TO 991
      ELSE IF( STRING(1:LENS) .EQ. 'VIDEO_ON' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, VIDEO_ON, LEN_VDN, IER )
        IF( IER .EQ. -1 )GO TO 991
      ELSE IF( STRING(1:LENS) .EQ. 'TERMINAL_TYPE' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, STRING, LTERM, IER )
        IF( IER .EQ. -1 )GO TO 991
        IF( STRING(1:LTERM) .EQ. 'TEK4010' )THEN
          TERMTYPE = 1
        ELSE IF( STRING(1:LTERM) .EQ. 'TEK4014' )THEN
          TERMTYPE = 2
          TEK4014  = .TRUE.
        ELSE IF( STRING(1:LTERM) .EQ. 'REGIS' )THEN
          TERMTYPE = 3
        ELSE 
          GO TO 996
        END IF
      ELSE IF( STRING(1:LENS) .EQ. 'SCALEFACTORS' )THEN
        READ( IUNIT, *, ERR=997, END=98 )PMON_XFRAC,PMON_XOFF
        NLINE = NLINE + 1
        READ( IUNIT, *, ERR=997, END=98 )PMON_YFRAC,PMON_YOFF
        NLINE = NLINE + 1
      ELSE IF( STRING(1:LENS) .EQ. 'VECTOR_INIT_MODE' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, VECTOR_INIT_MODE, LEN_VIMODE, IER )
        IF( IER .EQ. -1 )GO TO 991
      ELSE IF( STRING(1:LENS) .EQ. 'VECTOR_MODE' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, VECTOR_MODE, LEN_VMODE, IER )
        IF( IER .EQ. -1 )GO TO 991
      ELSE IF( STRING(1:LENS) .EQ. 'ALPHA_MODE' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, ALPHA_MODE, LEN_AMODE, IER )
        IF( IER .EQ. -1 )GO TO 991
      ELSE IF( STRING(1:LENS) .EQ. 'POINT_MODE' )THEN
        READ( IUNIT, 50, ERR=991, END=98 )LINE
        NLINE = NLINE + 1
        CALL GENERIC_SCANNER( LINE, POINT_MODE, LEN_PMODE, IER )
        IF( IER .EQ. -1 )GO TO 991
      ELSE
        GO TO 99
      END IF
      GO TO 40   ! go back and read another line from the file
C
C   Finished reading from the file
C
98    CLOSE( IUNIT )
      RETURN
C
C   Some error occured in reading or opening the file
C
99    WRITE(*,100)NLINE
#ifdef VMS
100   FORMAT(' *** ERROR in terminal characteristics file'//
     &       ' TRIUMF$GENTERM on line ',I5)
#else
100   FORMAT(' *** ERROR in terminal characteristics file'//
     &       ' TRIUMF_GENTERM on line ',I5)
#endif
      CLOSE( IUNIT )
      RETURN 1
991   WRITE(*,100)NLINE+1
      CLOSE( IUNIT )
      RETURN 1
993   WRITE(*,100)NLINE+1
      WRITE(*,1000)'*** end of file reached while reading colours'
      CLOSE( IUNIT )
      RETURN 1
994   WRITE(*,100)NLINE+1
      WRITE(*,1000)'*** initial colour < 0'
      CLOSE( IUNIT )
      RETURN 1
995   WRITE(*,100)NLINE+1
      WRITE(*,1000)'*** initial colour > number of colours'
      CLOSE( IUNIT )
      RETURN 1
996   WRITE(*,100)NLINE+1
      WRITE(*,1000)'*** invalid terminal type'
      WRITE(*,1000)'*** choices are: TK4010, TK4014, or REGIS'
      CLOSE( IUNIT )
      RETURN 1
997   WRITE(*,100)NLINE+1
      WRITE(*,1000)'*** crosshair conversion numbers'
      CLOSE( IUNIT )
      RETURN 1
998   WRITE(*,1000)'*** Unable to open terminal characteristics file'
#ifdef VMS
      WRITE(*,1000)'*** associated with logical name TRIUMF$GENTERM'
#else
      WRITE(*,1000)'*** associated with logical name TRIUMF_GENTERM'
#endif
1000  FORMAT(' ',A)
      IDUM=NARGSI(0)
      CALL PUT_FORMSG
1001  WRITE(*,1002)
1002  FORMAT(' Enter filename (CTRL-Z ends) >> ',$)
      READ(*,1003,ERR=1001,END=1099)NAME
1003  FORMAT(A)
#ifdef VMS
      OPEN( FILE=NAME,UNIT=IUNIT,READONLY,SHARED,TYPE='OLD',ERR=1004 )
#else
      OPEN( FILE=NAME,UNIT=IUNIT,STATUS='OLD',ERR=1004 )
#endif
      GO TO 20
1004  WRITE(*,1000)'*** Unable to open file: '//NAME(1:LENSIG(NAME))
      IDUM=NARGSI(0)
      CALL PUT_FORMSG
      GO TO 1001
1099  RETURN 1
      END
CCCCCC
      SUBROUTINE GENERIC_SCANNER( LINE, STRING, LENS, IER )
C
      CHARACTER*(*) LINE
      INTEGER*4 LENS

      PARAMETER (MLENS=132, MLCTRL=6)
      CHARACTER*(MLENS) STRING
      CHARACTER*(MLCTRL) CTRL

      LOGICAL   FLAG
C
      INTEGER*2 NEW_STATE, ISTATE
      INTEGER*2 CLASSES(0:127)
      INTEGER*2 STATE_TABLE(7,7)
      DATA CLASSES
     &/  6,  6,  6,  6,  6,  6,  6,  6,  6,  1,  6,  6,  6,  6,  6,  6,
     &   6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     &   1,  7,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     &   5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  6,  6,  2,  6,  3,  6,
     &   6,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     &   4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  6,  6,  6,  6,  6,
     &   6,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     &   4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  6,  6,  6,  6,  6 /
C
      DATA STATE_TABLE
C      blnk,tab  <     >  A-Z,a-z  0-9  othr    !
C
     1 /   1,    3, -100,    2,     2,    2,  100,
     2     2,    3, -100,    2,     2,    2,    2,
     3  -100, -100, -100,    6,     4, -100, -100,
     4  -100, -100,    5, -100,     4, -100, -100,
     5     2,    3, -100,    2,     2,    2,    2,
     6  -100, -100,    7,    6,     6,    6,    6,
     7     2,    3, -100,    2,     2,    2,    2  /
C
      FLAG      = .FALSE.
      IER       = 0
      LENL      = LENSIG(LINE)
      STRING    = ' '
      LENS      = 0
      NEW_STATE = 1
      I         = 0
10    I         = I + 1
      IF( I .GT. LENL )THEN
        IF( FLAG .OR. (LENS .EQ. 0) )IER = -1
        RETURN
      END IF
      ISTATE    = NEW_STATE
      NEW_STATE = STATE_TABLE(CLASSES(ICHAR(LINE(I:I))),ISTATE)
      IF( NEW_STATE .EQ. 100 )THEN   ! a comment line
        IER = 1
        RETURN
      ELSE IF( NEW_STATE .EQ. 2 )THEN
        LENS = LENS+1
        IF( LENS .GT. MLENS )THEN
          WRITE(*,*)'*** ERROR in GENERIC_SCANNER'
          WRITE(*,*)'    Maximum line length exceeded'
          IER = -1
          RETURN
        END IF
        STRING(LENS:LENS) = LINE(I:I)
      ELSE IF( NEW_STATE .EQ. 3 )THEN
        FLAG = .TRUE.
        CTRL = ' '
        LCTR = 0
      ELSE IF( NEW_STATE .EQ. 4 )THEN
        LCTR = LCTR+1
        IF( LCTR .GT. MLCTRL )THEN
          WRITE(*,*)'*** ERROR in GENERIC_SCANNER'
          WRITE(*,*)'    Maximum length of control sequence exceeded'
          IER = -1
          RETURN
        END IF
        CTRL(LCTR:LCTR) = LINE(I:I)
      ELSE IF( NEW_STATE .EQ. 5 )THEN
        ICTRL = 0
        DO J = 1, LCTR
          JJ = LCTR - J
          ICTRL = ICTRL + (ICHAR(CTRL(J:J))-48)*(10**JJ)
        END DO
        IF( ICTRL .GT. 127 )THEN
          WRITE(*,*)'*** ERROR in GENERIC_SCANNER'
          WRITE(*,*)'    ASCII decimal > 127'
          IER = -1
          RETURN
        END IF
        LENS = LENS+1
        IF( LENS .GT. MLENS )THEN
          WRITE(*,*)'*** ERROR in GENERIC_SCANNER'
          WRITE(*,*)'    Maximum line length exceeded'
          IER = -1
          RETURN
        END IF
        STRING(LENS:LENS) = CHAR(ICTRL)
        FLAG = .FALSE.
      ELSE IF( NEW_STATE .EQ. 6 )THEN
        LCTR = LCTR+1
        IF( LCTR .GT. MLCTRL )THEN
          WRITE(*,*)'*** ERROR in GENERIC_SCANNER'
          WRITE(*,*)'    Maximum length of control sequence exceeded'
          IER = -1
          RETURN
        END IF
        CTRL(LCTR:LCTR) = LINE(I:I)
      ELSE IF( NEW_STATE .EQ. 7 )THEN
        IF( LENS .GT. MLENS )THEN
          WRITE(*,*)'*** ERROR in GENERIC_SCANNER'
          WRITE(*,*)'    Maximum line length exceeded'
          IER = -1
          RETURN
        END IF
        CALL GENERIC_TABLE( CTRL(1:LCTR), STRING(LENS+1:LENS+1), IER )
        IF( IER .NE. 0 )THEN
          WRITE(*,*)'*** ERROR in GENERIC_SCANNER'
          WRITE(*,*)'    Invalid control sequence'
          IER = -1
          RETURN
        END IF
        LENS = LENS+1
        FLAG = .FALSE.
      END IF
      GO TO 10
      END
CCCCCC
      SUBROUTINE GENERIC_TABLE( CTRL, STRING, IER )
C
      CHARACTER*(*) CTRL
      CHARACTER*1 STRING, BS
      CHARACTER*6 TEMP, TABLE1(0:32), TABLE2(0:32)
C
      DATA TABLE1
     & / 'NUL   ','SOH   ','STX   ','ETX   ','EOT   ','ENQ   ','ACK   ',
     &   'BEL   ','BS    ','HT    ','LF    ','VT    ','FF    ','CR    ',
     &   'SO    ','SI    ','DLE   ','DC1   ','DC2   ','DC3   ','DC4   ',
     &   'NAK   ','SYN   ','ETB   ','CAN   ','EM    ','SUB   ','ESC   ',
     &   'FS    ','GS    ','RS    ','US    ','SP    ' /
      DATA TABLE2
     & / 'CTRLSP','CTRLA ','CTRLB ','CTRLC ','CTRLD ','CTRLE ','CTRLF ',
     &   'CTRLG ','CTRLH ','CTRLI ','CTRLJ ','CTRLK ','CTLRL ','CTRLM ',
     &   'CTRLN ','CTLRO ','CTRLP ','CTRLQ ','CTLRR ','CTRLS ','CTRLT ',
     &   'CTRLU ','CTRLV ','CTRLW ','CTRLX ','CTRLY ','CTRLZ ','CTRL[ ',
     &   '      ','CTRL] ','CTRL` ','CTRL/ ','SP    ' /
CCC
      BS = CHAR(92)  ! backslash
      TABLE2(28) = 'CTRL'//BS//' '

      IER  = 0
      TEMP = ' '
      TEMP = CTRL
      DO I = 0, 32
        IF( TEMP .EQ. TABLE1(I) )THEN
          STRING = CHAR(I)
          RETURN
        END IF
      END DO
      DO I = 0, 32
        IF( TEMP .EQ. TABLE2(I) )THEN
          STRING = CHAR(I)
          RETURN
        END IF
      END DO
      IER = -1
      RETURN
      END
CCCCCC
      SUBROUTINE GENERIC_TERMINAL_SIZE( XMING, XMAXG, YMING, YMAXG )
C
C  Returns the size of the generic terminal in pixels
C
      CHARACTER GRAPHICS_CLEAR*132
     &         ,TRANSPARENT_CLEAR*132
     &         ,ENTER_TRANS_MODE*132
     &         ,ENTER_GRAPH_MODE*132
     &         ,PLOT_MODE(0:2)*132
     &         ,XHAIR_LOAD1*132, XHAIR_LOAD2*132
     &         ,COLOURS(0:20)*132
     &         ,VIDEO_OFF*132
     &         ,VIDEO_ON*132
     &         ,VECTOR_INIT_MODE*132
     &         ,VECTOR_MODE*132
     &         ,ALPHA_MODE*132
     &         ,POINT_MODE*132
      REAL*4    XMIN, XMAX, YMIN, YMAX
     &         ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &         ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &         ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
      INTEGER*4 LEN_PLV(0:2), LEN_CLR(0:20), INITCLR, NUMCLR, TERMTYPE
     &         ,LEN_VMODE, LEN_AMODE, LEN_PMODE
      COMMON /GENERIC_TERMINAL/ 
     &   TERMTYPE
     &  ,XMIN, XMAX, YMIN, YMAX
     &  ,GRAPHICS_CLEAR,    LEN_GCL
     &  ,TRANSPARENT_CLEAR, LEN_TCL
     &  ,ENTER_TRANS_MODE,  LEN_TRM
     &  ,ENTER_GRAPH_MODE,  LEN_GRM
     &  ,PLOT_MODE,         LEN_PLV
     &  ,XHAIR_LOAD1,       LEN_XLD1
     &  ,XHAIR_LOAD2,       LEN_XLD2
     &  ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &  ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &  ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
     &  ,COLOURS,           LEN_CLR, INITCLR, NUMCLR
     &  ,VIDEO_OFF,         LEN_VDF
     &  ,VIDEO_ON,          LEN_VDN
     &  ,VECTOR_INIT_MODE,  LEN_VIMODE
     &  ,VECTOR_MODE,       LEN_VMODE
     &  ,ALPHA_MODE,        LEN_AMODE
     &  ,POINT_MODE,        LEN_PMODE
C
      XMING = XMIN
      XMAXG = XMAX
      YMING = YMIN
      YMAXG = YMAX
      RETURN
      END
CCCCCC
      SUBROUTINE GENERIC_CLEAR
C
C  Clear the screen and initialize the buffer
C
      CHARACTER GRAPHICS_CLEAR*132
     &         ,TRANSPARENT_CLEAR*132
     &         ,ENTER_TRANS_MODE*132
     &         ,ENTER_GRAPH_MODE*132
     &         ,PLOT_MODE(0:2)*132
     &         ,XHAIR_LOAD1*132, XHAIR_LOAD2*132
     &         ,COLOURS(0:20)*132
     &         ,VIDEO_OFF*132
     &         ,VIDEO_ON*132
     &         ,VECTOR_INIT_MODE*132
     &         ,VECTOR_MODE*132
     &         ,ALPHA_MODE*132
     &         ,POINT_MODE*132
      REAL*4    XMIN, XMAX, YMIN, YMAX
     &         ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &         ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &         ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
      INTEGER*4 LEN_PLV(0:2), LEN_CLR(0:20), INITCLR, NUMCLR, TERMTYPE
     &         ,LEN_VMODE, LEN_AMODE, LEN_PMODE
      COMMON /GENERIC_TERMINAL/ 
     &   TERMTYPE
     &  ,XMIN, XMAX, YMIN, YMAX
     &  ,GRAPHICS_CLEAR,    LEN_GCL
     &  ,TRANSPARENT_CLEAR, LEN_TCL
     &  ,ENTER_TRANS_MODE,  LEN_TRM
     &  ,ENTER_GRAPH_MODE,  LEN_GRM
     &  ,PLOT_MODE,         LEN_PLV
     &  ,XHAIR_LOAD1,       LEN_XLD1
     &  ,XHAIR_LOAD2,       LEN_XLD2
     &  ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &  ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &  ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
     &  ,COLOURS,           LEN_CLR, INITCLR, NUMCLR
     &  ,VIDEO_OFF,         LEN_VDF
     &  ,VIDEO_ON,          LEN_VDN
     &  ,VECTOR_INIT_MODE,  LEN_VIMODE
     &  ,VECTOR_MODE,       LEN_VMODE
     &  ,ALPHA_MODE,        LEN_AMODE
     &  ,POINT_MODE,        LEN_PMODE
C
      COMMON /PLOTMONITOR/ IMONITOR, IOUTM
C
      LOGICAL IN_GRAPH_MODE
      COMMON /GRAPH_MODE/ IN_GRAPH_MODE
C
      IF( .NOT.IN_GRAPH_MODE )WRITE(IOUTM,10)ENTER_GRAPH_MODE(1:LEN_GRM)
      CALL FLUSH_PLOT
      WRITE(IOUTM,10)GRAPHICS_CLEAR(1:LEN_GCL)
C10   FORMAT('+',A,$)
10    FORMAT(' ',A,$)
      RETURN
      END
CCCCCC
      SUBROUTINE GENERIC_CLTRANS
C
C  Clear the alphanumeric screen 
C
      CHARACTER GRAPHICS_CLEAR*132
     &         ,TRANSPARENT_CLEAR*132
     &         ,ENTER_TRANS_MODE*132
     &         ,ENTER_GRAPH_MODE*132
     &         ,PLOT_MODE(0:2)*132
     &         ,XHAIR_LOAD1*132, XHAIR_LOAD2*132
     &         ,COLOURS(0:20)*132
     &         ,VIDEO_OFF*132
     &         ,VIDEO_ON*132
     &         ,VECTOR_INIT_MODE*132
     &         ,VECTOR_MODE*132
     &         ,ALPHA_MODE*132
     &         ,POINT_MODE*132
      REAL*4    XMIN, XMAX, YMIN, YMAX
     &         ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &         ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &         ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
      INTEGER*4 LEN_PLV(0:2), LEN_CLR(0:20), INITCLR, NUMCLR, TERMTYPE
     &         ,LEN_VMODE, LEN_AMODE, LEN_PMODE
      COMMON /GENERIC_TERMINAL/ 
     &   TERMTYPE
     &  ,XMIN, XMAX, YMIN, YMAX
     &  ,GRAPHICS_CLEAR,    LEN_GCL
     &  ,TRANSPARENT_CLEAR, LEN_TCL
     &  ,ENTER_TRANS_MODE,  LEN_TRM
     &  ,ENTER_GRAPH_MODE,  LEN_GRM
     &  ,PLOT_MODE,         LEN_PLV
     &  ,XHAIR_LOAD1,       LEN_XLD1
     &  ,XHAIR_LOAD2,       LEN_XLD2
     &  ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &  ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &  ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
     &  ,COLOURS,           LEN_CLR, INITCLR, NUMCLR
     &  ,VIDEO_OFF,         LEN_VDF
     &  ,VIDEO_ON,          LEN_VDN
     &  ,VECTOR_INIT_MODE,  LEN_VIMODE
     &  ,VECTOR_MODE,       LEN_VMODE
     &  ,ALPHA_MODE,        LEN_AMODE
     &  ,POINT_MODE,        LEN_PMODE
C
      COMMON /PLOTMONITOR/ IMONITOR, IOUTM
C
      LOGICAL IN_GRAPH_MODE
      COMMON /GRAPH_MODE/ IN_GRAPH_MODE
C
      WRITE(IOUTM,10)TRANSPARENT_CLEAR(1:LEN_TCL)
10    FORMAT(' ',A)
      RETURN
      END
CCCCCC
      SUBROUTINE GENERIC_PLOT_MONITOR( XM, YM, IPEN )
C
      CHARACTER GRAPHICS_CLEAR*132
     &         ,TRANSPARENT_CLEAR*132
     &         ,ENTER_TRANS_MODE*132
     &         ,ENTER_GRAPH_MODE*132
     &         ,PLOT_MODE(0:2)*132
     &         ,XHAIR_LOAD1*132, XHAIR_LOAD2*132
     &         ,COLOURS(0:20)*132
     &         ,VIDEO_OFF*132
     &         ,VIDEO_ON*132
     &         ,VECTOR_INIT_MODE*132
     &         ,VECTOR_MODE*132
     &         ,ALPHA_MODE*132
     &         ,POINT_MODE*132
      REAL*4    XMIN, XMAX, YMIN, YMAX
     &         ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &         ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &         ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
      INTEGER*4 LEN_PLV(0:2), LEN_CLR(0:20), INITCLR, NUMCLR, TERMTYPE
     &         ,LEN_VMODE, LEN_AMODE, LEN_PMODE
      COMMON /GENERIC_TERMINAL/ 
     &   TERMTYPE
     &  ,XMIN, XMAX, YMIN, YMAX
     &  ,GRAPHICS_CLEAR,    LEN_GCL
     &  ,TRANSPARENT_CLEAR, LEN_TCL
     &  ,ENTER_TRANS_MODE,  LEN_TRM
     &  ,ENTER_GRAPH_MODE,  LEN_GRM
     &  ,PLOT_MODE,         LEN_PLV
     &  ,XHAIR_LOAD1,       LEN_XLD1
     &  ,XHAIR_LOAD2,       LEN_XLD2
     &  ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &  ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &  ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
     &  ,COLOURS,           LEN_CLR, INITCLR, NUMCLR
     &  ,VIDEO_OFF,         LEN_VDF
     &  ,VIDEO_ON,          LEN_VDN
     &  ,VECTOR_INIT_MODE,  LEN_VIMODE
     &  ,VECTOR_MODE,       LEN_VMODE
     &  ,ALPHA_MODE,        LEN_AMODE
     &  ,POINT_MODE,        LEN_PMODE
C
      COMMON /PLOTMONITOR/ IMONITOR, IOUTM
C
      LOGICAL IN_GRAPH_MODE
      COMMON /GRAPH_MODE/ IN_GRAPH_MODE
C
      COMMON /MONITOR_SIZE/ XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE
C
C Flag to see if in transparent mode
C
      LOGICAL INTMOD
      COMMON /IN_TRANS_MODE/ INTMOD
C
      COMMON /PLOT_BUFFER/ INDEX, IMODE, BUFFER
      BYTE BUFFER(78)   ! modified by J.Chuma, 19Mar97 for g77
C                          was LOGICAL*1
C
C Previous TEK codes
C
      COMMON /TEK_PREVIOUS/ IYHIP, IYLOP, IXHIP, IXLOP, IEXTRAP
C
C Flag for point plot mode, TEK4014 output
C
      LOGICAL IN_POINT_MODE
      INTEGER IXPIXEL, IYPIXEL      !pixel last referenced
      LOGICAL DONT_PLOT

      DATA IN_POINT_MODE /.FALSE./
CCC
      IF( .NOT.IN_GRAPH_MODE )WRITE(IOUTM,10)ENTER_GRAPH_MODE(1:LEN_GRM)
C10   FORMAT('+',A,$)
10    FORMAT(' ',A,$)
      IN_GRAPH_MODE = .TRUE.
      IF( INTMOD )THEN
        INTMOD = .FALSE.
        DO I = 1, LEN_VIMODE
          CALL PACK_BUFFER( ICHAR(VECTOR_INIT_MODE(I:I)) )
        END DO
      END IF
      IF( TERMTYPE .EQ. 1 )THEN                 ! TEK4010 type terminal
        IXM = XM * PMON_XFRAC + PMON_XOFF
        IYM = YM * PMON_YFRAC + PMON_YOFF
        IF( DONT_PLOT )
     &   DONT_PLOT = ((IXM .EQ. IXPIXEL) .AND. (IYM .EQ. IYPIXEL))
        IXPIXEL = IXM
        IYPIXEL = IYM
        IF( DONT_PLOT )RETURN
C
C  Encode coordinates in Tektronix format
C
        IYHI = 32+IYM/32
        IYLO = 96+MOD(IYM,32)
        IXHI = 32+IXM/32
        IXLO = 64+MOD(IXM,32)
C
C   enter vector mode 
C   TK4010 type does not have point mode, so enter vector mode
C   and do a pen up then a pen down
C
        DO I = 1, LEN_VMODE
          CALL PACK_BUFFER( ICHAR(VECTOR_MODE(I:I)) )
        END DO
C
C  Prepare the plot buffer for the coordinate codes
C
        IF( IPEN .EQ. 2 )THEN   ! pen down
          CALL PACK_BUFFER(IYHIP)
          CALL PACK_BUFFER(IYLOP)
          CALL PACK_BUFFER(IXHIP)
          CALL PACK_BUFFER(IXLOP)
          CALL CHECK_BUFFER
        END IF
C
C  Put the coordinate codes in the buffer
C  first vector sequence in the buffer must always have all the bytes
C
        IF( INDEX .LE. 1 )THEN
          CALL PACK_BUFFER(IYHI)
          CALL PACK_BUFFER(IYLO)
          CALL PACK_BUFFER(IXHI)
          IYHIP   = IYHI
          IYLOP   = IYLO
          IXHIP   = IXHI
        ELSE                       ! Pack only necessary bytes in buffer
          IF( IYHI .NE. IYHIP )THEN      !Pack YHI
            CALL PACK_BUFFER(IYHI)
            IYHIP = IYHI
          END IF
          IF( IXHI .NE. IXHIP )THEN      !Pack XHI (& therefore YLO)
            CALL PACK_BUFFER(IYLO)
            CALL PACK_BUFFER(IXHI)
            IXHIP = IXHI
            IYLOP = IYLO
          ELSE
            IF( IYLO .NE. IYLOP )THEN    !Pack YLO
              CALL PACK_BUFFER(IYLO)
              IYLOP = IYLO
            END IF
          END IF
        END IF
        CALL PACK_BUFFER(IXLO)     !Always pack XLO
        IXLOP = IXLO
C
C must follow penup with pendown to plot a point
C
        IF( IPEN .EQ. 20 )CALL PACK_BUFFER(IXLO)
        CALL CHECK_BUFFER
        RETURN        
      ELSE IF( TERMTYPE .EQ. 2 )THEN   ! TEK4014 type terminal
        IXM = XM * PMON_XFRAC + PMON_XOFF
        IYM = YM * PMON_YFRAC + PMON_YOFF
        IF( DONT_PLOT )
     &   DONT_PLOT = ((IXM .EQ. IXPIXEL) .AND. (IYM .EQ. IYPIXEL))
        IXPIXEL = IXM
        IYPIXEL = IYM
        IF( DONT_PLOT )RETURN
C
C  Encode coordinates in Tektronix format:
C  Get extra byte for 4014
C
        IEXTRA = 96+4*(MOD(IYM,4))+MOD(IXM,4)
        IXM    = IXM/4
        IYM    = IYM/4
C
        IYHI = 32+IYM/32
        IYLO = 96+MOD(IYM,32)
        IXHI = 32+IXM/32
        IXLO = 64+MOD(IXM,32)
C
C  Prepare the plot buffer for the coordinate codes
C
        IF( (IPEN .EQ. 2) .AND. IN_POINT_MODE )THEN   ! pen down
C
C   enter alpha mode which leave point mode
C
          DO I = 1, LEN_AMODE
            CALL PACK_BUFFER( ICHAR(ALPHA_MODE(I:I)) )
          END DO
C
C   enter vector mode
C
          DO I = 1, LEN_VMODE
            CALL PACK_BUFFER( ICHAR(VECTOR_MODE(I:I)) )
          END DO
          CALL PACK_BUFFER(IYHIP)
          CALL PACK_BUFFER(IEXTRAP)
          CALL PACK_BUFFER(IYLOP)
          CALL PACK_BUFFER(IXHIP)
          CALL PACK_BUFFER(IXLOP)
          CALL CHECK_BUFFER
          IN_POINT_MODE = .FALSE.
        ELSE IF( IPEN .EQ. 3 )THEN  ! pen up
          IF( IN_POINT_MODE )THEN
C
C   enter alpha mode which leave point mode
C
            DO I = 1, LEN_AMODE
              CALL PACK_BUFFER( ICHAR(ALPHA_MODE(I:I)) )
            END DO
            IN_POINT_MODE = .FALSE.
          END IF
C
C   enter vector mode
C
          DO I = 1, LEN_VMODE
            CALL PACK_BUFFER( ICHAR(VECTOR_MODE(I:I)) )
          END DO
        ELSE IF( IPEN .EQ. 20 )THEN  ! point
          IF( .NOT.IN_POINT_MODE .OR. (INDEX .LE. 6) )THEN
C
C   enter point mode
C
            DO I = 1, LEN_PMODE
              CALL PACK_BUFFER( ICHAR(POINT_MODE(I:I)) )
            END DO
          END IF
          IN_POINT_MODE = .TRUE.
        END IF
C
C  Put the coordinate codes in the buffer.
C  first vector sequence in the buffer must always have all the bytes
C
        IF( INDEX .LE. 1 )THEN
          CALL PACK_BUFFER(IYHI)
          CALL PACK_BUFFER(IEXTRA)
          CALL PACK_BUFFER(IYLO)
          CALL PACK_BUFFER(IXHI)
          IYHIP   = IYHI
          IEXTRAP = IEXTRA
          IYLOP   = IYLO
          IXHIP   = IXHI
        ELSE                       ! Pack only necessary bytes in buffer
          IF( IYHI .NE. IYHIP )THEN        !Pack YHI
            CALL PACK_BUFFER(IYHI)
            IYHIP = IYHI
          END IF
          IF( IEXTRA .NE. IEXTRAP )THEN    !Pack EXTRA
            CALL PACK_BUFFER(IEXTRA)
            CALL PACK_BUFFER(IYLO)         !Must also pack YLO
            IEXTRAP = IEXTRA
            IYLOP   = IYLO
            IF( IXHI .NE. IXHIP )THEN      ! Pack XHI
              CALL PACK_BUFFER(IXHI)
              IXHIP = IXHI
            END IF
          ELSE
            IF( IXHI .NE. IXHIP )THEN      !Pack XHI (& therefore YLO)
              CALL PACK_BUFFER(IYLO)
              CALL PACK_BUFFER(IXHI)
              IXHIP = IXHI
              IYLOP = IYLO
            ELSE
              IF( IYLO .NE. IYLOP )THEN    !Pack YLO
                CALL PACK_BUFFER(IYLO)
                IYLOP = IYLO
              END IF
            END IF
          END IF
        END IF
        CALL PACK_BUFFER(IXLO)             !Always pack XLO
        IXLOP = IXLO
        CALL CHECK_BUFFER
        RETURN
      ELSE IF( TERMTYPE .EQ. 3 )THEN   !  REGIS type terminal
        IXM = NINT(XM)
        IYM = NINT(YM)
        IYM = ABS(IYM-INT(YMAXMSIZE))
        IF( IPEN .EQ. 3 )THEN       ! Pen up
          CALL PACK_BUFFER(80)            ! P
        ELSE IF( IPEN .EQ. 2 )THEN  ! Pen down
C
C VT241 quirk: the first pixel of a vector is missing if the previous
C move was a pen up.  Fix this by doing a pen down to the previous
C location:
C
          IF( IPENOLD .EQ. 3 )THEN
            CALL PACK_BUFFER(86)          ! V
            CALL PACK_BUFFER(91)          ! [
            CALL PACK_BUFFER(93)          ! ]
          END IF
          CALL PACK_BUFFER(86)            ! V
        ELSE IF( IPEN .EQ. 20 )THEN   ! plot point
          CALL PACK_BUFFER(80)            ! P
        END IF
        CALL PACK_BUFFER(91)              ! [
        ICH1 = IXM/100
        IT   = IXM/10
        ICH2 = IT - 10*ICH1
        ICH3 = IXM - 10*IT
        CALL PACK_BUFFER(ICH1+48)
        CALL PACK_BUFFER(ICH2+48)
        CALL PACK_BUFFER(ICH3+48)
        CALL PACK_BUFFER(44)              ! ,
        ICH1 = IYM/100
        IT   = IYM/10
        ICH2 = IT - 10*ICH1
        ICH3 = IYM - 10*IT
        CALL PACK_BUFFER(ICH1+48)
        CALL PACK_BUFFER(ICH2+48)
        CALL PACK_BUFFER(ICH3+48)
        CALL PACK_BUFFER(93)              ! ]
        IF( IPEN .EQ. 20 )THEN
          CALL PACK_BUFFER(86)            ! V
          CALL PACK_BUFFER(91)            ! [
          CALL PACK_BUFFER(93)            ! ]
        END IF
        CALL CHECK_BUFFER
        IPENOLD = IPEN        !    save the pen code
        RETURN
      END IF
      END
CCCCCC
      SUBROUTINE GENERIC_TRANSPARENT_MODE
C
C  Enter alphanumeric screen mode
C
      CHARACTER GRAPHICS_CLEAR*132
     &         ,TRANSPARENT_CLEAR*132
     &         ,ENTER_TRANS_MODE*132
     &         ,ENTER_GRAPH_MODE*132
     &         ,PLOT_MODE(0:2)*132
     &         ,XHAIR_LOAD1*132, XHAIR_LOAD2*132
     &         ,COLOURS(0:20)*132
     &         ,VIDEO_OFF*132
     &         ,VIDEO_ON*132
     &         ,VECTOR_INIT_MODE*132
     &         ,VECTOR_MODE*132
     &         ,ALPHA_MODE*132
     &         ,POINT_MODE*132
      REAL*4    XMIN, XMAX, YMIN, YMAX
     &         ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &         ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &         ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
      INTEGER*4 LEN_PLV(0:2), LEN_CLR(0:20), INITCLR, NUMCLR, TERMTYPE
     &         ,LEN_VMODE, LEN_AMODE, LEN_PMODE
      COMMON /GENERIC_TERMINAL/ 
     &   TERMTYPE
     &  ,XMIN, XMAX, YMIN, YMAX
     &  ,GRAPHICS_CLEAR,    LEN_GCL
     &  ,TRANSPARENT_CLEAR, LEN_TCL
     &  ,ENTER_TRANS_MODE,  LEN_TRM
     &  ,ENTER_GRAPH_MODE,  LEN_GRM
     &  ,PLOT_MODE,         LEN_PLV
     &  ,XHAIR_LOAD1,       LEN_XLD1
     &  ,XHAIR_LOAD2,       LEN_XLD2
     &  ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &  ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &  ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
     &  ,COLOURS,           LEN_CLR, INITCLR, NUMCLR
     &  ,VIDEO_OFF,         LEN_VDF
     &  ,VIDEO_ON,          LEN_VDN
     &  ,VECTOR_INIT_MODE,  LEN_VIMODE
     &  ,VECTOR_MODE,       LEN_VMODE
     &  ,ALPHA_MODE,        LEN_AMODE
     &  ,POINT_MODE,        LEN_PMODE
C
      COMMON /PLOTMONITOR/ IMONITOR, IOUTM
C
      LOGICAL IN_GRAPH_MODE
      COMMON /GRAPH_MODE/ IN_GRAPH_MODE
C
      LOGICAL INTMOD
      COMMON /IN_TRANS_MODE/ INTMOD
      DATA INTMOD /.TRUE./
CCC
      INTMOD = .TRUE.
      WRITE(IOUTM,10)ENTER_TRANS_MODE(1:LEN_TRM)
C10   FORMAT('+',A,$)
10    FORMAT(' ',A,$)
      IN_GRAPH_MODE = .FALSE.
      RETURN
      END
CCCCCC
      SUBROUTINE GENERIC_PLOT_MODE( ILEVEL )
C
C   ILEVEL = 0: dots turned on (default)
C          = 1: dots turned off
C          = 2: dots complemented or toggled
C
      CHARACTER GRAPHICS_CLEAR*132
     &         ,TRANSPARENT_CLEAR*132
     &         ,ENTER_TRANS_MODE*132
     &         ,ENTER_GRAPH_MODE*132
     &         ,PLOT_MODE(0:2)*132
     &         ,XHAIR_LOAD1*132, XHAIR_LOAD2*132
     &         ,COLOURS(0:20)*132
     &         ,VIDEO_OFF*132
     &         ,VIDEO_ON*132
     &         ,VECTOR_INIT_MODE*132
     &         ,VECTOR_MODE*132
     &         ,ALPHA_MODE*132
     &         ,POINT_MODE*132
      REAL*4    XMIN, XMAX, YMIN, YMAX
     &         ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &         ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &         ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
      INTEGER*4 LEN_PLV(0:2), LEN_CLR(0:20), INITCLR, NUMCLR, TERMTYPE
     &         ,LEN_VMODE, LEN_AMODE, LEN_PMODE
      COMMON /GENERIC_TERMINAL/ 
     &   TERMTYPE
     &  ,XMIN, XMAX, YMIN, YMAX
     &  ,GRAPHICS_CLEAR,    LEN_GCL
     &  ,TRANSPARENT_CLEAR, LEN_TCL
     &  ,ENTER_TRANS_MODE,  LEN_TRM
     &  ,ENTER_GRAPH_MODE,  LEN_GRM
     &  ,PLOT_MODE,         LEN_PLV
     &  ,XHAIR_LOAD1,       LEN_XLD1
     &  ,XHAIR_LOAD2,       LEN_XLD2
     &  ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &  ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &  ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
     &  ,COLOURS,           LEN_CLR, INITCLR, NUMCLR
     &  ,VIDEO_OFF,         LEN_VDF
     &  ,VIDEO_ON,          LEN_VDN
     &  ,VECTOR_INIT_MODE,  LEN_VIMODE
     &  ,VECTOR_MODE,       LEN_VMODE
     &  ,ALPHA_MODE,        LEN_AMODE
     &  ,POINT_MODE,        LEN_PMODE
C
      COMMON /PLOTMONITOR/ IMONITOR, IOUTM
C
      LOGICAL IN_GRAPH_MODE
      COMMON /GRAPH_MODE/ IN_GRAPH_MODE
C
      COMMON /GENERIC_COLOUR/ ICODE_SAVE
C
      IF( (ILEVEL .LT. 0) .OR. (ILEVEL .GT. 2) )RETURN
      IF( TERMTYPE .EQ. 3 )CALL REGIS_MODE
      IF( LEN_PLV(ILEVEL) .GT. 0 )THEN
        WRITE(IOUTM,10)PLOT_MODE( ILEVEL )(1:LEN_PLV(ILEVEL))
C10     FORMAT('+',A)
10      FORMAT(' ',A)
        ICODE = ICODE_SAVE
        IF( ILEVEL .EQ. 0 )CALL GENERIC_COLOR( ICODE )
      END IF
      RETURN
      END
CCCCCC
      SUBROUTINE GENERIC_CROSSHAIR( XM, YM, CODE, XLM, YLM )
C
C 2.147E9 is slightly < the maximum value that an integer can have
C
      PARAMETER (BIG = 2.147E9)
      CHARACTER*1 READ_KEY, ALTKEY, ESC, CR
      INTEGER     I33
      BYTE        CODE, IYHI, IYLO, IXHI, IXLO
      BYTE        IBYTE(4), IREGIS(11)

      CHARACTER GRAPHICS_CLEAR*132
     &         ,TRANSPARENT_CLEAR*132
     &         ,ENTER_TRANS_MODE*132
     &         ,ENTER_GRAPH_MODE*132
     &         ,PLOT_MODE(0:2)*132
     &         ,XHAIR_LOAD1*132, XHAIR_LOAD2*132
     &         ,COLOURS(0:20)*132
     &         ,VIDEO_OFF*132
     &         ,VIDEO_ON*132
     &         ,VECTOR_INIT_MODE*132
     &         ,VECTOR_MODE*132
     &         ,ALPHA_MODE*132
     &         ,POINT_MODE*132
      REAL*4    XMIN, XMAX, YMIN, YMAX
     &         ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &         ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &         ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
      INTEGER*4 LEN_PLV(0:2), LEN_CLR(0:20), INITCLR, NUMCLR, TERMTYPE
     &         ,LEN_VMODE, LEN_AMODE, LEN_PMODE
      COMMON /GENERIC_TERMINAL/ 
     &   TERMTYPE
     &  ,XMIN, XMAX, YMIN, YMAX
     &  ,GRAPHICS_CLEAR,    LEN_GCL
     &  ,TRANSPARENT_CLEAR, LEN_TCL
     &  ,ENTER_TRANS_MODE,  LEN_TRM
     &  ,ENTER_GRAPH_MODE,  LEN_GRM
     &  ,PLOT_MODE,         LEN_PLV
     &  ,XHAIR_LOAD1,       LEN_XLD1
     &  ,XHAIR_LOAD2,       LEN_XLD2
     &  ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &  ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &  ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
     &  ,COLOURS,           LEN_CLR, INITCLR, NUMCLR
     &  ,VIDEO_OFF,         LEN_VDF
     &  ,VIDEO_ON,          LEN_VDN
     &  ,VECTOR_INIT_MODE,  LEN_VIMODE
     &  ,VECTOR_MODE,       LEN_VMODE
     &  ,ALPHA_MODE,        LEN_AMODE
     &  ,POINT_MODE,        LEN_PMODE
C
      COMMON /PLOTMONITOR/ IMONITOR, IOUTM
C
      LOGICAL IN_GRAPH_MODE
      COMMON /GRAPH_MODE/ IN_GRAPH_MODE
C
      COMMON /MONITOR_SIZE/ XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE

      DATA  I33 /33/
CCC
      ESC = CHAR(27)
      CR = CHAR(13)

      IF( (TERMTYPE .EQ. 1) .OR. (TERMTYPE .EQ. 2) )THEN  ! 4010 or 4014
C
C   (IXLM,IYLM) are the monitor dot coordinates which
C   correspond to the plot coordinates (XL,YL)
C
        IXLM = MAX(-BIG, MIN(BIG,XLM+SIGN(.5,XLM)) )
        IYLM = MAX(-BIG, MIN(BIG,YLM+SIGN(.5,YLM)) )
C
C   If (IXLM,IYLM) is off the monitor screen. Display the crosshair at
C   the center of the screen
C
        IF( (IXLM .LT. XMINMSIZE) .OR. (IXLM .GT. XMAXMSIZE) )
     &   IXLM = (XMAXMSIZE + XMINMSIZE) / 2
        IF( (IYLM .LT. YMINMSIZE) .OR. (IYLM .GT. YMAXMSIZE) )
     &   IYLM = (YMAXMSIZE + YMINMSIZE) / 2
C
C   (IXLM,IYLM) must be on the monitor screen
C   Load the crosshair to location (IXLM,IYLM) on the screen
C
C   Scale and offset 
C
        IXLM = IXLM * XHAIR_XFRAC_1 + XHAIR_XOFF_1
        IYLM = IYLM * XHAIR_YFRAC_1 + XHAIR_YOFF_1
C
C   Calculate the four plot characters required to load the
C   crosshair to the TX4010 location: (IXLM,IYLM)
C
        IYHI = 32+IYLM/32
        IYLO = 96+MOD(IYLM,32)
        IXHI = 32+IXLM/32
        IXLO = 64+MOD(IXLM,32)
C
C   Load the crosshair at the TX4010 location: (IXLM,IYLM)
C
        IF( .NOT.IN_GRAPH_MODE )
     &   WRITE(IOUTM,11)ENTER_GRAPH_MODE(1:LEN_GRM)
C11     FORMAT('+',A,$)
11      FORMAT(' ',A,$)
        WRITE(IOUTM,10)XHAIR_LOAD1(1:LEN_XLD1)
     &              ,IYHI,IYLO,IXHI,IXLO
     &              ,XHAIR_LOAD2(1:LEN_XLD2)
C10     FORMAT('$',A,4A1,A)
10      FORMAT(' ',A,4A1,A,$)
        CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY,0))
        DO WHILE ( (CODE .EQ. ICHAR(CR)) .OR. (CODE .EQ. ICHAR(ESC)) )
          WRITE(IOUTM,10)XHAIR_LOAD1(1:LEN_XLD1)
     &                ,IYHI,IYLO,IXHI,IXLO
     &                ,XHAIR_LOAD2(1:LEN_XLD2)
          CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY,0))
        END DO
        DO IBYTER = 1, 4
          IBYTE(IBYTER) = ICHAR(READ_KEY('NOESC',' ',ALTKEY,0))
        END DO
        IDUMMY = ICHAR(READ_KEY(' ',' ',ALTKEY,0))
C
C   Calculate the crosshair coordinates (IXM,IYM) for the device
C
        IXM = (IBYTE(1)-I33)*32+IBYTE(2)
        IYM = (IBYTE(3)-I33)*32+IBYTE(4)
        IXM = MAX(0,IXM)
        IYM = MAX(0,IYM)
        IXM = MIN(IXM,1023)
        IYM = MIN(IYM,1023)
C
C   Scale and offset 
C
        XM = IXM * XHAIR_XFRAC_2 + XHAIR_XOFF_2
        YM = IYM * XHAIR_YFRAC_2 + XHAIR_YOFF_2
      ELSE IF( TERMTYPE .EQ. 3 )THEN
        CALL REGIS_MODE
C
C   (IXLM,IYLM) are the monitor dot coordinates which
C   correspond to the plot coordinates (XL,YL)
C
        XLM = MAX(-BIG,MIN(BIG,XLM))
        YLM = MAX(-BIG,MIN(BIG,YLM))
        IXLM = NINT(XLM)
        IYLM = NINT(YLM)
C
C   If (IXLM,IYLM) is off the monitor screen. Display the crosshair at
C   the center of the screen
C
        IF( (IXLM .LT. XMINMSIZE) .OR. (IXLM .GT. XMAXMSIZE) )
     &   IXLM = (XMAXMSIZE + XMINMSIZE) / 2
        IF( (IYLM .LT. YMINMSIZE) .OR. (IYLM .GT. YMAXMSIZE) )
     &   IYLM = (YMAXMSIZE + YMINMSIZE) / 2
C
C   (IXLM,IYLM) is on the monitor screen
C   Load the crosshair to location (IXLM,IYLM) on the screen
C
        IYLM = ABS(IYLM-INT(YMAXMSIZE))
C
C   Load the crosshair at the REGIS location: (IXLM,IYLM)
C
        WRITE(IOUTM,20)XHAIR_LOAD1(1:LEN_XLD1)//'['
     &                ,IXLM,',',IYLM
     &                ,']'//XHAIR_LOAD2(1:LEN_XLD2)
20      FORMAT(' ',A,I3.3,A1,I3.3,A)
C
C Read code and cross-hair coordinates
C
        CODE = ICHAR(READ_KEY('NOESC LC2UC',' ',ALTKEY,0))
        IREGIS(1) = ICHAR(READ_KEY('NOESC',' ',ALTKEY,0))
        IREGISR = 1
	DO WHILE (IREGIS(IREGISR) .NE. ICHAR(CR))
          IREGISR = IREGISR+1
          IREGIS(IREGISR) = ICHAR(READ_KEY('NOESC',' ',ALTKEY,0))
	END DO
        IREGISR = IREGISR-1
C
C  Interpret string IREGIS as P[xxx,yyy]
C     Extract xxx  ---> IXM  ,   yyy ----> IYM
C
        IYM = 0
        I   = IREGISR-1                    ! Start at last y
        J   = 0
        DO WHILE (IREGIS(I) .NE. ICHAR(','))
          IYM = IYM+(IREGIS(I)-48)*10**J
          I   = I-1
          J   = J+1
        END DO
        I   = I-1                        ! Start at last x
        IXM = 0
        J   = 0
        DO WHILE (IREGIS(I) .NE. ICHAR('['))
          IXM = IXM+(IREGIS(I)-48)*10**J
          I = I-1
          J = J+1
        END DO
        IYM = ABS(INT(YMAXMSIZE)-IYM)
        XM = IXM
        YM = IYM
      END IF
      RETURN
      END
CCCCCC
      SUBROUTINE GENERIC_COLOR( ICODE )
C
      CHARACTER GRAPHICS_CLEAR*132
     &         ,TRANSPARENT_CLEAR*132
     &         ,ENTER_TRANS_MODE*132
     &         ,ENTER_GRAPH_MODE*132
     &         ,PLOT_MODE(0:2)*132
     &         ,XHAIR_LOAD1*132, XHAIR_LOAD2*132
     &         ,COLOURS(0:20)*132
     &         ,VIDEO_OFF*132
     &         ,VIDEO_ON*132
     &         ,VECTOR_INIT_MODE*132
     &         ,VECTOR_MODE*132
     &         ,ALPHA_MODE*132
     &         ,POINT_MODE*132
      REAL*4    XMIN, XMAX, YMIN, YMAX
     &         ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &         ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &         ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
      INTEGER*4 LEN_PLV(0:2), LEN_CLR(0:20), INITCLR, NUMCLR, TERMTYPE
     &         ,LEN_VMODE, LEN_AMODE, LEN_PMODE
      COMMON /GENERIC_TERMINAL/ 
     &   TERMTYPE
     &  ,XMIN, XMAX, YMIN, YMAX
     &  ,GRAPHICS_CLEAR,    LEN_GCL
     &  ,TRANSPARENT_CLEAR, LEN_TCL
     &  ,ENTER_TRANS_MODE,  LEN_TRM
     &  ,ENTER_GRAPH_MODE,  LEN_GRM
     &  ,PLOT_MODE,         LEN_PLV
     &  ,XHAIR_LOAD1,       LEN_XLD1
     &  ,XHAIR_LOAD2,       LEN_XLD2
     &  ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &  ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &  ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
     &  ,COLOURS,           LEN_CLR, INITCLR, NUMCLR
     &  ,VIDEO_OFF,         LEN_VDF
     &  ,VIDEO_ON,          LEN_VDN
     &  ,VECTOR_INIT_MODE,  LEN_VIMODE
     &  ,VECTOR_MODE,       LEN_VMODE
     &  ,ALPHA_MODE,        LEN_AMODE
     &  ,POINT_MODE,        LEN_PMODE
C
      COMMON /PLOTMONITOR/ IMONITOR, IOUTM
C
      LOGICAL IN_GRAPH_MODE
      COMMON /GRAPH_MODE/ IN_GRAPH_MODE
C
      COMMON /GENERIC_COLOUR/ ICODE_SAVE
C
      IF( NUMCLR .EQ. 0 )RETURN
      ICODE1=ICODE
      IF( (ICODE1 .LT. INITCLR) .OR. (ICODE1 .GT. NUMCLR) )ICODE1=NUMCLR
      CALL FLUSH_PLOT
      IF( TERMTYPE .EQ. 3 )CALL REGIS_MODE
      WRITE(IOUTM,10)COLOURS(ICODE1)(1:LEN_CLR(ICODE1))
C10   FORMAT('+',A,$)
10    FORMAT(' ',A,$)
      ICODE_SAVE = ICODE1
      RETURN
      END
CCCCCC
      SUBROUTINE GENERIC_VIDEO_OFF( OPTION )
C
C    Subroutine to turn off the graphic screen without clearing the
C    graphics.  If OPTION is .TRUE., then turn off the graphics screen.
C    If OPTION is .FALSE., then turn on the graphics screen.
C
C    INPUT:  OPTION  (LOGICAL)
C    OUTPUT: none
C
      LOGICAL OPTION
C
      CHARACTER GRAPHICS_CLEAR*132
     &         ,TRANSPARENT_CLEAR*132
     &         ,ENTER_TRANS_MODE*132
     &         ,ENTER_GRAPH_MODE*132
     &         ,PLOT_MODE(0:2)*132
     &         ,XHAIR_LOAD1*132, XHAIR_LOAD2*132
     &         ,COLOURS(0:20)*132
     &         ,VIDEO_OFF*132
     &         ,VIDEO_ON*132
     &         ,VECTOR_INIT_MODE*132
     &         ,VECTOR_MODE*132
     &         ,ALPHA_MODE*132
     &         ,POINT_MODE*132
      REAL*4    XMIN, XMAX, YMIN, YMAX
     &         ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &         ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &         ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
      INTEGER*4 LEN_PLV(0:2), LEN_CLR(0:20), INITCLR, NUMCLR, TERMTYPE
     &         ,LEN_VMODE, LEN_AMODE, LEN_PMODE
      COMMON /GENERIC_TERMINAL/ 
     &   TERMTYPE
     &  ,XMIN, XMAX, YMIN, YMAX
     &  ,GRAPHICS_CLEAR,    LEN_GCL
     &  ,TRANSPARENT_CLEAR, LEN_TCL
     &  ,ENTER_TRANS_MODE,  LEN_TRM
     &  ,ENTER_GRAPH_MODE,  LEN_GRM
     &  ,PLOT_MODE,         LEN_PLV
     &  ,XHAIR_LOAD1,       LEN_XLD1
     &  ,XHAIR_LOAD2,       LEN_XLD2
     &  ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &  ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &  ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
     &  ,COLOURS,           LEN_CLR, INITCLR, NUMCLR
     &  ,VIDEO_OFF,         LEN_VDF
     &  ,VIDEO_ON,          LEN_VDN
     &  ,VECTOR_INIT_MODE,  LEN_VIMODE
     &  ,VECTOR_MODE,       LEN_VMODE
     &  ,ALPHA_MODE,        LEN_AMODE
     &  ,POINT_MODE,        LEN_PMODE
C
      COMMON /PLOTMONITOR/ IMONITOR, IOUTM
C
      LOGICAL IN_GRAPH_MODE
      COMMON /GRAPH_MODE/ IN_GRAPH_MODE
C
      IF( OPTION )THEN                    ! turn off the graphics screen
        IF( LEN_VDF .GT. 0 )WRITE(IOUTM,10)VIDEO_OFF(1:LEN_VDF)
      ELSE                                ! turn on the graphics screen
        IF( LEN_VDN .GT. 0 )WRITE(IOUTM,10)VIDEO_ON(1:LEN_VDN)
      END IF
C10   FORMAT('+',A)
10    FORMAT(' ',A)
      RETURN
      END
CCCCCC
      SUBROUTINE GENERIC_CHECK_BUFFER
C
      BYTE BUFFER(78)
      COMMON /PLOT_BUFFER/ INDEX, IMODE, BUFFER
C
      CHARACTER GRAPHICS_CLEAR*132
     &         ,TRANSPARENT_CLEAR*132
     &         ,ENTER_TRANS_MODE*132
     &         ,ENTER_GRAPH_MODE*132
     &         ,PLOT_MODE(0:2)*132
     &         ,XHAIR_LOAD1*132, XHAIR_LOAD2*132
     &         ,COLOURS(0:20)*132
     &         ,VIDEO_OFF*132
     &         ,VIDEO_ON*132
     &         ,VECTOR_INIT_MODE*132
     &         ,VECTOR_MODE*132
     &         ,ALPHA_MODE*132
     &         ,POINT_MODE*132
      REAL*4    XMIN, XMAX, YMIN, YMAX
     &         ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &         ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &         ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
      INTEGER*4 LEN_PLV(0:2), LEN_CLR(0:20), INITCLR, NUMCLR, TERMTYPE
     &         ,LEN_VMODE, LEN_AMODE, LEN_PMODE
      COMMON /GENERIC_TERMINAL/ 
     &   TERMTYPE
     &  ,XMIN, XMAX, YMIN, YMAX
     &  ,GRAPHICS_CLEAR,    LEN_GCL
     &  ,TRANSPARENT_CLEAR, LEN_TCL
     &  ,ENTER_TRANS_MODE,  LEN_TRM
     &  ,ENTER_GRAPH_MODE,  LEN_GRM
     &  ,PLOT_MODE,         LEN_PLV
     &  ,XHAIR_LOAD1,       LEN_XLD1
     &  ,XHAIR_LOAD2,       LEN_XLD2
     &  ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &  ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &  ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
     &  ,COLOURS,           LEN_CLR, INITCLR, NUMCLR
     &  ,VIDEO_OFF,         LEN_VDF
     &  ,VIDEO_ON,          LEN_VDN
     &  ,VECTOR_INIT_MODE,  LEN_VIMODE
     &  ,VECTOR_MODE,       LEN_VMODE
     &  ,ALPHA_MODE,        LEN_AMODE
     &  ,POINT_MODE,        LEN_PMODE
C
      COMMON /PLOTMONITOR/ IMONITOR, IOUTM
C
      LOGICAL IN_GRAPH_MODE
      COMMON /GRAPH_MODE/ IN_GRAPH_MODE
C
C Previous TEK codes:
C
      COMMON /TEK_PREVIOUS/ IYHIP, IYLOP, IXHIP, IXLOP, IEXTRAP
C
      IF( TERMTYPE .EQ. 1 )THEN   !   TK4010 terminal type
C
C   Enter alpha mode
C
        DO I = 1, LEN_AMODE
          CALL PACK_BUFFER( ICHAR(ALPHA_MODE(I:I)) )
        END DO
        CALL GENERIC_PRINT_BUFFER      ! Print the buffer.
C
C Move with pen up to the last point plotted on the screen...
C   Enter vector mode
C
        DO I = 1, LEN_VMODE
          CALL PACK_BUFFER( ICHAR(VECTOR_MODE(I:I)) )
        END DO
C
C We must pack all the bytes for the first vector as the terminal
C may receive other data before the next buffer is printed:
C
        CALL PACK_BUFFER(IYHIP)
        CALL PACK_BUFFER(IYLOP)
        CALL PACK_BUFFER(IXHIP)
        CALL PACK_BUFFER(IXLOP)
      ELSE IF( TERMTYPE .EQ. 2 )THEN    !   TK4014 terminal type
C
C   Enter alpha mode
C
        DO I = 1, LEN_AMODE
          CALL PACK_BUFFER( ICHAR(ALPHA_MODE(I:I)) )
        END DO
        CALL GENERIC_PRINT_BUFFER      ! Print the buffer.
C
C Move with pen up to the last point plotted on the screen...
C   Enter vector mode
C
        DO I = 1, LEN_VMODE
          CALL PACK_BUFFER( ICHAR(VECTOR_MODE(I:I)) )
        END DO
C
C We must pack all the bytes for the first vector as the terminal
C may receive other data before the next buffer is printed:
C
        CALL PACK_BUFFER(IYHIP)
        CALL PACK_BUFFER(IEXTRAP)
        CALL PACK_BUFFER(IYLOP)
        CALL PACK_BUFFER(IXHIP)
        CALL PACK_BUFFER(IXLOP)
      ELSE IF( TERMTYPE .EQ. 3 )THEN    !    REGIS terminal type
        INDEX_S = INDEX
        CALL REGIS_MODE
        CALL GENERIC_PRINT_BUFFER
        IF( INDEX_S .LT. 10 )RETURN
C
C   Penup move to last location plotted:
C
        BUFFER(1) = ICHAR('P')
        CALL MOVEC(9,BUFFER(INDEX_S-8),BUFFER(2))
        INDEX = 10
      END IF
      RETURN
      END
CCCCCC
      SUBROUTINE GENERIC_PRINT_BUFFER
C
C  prints the plot buffer to the screen
C
      CHARACTER GRAPHICS_CLEAR*132
     &         ,TRANSPARENT_CLEAR*132
     &         ,ENTER_TRANS_MODE*132
     &         ,ENTER_GRAPH_MODE*132
     &         ,PLOT_MODE(0:2)*132
     &         ,XHAIR_LOAD1*132, XHAIR_LOAD2*132
     &         ,COLOURS(0:20)*132
     &         ,VIDEO_OFF*132
     &         ,VIDEO_ON*132
     &         ,VECTOR_INIT_MODE*132
     &         ,VECTOR_MODE*132
     &         ,ALPHA_MODE*132
     &         ,POINT_MODE*132
      REAL*4    XMIN, XMAX, YMIN, YMAX
     &         ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &         ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &         ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
      INTEGER*4 LEN_PLV(0:2), LEN_CLR(0:20), INITCLR, NUMCLR, TERMTYPE
     &         ,LEN_VMODE, LEN_AMODE, LEN_PMODE
      COMMON /GENERIC_TERMINAL/ 
     &   TERMTYPE
     &  ,XMIN, XMAX, YMIN, YMAX
     &  ,GRAPHICS_CLEAR,    LEN_GCL
     &  ,TRANSPARENT_CLEAR, LEN_TCL
     &  ,ENTER_TRANS_MODE,  LEN_TRM
     &  ,ENTER_GRAPH_MODE,  LEN_GRM
     &  ,PLOT_MODE,         LEN_PLV
     &  ,XHAIR_LOAD1,       LEN_XLD1
     &  ,XHAIR_LOAD2,       LEN_XLD2
     &  ,XHAIR_XFRAC_1, XHAIR_XOFF_1, XHAIR_YFRAC_1, XHAIR_YOFF_1
     &  ,XHAIR_XFRAC_2, XHAIR_XOFF_2, XHAIR_YFRAC_2, XHAIR_YOFF_2
     &  ,PMON_XFRAC, PMON_XOFF, PMON_YFRAC, PMON_YOFF
     &  ,COLOURS,           LEN_CLR, INITCLR, NUMCLR
     &  ,VIDEO_OFF,         LEN_VDF
     &  ,VIDEO_ON,          LEN_VDN
     &  ,VECTOR_INIT_MODE,  LEN_VIMODE
     &  ,VECTOR_MODE,       LEN_VMODE
     &  ,ALPHA_MODE,        LEN_AMODE
     &  ,POINT_MODE,        LEN_PMODE
C
      COMMON /PLOTMONITOR/ IMONITOR, IOUTM
C
      LOGICAL IN_GRAPH_MODE
      COMMON /GRAPH_MODE/ IN_GRAPH_MODE
C
      BYTE BUFFER(78)
      COMMON /PLOT_BUFFER/ INDEX, IMODE, BUFFER
C
      IF( TERMTYPE .EQ. 3 )CALL REGIS_MODE
C
C Write out the plot buffer to the screen unit IOUTM.
C Then set INDEX (the number of characters in the buffer) to zero.
C
      IF( .NOT.IN_GRAPH_MODE )WRITE(IOUTM,11)ENTER_GRAPH_MODE(1:LEN_GRM)
C11   FORMAT('+',A,$)
11    FORMAT(' ',A,$)
      IN_GRAPH_MODE = .TRUE.
      IF( INDEX .GT. 0 )WRITE(IOUTM,10)(BUFFER(I),I=1,INDEX)
10    FORMAT(' ',78A1,$)
      INDEX = 0
      RETURN
      END
