      SUBROUTINE GET_ARRAY(IOFF,LTYPE,LENGTH,*)
C**********************************************************************
C
C  GET_ARRAY:  Allocates space for a new array and records the
C              allocation, if successful, in the master table.
C
C  INPUT:
C
C  LENGTH:    The length of the requested space in "elements"
C  LTYPE:     The number of bytes/element
C
C  OUTPUT:
C
C  IOFF:      The offset from the base address in "elements".
C
C  ERROR RETURNS:
C
C  RETURN1: -  LTYPE is not one of 1,2,4 or 8 OR
C           -  You have requested zero space OR
C           -  System cannot get this amount of space OR
C           -  You have exceeded the maximum number of entries
C              in the Master Table (the maximum is specified by
C              the call to ARINIT).
C
C  Descriptive messages are printed on Unit 6 for errors.
C
C      Modified by J. Chuma, March 7, 1997.  Eliminated the "$" from
C      common block and variable names for LINUX g77
C
C**********************************************************************
      COMMON /XD/ I4D
      COMMON /IADDRD/ IADDR
      COMMON /TABLED/ MAXTABLE,NTABLE,IEXIST,IVEC,IADDRESS,IBYTES
      LOGICAL*1 L1D(1)
      INTEGER I4D(1)
      REAL*8 R8D(1)
      EQUIVALENCE(L1D(1),I4D(1),R8D(1))
C****************************** Check LTYPE
      IF(LTYPE.NE.1.AND.LTYPE.NE.2.AND.LTYPE.NE.4.AND.LTYPE.NE.8)
     *THEN
          WRITE(6,10)
10        FORMAT('0*** Error in GET_ARRAY: Invalid LTYPE')
          RETURN1
      END IF
C****************************** Calculate requested space in bytes
      NBYTES=LTYPE*LENGTH
      CALL GET_SPACE(NBYTES,NEWADDR,*900)
      IOFF=(NEWADDR-IADDR)/LTYPE
C**********************************************************************
C  Add this block of space to the master table, so that when it is
C  later freed, FREESPACE will know what size it is.
C  NTABLE is the highest position in the Master Table that has been
C  filled.
C  Search through the first NTABLE elements of the Master Table to see
C  if there are any empty "holes".  If not, increment NTABLE.
C**********************************************************************
      DO 100 I=1,NTABLE
      K=I
      IF(.NOT.L1D(IEXIST+I))GOTO 300
100   CONTINUE
      IF(NTABLE.GE.MAXTABLE)THEN
          WRITE(6,110)
110       FORMAT('0*** Error in GET_ARRAY: attempt to exceed the specif
     *ied',/,
     *            '     maximum number of dynamic arrays')
          RETURN1
      END IF
      NTABLE=NTABLE+1
      K=NTABLE
C**********************************************************************
C  Record this new array in the master table
C**********************************************************************
300   I4D(IVEC+K)=IOFF
      I4D(IADDRESS+K)=NEWADDR
      I4D(IBYTES+K)=NBYTES
      L1D(IEXIST+K)=.TRUE.
      RETURN
900   RETURN1
      END
