      SUBROUTINE GET_PLOT_DEVICES( IMON1, IMON2 )

      CHARACTER*255 STRING1, STRING2

      LOGICAL*4 PSCOLOUR
      COMMON /POSTSCRIPTCOLOUR/ PSCOLOUR

      INTEGER*4 PLTRSIZE
      COMMON /PLOTTER_SIZE/ PLTRSIZE

      CHARACTER*11 DEVICES(32)
      INTEGER*4    NDEVICE(32), DEVSIZE(32)
      DATA DEVICES 
     & / 'VT100      ','VT640      ','TK4010     ','HP         '
     &  ,'HPA        ','HPB        ','HPC        ','HPD        '
     &  ,'HPE        ','CIT467     ','TK4107     ','VT241      '
     &  ,'PT100G     ','HOUSTON    ','HIA        ','HIB        '
     &  ,'HIC        ','HID        ','HIE        ','SEIKO      '
     &  ,'IMAGEN     ','POSTSCRIPT ','PSCOLOUR   ','LN03       '
     &  ,'GENERIC    ','DECWINDOWS ','X          ','NONE       '
     &  ,'GKS        ','PS         ','PSA3       ','PSA4       ' /
      DATA NDEVICE
     & /  0, 1, 2, 5 , 5, 5, 5, 5 , 5, 6, 7, 8 , 9,11,11,11
     &  ,11,11,11,12 ,13,14,14,16 ,17,18,18,99 ,19,14,14,14 /
      DATA DEVSIZE
     & /  0, 0, 0, 0 , 0, 1, 2, 3 , 4, 0, 0, 0 , 0, 0, 0, 1
     &  , 2, 3, 4, 0 , 0, 0, 0, 0 , 0, 0, 0, 0 , 0, 0, 0, 1 /
CCC
      CALL GET_TERMTYPE(STRING1)
      LS1 = LENSIG(STRING1)
      IF( LS1 .LE. 0 )THEN
        STRING1 = 'X'
        LS1 = 1
      END IF

      CALL GET_PLOTTERTYPE(STRING2)
      LS2 = LENSIG(STRING2)
      IF( LS2 .LE. 0 )THEN
        STRING2 = 'NONE'
        LS2 = 4
      END IF

      IMON1 = -1
      DO I = 1, 33
        IF( INDEX(DEVICES(I),STRING1(1:LS1)) .EQ. 1 )THEN
          IMON1 = NDEVICE(I)
          GO TO 40
        END IF
      END DO
   40 IF( (IMON1 .EQ. -1).OR.(IMON1 .EQ.  5).OR.(IMON1 .EQ. 11).OR.
     &    (IMON1 .EQ. 13).OR.(IMON1 .EQ. 14).OR.(IMON1 .EQ. 16) )THEN
        WRITE(*,*)' invalid terminal type'
        WRITE(*,*)' terminal type set to X'
        IMON1 = 18
      END IF
      IF( IMON1 .EQ. 99 )IMON1 = 0

      IMON2 = -1
      DO I = 1, 37
        IF( INDEX(DEVICES(I),STRING2(1:LS2)) .EQ. 1 )THEN
          IMON2    = NDEVICE(I)
          PLTRSIZE = DEVSIZE(I)
          IF( I .EQ. 26 )PSCOLOUR = .TRUE.
          GO TO 50
        END IF
      END DO
   50 IF( (IMON2 .EQ. -1) .OR. (IMON2 .EQ. 0) .OR.
     &    (IMON2 .EQ. 17) .OR. (IMON2 .EQ. 18) )THEN
        WRITE(*,*)' invalid plotter type'
        WRITE(*,*)' plotter type set to NONE'
        IMON2 = 0
      END IF
      IF( IMON2 .EQ. 99 )IMON2 = 0
      RETURN
      END
