      SUBROUTINE GPLOT_SYMBOL(X,Y,SIZE,COSANG,SINANG,NFILL,NUMSYM)
C                                                                      *
C    This GPLOT auxilliary routine plots various symbols as shown      *
C    below.  The symbol is plotted centred at (X,Y) (pixels) and the   *
C    size is SYMSIZ. It will be easy to add more                       *
C    symbols to the list, as opposed to the KOSTL:SYMBOL.FOR routine.  *
C                                                                      *
C  NUMSYM =   1 --> Square                                             *
C             2 --> Cross                                              *
C             3 --> Square with cross                                  *
C             4 --> Plus                                               *
C             5 --> Diamond                                            *
C             6 --> Diamond with plus                                  *
C             7 --> Asterisk                                           *
C             8 --> Filled Square                                      *
C             9 --> Filled Diamond                                     *
C            10 --> Equilateral triangle                               *
C            11 --> Filled equilateral triangle                        *
C            12 --> Circle                                             *
C            13 --> Filled circle                                      *
C            14 --> Star                                               *
C            15 --> Filled star                                        *
C            16 --> Point         (added August 29, 1985)              *
C            17 --> Arrow (foot at data pt.)   (added April 29, 1986)  *
C            18 --> Arrow (centred at data pt.)(added April 29, 1986)  *
C                                                                      *
C    If NUMSYM = anything else no symbol is plotted.                   *
C                                                                      *
C                                          Author:  Joe Chuma          *
C                                                   May 24, 1984       *
C                                                                      *
      PARAMETER  (TWOPI = 6.28318530718)
      PARAMETER  (SQRT3 = 1.73205080757)
      PARAMETER  (CS45  = 0.70710678119)
      PARAMETER  (TAN54 = 1.37638192047)
      PARAMETER  (SIN54 = 0.80901699437)
      PARAMETER  (COS54 = 0.58778525229)
      PARAMETER  (SIN72 = 0.95105651630)
      PARAMETER  (COS72 = 0.30901699437)
      PARAMETER  (TAN20 = 0.36397023400)
C
      COMMON /PLOT_PREVIOUS/ XPREV, YPREV, IPENP
C
C   Define rotation functions
C
      ROTX(XI,YI) =  XI * COSANG - YI * SINANG
      ROTY(XI,YI) =  XI * SINANG + YI * COSANG
      XI=1.
      YI=1.
C
      SIN144 = COS54
      COS144 = -SIN54
      COS216 = COS144
      SIN216 = -SIN144
      COS288 = COS72
      SIN288 = -SIN72
      SYMSIZ = SIZE
      SIZINC = SYMSIZ / NFILL
      IF(NUMSYM .EQ. 1 .OR. NUMSYM .EQ. 8)THEN           ! SQUARE
        DO I = 1, NFILL
          TEMP = SYMSIZ * 0.5
          CALL PLOT_R(X+ROTX(TEMP,-TEMP),Y+ROTY(TEMP,-TEMP),3)
          CALL PLOT_R(X+ROTX(TEMP,TEMP),Y+ROTY(TEMP,TEMP),2)
          CALL PLOT_R(X+ROTX(-TEMP,TEMP),Y+ROTY(-TEMP,TEMP),2)
          CALL PLOT_R(X+ROTX(-TEMP,-TEMP),Y+ROTY(-TEMP,-TEMP),2)
          CALL PLOT_R(X+ROTX(TEMP,-TEMP),Y+ROTY(TEMP,-TEMP),2)
          IF(NUMSYM .EQ. 1)GO TO 10
          SYMSIZ = SYMSIZ - SIZINC
        END DO
      ELSE IF(NUMSYM .EQ. 2)THEN                           ! CROSS
        TEMP = SYMSIZ * 0.5
        CALL PLOT_R(X+ROTX(TEMP,-TEMP),Y+ROTY(TEMP,-TEMP),3)
        CALL PLOT_R(X+ROTX(-TEMP,TEMP),Y+ROTY(-TEMP,TEMP),2)
        CALL PLOT_R(X+ROTX(-TEMP,-TEMP),Y+ROTY(-TEMP,-TEMP),3)
        CALL PLOT_R(X+ROTX(TEMP,TEMP),Y+ROTY(TEMP,TEMP),2)
      ELSE IF(NUMSYM .EQ. 3)THEN                    ! SQUARE WITH CROSS
        TEMP = SYMSIZ * 0.5
        CALL PLOT_R(X+ROTX(TEMP,-TEMP),Y+ROTY(TEMP,-TEMP),3)
        CALL PLOT_R(X+ROTX(TEMP,TEMP),Y+ROTY(TEMP,TEMP),2)
        CALL PLOT_R(X+ROTX(-TEMP,TEMP),Y+ROTY(-TEMP,TEMP),2)
        CALL PLOT_R(X+ROTX(-TEMP,-TEMP),Y+ROTY(-TEMP,-TEMP),2)
        CALL PLOT_R(X+ROTX(TEMP,-TEMP),Y+ROTY(TEMP,-TEMP),2)
        CALL PLOT_R(X+ROTX(TEMP,-TEMP),Y+ROTY(TEMP,-TEMP),3)
        CALL PLOT_R(X+ROTX(-TEMP,TEMP),Y+ROTY(-TEMP,TEMP),2)
        CALL PLOT_R(X+ROTX(-TEMP,-TEMP),Y+ROTY(-TEMP,-TEMP),3)
        CALL PLOT_R(X+ROTX(TEMP,TEMP),Y+ROTY(TEMP,TEMP),2)
      ELSE IF(NUMSYM .EQ. 4)THEN                        ! PLUS
        TEMP = SYMSIZ * 0.5
        CALL PLOT_R(X+ROTX(TEMP,0.),Y+ROTY(TEMP,0.),3)
        CALL PLOT_R(X+ROTX(-TEMP,0.),Y+ROTY(-TEMP,0.),2)
        CALL PLOT_R(X+ROTX(0.,-TEMP),Y+ROTY(0.,-TEMP),3)
        CALL PLOT_R(X+ROTX(0.,TEMP),Y+ROTY(0.,TEMP),2)
      ELSE IF(NUMSYM .EQ. 5 .OR. NUMSYM .EQ. 9)THEN      ! DIAMOND
        DO I = 1, NFILL
          TEMP1 = SYMSIZ * 0.5
          TEMP2 = SYMSIZ * 0.4
          CALL PLOT_R(X+ROTX(TEMP2,0.),Y+ROTY(TEMP2,0.),3)
          CALL PLOT_R(X+ROTX(0.,TEMP1),Y+ROTY(0.,TEMP1),2)
          CALL PLOT_R(X+ROTX(-TEMP2,0.),Y+ROTY(-TEMP2,0.),2)
          CALL PLOT_R(X+ROTX(0.,-TEMP1),Y+ROTY(0.,-TEMP1),2)
          CALL PLOT_R(X+ROTX(TEMP2,0.),Y+ROTY(TEMP2,0.),2)
          IF(NUMSYM .EQ. 5)GO TO 10
          SYMSIZ = SYMSIZ - SIZINC
        END DO
      ELSE IF(NUMSYM .EQ. 6)THEN                      ! DIAMOND + 
        TEMP1 = SYMSIZ * 0.5
        TEMP2 = SYMSIZ * 0.4
        CALL PLOT_R(X+ROTX(TEMP2,0.),Y+ROTY(TEMP2,0.),3)
        CALL PLOT_R(X+ROTX(0.,TEMP1),Y+ROTY(0.,TEMP1),2)
        CALL PLOT_R(X+ROTX(-TEMP2,0.),Y+ROTY(-TEMP2,0.),2)
        CALL PLOT_R(X+ROTX(0.,-TEMP1),Y+ROTY(0.,-TEMP1),2)
        CALL PLOT_R(X+ROTX(TEMP2,0.),Y+ROTY(TEMP2,0.),2)
        CALL PLOT_R(X+ROTX(TEMP2,0.),Y+ROTY(TEMP2,0.),3)
        CALL PLOT_R(X+ROTX(-TEMP2,0.),Y+ROTY(-TEMP2,0.),2)
        CALL PLOT_R(X+ROTX(0.,TEMP1),Y+ROTY(0.,TEMP1),3)
        CALL PLOT_R(X+ROTX(0.,-TEMP1),Y+ROTY(0.,-TEMP1),2)
      ELSE IF(NUMSYM .EQ. 7)THEN                          ! ASTERISK
        TEMP = SYMSIZ * 0.5
        TEMP2 = TEMP * CS45
        CALL PLOT_R(X+ROTX(TEMP,0.),Y+ROTY(TEMP,0.),3)
        CALL PLOT_R(X+ROTX(-TEMP,0.),Y+ROTY(-TEMP,0.),2)
        CALL PLOT_R(X+ROTX(TEMP2,TEMP2),Y+ROTY(TEMP2,TEMP2),3)
        CALL PLOT_R(X+ROTX(-TEMP2,-TEMP2),Y+ROTY(-TEMP2,-TEMP2),2)
        CALL PLOT_R(X+ROTX(0.,TEMP),Y+ROTY(0.,TEMP),3)
        CALL PLOT_R(X+ROTX(0.,-TEMP),Y+ROTY(0.,-TEMP),2)
        CALL PLOT_R(X+ROTX(-TEMP2,TEMP2),Y+ROTY(-TEMP2,TEMP2),3)
        CALL PLOT_R(X+ROTX(TEMP2,-TEMP2),Y+ROTY(TEMP2,-TEMP2),2)
      ELSE IF(NUMSYM .EQ. 10 .OR. NUMSYM .EQ. 11)THEN      ! TRIANGLE
        DO I = 1, NFILL
          TEMP1 = SYMSIZ / SQRT3
          TEMP2 = SYMSIZ / 3.
          CALL PLOT_R(X+ROTX(TEMP1,-TEMP2),Y+ROTY(TEMP1,-TEMP2),3)
          CALL PLOT_R(X+ROTX(0.,2*TEMP2),Y+ROTY(0.,2*TEMP2),2)
          CALL PLOT_R(X+ROTX(-TEMP1,-TEMP2),Y+ROTY(-TEMP1,-TEMP2),2)
          CALL PLOT_R(X+ROTX(TEMP1,-TEMP2),Y+ROTY(TEMP1,-TEMP2),2)
          IF(NUMSYM .EQ. 10)GO TO 10
          SYMSIZ = SYMSIZ - SIZINC
        END DO
      ELSE IF(NUMSYM .EQ. 12 .OR. NUMSYM .EQ. 13)THEN      ! CIRCLE
        DO I = 1, NFILL
          RADIUS = SYMSIZ * 0.5
          DTHETA = TWOPI / (2.*NFILL)
          CALL PLOT_R(X+RADIUS,Y,3)
          DO J = 1, 2*NFILL-1
            X1 = X + RADIUS * COS(DTHETA * J)
            Y1 = Y + RADIUS * SIN(DTHETA * J)
            CALL PLOT_R(X1,Y1,2)
          END DO
          CALL PLOT_R(X+RADIUS,Y,2)
          IF(NUMSYM .EQ. 12)GO TO 10
          SYMSIZ = SYMSIZ - SIZINC
        END DO
      ELSE IF(NUMSYM .EQ. 14 .OR. NUMSYM .EQ. 15)THEN
        DO I = 1, NFILL
          S  = 2. * SYMSIZ * COS54 / (1. + SIN54)
          H  = 0.5 * S * TAN54                     ! STAR or FILLED STAR
          AP = (SYMSIZ - H) / 3.
          X1 = X + ROTX(-0.5*S,-H)
          Y1 = Y + ROTY(-0.5*S,-H)
          CALL PLOT_R(X1,Y1,3)
          X2 = X + ROTX(0.,-AP)
          Y2 = Y + ROTY(0.,-AP)
          CALL PLOT_R(X2,Y2,2)
          X3 = -0.5*S * COS72 + H * SIN72
          Y3 = -0.5*S * SIN72 - H * COS72
          CALL PLOT_R(X+ROTX(X3,Y3),Y+ROTY(X3,Y3),2)
          X2 = AP * SIN72
          Y2 = -AP * COS72
          CALL PLOT_R(X+ROTX(X2,Y2),Y+ROTY(X2,Y2),2)
          X3 = -0.5*S * COS144 + H * SIN144
          Y3 = -0.5*S * SIN144 - H * COS144
          CALL PLOT_R(X+ROTX(X3,Y3),Y+ROTY(X3,Y3),2)
          X2 = AP * SIN144
          Y2 = -AP * COS144
          CALL PLOT_R(X+ROTX(X2,Y2),Y+ROTY(X2,Y2),2)
          X3 = -0.5*S * COS216 + H * SIN216
          Y3 = -0.5*S * SIN216 - H * COS216
          CALL PLOT_R(X+ROTX(X3,Y3),Y+ROTY(X3,Y3),2)
          X2 = AP * SIN216
          Y2 = -AP * COS216
          CALL PLOT_R(X+ROTX(X2,Y2),Y+ROTY(X2,Y2),2)
          X3 = -0.5*S * COS288 + H * SIN288
          Y3 = -0.5*S * SIN288 - H * COS288
          CALL PLOT_R(X+ROTX(X3,Y3),Y+ROTY(X3,Y3),2)
          X2 = AP * SIN288
          Y2 = -AP * COS288
          CALL PLOT_R(X+ROTX(X2,Y2),Y+ROTY(X2,Y2),2)
          CALL PLOT_R(X1,Y1,2)
          IF(NUMSYM .EQ. 14)GO TO 10
          SYMSIZ = SYMSIZ - SIZINC
        END DO
      ELSE IF(NUMSYM .EQ. 16)THEN     ! POINT
CC        IF( (XPREV .NE. X) .OR. (YPREV .NE. Y) )CALL PLOT_R(X,Y,3)
CC        CALL PLOT_R(X,Y,2)
        CALL PLOT_R(X,Y,20)
      ELSE IF(NUMSYM .EQ. 17)THEN     ! ARROW (foot at data point)
        CALL PLOT_R(X,Y,3)
        X1 = X + ROTX(0.,SYMSIZ)
        Y1 = Y + ROTY(0.,SYMSIZ)
        CALL PLOT_R(X1,Y1,2)
        X2 = -0.2 * SYMSIZ * TAN20
        Y2 =  0.8 * SYMSIZ
        CALL PLOT_R(X+ROTX(X2,Y2),Y+ROTY(X2,Y2),2)
        X3 = 0.2 * SYMSIZ * TAN20
        Y3 = Y2
        CALL PLOT_R(X+ROTX(X3,Y3),Y+ROTY(X3,Y3),2)
        CALL PLOT_R(X1,Y1,2)
      ELSE IF(NUMSYM .EQ. 18)THEN     ! ARROW (centred at data point)
        CALL PLOT_R(X+ROTX(0.,-0.5*SYMSIZ),Y+ROTY(0.,-0.5*SYMSIZ),3)
        X1 = X + ROTX(0.,0.5*SYMSIZ)
        Y1 = Y + ROTY(0.,0.5*SYMSIZ)
        CALL PLOT_R(X1,Y1,2)
        X2 = -0.2 * SYMSIZ * TAN20
        Y2 =  0.4 * SYMSIZ
        CALL PLOT_R(X+ROTX(X2,Y2),Y+ROTY(X2,Y2),2)
        X3 = 0.2 * SYMSIZ * TAN20
        Y3 = Y2
        CALL PLOT_R(X+ROTX(X3,Y3),Y+ROTY(X3,Y3),2)
        CALL PLOT_R(X1,Y1,2)
      END IF
10    RETURN
      END
