       SUBROUTINE GRAPHICS_HARDCOPY(IDEVICE)
C======================================================================C
C                                                                      C
C  GRAPHICS_HARDCOPY                            F.W. Jones, TRIUMF     C
C                                                                      C
C  Controls the output of hardcopy for various devices.                C
C                                                                      C
C  IDEVICE         0:  Device not specified                            C
C                  1:  Printronix                                      C
C                  2:  Zeta plotter  ***removed***                     C
C                  3:  HP plotter                                      C
C                  4:  HP Laserjet                                     C
C                  5:  HP Thinkjet                                     C
C                  6:  DEC LA100                                       C
C                  7:  QMS Lasergrafix  ***removed***                  C
C                  8:  Houston Instruments plotter                     C
C                  9:  DEC LN03+                                       C
C                 10:  Imagen laser printer (IMPRESS)                  C
C                 11:  HP Paintjet                                     C
C                 12:  PostScript                                      C
C                 13:  UIS metafile  ***removed***                     C
C                 14:  GKS metafile                                    C
C                 15:  RD-GLII plotter                                 C
C                                                                      C
C  If IDEVICE is 0, the bitmap and MONITOR2 settings are tested        C
C  and a menu of possible devices is displayed.  The user enters a     C
C  code to select the desired device.                                  C
C                                                                      C
C  Once the hardcopy device has been established, a command menu is    C
C  displayed.  The commands are:                                       C
C                                                                      C
C  PRINT -- produces a plot file and submits it to a device queue      C
C           The queue name can be specified by the user.               C
C                                                                      C
C  SAVE  -- produces a plot file for later printing                    C
C           The file name can be specified by the user.                C
C                                                                      C
C   Modified by J. Chuma on October 31, 1985 to change the input       C
C   and output units to IINS and IOUTS                                 C
C                                                                      C
C  Modified Dec 4/85 by F. Jones:  QMS Lasergrafix added.              C
C                                                                      C
C  Modified Feb 22/86 by J. Chuma:  Included IBIT for compatability    C
C  with PLOT_DEVICE_CM and SET_PLOT_DEVICES so the bitmap device       C
C  is known.  Also, included the auxilliary port output for the HP     C
C  or HOUSTON plotter.                                                 C
C                                                                      C
C  Modified Aug 11/86 by F. Jones:  Houston Instruments plotter added. C
C                                                                      C
C  Modified Sep 29/86 by C. Kost: Optional QUE_NAME used in            C
C  COMMON/QUE_NAMES/QUE_NAME is used when IDEVICE<0                    C
C  hardcopy to the device specified by IDEVICE without prompts.        C
C                                                                      C
C  Modified Nov 19/86 by F. Jones:  TeX bitmap option added for        C
C  HP Laserjet+.                                                       C
C                                                                      C
C  Modified Feb 3/87 by F. Jones:  limited support added for the       C
C  DEC LN03+ laser printer, to allow printing and saving hardcopies    C
C  from EDGR.  There is no work file, and it is assumed that the       C
C  plot file LN03.PLT has been generated on unit IOUTM2 with the       C
C  necessary escape sequences, ready to be saved or shipped to the     C
C  LN03.  No file name can be specified in the SAVE command.           C
C                                                                      C
C  Modified Nov 10/87 by F. Jones.  Support added for HP Paintjet.     C
C  Also, the APPEND option has been tentatively removed due to         C
C  problems caused by the SAVE file remaining open for append. This    C
C  feature is rarely used and in any case its removal will keep the    C
C  size of print jobs to a minimum for more equitable queue operation. C
C                                                                      C
C  Modified Feb 10/87 by F. Jones.  In the PRINT operation, plot       C
C  files are now written to the device and directory specified by      C
C  logical name SYS$SCRATCH.  As before, these files will be deleted   C
C  after printing.                                                     C
C                                                                      C
C  Modified June 6/88 by F. Jones.  Error returns added for plot file  C
C  output routines.  WRITE_PLOT_ZETA and WRITE_PLOT_HPP are now        C
C  subroutines rather than entry points to ZP and HP.                  C
C                                                                      C
C  Modified November 4/88 by J. Chuma. Allow QMS plots to Print to     C
C  a queue                                                             C
C                                                                      C
C  Modified Nov 14/88 by J. Chuma: LN03 fully supported                C
C                                                                      C
C  Modified 21-DEC-88 by F. Jones.  This routine has been largely      C
C  re-written to improve clarity and ease of maintenance.  The UIS     C
C  metafile output is now fully supported.                             C
C                                                                      C
C  Modified 06-MAR-89 by F. Jones: transparency mode added for         C
C  HP Paintjet printer.                                                C
C                                                                      C
C  Modified 15-MAY-89 by F. Jones: auto-justified mode added for       C
C  HP Laserjet TeX output.                                             C
C                                                                      C
C  Modified 20-NOV-89 by F. Jones: GKS metafile added.                 C
C                                                                      C
C  Modified 05-DEC-89 by F. Jones: support added for HP Laserjet       C
C  300 dpi using dynamic bitmap (IBIT_IN=32).                          C
C                                                                      C
C  Modified 04-JAN-90 by J.Chuma: support added for HP Laserjet        C
C  compression ( IBIT_IN = 1xx ).                                      C
C                                                                      C
C  Modified 16-OCT-90 by J.Chuma: support added for RD-GLII plotters   C
C                                                                      C
C  Modified 26-NOV-90 by F. Jones for RISC Ultrix                      C
C                                                                      C
C  Modified 25-NOV-92 by FWJ: common GHARD_MX added, allowing this     C
C  routine to be made non-interactive for use by Motif applications.   C
C  If MXGHARD=.TRUE., no interactive prompting will be done, and the   C
C  hardcopy command will be taken from MXINBUFF.  On return, flag MXOK C
C  is set to indicate the success or failure of the hardcopy output.   C
C                                                                      C
C  Modified 19-AUG-93 by FWJ: Zeta, QMS and UIS support removed        C
C                                                                      C
C  Modified 31-Jan-95 by J.Chuma: allow save and append to a file      C
C   but only for HP LaserJet for now.                                  C
C  Modified by J.Chuma, 20Mar97  for g77
C    do not declare SYSTEM as INTEGER and use CALL instead of ISTAT=
C  Modified by J.Chuma, 11-Apr-1997 for g77
C    must use unformatted plot files for bitmaps
C======================================================================C

      CHARACTER*60 MXINBUFF
      LOGICAL MXGHARD, MXOK
      COMMON /GHARD_MX/ MXGHARD, MXOK, MXINBUFF
      DATA MXGHARD /.FALSE./

      COMMON / BITMAP_DEVICE / IBIT_IN
C  If last digit of IBIT_IN 
C            = 0 --> No specific device chosen
C            = 1 --> PRINTRONIX
C            = 2 --> HPLASER
C            = 3 --> HPTHINK
C            = 4 --> LA100
C            = 5 --> HP Paintjet
C  For example, IBIT_IN = 22 --> HPLASER
C               IBIT_IN = 32 --> HPLASER 300 dpi full page
C               IBIT_IN =132 --> HPLASER 300 dpi full page compressed
C               IBIT_IN = 15 --> HP Paintjet

      LOGICAL BITMAP_EMPTY
      COMMON /BITMAP_STATUS/ BITMAP_EMPTY, MAXLINES

      LOGICAL FMTED
      COMMON /SPOOL/ FMTED

      LOGICAL*1 HARDCOPY(188,2048)
      COMMON /PLOTHARDCOPY/ IXLAST,IYLAST,N1,N2,HARDCOPY

      COMMON /PLOTMONITOR/ IMONITOR,IOUTM

      COMMON /PLOTMONITOR2/ IMONITOR2,IOUTM2

      LOGICAL WELL
      COMMON /TO_BIT_OR_NOT/ WELL

      LOGICAL TRANSPARENCY
      COMMON /WRITEBITMAPHPPAINT/ TRANSPARENCY

      COMMON /PLOT_INPUT_UNIT/ IINS

      COMMON /PLOT_OUTPUT_UNIT/ IOUTS

      CHARACTER*20 QUE_NAME
      COMMON /QUE_NAMES/ QUE_NAME

      LOGICAL GKSMOPEN
      COMMON /GKSPLOT/ GKSMOPEN

      PARAMETER (NDEV=15) ! Change this parameter when new devices are added

      CHARACTER*15 DEVICE(NDEV)  ! Device names
      DATA DEVICE
     & /'Printronix     ','Zeta plotter   ','HP plotter     '
     & ,'HP Laserjet    ','HP Thinkjet    ','LA100          '
     & ,'QMS Lasergrafix','Houston plotter','LN03+          '
     & ,'Imagen         ','HP Paintjet    ','PostScript     '
     & ,'UIS metafile   ','GKS metafile   ','RD-GLII plotter'/

      CHARACTER*3 DEVCODE(NDEV) ! Device codes
      DATA DEVCODE
     & /'P  ','Z  ','HPP','HPL','HPT','LA ','QMS','HOU','LN '
     & ,'IM ','HPJ','PS ','UIS','GKS','RDG'/

      CHARACTER*14 DEVFILE(NDEV) ! Default filenames for plot files
      DATA DEVFILE
     & /'PX.PLT        ','ZETA.PLT      ','HPP.PLT       '
     & ,'HPLASER.PLT   ','HPTHINK.PLT   ','LA100.PLT     '
     & ,'QMS.PLT       ','HOUSTON.PLT   ','LN03.PLT      '
     & ,'IMAGEN.IMP    ','HPPAINT.PLT   ','POSTSCRIPT.PLT'
     & ,'UISMETA.PLT   ','GKSMETA.PLT   ','RDGL.PLT      '/

      LOGICAL VALID(NDEV)  ! List of valid devices

      CHARACTER*80 STRING
      CHARACTER*60 INBUFF,PARAM,QUEUE,PLOTFILE
      CHARACTER*20 DEFQUE
      CHARACTER*10 PRTOPT
      CHARACTER*5 COMMAND
      CHARACTER*1 CC

      LOGICAL PRINTOK,AUXOK,TEXOK,COMPOK,APNDOK
#ifdef unix
#elif g77
#elif gfortran
#else
      INTEGER*4 SYSTEM
#endif
      CHARACTER*1 ESC
      CHARACTER*4 REV, NOR
CCC
      ESC = CHAR(27)    ! modified by J.Chuma, 20Mar97 for g77
      REV = ESC//'[7m'
      NOR = ESC//'[0m'

      IBIT3 = IBIT_IN/100
      IBIT2 = (IBIT_IN - IBIT3*100)/10
      IBIT1 = IBIT_IN - IBIT3*100 - IBIT2*10

      IF( MXGHARD )THEN
        PRINTOK=.TRUE.
        COMPOK=.TRUE.
        TEXOK=.TRUE.
        AUXOK=.TRUE.
        DEFQUE=' '
        MXOK=.FALSE.
        IDEV=IDEVICE
        INBUFF=MXINBUFF
        GO TO 66
      END IF

      DO I = 1, NDEV
        VALID(I) = .FALSE.
      END DO

      IF( NARGS().GT.0 )THEN
        IDEV=ABS(IDEVICE)
        IF( IDEV.EQ.2 .OR. IDEV.EQ.7 .OR. IDEV.EQ.13 )RETURN ! Zeta/QMS/UIS
        IF( IDEVICE.LT.0 )THEN      !direct printing
          CC='P'
#ifdef VMS
          PLOTFILE='SYS$SCRATCH:'//DEVFILE(IDEV)
#endif
#ifdef unix
          PLOTFILE=DEVFILE(IDEV)
#endif
          QUEUE=QUE_NAME
          GO TO 70
        END IF
      ELSE
        IDEV=0
      END IF

      IF( IDEV.NE.0 )GO TO 60
C======================================================================C
C  Device not specified.  Make a list of valid devices.
C======================================================================C
      CALL CLTRANS
      IF( WELL )THEN      !Bitmap devices...
        IF(IBIT1 .EQ. 0)THEN
          VALID(1)=.TRUE.
          VALID(4)=.TRUE.
          VALID(5)=.TRUE.
          VALID(6)=.TRUE.
        ELSE IF(IBIT1 .EQ. 1)THEN      !Printronix
          VALID(1)=.TRUE.
        ELSE IF(IBIT1 .EQ. 2)THEN      !HP Laserjet
          VALID(4)=.TRUE.
        ELSE IF(IBIT1 .EQ. 3)THEN      !HP Thinkjet
          VALID(5)=.TRUE.
        ELSE IF(IBIT1 .EQ. 4)THEN      !LA100
          VALID(6)=.TRUE.
        ELSE IF(IBIT1 .EQ. 5)THEN      !HP Paintjet
          VALID(11)=.TRUE.
        END IF      
      ENDIF

C Plotters:
      IF(IMONITOR2.EQ.5)THEN      !HP plotter
        VALID(3)=.TRUE.
      ELSE IF(IMONITOR2.EQ.11)THEN      !HI plotter
        VALID(8)=.TRUE.
      ELSE IF(IMONITOR2.EQ.13)THEN      !Imagen
        VALID(10)=.TRUE.
      ELSE IF(IMONITOR2.EQ.14)THEN      !PostScript
        VALID(12)=.TRUE.
      ELSE IF(IMONITOR2.EQ.16)THEN      !LN03+
        VALID(9)=.TRUE.
      ELSE IF(IMONITOR2.EQ.19)THEN      !GKS metafile
        IF(GKSMOPEN)VALID(14)=.TRUE.
      ELSE IF(IMONITOR2.EQ.20)THEN      !RD-GLII plotter
        VALID(15)=.TRUE.
      ENDIF

C How many valid devices?
      NVALID=0
      DO I=1,NDEV
        IF( VALID(I) )THEN
          NVALID=NVALID+1
          IDEV=I
        END IF
      END DO
      IF( NVALID.EQ.0 )THEN
        WRITE(*,*)'GRAPHICS_HARDCOPY: no valid devices'
        RETURN
      END IF
      IF( NVALID.EQ.1 )GO TO 60

C Write the selection list
      DO I=1,NDEV
        IF( VALID(I) )
     &   WRITE(IOUTS,*)REV,' ',DEVCODE(I),' ',NOR,'  ',DEVICE(I)
      ENDDO
      WRITE(IOUTS,*)REV,' Q   ',NOR,'   QUIT'
      WRITE(IOUTS,*)
C======================================================================C
C  Device selection
C======================================================================C
25    WRITE(IOUTS,1000)
1000  FORMAT(' Enter device code > ',$)
      READ(IINS,1001,ERR=25,END=998)INBUFF
1001  FORMAT(A)
      IF(LENSIG(INBUFF).EQ.0)GO TO 25
      CALL UPRCASE(INBUFF,INBUFF)
      DO WHILE(INBUFF(1:1).EQ.' ')  ! Strip off leading blanks
        INBUFF=INBUFF(2:)
      ENDDO
      IF(INBUFF.EQ.'Q')GO TO 998

      DO I=1,NDEV
        IF( INBUFF.EQ.DEVCODE(I) )THEN
          IF( .NOT.VALID(I) )THEN
            WRITE(IOUTS,*)'Invalid device code'
            GO TO 25
          ENDIF
          IDEV=I
          GO TO 60
        ENDIF
      ENDDO
      WRITE(IOUTS,*)'Invalid device code'
      GO TO 25
C======================================================================C
C  Determine valid commands and defaults.  This section should be
C  modified to reflect local conditions as follows: for each device,
C    Set PRINTOK to false if printing on a queue is not allowed.
C    Set DEFQUE to the queue name if there is a default print queue.
C    Set TEXOK to true if TeX-includible output is possible.
C    Set AUXOK to true if auxiliary port output is allowed.
C    Set COMPOK to true if compressed output is allowed.
C    Set APNDOK to true if appended output is allowed.
C======================================================================C
60    CALL CLTRANS
      PRINTOK=.TRUE.
      COMPOK=.FALSE.
      APNDOK=.FALSE.
      DEFQUE=' '
      TEXOK=.FALSE.
      AUXOK=.FALSE.
      TRANSPARENCY=.FALSE.

      IF(IDEV.EQ.3)THEN      !HP plotter
#ifdef VMS
        DEFQUE='HPLTR'
#endif
#ifdef unix
        CALL GETENV('HPLTR',DEFQUE)
#endif
        AUXOK=.TRUE.
      ELSE IF(IDEV.EQ.4)THEN      !HP Laserjet
#ifdef VMS
        DEFQUE='HP$LASER'
#endif
#ifdef unix
        CALL GETENV('HP_LASER',DEFQUE)
        IF(DEFQUE.EQ.' ')DEFQUE='PRINTER'
#endif
        TEXOK=.TRUE.
        COMPOK=.TRUE.
        APNDOK=.TRUE.
      ELSE IF(IDEV.EQ.6)THEN      !LA 100
#ifdef VMS
        DEFQUE='PHYS'
#endif
      ELSE IF(IDEV.EQ.8)THEN      !Houston plotter
        AUXOK=.TRUE.
      ELSE IF(IDEV.EQ.11)THEN     !HP Paintjet
#ifdef unix
        CALL GETENV('HP_PAINT',DEFQUE)
#endif
      ELSE IF(IDEV.EQ.12)THEN     !PostScript
#ifdef VMS
        DEFQUE='POST$SCRIPT'
#endif
#ifdef unix
        CALL GETENV('PS_PRINTER',DEFQUE)
#endif
      ELSE IF(IDEV.EQ.14)THEN     !GKS metafile
        PRINTOK=.FALSE.
      ELSE IF(IDEV.EQ.15)THEN     !RD-GLII plotter
#ifdef VMS
        DEFQUE='RDGL'
#endif
#ifdef unix
        CALL GETENV('RDGL',DEFQUE)
#endif
        AUXOK=.TRUE.
      ENDIF
C======================================================================C
C  Display the command menu
C======================================================================C
      WRITE(IOUTS,*)'Device: ',DEVICE(IDEV)
      IF(DEFQUE.NE.' ')WRITE(IOUTS,*)'Default queue: ',DEFQUE
      WRITE(IOUTS,*)REV,' HARDCOPY COMMANDS ',NOR
      IF( PRINTOK )THEN
        IF( DEFQUE.EQ.' ' )THEN
          WRITE(IOUTS,*)REV,'  P   {que-name}   ',NOR,' Print'
        ELSE
          WRITE(IOUTS,*)REV,'  P   [que-name]   ',NOR,' Print'
        ENDIF
        IF( COMPOK )THEN
          IF( DEFQUE.EQ.' ' )THEN
            WRITE(IOUTS,*)REV,'  PC  {que-name}   ',NOR,
     &       ' Print compressed (LJ IIP/III only)'
          ELSE
            WRITE(IOUTS,*)REV,'  PC  [que-name]   ',NOR,
     &       ' Print compressed (LJ IIP/III only)'
          END IF
        END IF
      END IF
      IF( IDEV.EQ.11 )WRITE(IOUTS,*)REV,'  PT  {que-name}   ',NOR,
     &  ' Print transparency'
      IF( IDEV.EQ.12 )WRITE(IOUTS,*)REV,'  PT  {que-name}   ',NOR,
     &  ' Print transparency [IBM PS 4079]'
      WRITE(IOUTS,*)REV,'  S   [file-name]  ',NOR,' Save'
      IF( APNDOK )WRITE(IOUTS,*)REV,'  SA  [file-name]  ',NOR
     & ,' Save & append to file'
      IF( COMPOK )WRITE(IOUTS,*)REV,'  SC  [file-name]  ',NOR
     &  ,' Save compressed (LJ IIP/III only)'
      IF( APNDOK )WRITE(IOUTS,*)REV,'  SCA [file-name]  ',NOR
     &   ,' Save compressed & append to file'
      IF( TEXOK )THEN
        WRITE(IOUTS,*)REV,'  T   [file-name]  ',NOR,' TeX output'
        WRITE(IOUTS,*)REV,'  TJ  [file-name]  ',NOR,
     &      ' TeX justified output'
        IF( COMPOK )THEN
          WRITE(IOUTS,*)REV,'  TC  [file-name]  ',NOR,
     &     ' TeX output compressed (LJ IIP/III only)'
          WRITE(IOUTS,*)REV,'  TJC [file-name]  ',NOR,
     &     ' TeX justified output compressed (LJ IIP/III only)'
        END IF
      END IF
      IF(AUXOK)WRITE(IOUTS,*)REV,'  A                ',NOR,
     &    ' Auxiliary port output'
      WRITE(IOUTS,*)REV,'  Q                ',NOR,' Quit'
      WRITE(IOUTS,*)

C======================================================================C
C  Read and parse the command
C======================================================================C
65    IF(MXGHARD)RETURN
      WRITE(IOUTS,1002)
1002  FORMAT(' Enter hardcopy command > ',$)
      READ(IINS,1003,ERR=65,END=998)INBUFF
1003  FORMAT(A)
      IF(LENSIG(INBUFF).EQ.0)GO TO 65
C Identify the command and diagnose any errors
66    CALL GRAPHICS_HARDCOPY_PARSE(INBUFF,COMMAND,1)
      CALL UPRCASE(COMMAND,COMMAND)
      CC=COMMAND(1:1)
      IF(CC.EQ.'P')THEN
        IF(.NOT.PRINTOK)THEN
          WRITE(IOUTS,*)'Invalid command'
          GO TO 65
        ENDIF
        IF((IDEV.EQ.11.OR.IDEV.EQ.12).AND.COMMAND(2:2).EQ.'T')
     &    TRANSPARENCY=.TRUE.
      ELSE IF(CC.EQ.'A')THEN
        IF(.NOT.AUXOK)THEN
          WRITE(IOUTS,*)'Invalid command'
          GO TO 65
        ENDIF
      ELSE IF(CC.EQ.'T')THEN
        IF(.NOT.TEXOK)THEN
          WRITE(IOUTS,*)'Invalid command'
          GO TO 65
        ENDIF
      ELSE IF(CC.EQ.'Q')THEN
        GO TO 998
      ELSE IF(CC.NE.'S')THEN
        WRITE(IOUTS,*)'Unrecognized command.'
        GO TO 65
      ENDIF

C Establish plot file name and queue name
      IF(CC.EQ.'P')THEN
        CALL GRAPHICS_HARDCOPY_PARSE(INBUFF,PARAM,2)
        IF(LENSIG(PARAM).EQ.0)THEN
          IF(DEFQUE.NE.' ')THEN
            QUEUE=DEFQUE
          ELSE
            WRITE(IOUTS,*)'Queue name must be specified'
            GO TO 65
          ENDIF
        ELSE
          QUEUE=PARAM
        ENDIF
#ifdef VMS
        PLOTFILE='SYS$SCRATCH:'//DEVFILE(IDEV)
#endif
#ifdef unix
        PLOTFILE=DEVFILE(IDEV)
#endif
      ELSE IF(CC.EQ.'S')THEN
        CALL GRAPHICS_HARDCOPY_PARSE(INBUFF,PARAM,2)
        IF(LENSIG(PARAM).EQ.0)THEN
          PLOTFILE=DEVFILE(IDEV)
        ELSE
          PLOTFILE=PARAM
        ENDIF
        IF((IDEV.EQ.11.OR.IDEV.EQ.12).AND.COMMAND(2:2).EQ.'T')
     &    TRANSPARENCY=.TRUE.
      ELSE IF(CC.EQ.'T')THEN
        CALL GRAPHICS_HARDCOPY_PARSE(INBUFF,PARAM,2)
        IF(LENSIG(PARAM).EQ.0)THEN
          PLOTFILE='HPTEX.PLT'
        ELSE
          PLOTFILE=PARAM
        ENDIF
      ELSE IF(CC.EQ.'A')THEN
#ifdef VMS
        PLOTFILE='SYS$SCRATCH:'//DEVFILE(IDEV)
#endif
#ifdef unix
        PLOTFILE=DEVFILE(IDEV)
#endif
      ENDIF

C======================================================================C
C  Open the plot file
C======================================================================C
70    CALL FIND_UNIT(IOUTH)
#ifdef VMS
      IF(IDEV.EQ.1)THEN      !Printronix
        IF( BITMAP_EMPTY )THEN
          WRITE(IOUTS,*)'No hardcopy produced: bitmap is empty'
          GO TO 998
        END IF
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='NEW',FORM='UNFORMATTED',
     &       CARRIAGECONTROL='LIST',RECL=136,ERR=999)
      ELSE IF(IDEV.EQ.3.OR.IDEV.EQ.15)THEN     !HP/RD-GLII plotters
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='NEW',
     &       CARRIAGECONTROL='LIST',ERR=999)
      ELSE IF(IDEV.EQ.4.OR.IDEV.EQ.5)THEN      !HP Laser/Thinkjet
        IF( BITMAP_EMPTY )THEN
          WRITE(IOUTS,*)'No hardcopy produced: bitmap is empty'
          GO TO 998
        END IF
        IF( (COMMAND(1:2).EQ.'SA') .OR. (COMMAND(1:3).EQ.'SCA') )THEN
          OPEN(UNIT=IOUTH,FILE=PLOTFILE,ACCESS='APPEND',STATUS='OLD'
     &        ,ERR=999)
        ELSE
          OPEN(UNIT=IOUTH,FILE=PLOTFILE,RECL=1024
     &     ,CARRIAGECONTROL='NONE',STATUS='NEW',ERR=999)
        END IF
      ELSE IF(IDEV.EQ.6)THEN      !LA100
        IF( BITMAP_EMPTY )THEN
          WRITE(IOUTS,*)'No hardcopy produced: bitmap is empty'
          GO TO 998
        END IF
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,
     &       STATUS='NEW',ERR=999)
      ELSE IF(IDEV.EQ.8)THEN      !Houston
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,
     &       CARRIAGECONTROL='LIST',STATUS='NEW',ERR=999)
      ELSE IF(IDEV.EQ.9)THEN      ! LN03+
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,
     &       CARRIAGECONTROL='FORTRAN',STATUS='NEW',ERR=999)
      ELSE IF(IDEV.EQ.10)THEN     ! Imagen
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,
     &       CARRIAGECONTROL='NONE',STATUS='NEW',ERR=999)
      ELSE IF(IDEV.EQ.11)THEN     ! HP PaintJet
        IF( BITMAP_EMPTY )THEN
          WRITE(IOUTS,*)'No hardcopy produced: bitmap is empty'
          GO TO 998
        END IF
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,RECL=512,
     &       CARRIAGECONTROL='NONE',STATUS='NEW',ERR=999)
      ELSE IF(IDEV.EQ.12)THEN     ! PostScript
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,
     &       CARRIAGECONTROL='LIST',STATUS='NEW',ERR=999)
      ELSE IF(IDEV.EQ.14)THEN     ! GKS metafile
        IF(.NOT.GKSMOPEN)THEN
          WRITE(*,*)'No GKS metafile for current plot.'
          WRITE(*,*)'The plot must be cleared to start a new metafile.'
          RETURN
        ENDIF
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='NEW',ERR=999)
      ENDIF
#else
      IF(IDEV.EQ.1)THEN      !Printronix
        IF( BITMAP_EMPTY )THEN
          WRITE(IOUTS,*)'No hardcopy produced: bitmap is empty'
          GO TO 998
        END IF
#ifdef g77
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',ERR=999)
#elif gfortran
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',ERR=999)
#else
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',
     &       CARRIAGECONTROL='LIST',RECL=136,ERR=999)
#endif
      ELSE IF(IDEV.EQ.3.OR.IDEV.EQ.15)THEN     !HP/RD-GLII plotters
#ifdef g77
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',ERR=999)
#elif gfortran
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',ERR=999)
#else
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',
     &       CARRIAGECONTROL='LIST',ERR=999)
#endif
      ELSE IF(IDEV.EQ.4.OR.IDEV.EQ.5)THEN      !HP Laser/Thinkjet
        IF( BITMAP_EMPTY )THEN
          WRITE(IOUTS,*)'No hardcopy produced: bitmap is empty'
          GO TO 998
        END IF
        IF( (COMMAND(1:2).EQ.'SA') .OR. (COMMAND(1:3).EQ.'SCA') )THEN
#ifdef _AIX
          OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='OLD',ERR=999)
#elif g77
          OPEN(UNIT=IOUTH,FILE=PLOTFILE,ACCESS='APPEND',STATUS='OLD',
     &        FORM='UNFORMATTED',ERR=999)
#elif gfortran
          OPEN(UNIT=IOUTH,FILE=PLOTFILE,ACCESS='APPEND',STATUS='OLD',
     &        FORM='UNFORMATTED',ERR=999)
#else
          OPEN(UNIT=IOUTH,FILE=PLOTFILE,ACCESS='APPEND',STATUS='OLD',
     &        ERR=999)
#endif
        ELSE
#ifdef g77
          OPEN(UNIT=IOUTH,FILE=PLOTFILE,FORM='UNFORMATTED',
     &     STATUS='UNKNOWN',ERR=999)
#elif gfortran
          OPEN(UNIT=IOUTH,FILE=PLOTFILE,FORM='UNFORMATTED',
     &     STATUS='UNKNOWN',ERR=999)
#else
          OPEN(UNIT=IOUTH,FILE=PLOTFILE,RECL=1024,
     &     CARRIAGECONTROL='NONE',STATUS='UNKNOWN',ERR=999)
#endif
        END IF
      ELSE IF(IDEV.EQ.6)THEN      !LA100
        IF( BITMAP_EMPTY )THEN
          WRITE(IOUTS,*)'No hardcopy produced: bitmap is empty'
          GO TO 998
        END IF
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',ERR=999)
      ELSE IF(IDEV.EQ.8)THEN      !Houston
#ifdef g77
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',ERR=999)
#elif gfortran
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',ERR=999)
#else
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,
     &       CARRIAGECONTROL='LIST',STATUS='UNKNOWN',ERR=999)
#endif
      ELSE IF(IDEV.EQ.9)THEN      ! LN03+
#ifdef g77
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',ERR=999)
#elif gfortran
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',ERR=999)
#else
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,
     &       CARRIAGECONTROL='FORTRAN',STATUS='UNKNOWN',ERR=999)
#endif
      ELSE IF(IDEV.EQ.10)THEN     ! Imagen
#ifdef g77
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',ERR=999)
#elif gfortran
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',ERR=999)
#else
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,
     &       CARRIAGECONTROL='NONE',STATUS='UNKNOWN',ERR=999)
#endif
      ELSE IF(IDEV.EQ.11)THEN     ! HP PaintJet
        IF( BITMAP_EMPTY )THEN
          WRITE(IOUTS,*)'No hardcopy produced: bitmap is empty'
          GO TO 998
        END IF
#ifdef g77
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,FORM='UNFORMATTED',
     &       STATUS='UNKNOWN',ERR=999)
#elif gfortran
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,FORM='UNFORMATTED',
     &       STATUS='UNKNOWN',ERR=999)
#else
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,
     &       CARRIAGECONTROL='NONE',STATUS='UNKNOWN',ERR=999)
#endif
      ELSE IF(IDEV.EQ.12)THEN     ! PostScript
#ifdef g77
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',ERR=999)
#elif gfortran
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',ERR=999)
#else
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,
     &       CARRIAGECONTROL='LIST',STATUS='UNKNOWN',ERR=999)
#endif
      ELSE IF(IDEV.EQ.14)THEN     ! GKS metafile
        IF(.NOT.GKSMOPEN)THEN
          WRITE(*,*)'No GKS metafile for current plot.'
          WRITE(*,*)'The plot must be cleared to start a new metafile.'
          RETURN
        ENDIF
        OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='UNKNOWN',ERR=999)
      ENDIF
#endif
      IF(CC.EQ.'S'.OR.CC.EQ.'T')WRITE(IOUTS,*)'Plot file ',PLOTFILE

C======================================================================C
C  Write into the plot file
C======================================================================C
      IF( IDEV.EQ.1 )THEN      !Printronix
#ifdef VMS
        FMTED=.FALSE.
#else
        FMTED=.TRUE.
#endif
        CALL WRITE_PX(IOUTH,HARDCOPY,188,N1,N2,.TRUE.,*65)
      ELSE IF( IDEV.EQ.3 )THEN      !HP plotter
        CALL WRITE_PLOT_HPP(IOUTM2,IOUTH,*65)
      ELSE IF( IDEV.EQ.4 )THEN      !HP Laserjet
        LASER = 1
        IF( COMMAND(2:2).EQ.'C' )IBIT3 = 1
        IF( COMMAND(1:1).EQ.'T' )THEN
          LASER = 2
          IF( COMMAND(2:2).EQ.'J' )THEN
            LASER = 3
            IF( COMMAND(3:3).EQ.'C' )IBIT3 = 1
          END IF
        END IF
        IF( COMMAND(1:2).EQ.'SA' )LASER = 4
        IF( COMMAND(1:3).EQ.'SCA' )LASER = 4
        IF( IBIT3.EQ.1 )THEN
          IF( IBIT2.EQ.3 )THEN
            CALL WRITE_HP300C(IOUTH,LASER,*65)
          ELSE
            CALL WRITE_HPJETC(IOUTH,HARDCOPY,188,N1,N2,.TRUE.,LASER,*65)
          END IF
        ELSE
          IF( IBIT2.EQ.3 )THEN
            CALL WRITE_HP300(IOUTH,LASER,*65)
          ELSE
            CALL WRITE_HPJET(IOUTH,HARDCOPY,188,N1,N2,.TRUE.,LASER,*65)
          END IF
        END IF
      ELSE IF( IDEV.EQ.5 )THEN      !HP Thinkjet
        LASER = 0
        CALL WRITE_HPJET(IOUTH,HARDCOPY,188,N1,N2,.TRUE.,LASER,*65)
      ELSE IF( IDEV.EQ.6 )THEN      !LA100
        CALL WRITE_LA100(IOUTH,HARDCOPY,188,N1,N2,.TRUE.,*65)
      ELSE IF( IDEV.EQ.8 )THEN      !Houston
        CALL WRITE_PLOT_HOUSTON(IOUTM2,IOUTH,*65)
      ELSE IF( IDEV.EQ.9 )THEN      !LN03+
        CALL WRITE_PLOT_LN03(IOUTM2,IOUTH,*65)
      ELSE IF( IDEV.EQ.10 )THEN     !Imagen IMPRESS
        CALL WRITE_PLOT_IMPRESS(IOUTM2,IOUTH,*65)
      ELSE IF( IDEV.EQ.11 )THEN     !HP Paintjet
        CALL WRITE_HPPAINT(IOUTH,*65)
        TRANSPARENCY=.FALSE.
      ELSE IF( IDEV.EQ.12 )THEN     !PostScript
        CALL WRITE_PLOT_POSTSCRIPT(IOUTM2,IOUTH,*65)
        TRANSPARENCY=.FALSE.
      ELSE IF( IDEV.EQ.14 )THEN      !GKS metafile
        CALL GKS_CLOSE
        CALL WRITE_PLOT_GKS(IOUTM2,IOUTH,*65)
      ELSE IF( IDEV.EQ.15 )THEN      !RD-GLII plotter
        CALL WRITE_PLOT_RDGL(IOUTM2,IOUTH,*65)
      END IF
C======================================================================C
C  Print the plot file
C======================================================================C
      IF(CC.EQ.'P')THEN
        CLOSE(UNIT=IOUTH)
        NCQ=LENSIG(QUEUE)
#ifdef VMS
        PRTOPT=' '
        IF(IDEV.EQ.4.OR.IDEV.EQ.5.OR.IDEV.EQ.11)PRTOPT='PASSALL'
CC        IF(IDEV.EQ.12)PRTOPT='POSTSCRIPT'
        IDUM = NARGSI(5)
        CALL QUEUE_PLOT(QUEUE(1:NCQ),PLOTFILE,PRTOPT,ISTAT1,ISTAT2)
        IF(.NOT.ISTAT1.OR..NOT.ISTAT2)GO TO 65      !error return
#else
C Postscript: no -x flag
        IF(IDEV.EQ.12)THEN
          IF(QUEUE.EQ.'PRINTER')THEN
#ifdef g77
            STRING = 'lpr -h '//PLOTFILE
            CALL SYSTEM(STRING)
#elif gfortran
            STRING = 'lpr -h '//PLOTFILE
            CALL SYSTEM(STRING)
#else
            ISTAT=SYSTEM('lpr -h '//PLOTFILE)
#endif
          ELSE
#ifdef __hpux
            ISTAT=SYSTEM('lpr -d'//QUEUE(1:NCQ)//' '//PLOTFILE)
#elif g77
            STRING = 'lpr -h -P '//QUEUE(1:NCQ)//' '//PLOTFILE
            CALL SYSTEM(STRING)
#elif gfortran
            STRING = 'lpr -h -P '//QUEUE(1:NCQ)//' '//PLOTFILE
            CALL SYSTEM(STRING)
#else
            ISTAT=SYSTEM('lpr -h -P '//QUEUE(1:NCQ)//' '//PLOTFILE)
#endif
          ENDIF
C Other: use -x flag
        ELSE
          IF(QUEUE.EQ.'PRINTER')THEN
#ifdef g77
            STRING = 'lpr -x -h '//PLOTFILE
            CALL SYSTEM(STRING)
#elif gfortran
            STRING = 'lpr -x -h '//PLOTFILE
            CALL SYSTEM(STRING)
#else
            ISTAT=SYSTEM('lpr -x -h '//PLOTFILE)
#endif
          ELSE
#ifdef __hpux
            ISTAT=SYSTEM('lpr -d'//QUEUE(1:NCQ)//' '//PLOTFILE)
#elif g77
            STRING = 'lpr -x -h -P '//QUEUE(1:NCQ)//' '//PLOTFILE
            CALL SYSTEM(STRING)
#elif gfortran
            STRING = 'lpr -x -h -P '//QUEUE(1:NCQ)//' '//PLOTFILE
            CALL SYSTEM(STRING)
#else
            ISTAT=SYSTEM('lpr -x -h -P '//QUEUE(1:NCQ)//' '//PLOTFILE)
#endif
          ENDIF
        ENDIF
#endif
C Auxiliary port output:
      ELSE IF(CC .EQ. 'A')THEN
        CALL AUX_PORT_OUTPUT(IOUTH)
      ENDIF

C Close the plot file and exit
      CLOSE(UNIT=IOUTH)
      IF(MXGHARD)MXOK=.TRUE.
998   RETURN

C Error return:
999   WRITE(IOUTS,*)'Unable to open plot file ',
     &  PLOTFILE(1:LENSIG(PLOTFILE))
      CALL FORMSG
      GO TO 65                                    
      END

      SUBROUTINE GRAPHICS_HARDCOPY_PARSE(STRING,FIELD,IFIELD)
C======================================================================C
C
C  Extracts a specified character field from a string.  Fields may be 
C  delimited by blanks or tabs.
C
C  Inputs:
C    STRING  character string to be parsed
C    IFIELD  number of the field to be extracted
C  Output:
C    FIELD   contents of the field if it exists, otherwise blank
C
C======================================================================C

      CHARACTER*(*) STRING,FIELD

      CHARACTER*1 TAB
      LOGICAL IN_FIELD

      TAB = CHAR(9)   ! modified by J.Chuma, 20Mar97 for g77
      ICOUNT=0
      IN_FIELD=.FALSE.

      DO I=1,LENSIG(STRING)
        IF((STRING(I:I).EQ.' ').OR.(STRING(I:I).EQ.TAB))THEN
          IF(IN_FIELD)THEN
            IF(ICOUNT.EQ.IFIELD)THEN
              FIELD=STRING(ISTART:I-1)
              RETURN
            ENDIF
            IN_FIELD=.FALSE.
          ENDIF
        ELSE
          IF(.NOT.IN_FIELD)THEN
            ICOUNT=ICOUNT+1
            IN_FIELD=.TRUE.
            ISTART=I
          ENDIF
        ENDIF
      ENDDO

      IF(IN_FIELD.AND.ICOUNT.EQ.IFIELD)THEN
        FIELD=STRING(ISTART:LEN(STRING))
      ELSE
        FIELD=' '
      ENDIF

      RETURN
      END
