C
C  HP plotter subroutines
C
C  WRITTEN BY MIKE KENT, TRIUMF VANCOUVER     JULY 1983
C  VERSION 1.0   ( 12 OCTOBER 1983)
C
C  Extensively modified by Joe Chuma, January 25, 1984
C  Modified by Ken Fong, February, 1984
C  Modified by F. Jones, March/85.
C  Modified by J. Chuma, May/90  included ERR= in the write statements
C    to avoid crashes when SYS$SCRATCH is full
C  Modified 30-JAN-96 by FWJ: changed the writing format for the
C    pen code and coordinates from a run-time format to a fixed format.
C    This gives greater efficiency and works around an Alpha/OSF1
C    Fortran bug (dumps core when interpreting the run-time format).

      SUBROUTINE HP_PLOTS( IUNIT )
C
C  Initialization
C
C  Modified March 4/85 by F. Jones:
C    PX and PY are set outside the plotting region, so that an initial
C    pen up to (0,0) will not be masked.
C
      IMPLICIT NONE

      INTEGER*4 IUNIT

      INTEGER*4 IIUNIT
      COMMON /HPUNIT/ IIUNIT
      CHARACTER*4 PEN_STATE
      REAL*4 PX, PY
      INTEGER*4 ICOUNT
      COMMON /HPPEN/ PEN_STATE,PX,PY,ICOUNT
      CHARACTER*6 BUF(12)
      COMMON /HPFLUSH/ BUF

      PEN_STATE = 'U'
      PX = -1.
      PY = -1.
      ICOUNT = -1
      IIUNIT = IUNIT
      CALL HP_NEWPEN(1)
      RETURN
      END

      SUBROUTINE HP_PLOT(DX,DY,IPEN)
C
C  Cory's plot package calls Z_PLOT with real values
C  of x and y in the range 0 < x < 27.94 and 0 < y < 21.59 cm with
C  infinitely small increments.
C  The HP plotter requires ASCII integer strings
C  in the range 0 < x < 10900 and 0 < y < 7650.  When using the A4
C  setting for paper size (dipswitch selectable).
C  First we scale the data and convert it into integers.
C  354.414=10900/21.59*0.702    OLD
C  390.122=10900/27.94          NEW
C  273.80=7650/27.94            OLD
C  354.33=7650/21.59            NEW
C
C  Modified March 4/85 by F. Jones:
C    The scaling has been changed so that this routine may be passed
C    true "device coordinates" in centimeters.  The above "fudge
C    numbers" have been eliminated, since they are an attempt to
C    emulate Zeta plotter coordinates, when in fact the Zeta plotter
C    has a larger plottable area than the HP plotters.
C
C    The HP 7575A (6-pen) plotter has 402 "plotter units" per cm,
C    while the HP 7470A (2-pen) and 7550A (8-pen) have 400 plotter
C    units per cm.  In order to support all units in a transparent
C    way, the compromise conversion factor of 401 has been used.
C    This results in errors of at most 0.25% in actual distances
C    plotted.  The three plotters have slight differences in the size
C    of the plotting area.  To avoid overflow, the following maxima
C    should be used:
C
C          X: 25.36 cm (10169 plotter units)
C          Y: 19.07 cm ( 7647 plotter units)
C
C    The following call to MONITOR2_RANGE will support all devices:
C
C      CALL MONITOR2_RANGE(5,7,XMINH,XMAXH,YMINH,YMAXH,
C                          0.,25.36,0.,19.07,-1)
C
C    Note that the orientation (-1) has been changed to reflect that
C    of the HP plotter, which is opposite to that of the Zeta plotter.
C                                                                     
      IMPLICIT NONE

      REAL*4 DX, DY
      INTEGER*4 IPEN

      INTEGER*4 IIUNIT
      COMMON /HPUNIT/ IIUNIT
      CHARACTER*4 PEN_STATE
      REAL*4 PX, PY
      INTEGER*4 ICOUNT
      COMMON /HPPEN/ PEN_STATE,PX,PY,ICOUNT
      CHARACTER*6 BUF(12)
      COMMON /HPFLUSH/ BUF

      CHARACTER*4 PEN
      CHARACTER*6 CHX, CHY
      INTEGER*4   I, IX, IY

      PX = DX
      PY = DY
      IX = DX*401.
      IY = DY*401.
      WRITE(CHX,10)IX
      WRITE(CHY,10)IY
   10 FORMAT(I6)

      PEN = 'D'
      IF( IPEN.GT.2 )PEN = 'U'        ! select pen UP/DOWN
      IF( PEN.EQ.PEN_STATE )THEN 

C   Forget about old position if pen is still up:

        IF( PEN.NE.'U' .OR. ICOUNT.LT.1 )ICOUNT = ICOUNT+2
        BUF(ICOUNT) = CHX
        BUF(ICOUNT+1) = CHY
        IF( ICOUNT.LT.11 )RETURN

C  write buffer if full

C FWJ 29-JAN-96
C       WRITE(IIUNIT,30,ERR=99) PEN,(BUF(I),I=1,12)
        WRITE(IIUNIT,30,ERR=99)'P',PEN,(BUF(I),I=1,12),';'
        ICOUNT = -1
        RETURN
      ELSE
C FWJ 29-JAN-96
C       IF( ICOUNT.NE.-1 )
C    &   WRITE(IIUNIT,30,ERR=99)PEN_STATE,(BUF(I),I=1,ICOUNT+1)
        IF( ICOUNT.NE.-1 )
     &   WRITE(IIUNIT,30,ERR=99)'P',PEN_STATE,(BUF(I),I=1,ICOUNT+1),';'

C   flush buffer of previous pen state if it is not empty

        ICOUNT = 1
        PEN_STATE = PEN           !new pen status
        BUF(1) = CHX
        BUF(2) = CHY
      END IF
C FWJ 29-JAN-96
C  30 FORMAT('P',A1,<ICOUNT+1>A6,';')
   30 FORMAT(2A1,13A)
      RETURN
   99 CALL TRANSPARENT_MODE(0)
      WRITE(*,*)'Error in HP_PLOT: writing to HP plot file'
      CALL FORMSG
      RETURN
      END

      SUBROUTINE HP_FLUSH

      IMPLICIT NONE

      INTEGER*4 IIUNIT
      COMMON /HPUNIT/ IIUNIT
      CHARACTER*4 PEN_STATE
      REAL*4 PX, PY
      INTEGER*4 ICOUNT
      COMMON /HPPEN/ PEN_STATE,PX,PY,ICOUNT
      CHARACTER*6 BUF(12)
      COMMON /HPFLUSH/ BUF

      INTEGER*4 I

C   flush buffer of previous pen state if it is not empty

C FWJ 29-JAN-96
C     IF( ICOUNT.NE.-1 )
C    & WRITE(IIUNIT,10,ERR=99)PEN_STATE,(BUF(I),I=1,ICOUNT+1)
C  10 FORMAT('P',A1,<ICOUNT+1>A6,';')
      IF( ICOUNT.NE.-1 )
     & WRITE(IIUNIT,10,ERR=99)'P',PEN_STATE,(BUF(I),I=1,ICOUNT+1),';'
   10 FORMAT(2A1,13A)
      ICOUNT = -1
      RETURN
   99 CALL TRANSPARENT_MODE(0)
      WRITE(*,*)'Error in HP_FLUSH: writing to HP plot file'
      CALL FORMSG
      RETURN
      END

      SUBROUTINE HP_NEWPEN( IPEN )
C
C  Just selects the pen...
C  Modified by J.L.C., Apr  1, 1986: put pen up before selecting a new pen
C  Modified by J.L.C., May 26, 1994: allow pen numbers > 9
C
      IMPLICIT NONE

      INTEGER*4 IPEN

      INTEGER*4 IIUNIT
      COMMON /HPUNIT/ IIUNIT
      CHARACTER*4 PEN_STATE
      REAL*4 PX, PY
      INTEGER*4 ICOUNT
      COMMON /HPPEN/ PEN_STATE,PX,PY,ICOUNT
      CHARACTER*6 BUF(12)
      COMMON /HPFLUSH/ BUF

      IF( IPEN .LE. 0 )THEN
        CALL TRANSPARENT_MODE(0)
        WRITE(*,*)'Warning from HP_NEWPEN: pen number <= 0'
      ELSE IF( IPEN .LT. 10 )THEN
        CALL HP_FLUSH
        WRITE(IIUNIT,10,ERR=99)
   10   FORMAT('PU;')
        WRITE(IIUNIT,20,ERR=99)IPEN
   20   FORMAT('SP',I1,';')
        PEN_STATE = 'U'
        ICOUNT = -1
      ELSE IF( IPEN .LE. 15 )THEN
        CALL HP_FLUSH
        WRITE(IIUNIT,10,ERR=99)
        WRITE(IIUNIT,30,ERR=99)IPEN
   30   FORMAT('SP',I2,';')
        PEN_STATE = 'U'
        ICOUNT = -1
      ELSE
        CALL TRANSPARENT_MODE(0)
        WRITE(*,*)'Warning from HP_NEWPEN: pen number > 15'
      END IF
      RETURN
   99 CALL TRANSPARENT_MODE(0)
      WRITE(*,*)'Error in HP_NEWPEN: writing to HP plot file'
      CALL FORMSG
      RETURN
      END

      SUBROUTINE HP_SPEED(ISPEED)
C
C  Changes the plotting speed
C
      IMPLICIT NONE

      INTEGER*4 ISPEED

      INTEGER*4 IIUNIT
      COMMON /HPUNIT/ IIUNIT
      CHARACTER*4 PEN_STATE
      REAL*4 PX, PY
      INTEGER*4 ICOUNT
      COMMON /HPPEN/ PEN_STATE,PX,PY,ICOUNT
      CHARACTER*6 BUF(12)
      COMMON /HPFLUSH/ BUF

      IF( ISPEED.LT.1 )THEN
        CALL TRANSPARENT_MODE(0)
        WRITE(*,*)'Error in HP_SPEED: speed < 1'
      ELSE IF( ISPEED.LT.10 )THEN
        CALL HP_FLUSH
        WRITE(IIUNIT,10,ERR=99)ISPEED
   10   FORMAT('VS',I1,';')
      ELSE IF( ISPEED.LE.80 )THEN
        CALL HP_FLUSH
        WRITE(IIUNIT,20,ERR=99)ISPEED
   20   FORMAT('VS',I2,';')
      ELSE 
        CALL TRANSPARENT_MODE(0)
        WRITE(*,*)'Error in HP_SPEED: speed > 80'
      END IF
      RETURN
   99 CALL TRANSPARENT_MODE(0)
      WRITE(*,*)'Error in HP_SPEED: writing to HP plot file'
      CALL FORMSG
      RETURN
      END
