      SUBROUTINE CROSSHAIR_R(X,Y,CODE,XL,YL)
C HACKED for HP-UX
C======================================================================C
C                                                                      C
C  CROSSHAIR_R                                                         C
C                                                                      C
C  Gets a digitized point using the device's crosshair cursor.         C
C                                                                      C
C  If the plot coordinates (XL,YL) are on the screen then the          C
C  crosshair will appear at the screen location corresponding to       C
C  (XL,YL). If (XL,YL) is off the screen then it will appear where it  C
C  was the last time it was positioned. It can then be positioned to   C
C  any point on the display screen using the four arrow keys on the    C
C  keyboard. After being positioned, typing any key on the keyboard    C
C  will cause the character corresponding to that key to be returned   C
C  in CODE (LOGICAL*1), and the cross hair plot coordinates to be      C
C  returned in (X,Y).                                                  C
C                                                                      C
C  Note: In order to use this subroutine correctly the trailer codes   C
C  of the VT640 local mode (set using the PF3 key after doing a SETUP  C
C  RESET) must be set to 0D (carriage return) and 0C hexadecimal.      C
C                                                                      C
C  NOTE:  There are 4 light pen modes which can be set by via the MODE C
C  variable (CHARACTER*1) in the common block LIGHT_PEN_MODE.  The     C
C  modes are:                                                          C
C              '0' - clear (ie. nothing happens)                       C
C              '1' - turns the 'L1' light on the keyboard on           C
C              '2' - beeps when a reading is made                      C
C              '3' - flashes 'LIGHT PEN READY' (default)               C
C  These mode have no effect when you are not using the light pen.     C
C                                                                      C
C   Written by Arthur Haynes, TRIUMF U.B.C., July 7, 1981.             C
C   Modified by Henry Baragar, TRIUMF UBC, November 18, 1982.          C
C   Modified by Alan Carruthers, February 23, 1983 to allow            C
C     joystick positioning of crosshairs on VS11, then readback        C
C     of crosshair location.                                           C
C   Modified by Alan Carruthers, October 4, 1983 to prevent            C
C     integer overflow when IXLM and IYLM are calculated.              C
C   Modified by Henry Baragar, May 23, 1984 to use READ_KEY            C
C     to get imput to prevent problems that occur when the             C
C     <CR> is hit for input.	                                       C
C   Modified by Bernard Henin, July 1984, to include the               C
C     TEKTRONIX-4107.                                                  C
C   Modified by Corrie Kost, Aug 23/1984 to use VT241 and              C
C     improve coding readability                                       C
C   Modified by F.W. Jones, Oct 28/86.  For the VT640, after the       C
C     crosshair address is sent, a string of 40 nulls is sent before   C
C     bringing up the crosshairs.  This is to correct a timing         C
C     problem that occurs in some VT640's, where the crosshairs will   C
C     not come up and the terminal will hang.  An alternative fix      C
C     would be to put a "sleep" of about 0.05 sec between the two      C
C     escape sequences.  This problem appeared after the "sleep" was   C
C     removed from the TRANSPARENT_MODE procedure and seems to result  C
C     from quick transitions between transparent and graphics modes.   C
C   Modified by J.Chuma, Jan 30, 1987, to correct scaling numbers for  C
C     the TEK-4107.  See [KOST.LIBRARY.EXAMPLES]TK4107.FOR for tests)  C
C   Modified Mar 20/87 by F. Jones for Seiko GR-1105 terminal support  C
C   Modified Aug 18/87 by F. Jones.  To correct VT640 crosshair        C
C     hangup which appeared again, the fix has been changed.  Now a    C
C     string of 60 nulls is sent before sending the crosshair address  C
C     and mode change sequences, which are sent without intervening    C
C     nulls.                                                           C
C                                                                      C
C   Modified May 6/88 by C. Kost. Restrain cursor addresses returned   C
C     to 0-1023 (both X&Y)                                             C
C   Modified Aug 9/88 by C.Kost. Optionally preset cursor for VAXSTATn.C
C   Modified by J.Chuma, May 10, /89, support generic terminal         C
C   Modified 02-JAN-91 by F. Jones for RISC/ULTRIX: optional argument  C
C     TIMEOUT must be present in calls to READ_KEY.                    C
C   Modified by J.Chuma, November 4, 1991 to eliminate light pen       C
C     support                                                          C
C   Modified 19-AUG-93 by FWJ: Zeta and UIS support removed            C
C                                                                      C
C   Input  Parameters: XL,YL (R*4).                                    C
C                                                                      C
C   Output Parameters: X,Y (R*4); CODE (L*1).                          C
C                                                                      C
C======================================================================C
      COMMON /PLOT_CLEAR/ CLEAR
      LOGICAL CLEAR
      COMMON /PLOTMONITOR/ IMONITOR,IOUTM
      COMMON /MONITOR_SIZE/ XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE
      COMMON /PLOT_TO_MONITOR/ RMATRIXMP(2,2),SHIFTMP(2)
      COMMON /MONITOR_TO_PLOT/ RMATRIXPM(2,2),SHIFTPM(2)
      LOGICAL*1 CODE,IBYTE(4)
      CHARACTER*1 ESC, GS, SUB
      PARAMETER ( ESC=CHAR(27), GS=CHAR(29), SUB=CHAR(26) )
      INTEGER I33/33/
      LOGICAL*1 IYHI,IYLO,IXHI,IXLO
      LOGICAL*1 I241(11)
      CHARACTER*1 READ_KEY, ALTKEY
C 2.147E9 is slightly smaller than the maximum
C value that an integer variable can have:
      PARAMETER (BIG = 2.147E9)  !inserted by Alan Carruthers
      LOGICAL*1 CR/13/,EC/27/
      LOGICAL*1 NULLS(60)/60*0/
      CHARACTER*1 US /31/
      CHARACTER*2 HEXBUFF
      INTEGER*2 IXM2,IYM2,IXLOB,IXMOB,IXHOB,IYLOB,IYMOB,IYHOB
D     INTEGER*4 I4

      IF(CLEAR)CALL CLEAR_PLOT
      X=0.
      Y=0.
      CODE='0'
C
C    IMONITOR #      DEVICE
C    ----------     --------
C       0            no monitor
C       1            VT640
C       2            TX4010
C       3            VS11
C       4            ZETA
C       5            HP
C       6            CIT-467
C       7            TEK4107
C       8            VT241
C       9            PT100G
C      10
C      11
C      12            SEIKO GR1105
C      13      
C      14            
C      15            VAXSTATION
C      16            LN03+
C      17            generic terminal
C      18            VaxStation DecWindows

      IF( IMONITOR .EQ. 0 )RETURN
C            1   2   3  4  5   6   7   8   9 10 11  12
      GOTO (100,200,10,10,10,600,700,800,100,10,10,900,
C            13 14 15 16   17   18
     #       10,10,10,10,1100,1200)IMONITOR
10    RETURN

C=================================================================
C   Determine the monitor coordinates (XLM,YLM) which         ==
C   correspond to the plot coordinates (XL,YL):               ==
C                                                             ==
C       |XLM|               |XL|                              ==
C       |   | = RMATRIXMP * |  | + SHIFTMP                    ==
C       |YLM|               |YL|                              ==
C=================================================================
100   XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)
      YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)
C=================================================================
C   (IXLM,IYLM) are the monitor dot coordinates which         ==
C   correspond to the plot coordinates (XL,YL).               ==
C=================================================================
      IXLM=MAX(-BIG,MIN(BIG,XLM+SIGN(.5,XLM)))  !Alan Carruthers
      IYLM=MAX(-BIG,MIN(BIG,YLM+SIGN(.5,YLM)))  !Alan Carruthers
C=================================================================
C   Check to see if (IXLM,IYLM) is on the monitor screen.     ==
C=================================================================
      IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR.
     *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 125
C=================================================================
C   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==
C   to location (IXLM,IYLM) on the screen.                    ==
C=================================================================
C   Scale from VT640 to TX4010 values since VT640 is a TX4010 ==
C   emulator.                                                 ==
C=================================================================
      IXLM=IXLM*1024/640
      IYLM=IYLM*780/480
C=================================================================
C   Calculate the four plot characters required to load the   ==
C   crosshair to the TX4010 location: (IXLM,IYLM).            ==
C=================================================================
      IYHI=32+IYLM/32
      IYLO=96+MOD(IYLM,32)
      IXHI=32+IXLM/32
      IXLO=64+MOD(IXLM,32)
C=================================================================
C   Load the crosshair at the TX4010 location: (IXLM,IYLM).   ==
C=================================================================
cc      WRITE(IOUTM,122)GS,IYHI,IYLO,IXHI,IXLO,ESC,'/','f',NULLS,ESC,SUB
      WRITE(IOUTM,122)NULLS,GS,IYHI,IYLO,IXHI,IXLO,ESC,'/','f',ESC,SUB
122   FORMAT(70A1,$)
      GO TO 124
C=================================================================
C   (IXLM,IYLM) is off the monitor screen. Display the        ==
C   crosshair on the screen at the same place it was last     ==
C   positioned.                                               ==
C=================================================================
125   WRITE(IOUTM,150)GS,ESC,SUB   
C
C Enter Graphics, ...Crosshair mode, Read code and crosshair coordinates
C
150   FORMAT(1X,3A1,$)
124   CODE = ICHAR(READ_KEY('NOESC FAST LC2UC PURGE',' ',ALTKEY,0))
      DO WHILE (CODE.EQ.CR .OR. CODE.EQ.EC)
        CALL BELL(1)
        WRITE(IOUTM,150)GS,ESC,SUB
        CODE = ICHAR(READ_KEY('NOESC FAST LC2UC PURGE',' ',ALTKEY,0))
      ENDDO
      DO IBYTER=1,4
        IBYTE(IBYTER) = ICHAR(READ_KEY('NOESC FAST',' ',ALTKEY,0))
      ENDDO
      IDUMMY = ICHAR(READ_KEY('FAST ',' ',ALTKEY,0))
#ifdef unix
      IDUMMY = ICHAR(READ_KEY('RESET',' ',ALTKEY,0))
#endif
C=================================================================
C   Calculate the crosshair coordinates (IXM,IYM) for the     ==
C   device.                                                   ==
C=================================================================
      IXM=(IBYTE(1)-I33)*32+IBYTE(2)
      IYM=(IBYTE(3)-I33)*32+IBYTE(4)
      IXM=MAX(0,IXM)
      IYM=MAX(0,IYM)
      IXM=MIN(IXM,1023)
      IYM=MIN(IYM,1023)
C=================================================================
C   Scale from TX4010 to VT640 values since VT640 is a TX4010 ==
C   emulator.                                                 ==
C=================================================================
      IXM=IXM*640./1024.+.6
      IYM=IYM*480./780.+.6
C=================================================================
C   Determine the plot coordinates (X,Y) which correspond     ==
C   to the crosshair monitor coordinates (IXM,IYM):           ==
C                                                             ==
C       |X|               |IXM|                               ==
C       | | = RMATRIXPM * |   | + SHIFTPM                     ==
C       |Y|               |IYM|                               ==
C=================================================================
      X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)
      Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)
      RETURN
C
C***** TX4010
C
C=================================================================
C   Determine the monitor coordinates (XLM,YLM) which         ==
C   correspond to the plot coordinates (XL,YL):               ==
C                                                             ==
C       |XLM|               |XL|                              ==
C       |   | = RMATRIXMP * |  | + SHIFTMP                    ==
C       |YLM|               |YL|                              ==
C=================================================================
200   XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)
      YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)
C=================================================================
C   (IXLM,IYLM) are the monitor dot coordinates which         ==
C   correspond to the plot coordinates (XL,YL).               ==
C=================================================================
      IXLM=MAX(-BIG,MIN(BIG,XLM+SIGN(.5,XLM)))  !Alan Carruthers
      IYLM=MAX(-BIG,MIN(BIG,YLM+SIGN(.5,YLM)))  !Alan Carruthers
C=================================================================
C   Check to see if (IXLM,IYLM) is on the monitor screen.     ==
C=================================================================
      IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR.
     *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 225
C=================================================================
C   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==
C   to location (IXLM,IYLM) on the screen.                    ==
C=================================================================
C   Calculate the four plot characters required to load the   ==
C   crosshair to the TX4010 location: (IXLM,IYLM).            ==
C=================================================================
      IYHI=32+IYLM/32
      IYLO=96+MOD(IYLM,32)
      IXHI=32+IXLM/32
      IXLO=64+MOD(IXLM,32)
C=================================================================
C   Load the crosshair at the TX4010 location: (IXLM,IYLM).   ==
C=================================================================
      WRITE(IOUTM,222)GS,IYHI,IYLO,IXHI,IXLO,ESC,'/','f',ESC,SUB
222   FORMAT(1X,10A1,$)
      GO TO 224
C=================================================================
C   (IXLM,IYLM) is off the monitor screen. Display the        ==
C   crosshair on the screen at the same place it was last     ==
C   positioned.                                               ==
C=================================================================
225   WRITE(IOUTM,250)GS,ESC,SUB   
C
C Enter Graphics, ...Crosshair mode, Read code and crosshair coordinates
C
250   FORMAT(1X,3A1,$)
224   CODE = ICHAR(READ_KEY('NOESC FAST LC2UC PURGE',' ',ALTKEY,0))
      DO WHILE (CODE.EQ.CR .OR. CODE.EQ.EC)
        CALL BELL(1)
        WRITE(IOUTM,250)GS,ESC,SUB
        CODE = ICHAR(READ_KEY('NOESC LC2UC FAST PURGE',' ',ALTKEY,0))
      ENDDO
      DO IBYTER=1,4
        IBYTE(IBYTER) = ICHAR(READ_KEY('NOESC FAST',' ',ALTKEY,0))
      ENDDO
      IDUMMY = ICHAR(READ_KEY('FAST ',' ',ALTKEY,0))
#ifdef unix
      IDUMMY = ICHAR(READ_KEY('RESET',' ',ALTKEY,0))
#endif
C=================================================================
C   Calculate the crosshair coordinates (IXM,IYM) for the     ==
C   device.                                                   ==
C=================================================================
      IXM=(IBYTE(1)-I33)*32+IBYTE(2)
      IYM=(IBYTE(3)-I33)*32+IBYTE(4)
      IXM=MAX(0,IXM)
      IYM=MAX(0,IYM)
      IXM=MIN(IXM,1023)
      IYM=MIN(IYM,1023)
C=================================================================
C   Determine the plot coordinates (X,Y) which correspond     ==
C   to the crosshair monitor coordinates (IXM,IYM):           ==
C                                                             ==
C       |X|               |IXM|                               ==
C       | | = RMATRIXPM * |   | + SHIFTPM                     ==
C       |Y|               |IYM|                               ==
C=================================================================
      X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)
      Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)
      RETURN

C*** CIT-467
C
C=================================================================
C   Determine the monitor coordinates (XLM,YLM) which         ==
C   correspond to the plot coordinates (XL,YL):               ==
C                                                             ==
C       |XLM|               |XL|                              ==
C       |   | = RMATRIXMP * |  | + SHIFTMP                    ==
C       |YLM|               |YL|                              ==
C=================================================================
600   XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)
      YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)
C=================================================================
C   (IXLM,IYLM) are the monitor dot coordinates which         ==
C   correspond to the plot coordinates (XL,YL).               ==
C=================================================================
      IXLM=MAX(-BIG,MIN(BIG,XLM+SIGN(.5,XLM)))  !Alan Carruthers
      IYLM=MAX(-BIG,MIN(BIG,YLM+SIGN(.5,YLM)))  !Alan Carruthers
C=================================================================
C   Check to see if (IXLM,IYLM) is on the monitor screen.     ==
C=================================================================
      IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR.
     *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 625
C=================================================================
C   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==
C   to location (IXLM,IYLM) on the screen.                    ==
C=================================================================
C   Scale from CIT-467 to TX4010  since CIT-467   is a TX4010 ==
C   emulator.                                                 ==
C=================================================================
      IXLM=IXLM*1023.77/571.      ! SEE CIT467.FOR
      IYLM=IYLM*785.87/479.       ! SEE CIT467.FOR
C=================================================================
C   Calculate the four plot characters required to load the   ==
C   crosshair to the TX4010 location: (IXLM,IYLM).            ==
C=================================================================
      IYHI=32+IYLM/32
      IYLO=96+MOD(IYLM,32)
      IXHI=32+IXLM/32
      IXLO=64+MOD(IXLM,32)
C=================================================================
C   Load the crosshair at the TX4010 location: (IXLM,IYLM).   ==
C=================================================================
      WRITE(IOUTM,622)GS,IYHI,IYLO,IXHI,IXLO,ESC,'/','f',ESC,SUB
622   FORMAT(1X,10A1,$)
      GO TO 624
C=================================================================
C   (IXLM,IYLM) is off the monitor screen. Display the        ==
C   crosshair on the screen at the same place it was last     ==
C   positioned.                                               ==
C=================================================================
625   WRITE(IOUTM,650)GS,ESC,SUB   
C
C Enter Graphics, ...Crosshair mode, Read code and crosshair coordinates
C
650   FORMAT(1X,3A1,$)
624   CODE = ICHAR(READ_KEY('NOESC FAST LC2UC PURGE',' ',ALTKEY,0))
      DO WHILE (CODE.EQ.CR .OR. CODE.EQ.EC)
        CALL BELL(1)
        WRITE(IOUTM,650)GS,ESC,SUB
        CODE = ICHAR(READ_KEY('NOESC FAST LC2UC PURGE',' ',ALTKEY,0))
      ENDDO
      DO IBYTER=1,4
        IBYTE(IBYTER) = ICHAR(READ_KEY('NOESC FAST',' ',ALTKEY,0))
      ENDDO
      IDUMMY = ICHAR(READ_KEY('FAST ',' ',ALTKEY,0))
#ifdef unix
      IDUM=ICHAR(READ_KEY('RESET',' ',ALTKEY,0))
#endif
C=================================================================
C   Calculate the crosshair coordinates (IXM,IYM) for the     ==
C   device.                                                   ==
C=================================================================
      IXM=(IBYTE(1)-I33)*32+IBYTE(2)
      IYM=(IBYTE(3)-I33)*32+IBYTE(4)
      IXM=MAX(0,IXM)
      IYM=MAX(0,IYM)
      IXM=MIN(IXM,1023)
      IYM=MIN(IYM,1023)
C=================================================================
C   Scale from TX4010 to CIT-467 since CIT-467    is a TX4010 ==
C   emulator.                                                 ==
C=================================================================
      IXM=IXM*571./1023.77+.6        ! DONT ASK WHY THIS WORKS !
      IYM=IYM*479./786.11+.6         ! SEE CIT467.FOR FOR TESTS
C=================================================================
C   Determine the plot coordinates (X,Y) which correspond     ==
C   to the crosshair monitor coordinates (IXM,IYM):           ==
C                                                             ==
C       |X|               |IXM|                               ==
C       | | = RMATRIXPM * |   | + SHIFTPM                     ==
C       |Y|               |IYM|                               ==
C=================================================================
      X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)
      Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)
      RETURN
C
C*** TEK4107
C
C=================================================================
C   Determine the monitor coordinates (XLM,YLM) which         ==
C   correspond to the plot coordinates (XL,YL):               ==
C                                                             ==
C       |XLM|               |XL|                              ==
C       |   | = RMATRIXMP * |  | + SHIFTMP                    ==
C       |YLM|               |YL|                              ==
C=================================================================
700   XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)
      YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)
C=================================================================
C   (IXLM,IYLM) are the monitor dot coordinates which         ==
C   correspond to the plot coordinates (XL,YL).               ==
C=================================================================
      IXLM=MAX(-BIG,MIN(BIG,XLM+SIGN(.5,XLM)))  !Alan Carruthers
      IYLM=MAX(-BIG,MIN(BIG,YLM+SIGN(.5,YLM)))  !Alan Carruthers
C=================================================================
C   Check to see if (IXLM,IYLM) is on the monitor screen.     ==
C=================================================================
      IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR.
     *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 725
C=================================================================
C   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==
C   to location (IXLM,IYLM) on the screen.                    ==
C=================================================================
C   Scale from VT640 to TX4010 values since VT640 is a TX4010 ==
C   emulator.                                                 ==
C=================================================================
      IXLM=IXLM*1023.8/639.+0.12707355      ! DONT ASK WHY THIS WORKS !
      IYLM=IYLM*782.515/479.+0.127943215031 ! SEE TK4107.FOR FOR TESTS
C=================================================================
C   Calculate the four plot characters required to load the   ==
C   crosshair to the TX4010 location: (IXLM,IYLM).            ==
C=================================================================
      IYHI=32+IYLM/32
      IYLO=96+MOD(IYLM,32)
      IXHI=32+IXLM/32
      IXLO=64+MOD(IXLM,32)
C=================================================================
C   Load the crosshair at the TX4010 location: (IXLM,IYLM).   ==
C=================================================================
      WRITE(IOUTM,722)
     #           ESC,'%!',0,GS,IYHI,IYLO,IXHI,IXLO,ESC,'/','f',ESC,SUB
722   FORMAT(1X,A1,A2,I1,10A1,$)
      GO TO 724
C=================================================================
C   (IXLM,IYLM) is off the monitor screen. Display the        ==
C   crosshair on the screen at the same place it was last     ==
C   positioned.                                               ==
C=================================================================
725   WRITE(IOUTM,722)ESC,'%!',0,GS,ESC,SUB   
C
C Enter Graphics, ...Crosshair mode, Read code and crosshair coordinates
C
750   FORMAT(1X,7A1,$)
724   CODE = ICHAR(READ_KEY('NOESC FAST LC2UC PURGE',' ',ALTKEY,0))
      DO WHILE (CODE.EQ.CR .OR. CODE.EQ.EC)
        CALL BELL(1)
        WRITE(IOUTM,722)ESC,'%!',0,GS,ESC,SUB
        CODE = ICHAR(READ_KEY('NOESC FAST LC2UC PURGE',' ',ALTKEY,0))
      ENDDO
      DO IBYTER=1,4
        IBYTE(IBYTER) = ICHAR(READ_KEY('NOESC FAST',' ',ALTKEY,0))
      ENDDO
      IDUMMY = ICHAR(READ_KEY('FAST ',' ',ALTKEY,0))
#ifdef unix
      IDUM=ICHAR(READ_KEY('RESET',' ',ALTKEY,0))
#endif
C=================================================================
C   Calculate the crosshair coordinates (IXM,IYM) for the     ==
C   device.                                                   ==
C=================================================================
      IXM=(IBYTE(1)-I33)*32+IBYTE(2)
      IYM=(IBYTE(3)-I33)*32+IBYTE(4)
      IXM=MAX(0,IXM)
      IYM=MAX(0,IYM)
      IXM=MIN(IXM,1023)
      IYM=MIN(IYM,1023)
C=================================================================
C   Scale from TX4010 to VT640 values since VT640 is a TX4010 ==
C   emulator.                                                 ==
C=================================================================
      IXM=IXM*(639./1023.8)+.65   ! DONT ASK WHY IT JUST WORKS.
      IYM=IYM*(479./783.2)+0.92   ! SEE TK4107.FOR FOR TESTING
C=================================================================
C   Determine the plot coordinates (X,Y) which correspond     ==
C   to the crosshair monitor coordinates (IXM,IYM):           ==
C                                                             ==
C       |X|               |IXM|                               ==
C       | | = RMATRIXPM * |   | + SHIFTPM                     ==
C       |Y|               |IYM|                               ==
C=================================================================
      X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)
      Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)
      WRITE(IOUTM,760)ESC,'ID',0
760   FORMAT(1X,A1,A2,I1,$)
      RETURN
C
C VT241
C
C=================================================================
C   Determine the monitor coordinates (XLM,YLM) which         ==
C   correspond to the plot coordinates (XL,YL):               ==
C                                                             ==
C       |XLM|               |XL|                              ==
C       |   | = RMATRIXMP * |  | + SHIFTMP                    ==
C       |YLM|               |YL|                              ==
C=================================================================
800   CALL REGIS_MODE
C
      XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)
      YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)
C=================================================================
C   (IXLM,IYLM) are the monitor dot coordinates which         ==
C   correspond to the plot coordinates (XL,YL).               ==
C=================================================================
      XLM=MAX(-BIG,MIN(BIG,XLM))  !Alan Carruthers
      YLM=MAX(-BIG,MIN(BIG,YLM))  !Alan Carruthers
      IXLM=NINT(XLM)
      IYLM=NINT(YLM)
C=================================================================
C   Check to see if (IXLM,IYLM) is on the monitor screen.     ==
C=================================================================
      IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR.
     *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 825
C=================================================================
C   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==
C   to location (IXLM,IYLM) on the screen.                    ==
C=================================================================
      IYLM=ABS(IYLM-479)
C=================================================================
C   Load the crosshair at the VT241  location: (IXLM,IYLM).   ==
C=================================================================
      WRITE(IOUTM,822)'P[',IXLM,',',IYLM,']R(P(I))'
822   FORMAT(1X,A,I3.3,A1,I3.3,A)
      GO TO 824
C
C Enter Graphics ...Crosshair mode.. Read code and cross-hair coordinates.
C
825   WRITE(IOUTM,850)'R(P(I))'
850   FORMAT(1X,A)
824   CODE = ICHAR(READ_KEY('NOESC FAST LC2UC',' ',ALTKEY,0))
C     DO WHILE (CODE.EQ.CR .OR. CODE.EQ.ESC)
C       CALL BELL(1)
C       WRITE(IOUTM,850)'R(P(I))'
C       CODE = ICHAR(READ_KEY('NOESC FAST LC2UC PURGE',' ',ALTKEY,0))
C     ENDDO
      I241(1) = ICHAR(READ_KEY('NOESC FAST',' ',ALTKEY,0))
      I241R=1
      DO WHILE (I241(I241R) .NE. CR)
        I241R=I241R+1
        I241(I241R) = ICHAR(READ_KEY('NOESC FAST',' ',ALTKEY,0))
      ENDDO
#ifdef unix
      IDUMMY = ICHAR(READ_KEY('RESET',' ',ALTKEY,0))
#endif
      WRITE(IOUTM,852)ESC,'\\'     ! Exit Regis Mode
 852  FORMAT(1X,A1,A)
      I241R=I241R-1
C
C  INTERPRET STRING I241 AS P[xxx,yyy]
C  Extract xxx  ---> IXM  ,   yyy ----> IYM
C
      IYM=0
      I=I241R-1                                  !Start at last y
      J=0
      DO WHILE (I241(I).NE. ',')
      IYM=IYM+(I241(I)-48)*10**J
      I=I-1
      J=J+1
      ENDDO
      I=I-1                                     ! Start at last x
      IXM=0
      J=0
      DO WHILE (I241(I) .NE. '[')
      IXM=IXM+(I241(I)-48)*10**J
      I=I-1
      J=J+1
      ENDDO
      IYM=ABS(479-IYM)
C=================================================================
C   Determine the plot coordinates (X,Y) which correspond     ==
C   to the crosshair monitor coordinates (IXM,IYM):           ==
C                                                             ==
C       |X|               |IXM|                               ==
C       | | = RMATRIXPM * |   | + SHIFTPM                     ==
C       |Y|               |IYM|                               ==
C=================================================================
      X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)
      Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)
      RETURN
C
C*** SEIKO GR-1105 ***
C
C=================================================================
C   Determine the monitor coordinates (XLM,YLM) which         ==
C   correspond to the plot coordinates (XL,YL):               ==
C                                                             ==
C       |XLM|               |XL|                              ==
C       |   | = RMATRIXMP * |  | + SHIFTMP                    ==
C       |YLM|               |YL|                              ==
C=================================================================
900   XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)
      YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)
C=================================================================
C   (IXLM,IYLM) are the monitor dot coordinates which         ==
C   correspond to the plot coordinates (XL,YL).               ==
C=================================================================
      IXLM=MAX(-BIG,MIN(BIG,XLM+SIGN(.5,XLM)))  !Alan Carruthers
      IYLM=MAX(-BIG,MIN(BIG,YLM+SIGN(.5,YLM)))  !Alan Carruthers
C
C=================================================================
C   Check to see if (IXLM,IYLM) is on the monitor screen.     ==
C=================================================================
      IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR.
     *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 925
C=================================================================
C   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==
C   to location (IXLM,IYLM) on the screen.                    ==
C=================================================================
C Convert to 15-bit ASCII format:
      IXLOB=IBITS(IXLM,0,5) + 32
      IXMOB=IBITS(IXLM,5,5) + 64
      IXHOB=IBITS(IXLM,10,5) + 96
      IYLOB=IBITS(IYLM,0,5) + 32
      IYMOB=IBITS(IYLM,5,5) + 64
      IYHOB=IBITS(IYLM,10,5) + 96
      WRITE(IOUTM,922)ESC,'K',' ',ESC,'c','B',IXHOB,IXMOB,IXLOB,
     #                                        IYHOB,IYMOB,IYLOB,' ',ESC
922   FORMAT(1X,20A1)
C
C Query crosshair position:
925   WRITE(IOUTM,960)ESC,'K ',ESC,'rA!'
960   FORMAT(1X,A1,A2,A1,A3)
C
C Read the response:
      IDUMMY=ICHAR(READ_KEY('NOESC FAST PURGE',' ',ALTKEY,0))
      IDUMMY=ICHAR(READ_KEY('NOESC FAST',' ',ALTKEY,0))
      IDUMMY=ICHAR(READ_KEY('NOESC FAST',' ',ALTKEY,0))
      IXHOB = ICHAR(READ_KEY('NOESC FAST',' ',ALTKEY,0)) - 32
      IXMOB = ICHAR(READ_KEY('NOESC FAST',' ',ALTKEY,0)) - 32
      IXLOB = ICHAR(READ_KEY('NOESC FAST',' ',ALTKEY,0)) - 32
      IYHOB = ICHAR(READ_KEY('NOESC FAST',' ',ALTKEY,0)) - 32
      IYMOB = ICHAR(READ_KEY('NOESC FAST',' ',ALTKEY,0)) - 32
      IYLOB = ICHAR(READ_KEY('NOESC FAST',' ',ALTKEY,0)) - 32
      HEXBUFF(1:1)=READ_KEY('NOESC FAST',' ',ALTKEY,0)
      HEXBUFF(2:2)=READ_KEY('NOESC FAST',' ',ALTKEY,0)
      IDUMMY = ICHAR(READ_KEY('FAST ',' ',ALTKEY,0))
#ifdef unix
      IDUMMY = ICHAR(READ_KEY('RESET',' ',ALTKEY,0))
#endif
C Get key code:
      READ(HEXBUFF,970)CODE
970   FORMAT(Z2)
C
C=================================================================
C   Calculate the crosshair coordinates (IXM,IYM) for the     ==
C   device.                                                   ==
C=================================================================
CC      CALL MVBITS(IXLOB,0,5,IXM2,0)
CC      CALL MVBITS(IXMOB,0,5,IXM2,5)
CC      CALL MVBITS(IXHOB,0,5,IXM2,10)
CC      CALL MVBITS(IXM2,14,1,IXM2,15)      !set bit 15 = bit 14
CC      CALL MVBITS(IYLOB,0,5,IYM2,0)
CC      CALL MVBITS(IYMOB,0,5,IYM2,5)
CC      CALL MVBITS(IYHOB,0,5,IYM2,10)
CC      CALL MVBITS(IYM2,14,1,IYM2,15)      !set bit 15 = bit 14
      IXM=IXM2
      IYM=IYM2
C
C=================================================================
C   Determine the plot coordinates (X,Y) which correspond     ==
C   to the crosshair monitor coordinates (IXM,IYM):           ==
C                                                             ==
C       |X|               |IXM|                               ==
C       | | = RMATRIXPM * |   | + SHIFTPM                     ==
C       |Y|               |IYM|                               ==
C=================================================================
      X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)
      Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)
      RETURN

C  IMONITOR=17:  generic terminal
C
C   Determine the monitor coordinates (XLM,YLM) which
C   correspond to the plot coordinates (XL,YL)
C
C       |XLM|               |XL|
C       |   | = RMATRIXMP * |  | + SHIFTMP
C       |YLM|               |YL|
C
1100  XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)
      YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)
      CALL GENERIC_CROSSHAIR( XM, YM, CODE, XLM, YLM )
C
C   Determine the plot coordinates (X,Y) which correspond 
C   to the crosshair monitor coordinates (XM,YM)
C
C       |X|               |IXM|
C       | | = RMATRIXPM * |   | + SHIFTPM
C       |Y|               |IYM|
C
      X=RMATRIXPM(1,1)*XM+RMATRIXPM(1,2)*YM+SHIFTPM(1)
      Y=RMATRIXPM(2,1)*XM+RMATRIXPM(2,2)*YM+SHIFTPM(2)
      RETURN

C=================================================================
C  IMONITOR=18:  X Window display
C=================================================================
C=================================================================
C   Determine the monitor coordinates (XLM,YLM) which         ==
C   correspond to the plot coordinates (XL,YL):               ==
C                                                             ==
C       |XLM|               |XL|                              ==
C       |   | = RMATRIXMP * |  | + SHIFTMP                    ==
C       |YLM|               |YL|                              ==
C=================================================================
1200  XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)
      YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)
      CALL XVST_CROSSHAIR(XM,YM,ICODE,XLM,YLM)
      CODE = ICODE
C=================================================================
C   Determine the plot coordinates (X,Y) which correspond     ==
C   to the crosshair monitor coordinates (IXM,IYM):           ==
C                                                             ==
C       |X|               |IXM|                               ==
C       | | = RMATRIXPM * |   | + SHIFTPM                     ==
C       |Y|               |IYM|                               ==
C=================================================================
      X=RMATRIXPM(1,1)*XM+RMATRIXPM(1,2)*YM+SHIFTPM(1)
      Y=RMATRIXPM(2,1)*XM+RMATRIXPM(2,2)*YM+SHIFTPM(2)
      RETURN

      END
