      SUBROUTINE RICON(RNUM,CNUM,ITYPE,FMT,IWIDTH,*)
C HACKED for HP-UX: can't encode into passed-length buffer
C  
C     reqd. KOSTL: routines - BTD,EQUC,MOVEC,SETC
C================================================================
C================================================================
C==                                                            ==
C==   RICON: CONVERTS THE NUMBER RNUM (WHICH MAY BE R*8,R*4,   ==
C==          I*4,I*2, DEPENDING ON ITYPE = 1,2,3,4) TO IWIDTH  ==
C==          CHARACTERS IN THE ARRAY CNUM USING THE FORMAT CODE==
C==          FMT.                                              ==
C==                                                            ==
C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., NOV. 17, 1978.  ==
C==                                                            ==
C==   INPUT  PARAMETERS: RNUM (R*8,R*4,I*4,I*2 FOR ITYPE=1,2,3,==
C==                      4, RESPECTIVELY);                     ==
C==                      FMT (L*1); ITYPE,IWIDTH, (I*4).       ==
C==                                                            ==
C==   OUTPUT PARAMETERS: CNUM(IWIDTH), (L*1).                  ==
C==                                                            ==
C==   PARAMETER DEFINITIONS:                                   ==
C==   --------- -----------                                    ==
C==                                                            ==
C==   RNUM  : REAL OR INTEGER NUMBER TO BE CONVERTED BY RICON  ==
C==           TO "IWIDTH" CHARACTERS IN THE STRING "CNUM" USING==
C==           THE FORMAT SPECIFICATION "FMT".                  ==
C==           RNUM IS REAL*8, REAL*4, INTEGER*4, OR INTEGER*2, ==
C==           IF ITYPE = 1, 2, 3, OR 4, RESPECTIVELY.          ==
C==                                                            ==
C==   CNUM  : LOGICAL*1 ARRAY INTO WHICH THE CHARACTER STRING  ==
C==           CORRESPONDING TO THE NUMBER "RNUM" IS PLACED.    ==
C==           CNUM MUST BE AT LEAST "IWIDTH" CHARACTERS LONG.  ==
C==                                                            ==
C==   ITYPE : TYPE OF NUMBER IN RNUM TO BE CONVERTED. SEE RNUM.==
C==                                                            ==
C==   FMT   : FORMAT CODE USED TO CONVERT "RNUM" INTO THE      ==
C==           CHARACTER STRING "CNUM".  EXAMPLES OF FORMATS:   ==
C==           (I10), (F10.3), (G11.5), (E10.3), (D16.7), ETC.  ==
C==           THE WIDTH OF THE FORMAT CODE MUST BE THE SAME AS ==
C==           IWIDTH. NOTE: THE INTEGER "I" FORMAT CODE        ==
C==           MAY BE USED EVEN WHEN RNUM IS REAL, AND THE REAL ==
C==           FORMAT CODES: "D", "E", "F", AND "G" MAY BE USED ==
C==           EVEN WHEN "RNUM" IS INTEGER OR INTEGER*2.        ==
C==                                                            ==
C==   IWIDTH: NUMBER OF CHARACTERS STORED IN CNUM WHEN "RNUM"  ==
C==           IS CONVERTED TO "CNUM". IWIDTH MUST BE EQUAL TO  ==
C==           THE FORMAT WIDTH OF "FMT".                       ==
C==                                                            ==
C==   RETURN1: OCCURS IF "FMT" OR "IWIDTH" IS INVALID OR IF    ==
C==            THE NUMBER "RNUM" OVERFLOWS THE FORMAT "FMT".   ==
C==            IN THESE CASES "IWIDTH" CHARACTERS OF "CNUM"    ==
C==            ARE SET TO "*".                                 ==
C==                                                            ==
C================================================================
C================================================================
      LOGICAL*1 CNUM(IWIDTH),FMT(10),BUFFER(132)
      LOGICAL*1 FM(8)/'(','F',3*' ','.','0',')'/
      LOGICAL*1 NFIRST/.FALSE./
      LOGICAL   EQUC
      REAL*8    R8
      INTEGER*2 RNUM(4),R2(4),I2(2)
      EQUIVALENCE (R8,R2(1)),(I4,I2(1)),(R4,R2(1))
      IF(IWIDTH.LE.0)RETURN1
      IF(NFIRST)GO TO 5
C================================================================
C==   THE FIRST TIME THROUGH: ASSIGN UNIT 99 TO A CORE TO CORE ==
C==   BUFFER.  (Remove for VAX version)                        ==
C================================================================
      NFIRST=.TRUE.
C     CALL FTNCMD('BUFFER 99',9)
C================================================================
C==   ITYPE = 1,2,3,4 CORRESPONDS TO RNUM BEING R*8,R*4,I*4,I*2==
C================================================================
5     GO TO (10,20,30,40),ITYPE
C================================================================
C==   ITYPE=1:                                                 ==
C==   RNUM IS REAL*8. I*2 R2(4) IS EQUIVALENCED TO R*8 R8.     ==
C================================================================
10    R2(1)=RNUM(1)
      R2(2)=RNUM(2)
      R2(3)=RNUM(3)
      R2(4)=RNUM(4)
      GO TO 50
C================================================================
C==   ITYPE=2:                                                 ==
C==   RNUM IS REAL*4. I*2 R2(4) IS EQUIVALENCED TO R*8 R8.     ==
C================================================================
20    R8=0.D0
      R2(1)=RNUM(1)
      R2(2)=RNUM(2)
      R8=R4
      GO TO 50
C================================================================
C==   ITYPE=3:                                                 ==
C==   RNUM IS INTEGER*4. I*2 I2(2) IS EQUIVALENCED TO I*4 I4.  ==
C================================================================
30    I2(1)=RNUM(1)
      I2(2)=RNUM(2)
      R8=I4
      GO TO 50
C================================================================
C==   ITYPE=4:                                                 ==
C==   RNUM IS INTEGER*2.                                       ==
C================================================================
40    R8=RNUM(1)
C================================================================
C==   CHECK TO SEE IF "FMT" IS AN "I" FORMAT CODE.             ==
C==   IF IT IS GO TO 100.                                      ==
C================================================================
50    IF(EQUC(FMT(2),%REF('I')))GO TO 100
C================================================================
C==   "FMT" IS NOT AN "I" FORMAT CODE.                         ==
C==   WRITE OUT R8 ON CORE TO CORE UNIT 99 USING FORMAT "FMT". ==
C==   THEN READ FROM 99 "IWIDTH" CHARACTERS INTO "CNUM".       ==
C================================================================
C**   Use ENCODE for VAX
C****************************************************************
C     WRITE(99,FMT,ERR=900)R8
C     READ(99,60)CNUM
C60   FORMAT(255A1)
CC      ENCODE(IWIDTH,FMT,CNUM,ERR=900)R8
      ENCODE(IWIDTH,FMT,BUFFER,ERR=900)R8
      CALL MOVEC(IWIDTH,BUFFER(1),CNUM(1))
      RETURN
C================================================================
C==   "FMT" IS AN "I" FORMAT CODE.                             ==
C==   CONVERT THE FORMAT CODE "FMT" WIDTH (IWIDTH) + 1 INTO    ==
C==   A CHARACTER STRING IN FM(3) (3 CHARACTERS LONG).         ==
C================================================================
100   CALL BTD(IWIDTH+1,FM(3),3,NSIG,%REF('0'))
      IF(NSIG.GT.3)GO TO 900
C================================================================
C==   WRITE OUT R8 ON CORE TO CORE UNIT 99 USING FORMAT "FM".  ==
C==   THEN READ FROM 99 "IWIDTH" CHARACTERS INTO "CNUM".       ==
C================================================================
C     WRITE(99,FM,ERR=900)R8
C     READ(99,60)CNUM
      ENCODE(IWIDTH+1,FM,BUFFER,ERR=900)R8
      CALL MOVEC(IWIDTH,BUFFER(1),CNUM(1))
      RETURN
C================================================================
C==   INVALID FORMAT CODE IN "FMT".                            ==
C==   SET "IWIDTH" CHARACTERS OF "CNUM" TO BLANK.              ==
C================================================================
900   CALL SETC(IWIDTH,CNUM,%REF('*'))
      RETURN1
      END
