      FUNCTION IT_IS(STRING1,STRING2,NCHAR)
C======================================================================
C  
C  reqd. KOSTL: routines - LENSIG
C
C  IT_IS:  To see if STRING1 "matches" STRING2.  By this we mean,
C
C          1.  STRING2 must contain at least NCHAR characters and these
C              must be equal to the first NCHAR characters of STRING1.
C          2.  If STRING2 contains > NCHAR characters, these must be
C              equal to the corresponding characters of STRING1.
C
C  Typically, STRING1 is a interactive program command, NCHAR is the
C  minimum abbreviation of the command, and STRING2 is the string
C  which has been read in and you wish to decode.
C
C======================================================================
      CHARACTER*100 BUFFER
      CHARACTER*(*) STRING1,STRING2
      LOGICAL*1 IT_IS
      IT_IS=.FALSE.
C======================================================================
C  Delete trailing blanks.  If STRING1 and STRING2 do not contain
C  at least NCHAR signficant characters, the match cannot possibly be 
C======================================================================
      LEN1=LENSIG(STRING1)
      IF(LEN1.LT.NCHAR)RETURN
      LEN2=LENSIG(STRING2)
      IF(LEN2.LT.NCHAR)RETURN
      IF(STRING2(1:NCHAR).NE.STRING1(1:NCHAR))RETURN
C======================================================================
C  Adjust STRING1 (the command) to the same length as the input
C  by either truncation or padding with blanks.  Then compare.
C======================================================================
      BUFFER(1:LEN2)=STRING1(1:LEN2)
      IF(STRING2.EQ.BUFFER(1:LEN2))IT_IS=.TRUE.
      RETURN
      END
