      SUBROUTINE LWRCASE(LINE,LWLINE)
C  
C     reqd. routines - NONE
C================================================================
C================================================================
C==                                                            ==
C==   UPCASE:     Converts UUPER case ASCII characters in      ==
C==               "LINE" into lower case ASCII characters. All ==
C==               other characters remain the same. The result ==
C==               is returned in LWINE.                        ==
C==               Both LINE and LWLINE are variable length     ==
C==               character strings, i.e.                      ==
C==               their length attribute is determined in the  ==
C==               calling routine. The lengths of "LINE" and   ==
C==               "LWLINE" need not be the same.     If "LINE" ==
C==               is longer than "LWLINE" then "LINE" will     ==
C==               be truncated and stored in "LWLINE"; if      ==
C==               "LWLINE" is longer than "LINE" then it       ==
C==               will be padded with blanks.                  ==
C==                                                            ==
C==   Adapted from UPPER_CASE.FOR       C.J.K  May/91          ==
C==                                                            ==
C==   Input  Parameters: LINE (CHARACTER*(N)).                 ==
C==                                                            ==
C==   Output Parameters: LWLINE  (CHARACTER*(N)).              ==
C==                                                            ==
C================================================================
C================================================================
      CHARACTER*(*) LINE,LWLINE
      CHARACTER TABLE(0:255)
      LOGICAL*1 NFIRST/.FALSE./
      IF(NFIRST)GO TO 100
C================================================================
C==   First time through this subroutine.                      ==
C==   Set up the character translation table to translate all  ==
C==   upper case ASCII characters to lower case.               ==
C================================================================
      NFIRST=.TRUE.
      DO 10 I=0,255
      TABLE(I)=CHAR(I)            ! Most characters are unchanged.
10    CONTINUE
      DO 20 I=65,90
      TABLE(I)=CHAR(I+32)         ! 0 parity upper case --> lower case.
      TABLE(I+128)=CHAR(I+128+32) ! 1 parity upper case --> lower case.
20    CONTINUE
C
C
100   LEN1=LEN(LINE)
      LEN2=LEN(LWLINE)
      DO 30 I=1,MIN(LEN1,LEN2)
      LWLINE(I:I)=TABLE(ICHAR(LINE(I:I))) ! Translate line.
30    CONTINUE
      IF(LEN2.GT.LEN1)LWLINE(LEN1+1:LEN2)=' '
      RETURN
      END

