      SUBROUTINE MONITOR_RANGE(IMONITOR,IOUTM,XMINH,XMAXH,YMINH,YMAXH,
     *                         XMINM,XMAXM,YMINM,YMAXM,IORIENTM,*)
C======================================================================C
C                                                                      C
C  MONITOR_RANGE takes a window of the internal (printronix, or        C
C  "hardcopy") bit map and viewports it into the monitor (usually      C
C  the screen).                                                        C
C                                                                      C
C  More specifically, MONITOR_RANGE defines the window of the          C
C  hardcopy:  XMINH <= XH <= XMAXH; YMINH <= YH <= YMAXH (dots),       C
C  which is to be displayed on the monitor screen in the monitor       C
C  viewport given by:  XMINM <= XM <= XMAXM; YMINM <= YM <= YMAXM,     C
C  with an orientation given by IORIENTM:                              C
C                                                                      C
C    IORIENTM= 1: XH is horizontal on the screen;                      C
C                 YH is vertical on the screen;                        C
C                 The point (XMINH,YMINH) of the hardcopy appears in   C
C                 the lower left hand corner of the monitor viewport   C
C            =-1: XH is vertical on the screen;                        C
C                 YH is horizontal on the screen;                      C
C                 the point (XMINH,YMINH) of the hardcopy appears in   C
C                 the upper left hand corner of the monitor viewport   C
C                                                                      C
C  There are no limits on the values of XMINH,XMAXH,YMINH, and YMAXH,  C
C  although the hardcopy can only exist on the printronix page which   C
C  has a range in dots given by:  0 <= XH <= 2047; 0 <= YH <= 785.     C
C  However the values of XMINM,XMAXM,YMINM,YMAXM are limited to the    C
C  range:  0 <= XM <= XMAXMSIZE; 0 <= YM <= YMAXMSIZE,                 C
C  where XMAXMSIZE and YMAXMSIZE depend on the type of monitor         C
C  specified by IMONITOR:                                              C
C                                                                      C
C  IMONITOR = 0: no monitor,                                           C
C           = 1: VT640: 0 <= XM <= 639; 0 <= YM <= 479                 C
C           = 2: Tektronix 4010/12: X 0-1023, Y 0-779                  C
C           = 3: not used                                              C
C           = 4: Zeta Plotter: X 0-215.9, Y 0-27.94                    C
C           = 5: HP Plotter: X 0-41.49, Y 0-25.84                      C
C           = 6: CIT-467: 0<= XM <= 571; 0<= YM <= 479                 C
C           = 7: TEK4107: 0<= XM <= 639; 0<= YM <= 479                 C
C           = 8: VT241: 0 <= XM <= 639; 0 <= YM <= 479                 C
C           = 9: PT100: 0 <= XM <= 639; 0 <= YM <= 479                 C
C           =10: QMS: 0 <= XM <= 3300; 0 <= YM <= 2550                 C
C           =11: Houston plotter: X 0-86.36, Y 0-54.61                 C
C           =12: Seiko GR-1105: X -2048 - 2047, Y -1560 - 1559         C
C           =13: Imagen: 0 <= XM <= 3328; 0 <= YM <= 2560              C
C           =14: Postscript: X 0-3357, Y 0-2400                        C
C           =15: VAXSTATION: X 0-1,    y 0-.75                         C
C           =16: LN03+: 0 <= XM <= 639; 0 <= YM <= 479                 C
C           =17: Generic terminal                                      C
C           =18: Vaxstation DecWindows: X 0-1, Y 0-.75                 C
C                                                                      C
C  If the values of XMINM,XMAXM,YMINM,YMAXM fall outside the monitor   C
C  screen size then they will be set to the nearest limit. If IMONITOR C
C  is invalid then an error message is printed on unit 6 and a RETURN1 C
C  is performed. If any of the sides of the "HARDCOPY" window or       C
C  "MONITOR" window are equal to 0 (eg. XMINH=XMAXH), then an error    C
C  message is printed on unit 6 and a RETURN1 is performed.            C
C                                                                      C
C  IOUTM is the output unit to which the screen plot characters will   C
C  be written.                                                         C
C                                                                      C
C   Input  Parameters: IMONITOR,IOUTM (I*4); XMINH,XMAXH,              C
C                      YMINH,YMAXH,XMINM,XMAXM,YMINM,YMAXM             C
C                      (R*4); IORIENTM (I*4).                          C
C                                                                      C
C   If MONITOR_RANGE is never called these parameters default to the   C
C   following values:                                                  C
C     IMONITOR=1 (VT640); IOUTM=6;                                     C
C     XMINH,XMAXH,YMINH,YMAXH default to the entire hardcopy           C
C     viewport specified by HARDCOPY_RANGE, i.e. the values of         C
C     XMINH,XMAXH,YMINH,YMAXH in the last call to HARDCOPY_RANGE;      C
C     0=XMINM <= XM <= XMAXM=639; 0=YMINM <= YM <= YMAXM=479;          C
C     IORIENTM defaults to -1.                                         C
C                                                                      C
C   Written by Arthur Haynes, TRIUMF U.B.C., July 16, 1982.            C
C                                                                      C
C   Modified by Joe Chuma, December, 1983 to include the HP            C
C   plotter                                                            C
C   Modified by Bernard Henin, july 1984, to include the               C
C   Tektronix 4107.                                                    C
C   Modified by F.W. Jones, August/84, to include the VT241.           C
C   Modified by F.W. Jones, Oct 7/85, to include the PT100.            C
C   Modified by F.W. Jones, Dec 5/85, for QMS Lasergrafix.             C
C   Modified by F.W. Jones, Aug 11/86, for Houston Instuments plotter. C
C   Modified by F.W. Jones, Mar 20/87, for Seiko GR-1105 terminal.     C
C   Modified by F.W. Jones, Jun/88, for Vaxstation                     C
C   Modified by J.Chuma, Nov /88, for LN03+                            C
C   Modified by J.Chuma, May 10 /89, for generic terminal              C
C   Modified by F.W. Jones Sept/89 for VaxStation DecWindows           C
C                                                                      C
C======================================================================C

      COMMON /PLOTMONITOR/ IMONITOR2,IOUTM2
      COMMON /MONITORRANGE/ XMINMP,XMAXMP,YMINMP,YMAXMP,XMINM2,XMAXM2,
     *                       YMINM2,YMAXM2
      COMMON /MONITOR_RANGE2/ XMINH2,XMAXH2,YMINH2,YMAXH2,IORIENTM2
      DATA XMINH2,XMAXH2,YMINH2,YMAXH2/0.,479.,0.,639./
      DATA IORIENTM2/-1/
      COMMON /MONITOR_SIZE/ XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE
      COMMON /PLOT_TO_MONITOR/ RMATRIXMP(2,2),SHIFTMP(2)
      COMMON /MONITOR_TO_PLOT/ RMATRIXPM(2,2),SHIFTPM(2)
      COMMON /HARDCOPY_TO_MONITOR/ RMATRIXMH(2,2),SHIFTMH(2)
      COMMON /PLOT_TO_HARDCOPY/ RMATRIXHP(2,2),SHIFTHP(2)
      COMMON /CALL_MONITOR_RANGE/ MONITOR_RANGE_CALLED
      LOGICAL MONITOR_RANGE_CALLED
      REAL XMINMA(0:19)/12*0.,-2048.,7*0./
      REAL YMINMA(0:19)/12*0.,-1560.,7*0./
      REAL XMAXMA(0:19)/0.,639.,1023.,511.,215.9,109.22,
     &  571.,639.,639.,639.,3300.,109.22,2047.,3328.,3357.,1.,
     &  639.,639.,1.,1./
      REAL YMAXMA(0:19)/0.,479.,779.,479.,27.94,83.82,
     &  479.,479.,479.,479.,2550.,83.82,1559.,2560.,2400.,0.75,
     &  479.,479.,0.75,1./
C
C  Procedure begins
C
      IMONITOR2=IMONITOR
      IORIENTM2=IORIENTM
      XMINH2=XMINH
      XMAXH2=XMAXH
      YMINH2=YMINH
      YMAXH2=YMAXH

C   Check the monitor type
C
      IF( IMONITOR .EQ. 0 )RETURN                   ! no monitor 
      IF( (IMONITOR .LT. 1) .OR. (IMONITOR .GT. 18) )THEN
        WRITE(6,5)IMONITOR
5       FORMAT(' ***Error*** in MONITOR_RANGE: invalid monitor type: ',
     &   I5)
6       RETURN 1
      END IF
C
C   Set the monitor size parameters
C
      IF( IMONITOR .EQ. 17 )THEN
C
C   Must call GENERIC_TERMINAL_SETUP before calling MONITOR_RANGE
C   for example, SET_PLOT_DEVICES calls it for you
CC        CALL GENERIC_TERMINAL_SETUP( &6 )
C
        CALL GENERIC_TERMINAL_SIZE( XMING, XMAXG, YMING, YMAXG )
        XMINM = XMING
        XMAXM = XMAXG
        YMINM = YMING
        YMAXM = YMAXG
        XMINMSIZE = XMING
        XMAXMSIZE = XMAXG
        YMINMSIZE = YMING
        YMAXMSIZE = YMAXG
      ELSE
        XMINMSIZE = XMINMA(IMONITOR)
        XMAXMSIZE = XMAXMA(IMONITOR)
        YMINMSIZE = YMINMA(IMONITOR)
        YMAXMSIZE = YMAXMA(IMONITOR)
      END IF
      MONITOR_RANGE_CALLED=.TRUE.
      IOUTM2=IOUTM
C
C   Make sure that the monitor viewport is within the monitor dimensions
C
      XMINM2=MAX(MIN(XMINM,XMAXMSIZE),XMINMSIZE)
      XMAXM2=MAX(MIN(XMAXM,XMAXMSIZE),XMINMSIZE)
      YMINM2=MAX(MIN(YMINM,YMAXMSIZE),YMINMSIZE)
      YMAXM2=MAX(MIN(YMAXM,YMAXMSIZE),YMINMSIZE)
C
C   Make sure that none of the sides of the window and viewport are 0
C
      IF( XMINM2 .EQ. XMAXM2 )THEN
        WRITE(6,*)' ***Error*** in MONITOR_RANGE: XMINM = XMAXM'
        RETURN 1
      END IF
      IF( YMINM2 .EQ. YMAXM2 )THEN
        WRITE(6,*)' ***Error*** in MONITOR_RANGE: YMINM = YMAXM'
        RETURN 1
      END IF
      IF( XMINH .EQ. XMAXH )THEN
        WRITE(6,*)' ***Error*** in MONITOR_RANGE: XMINH = XMAXH'
        RETURN 1
      END IF
      IF( YMINH .EQ. YMAXH )THEN
        WRITE(6,*)' ***Error*** in MONITOR_RANGE: YMINH = YMAXH'
        RETURN 1
      END IF
      IORIENTM2=IORIENTM
      IF( IORIENTM2 .NE. -1 )IORIENTM2=1
C
C   Calculate the "HARDCOPY" to "MONITOR" transformation:
C
C for IORIENTM = 1:
C   XM = (XH-XMINH)/(XMAXH-XMINH)*(XMAXM-XMINM)+XMINM
C      = RMATRIXMH(1,1)*XH+RMATRIXMH(1,2)*YH+SHIFTMH(1)
C   YM = (YH-YMINH)/(YMAXH-YMINH)*(YMAXM-YMINM)+YMINM
C      = RMATRIXMH(2,1)*XH+RMATRIXMH(2,2)*YH+SHIFTMH(2)
C
C for IORIENTM = -1:
C   XM = (YH-YMINH)/(YMAXH-YMINH)*(XMAXM-XMINM)+XMINM
C      = RMATRIXMH(1,1)*XH+RMATRIXMH(1,2)*YH+SHIFTMH(1)
C   YM = YMAXM-(XH-XMINH)/(XMAXH-XMINH)*(YMAXM-YMINM)
C        RMATRIXMH(2,1)*XH+RMATRIXMH(2,2)*YH+SHIFTMH(2)
C
      IF( IORIENTM2 .EQ. -1 )THEN
        RMATRIXMH(1,1)=0.
        RMATRIXMH(1,2)=(XMAXM2-XMINM2)/(YMAXH-YMINH)
        RMATRIXMH(2,1)=-(YMAXM2-YMINM2)/(XMAXH-XMINH)
        RMATRIXMH(2,2)=0.
        SHIFTMH(1)=XMINM2-RMATRIXMH(1,2)*YMINH
        SHIFTMH(2)=YMAXM2-RMATRIXMH(2,1)*XMINH
      ELSE
        RMATRIXMH(1,1)=(XMAXM2-XMINM2)/(XMAXH-XMINH)
        RMATRIXMH(1,2)=0.
        RMATRIXMH(2,1)=0.
        RMATRIXMH(2,2)=(YMAXM2-YMINM2)/(YMAXH-YMINH)
        SHIFTMH(1)=XMINM2-RMATRIXMH(1,1)*XMINH
        SHIFTMH(2)=YMINM2-RMATRIXMH(2,2)*YMINH
      END IF
C
C   Calculate the transformation matrix RMATRIXMP from the "PLOT" 
C   coordinate system to the "MONITOR" coordinate system
C
C   RMATRIXMP      = RMATRIXMH          * RMATRIXHP
C
C   MONITOR<--PLOT = MONITOR<--HARDCOPY * HARDCOPY<--PLOT
C
      RMATRIXMP(1,1)=RMATRIXMH(1,1)*RMATRIXHP(1,1)+
     *               RMATRIXMH(1,2)*RMATRIXHP(2,1)
      RMATRIXMP(1,2)=RMATRIXMH(1,1)*RMATRIXHP(1,2)+
     *               RMATRIXMH(1,2)*RMATRIXHP(2,2)
      RMATRIXMP(2,1)=RMATRIXMH(2,1)*RMATRIXHP(1,1)+
     *               RMATRIXMH(2,2)*RMATRIXHP(2,1)
      RMATRIXMP(2,2)=RMATRIXMH(2,1)*RMATRIXHP(1,2)+
     *               RMATRIXMH(2,2)*RMATRIXHP(2,2)
C
C   Calculate the translation vector SHIFTMP from the "PLOT"
C   coordinate system to the "MONITOR" coordinate system
C
C   SHIFTMP = RMATRIXMH * SHIFTHP + SHIFTMH
C
      SHIFTMP(1)=RMATRIXMH(1,1)*SHIFTHP(1)+RMATRIXMH(1,2)*SHIFTHP(2)+
     *           SHIFTMH(1)
      SHIFTMP(2)=RMATRIXMH(2,1)*SHIFTHP(1)+RMATRIXMH(2,2)*SHIFTHP(2)+
     *           SHIFTMH(2)
C
C   Calculate the inverse transformation matrix RMATRIXPM from
C   the "MONITOR" coordinate system to the "PLOT" coordinate system:
C
C   RMATRIXPM      = RMATRIXMP**-1
C
C   PLOT<--MONITOR = (MONITOR<--PLOT)**-1
C
      DETMP=RMATRIXMP(1,1)*RMATRIXMP(2,2)-RMATRIXMP(2,1)*RMATRIXMP(1,2)
      RMATRIXPM(1,1)=RMATRIXMP(2,2)/DETMP
      RMATRIXPM(1,2)=-RMATRIXMP(1,2)/DETMP
      RMATRIXPM(2,1)=-RMATRIXMP(2,1)/DETMP
      RMATRIXPM(2,2)=RMATRIXMP(1,1)/DETMP
C
C   Calculate the inverse translation vector SHIFTPM from the 
C   "MONITOR" coordinate system to the "PLOT" coordinate system
C
C   SHIFTPM = -RMATRIXPM * SHIFTMP
C
      SHIFTPM(1)=-RMATRIXPM(1,1)*SHIFTMP(1)-RMATRIXPM(1,2)*SHIFTMP(2)
      SHIFTPM(2)=-RMATRIXPM(2,1)*SHIFTMP(1)-RMATRIXPM(2,2)*SHIFTMP(2)
C
C   Calculate the boundaries in the "PLOT" coordinate system 
C   corresponding to the monitor viewport.
C
C   Expand these boundaries by 1/1000000 of their original dimensions
C   in order to avoid round off problems when one plots right on the 
C   boundaries.
C
      XMINMP2=RMATRIXPM(1,1)*XMINM2+RMATRIXPM(1,2)*YMINM2+SHIFTPM(1)
      YMINMP2=RMATRIXPM(2,1)*XMINM2+RMATRIXPM(2,2)*YMINM2+SHIFTPM(2)
      XMAXMP2=RMATRIXPM(1,1)*XMAXM2+RMATRIXPM(1,2)*YMAXM2+SHIFTPM(1)
      YMAXMP2=RMATRIXPM(2,1)*XMAXM2+RMATRIXPM(2,2)*YMAXM2+SHIFTPM(2)
      XMINMP=XMINMP2-.000001*(XMAXMP2-XMINMP2)
      XMAXMP=XMAXMP2+.000001*(XMAXMP2-XMINMP2)
      YMINMP=YMINMP2-.000001*(YMAXMP2-YMINMP2)
      YMAXMP=YMAXMP2+.000001*(YMAXMP2-YMINMP2)
      RETURN
      END
