      SUBROUTINE PEN_DOWN(X,Y)
C======================================================================C
C                                                                      C
C     PEN_DOWN: moves the pen down to the plot coordinates             C
C               (X,Y) on the screen and hardcopy.                      C
C                                                                      C
C     Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.           C
C                                                                      C
C     Input  Parameters: X,Y (R*4).                                    C
C                                                                      C
C     Modified by Alan Carruthers, July 15, 1983                       C
C       -- call to PUT_METAFILE1 added to support metafile             C
C                                                                      C
C     Modified Feb 21/85 by F. Jones:  check added to bitmap           C
C     flag WELL to avoid unnecessary calculation of hardcopy           C
C     coordinates and call to PLOT_HARDCOPY, in the case where         C
C     the bitmap is turned off.                                        C
C                                                                      C
C     Modified Jan-88 by F. Jones:  line-thickening algorithm added    C
C     for bitmap.  Line width in pixels is set by LWIDTH.              C
C     The "brush" used is a square of LWIDTH x LWIDTH pixels.          C
C
C     Modified Apr-88 by F. Jones:  round brush option added for       C
C     line thickening.  This is enabled by making LWIDTH negative      C
C     and makes a difference only with widths of 4 pixels or more.     C
C     Compared to the square brush, the round brush gives a more       C
C     consistent line width for lines of different angles.             C
C                                                                      C
C     Modified 01-May-91 by F. Jones:  Telidon metafile o/p removed.   C
C                                                                      C
C======================================================================C
      COMMON /PLOTMONITOR/ IMONITOR,IOUTM
      COMMON /MONITORRANGE/ XMINMP,XMAXMP,YMINMP,YMAXMP,XMINM,XMAXM,
     *                       YMINM,YMAXM
      COMMON /PLOTMONITOR2/ IMONITOR2,IOUTM2
      COMMON /MONITOR2RANGE/ XMINMP2,XMAXMP2,YMINMP2,YMAXMP2,
     *                        XMINM2,XMAXM2,YMINM2,YMAXM2
      COMMON /PLOTHARDCOPY/ XLAST,YLAST,N1,N2,HARDCOPY(188,2048)
      LOGICAL*1 HARDCOPY
      COMMON /HARDCOPYRANGE/ XMINHP,XMAXHP,YMINHP,YMAXHP,IORIENTH
      COMMON /PLOT_TO_HARDCOPY/ RMATRIXHP(2,2),SHIFTHP(2)
      COMMON/TO_BIT_OR_NOT/WELL
      LOGICAL WELL
      COMMON/PLOT_HARDCOPY_LINEWIDTH/LWIDTH

      REAL XDRAW(2),YDRAW(2)
      LOGICAL EVEN

      IF(IMONITOR.EQ.0)GO TO 200
C=================================================================
C   Clip the line segment (XLAST,YLAST)-->(X,Y) within the     
C   plot coordinates corresponding to the hardcopy window:    
C   XMINMP <= x <= XMAXMP; YMINMP <= y <= YMAXMP.
C=================================================================

C
C   Modified Apr 24/91 C.J.K
C
      NDRAW=1
      XDRAW(1)=X
      YDRAW(1)=Y
      IF(X     .GE. XMINMP  .AND.
     &   XLAST .GE. XMINMP  .AND.
     &   X     .LE. XMAXMP  .AND.
     &   XLAST .LE. XMAXMP  .AND.
     &   Y     .GE. YMINMP  .AND.
     &   YLAST .GE. YMINMP  .AND.
     &   Y     .LE. YMAXMP  .AND.
     &   YLAST .LE. YMAXMP      ) GO TO 21

      CALL WINDOW_CLIP(XLAST,YLAST,X,Y,XMINMP,XMAXMP,YMINMP,YMAXMP,
     *                 XDRAW,YDRAW,NDRAW)
      IF(NDRAW.EQ.0)GO TO 200
      IF(NDRAW.EQ.2)GO TO 150
C=================================================================
C   NDRAW = 1: (XLAST,YLAST) is in the hardcopy window.       
C=================================================================
 21   CALL PLOT_MONITOR(XDRAW(1),YDRAW(1),2) !Move pen down 
                                             !to (XDRAW(1),YDRAW(1)).
      GO TO 200
C=================================================================
C   NDRAW = 2: (XLAST,YLAST) is outside the hardcopy window.  
C=================================================================
150   CALL PLOT_MONITOR(XDRAW(1),YDRAW(1),3) !Pen up to beginning.
      CALL PLOT_MONITOR(XDRAW(2),YDRAW(2),2) !Draw clipped segment.
C
200   IF(IMONITOR2.EQ.0)GO TO 300
C=================================================================
C   Clip the line segment (XLAST,YLAST)-->(X,Y) within the    
C   plot coordinates corresponding to the hardcopy window:    
C   XMINMP2 <= x <= XMAXMP2; YMINMP2 <= y <= YMAXMP2.         
C=================================================================
      CALL WINDOW_CLIP(XLAST,YLAST,X,Y,XMINMP2,XMAXMP2,YMINMP2,YMAXMP2,
     *                 XDRAW,YDRAW,NDRAW)
      IF(NDRAW.EQ.0)GO TO 300
      IF(NDRAW.EQ.2)GO TO 250
C=================================================================
C   NDRAW = 1: (XLAST,YLAST) is in the hardcopy window.       
C=================================================================
      CALL PLOT_MONITOR2(XDRAW(1),YDRAW(1),2) !Move pen down 
                                              !to (XDRAW(1),YDRAW(1)).
      GO TO 300
C=================================================================
C   NDRAW = 2: (XLAST,YLAST) is outside the hardcopy window.  
C=================================================================
250   CALL PLOT_MONITOR2(XDRAW(1),YDRAW(1),3) !Pen up to beginning.
      CALL PLOT_MONITOR2(XDRAW(2),YDRAW(2),2) !Draw clipped segment.
C
300   CONTINUE
      XH =   RMATRIXHP(1,1)*X    +RMATRIXHP(1,2)*Y    +SHIFTHP(1)
      YH =   RMATRIXHP(2,1)*X    +RMATRIXHP(2,2)*Y    +SHIFTHP(2)
C
      IF(.NOT.WELL.OR.IORIENTH.EQ.0)GO TO 350
C=================================================================
C   Draw line segment (XLAST,YLAST)-->(X,Y) on hardcopy.      
C   First convert the plot coordinates to the corresponding   
C   hardcopy coordinates using the matrix RMATRIXHP and the   
C   translation vector SHIFTHP:                               
C                                                             
C       |XH|               |X|                                
C       |  | = RMATRIXHP * | | + SHIFTHP                      
C       |YH|               |Y|                                
C=================================================================
      XLASTH=RMATRIXHP(1,1)*XLAST+RMATRIXHP(1,2)*YLAST+SHIFTHP(1)
      YLASTH=RMATRIXHP(2,1)*XLAST+RMATRIXHP(2,2)*YLAST+SHIFTHP(2)
      IXLASTH=XLASTH+SIGN(.5,XLASTH)
      IYLASTH=YLASTH+SIGN(.5,YLASTH)
      IXH=XH+SIGN(.5,XH)
      IYH=YH+SIGN(.5,YH)
C=================================================================
C   Draw line segment (IXLASTH,IYLASTH)-->(IXH,IYH) (hardcopy 
C   dot coordinates) on the hardcopy bitmap: HARDCOPY(N1,N2). 
C=================================================================
      LWID=ABS(LWIDTH)
      IF(LWID.LE.1)THEN
        CALL PLOT_HARDCOPY(IXLASTH,IYLASTH,IXH,IYH,HARDCOPY,188,N1,N2)
      ELSE IF(LWIDTH.GE.-3)THEN      !square brush
        LIM2=LWID/2
        LIM1=-LIM2
        IF(MOD(LWID,2).EQ.0)LIM1=LIM1+1
        DO J=LIM1,LIM2
          DO I=LIM1,LIM2
            CALL PLOT_HARDCOPY(IXLASTH+I,IYLASTH+J,IXH+I,IYH+J,
     &        HARDCOPY,188,N1,N2)
          ENDDO
        ENDDO
      ELSE      !circular brush
        LIM2=LWID/2
        LIM1=-LIM2
        EVEN=(MOD(LWID,2).EQ.0)
        IF(EVEN)LIM1=LIM1+1
        DMAX2=(FLOAT(LWID)/2.)**2      !max distance to pixel (squared)
        DO J=LIM1,LIM2
          DO I=LIM1,LIM2
            IF(EVEN)THEN
              D2 = (FLOAT(I)-0.5)**2 + (FLOAT(J)-0.5)**2
            ELSE
              D2 = FLOAT(I)**2 + FLOAT(J)**2
            ENDIF
            IF(D2.LE.DMAX2)THEN
              CALL PLOT_HARDCOPY(IXLASTH+I,IYLASTH+J,IXH+I,IYH+J,
     &          HARDCOPY,188,N1,N2)
            ENDIF
          ENDDO
        ENDDO
      ENDIF

C=================================================================
C   Set (XLAST,YLAST) to the new pen position (X,Y).          
C=================================================================
350   XLAST=X
      YLAST=Y
      RETURN
      END
