      SUBROUTINE PEN_UP(X,Y)
C=================================================================
C==                                                             ==
C==   PEN_UP: moves the pen up to the plot coordinates (X,Y) on ==
C==           the screen and hardcopy.                          ==
C==                                                             ==
C==   Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.    ==
C==                                                             ==
C==   Input  Parameters: X,Y (R*4).                             ==
C==                                                             ==
C==   Modified by Alan Carruthers, July 15, 1983                ==
C==     -- calls to PUT_METAFILE1 added to support metafile     ==
C==   Modified by F. Jones, 01-May-91                           ==
C==     -- Telidon Metafile o/p removed                         ==
C=================================================================
      COMMON /PLOTMONITOR/ IMONITOR,IOUTM
      COMMON /MONITORRANGE/ XMINMP,XMAXMP,YMINMP,YMAXMP,XMINM,XMAXM,
     *                       YMINM,YMAXM
      COMMON /PLOTMONITOR2/ IMONITOR2,IOUTM2
      COMMON /MONITOR2RANGE/ XMINMP2,XMAXMP2,YMINMP2,YMAXMP2,
     *                       XMINM2,XMAXM2,YMINM2,YMAXM2
      COMMON /PLOTHARDCOPY/ XLAST,YLAST,N1,N2,HARDCOPY(188,2048)
      LOGICAL*1 HARDCOPY
      COMMON /PLOT_TO_HARDCOPY/RMATRIXHP(2,2),SHIFTHP(2)

C=================================================================
C==   Set (XLAST,YLAST) to the new pen position (X,Y).          ==
C=================================================================
      XLAST=X
      YLAST=Y
C
      IF(IMONITOR.EQ.0)GO TO 100 ! If only hardcopy device return.
C=================================================================
C==   Move the pen up to (X,Y) on the screen, if (X,Y) is in the==
C==   hardcopy window.                                          ==
C=================================================================
      IF((X-XMINMP)*(XMAXMP-X).GE.0.AND.
     *   (Y-YMINMP)*(YMAXMP-Y).GE.0)
     *   CALL PLOT_MONITOR(X,Y,3)
C=================================================================
C==   Take care of the 2'nd monitor.                            ==
C=================================================================
100   IF(IMONITOR2.EQ.0)RETURN
C=================================================================
C==   Move the pen up to (X,Y) on the screen, if (X,Y) is in the==
C==   harcopy window.                                           ==
C=================================================================
      IF((X-XMINMP2)*(XMAXMP2-X).GE.0.AND.
     *   (Y-YMINMP2)*(YMAXMP2-Y).GE.0)
     *   CALL PLOT_MONITOR2(X,Y,3)
      RETURN
      END
