      SUBROUTINE PLOT_HARDCOPY(IX1,IY1,IX2,IY2,ARRAY,ND1,N1,N2)
C======================================================================C
C                                                                      C
C  PLOT_HARDCOPY                                                       C
C                                                                      C
C  Draws a line from the dot location (IX1,IY1) to the dot location    C
C  (IX2,IY2), by lighting up the bits in the bit map array "ARRAY".    C
C                                                                      C
C  The algorithm used originated from the book: "Principles of         C
C  Interactive Computer Graphics", by Newmann & Sproull, pages 25-26.  C
C                                                                      C
C  "ARRAY" contains N2 lines of N1 bytes which form a bit map image    C
C  in printronix format with 6 bits per byte. For the printronix N1    C
C  is a maximum of 131 which implies a total of 786 dots per line      C
C  (IY = 0 to 785).  The x-axis runs vertically down the printronix    C
C  page with IX ranging from 0 to N2-1.  The y-axis runs horizontally  C
C  across the page with IY ranging from 0 to N1*6-1.  The origin of    C
C  this coordinate system is at the top left hand corner of the page,  C
C  i.e. the 1'st bit (low order bit) of "ARRAY(1,1)".                  C
C  0 <= IX <= N2-1; 0 <= IY <= N1*6-1.                                 C
C  The dot location (IX,IY) is represented in the array by the         C
C  "IMOD(IY,6)+1"'th bit of the array location "ARRAY(IY/6+1,IX+1)".   C
C  Eg. (0,0) is the 1'st bit of "ARRAY(1,1)", & (N2-1,N1*6-1) is the   C
C  6'th bit of "ARRAY(N1,N2)".                                         C
C                                                                      C
C   Written by Arthur Haynes, TRIUMF U.B.C., July 8, 1981.             C
C                                                                      C
C   Input  Parameters: IX1,IY1,IX2,IY2,ND1,N1,N2 (I*4).                C
C                      ARRAY(ND1,N2) (Logical*1).                      C
C                                                                      C
C   Parameter Definitions:                                             C
C   --------- -----------                                              C
C                                                                      C
C   IX1   : X-coordinate of the start of the line.                     C
C   IY1   : Y-coordinate of the start of the line.                     C
C                                                                      C
C   IX2   : X-coordinate of the end of the line.                       C
C   IY2   : Y-coordinate of the end of the line.                       C
C                                                                      C
C   Note: (IX1,IY1) and/or (IX2,IY2) can be outside the bit map array. C
C         The subroutine PLOT_HARDCOPY simply clips the line at the    C
C         edges of the array.                                          C
C                                                                      C
C   ARRAY : Bit map array in which the line is plotted by              C
C           lighting up the bits. "ARRAY" is a logical*1               C
C           array dimensioned: (ND1,N2).                               C
C                                                                      C
C   ND1   : First dimension of the array "ARRAY". Must be              C
C           greater than or equal to N1.                               C
C                                                                      C
C   N1    : Number of bytes per line of the bit map array.             C
C                                                                      C
C   N2    : Second dimension of the array "ARRAY".                     C
C           Number of dot lines of the bit map array.                  C
C                                                                      C
C  Modified Jan 29/84 by F.W. Jones:                                   C
C  Flag BITMAP_EMPTY added to communicate with CLEAR_PLOT.             C
C                                                                      C
C  Modified Jan 19/88 by F.W. Jones:  the internal bitmap storage      C
C  has been changed from Printronix format (6 significant bits per     C
C  byte) to HP Laserjet format (8 significant bits per byte).          C
C                                                                      C
C  Modified Dec 05/89 by F.W. Jones:  section added for plotting into  C
C  the dynamic bitmap for HP Laserjet 300 dpi hardcopies.              C
C                                                                      C
C  Modified Jan 04/90 by J.Chuma:  added support for HP LaserJet       C
C  compression (IBITDEV=132).                                          C
C                                                                      C
C  Modified Nov 30/90 by J.Chuma:  ILEV = 1 means erase for HPpaintJet C
C  Modified by J.Chuma, 20Mar97 for g77
C    use .TRUE. and .FALSE. for LOGICAL variables
C======================================================================C
      LOGICAL*1 ARRAY(ND1,N2)

      COMMON/TO_BIT_OR_NOT/WELL
      LOGICAL WELL/.TRUE./
      COMMON /PLOT_LEVEL/ ILEV
      COMMON/GRAPHICS_BITMAP/HPAINT,NBYTES,IOFFSET,NXDIM,NYDIM,MAXY
      LOGICAL*1 HPAINT(4)
      COMMON /PLOT_COLOURS/ ICOLOUR_1, ICOLOUR_2
      COMMON/BITMAP_STATUS/BITMAP_EMPTY,MAXLINES
      LOGICAL BITMAP_EMPTY
      INTEGER MAXLINES
      COMMON /BITMAP_DEVICE/ IBITDEV

      LOGICAL DY_GT_DX,PL1,PL2,PL3
      INTEGER ICIT467(8)/0,1,4,5,2,3,6,7/  ! REMAPS CITCOLOURS TO PAINTJET

      INTEGER*2 LOC8(8)/128, 64, 32, 16, 8, 4, 2, 1/
      INTEGER*2 MOC8(8)/127,-65,-33,-17,-9,-5,-3,-2/

      INTEGER*2 ILARR1
      LOGICAL*1 LARR1(2)
      EQUIVALENCE(LARR1(1),ILARR1)

      IF(.NOT. WELL) RETURN
      BITMAP_EMPTY=.FALSE.
      IF(NBYTES.NE.0) GO TO 200       ! Use dynamic bitmap

      IDELTAX=IX2-IX1
      IDELTAY=IY2-IY1
      IX=IX1
      IY=IY1
      I2=IX+1
      IF(I2.LT.1.OR.I2.GT.N2)GO TO 50
      I1=IY/8+1
      IF(I1.LT.1.OR.I1.GT.N1)GO TO 50
      IBIT=IY+1-(I1-1)*8
#ifdef BEND
      LARR1(2)=ARRAY(I1,I2)
#else
      LARR1(1)=ARRAY(I1,I2)
#endif
      IF(ILEV.EQ.0)THEN
         ILARR1=IOR(ILARR1,LOC8(IBIT))
      ELSE IF(ILEV.EQ.1)THEN
         ILARR1=IAND(ILARR1,MOC8(IBIT))
      ELSE
         ILARR1=IEOR(ILARR1,LOC8(IBIT))
      ENDIF
#ifdef BEND
      ARRAY(I1,I2)=LARR1(2)
#else
      ARRAY(I1,I2)=LARR1(1)
#endif
50    DY_GT_DX=IABS(IDELTAY).GT.IABS(IDELTAX)
      IF(DY_GT_DX)THEN
         ITEMP=IDELTAX
         IDELTAX=IDELTAY
         IDELTAY=ITEMP
         ITEMP=IX
         IX=IY
         IY=ITEMP
      ENDIF
      IDX=ISIGN(1,IDELTAX)
      IDY=ISIGN(1,IDELTAY)
      IADELTAX=IABS(IDELTAX)
      IADELTAY=IABS(IDELTAY)
      IERROR=2*IADELTAY-IADELTAX
      DO 100 I=1,IADELTAX
      IF(IERROR.GT.0)THEN
         IY=IY+IDY
         IERROR=IERROR+2*IADELTAY-2*IADELTAX
      ELSE
         IERROR=IERROR+2*IADELTAY
      ENDIF
      IX=IX+IDX
      IXX=IX
      IYY=IY
      IF(DY_GT_DX)THEN
         IXX=IY
         IYY=IX
      ENDIF
      I2=IXX+1
      IF(I2.LT.1.OR.I2.GT.N2)GO TO 100
      I1=IYY/8+1
      IF(I1.LT.1.OR.I1.GT.N1)GO TO 100
      IBIT=IYY+1-(I1-1)*8
#ifdef BEND
      LARR1(2)=ARRAY(I1,I2)
#else
      LARR1(1)=ARRAY(I1,I2)
#endif
      IF(ILEV.EQ.0)THEN
         ILARR1=IOR(ILARR1,LOC8(IBIT))
      ELSE IF(ILEV.EQ.1)THEN
         ILARR1=IAND(ILARR1,MOC8(IBIT))
      ELSE
         ILARR1=IEOR(ILARR1,LOC8(IBIT))
      ENDIF
#ifdef BEND
      ARRAY(I1,I2)=LARR1(2)
#else
      ARRAY(I1,I2)=LARR1(1)
#endif
100   CONTINUE
      RETURN

C======================================================================C
C  HP Paintjet section follows
C======================================================================C
200   IF(IBITDEV.EQ.32 .OR. IBITDEV.EQ.132)GO TO 600
CC      IF( (ICOLOUR_1 .LT. 0) .OR. (ICOLOUR_1 .GT. 7) )
CC     & WRITE(*,*)'ICOLOUR_1= ',ICOLOUR_1
      IDUM = MAX(0,ICOLOUR_1)
      IDUM = MIN(7,IDUM)        ! modified Feb 6/91 JLC
      ICOL=ICIT467(IDUM+1)     
      IF( ILEV .EQ. 1 )ICOL=0   ! erase mode   (JLC Nov/90)
      N4 = NYDIM/3   ! Usually 5400/3
      N3 = NXDIM*8   ! Usually 180*8
C
      PL1=.FALSE.
      PL2=.FALSE.
      PL3=.FALSE.
      IF( ICOL.EQ.1 .OR. ICOL.EQ.3 .OR. ICOL.EQ.5 .OR. ICOL.EQ.7 )
     & PL1=.TRUE.
      IF( ICOL.EQ.2 .OR. ICOL.EQ.3 .OR. ICOL.EQ.6 .OR. ICOL.EQ.7 )
     & PL2=.TRUE.
      IF( ICOL.EQ.4 .OR. ICOL.EQ.5 .OR. ICOL.EQ.6 .OR. ICOL.EQ.7 )
     & PL3=.TRUE.
      IDELTAX=IX2-IX1
      IDELTAY=IY2-IY1
      IX=IX1
      IY=IY1
      I2=IX+1
      IF(I2.LT.1.OR.I2.GT.N4)GO TO 150
      I1=IY/8+1
      IF(I1.LT.1.OR.I1.GT.N3)GO TO 150
      IBIT=IY+1-(I1-1)*8
#ifdef BEND
      IF(PL1)THEN
         III=IOFFSET+I1+((I2-1)*3+0)*NXDIM
         LARR1(2)=HPAINT(III)
         ILARR1=IOR(ILARR1,LOC8(IBIT))
         HPAINT(III)=LARR1(2)
      ELSE
         III=IOFFSET+I1+((I2-1)*3+0)*NXDIM
         LARR1(2)=HPAINT(IOFFSET+I1+((I2-1)*3+0)*NXDIM)
         ILARR1=IAND(ILARR1,MOC8(IBIT))
         HPAINT(IOFFSET+I1+((I2-1)*3+0)*NXDIM)=LARR1(2)
      ENDIF
      IF(PL2)THEN
         III=IOFFSET+I1+((I2-1)*3+1)*NXDIM
         LARR1(2)=HPAINT(III)
         ILARR1=IOR(ILARR1,LOC8(IBIT))
         HPAINT(III)=LARR1(2)
      ELSE
         III=IOFFSET+I1+((I2-1)*3+1)*NXDIM
         LARR1(2)=HPAINT(III)
         ILARR1=IAND(ILARR1,MOC8(IBIT))
         HPAINT(III)=LARR1(2)
      ENDIF
      IF(PL3)THEN
         III=IOFFSET+I1+((I2-1)*3+2)*NXDIM
         LARR1(2)=HPAINT(III)
         ILARR1=IOR(ILARR1,LOC8(IBIT))
         HPAINT(III)=LARR1(2)
      ELSE
         III=IOFFSET+I1+((I2-1)*3+2)*NXDIM
         LARR1(2)=HPAINT(III)
         ILARR1=IAND(ILARR1,MOC8(IBIT))
         HPAINT(III)=LARR1(2)
      ENDIF
#else
      IF(PL1)THEN
         III=IOFFSET+I1+((I2-1)*3+0)*NXDIM
         LARR1(1)=HPAINT(III)
         ILARR1=IOR(ILARR1,LOC8(IBIT))
         HPAINT(III)=LARR1(1)
      ELSE
         III=IOFFSET+I1+((I2-1)*3+0)*NXDIM
         LARR1(1)=HPAINT(IOFFSET+I1+((I2-1)*3+0)*NXDIM)
         ILARR1=IAND(ILARR1,MOC8(IBIT))
         HPAINT(IOFFSET+I1+((I2-1)*3+0)*NXDIM)=LARR1(1)
      ENDIF
      IF(PL2)THEN
         III=IOFFSET+I1+((I2-1)*3+1)*NXDIM
         LARR1(1)=HPAINT(III)
         ILARR1=IOR(ILARR1,LOC8(IBIT))
         HPAINT(III)=LARR1(1)
      ELSE
         III=IOFFSET+I1+((I2-1)*3+1)*NXDIM
         LARR1(1)=HPAINT(III)
         ILARR1=IAND(ILARR1,MOC8(IBIT))
         HPAINT(III)=LARR1(1)
      ENDIF
      IF(PL3)THEN
         III=IOFFSET+I1+((I2-1)*3+2)*NXDIM
         LARR1(1)=HPAINT(III)
         ILARR1=IOR(ILARR1,LOC8(IBIT))
         HPAINT(III)=LARR1(1)
      ELSE
         III=IOFFSET+I1+((I2-1)*3+2)*NXDIM
         LARR1(1)=HPAINT(III)
         ILARR1=IAND(ILARR1,MOC8(IBIT))
         HPAINT(III)=LARR1(1)
      ENDIF
#endif
150   DY_GT_DX=IABS(IDELTAY).GT.IABS(IDELTAX)
      IF(DY_GT_DX)THEN
         ITEMP=IDELTAX
         IDELTAX=IDELTAY
         IDELTAY=ITEMP
         ITEMP=IX
         IX=IY
         IY=ITEMP
      ENDIF
      IDX=ISIGN(1,IDELTAX)
      IDY=ISIGN(1,IDELTAY)
      IADELTAX=IABS(IDELTAX)
      IADELTAY=IABS(IDELTAY)
      IERROR=2*IADELTAY-IADELTAX
      DO 300 I=1,IADELTAX
      IF(IERROR.GT.0)THEN
         IY=IY+IDY
         IERROR=IERROR+2*IADELTAY-2*IADELTAX
      ELSE
         IERROR=IERROR+2*IADELTAY
      ENDIF
      IX=IX+IDX
      IXX=IX
      IYY=IY
      IF(DY_GT_DX)THEN
         IXX=IY
         IYY=IX
      ENDIF
      I2=IXX+1
      IF(I2.LT.1.OR.I2.GT.N4)GO TO 300
      I1=IYY/8+1
      IF(I1.LT.1.OR.I1.GT.N3)GO TO 300
      IBIT=IYY+1-(I1-1)*8
#ifdef BEND
      IF(PL1)THEN
         III=IOFFSET+I1+((I2-1)*3+0)*NXDIM
         LARR1(2)=HPAINT(III)
         ILARR1=IOR(ILARR1,LOC8(IBIT))
         HPAINT(III)=LARR1(2)
      ELSE
         III=IOFFSET+I1+((I2-1)*3+0)*NXDIM
         LARR1(2)=HPAINT(IOFFSET+I1+((I2-1)*3+0)*NXDIM)
         ILARR1=IAND(ILARR1,MOC8(IBIT))
         HPAINT(IOFFSET+I1+((I2-1)*3+0)*NXDIM)=LARR1(2)
      ENDIF
      IF(PL2)THEN
         III=IOFFSET+I1+((I2-1)*3+1)*NXDIM
         LARR1(2)=HPAINT(III)
         ILARR1=IOR(ILARR1,LOC8(IBIT))
         HPAINT(III)=LARR1(2)
      ELSE
         III=IOFFSET+I1+((I2-1)*3+1)*NXDIM
         LARR1(2)=HPAINT(III)
         ILARR1=IAND(ILARR1,MOC8(IBIT))
         HPAINT(III)=LARR1(2)
      ENDIF
      IF(PL3)THEN
         III=IOFFSET+I1+((I2-1)*3+2)*NXDIM
         LARR1(2)=HPAINT(III)
         ILARR1=IOR(ILARR1,LOC8(IBIT))
         HPAINT(III)=LARR1(2)
      ELSE
         III=IOFFSET+I1+((I2-1)*3+2)*NXDIM
         LARR1(2)=HPAINT(III)
         ILARR1=IAND(ILARR1,MOC8(IBIT))
         HPAINT(III)=LARR1(2)
      ENDIF
#else
      IF(PL1)THEN
         III=IOFFSET+I1+((I2-1)*3+0)*NXDIM
         LARR1(1)=HPAINT(III)
         ILARR1=IOR(ILARR1,LOC8(IBIT))
         HPAINT(III)=LARR1(1)
      ELSE
         III=IOFFSET+I1+((I2-1)*3+0)*NXDIM
         LARR1(1)=HPAINT(IOFFSET+I1+((I2-1)*3+0)*NXDIM)
         ILARR1=IAND(ILARR1,MOC8(IBIT))
         HPAINT(IOFFSET+I1+((I2-1)*3+0)*NXDIM)=LARR1(1)
      ENDIF
      IF(PL2)THEN
         III=IOFFSET+I1+((I2-1)*3+1)*NXDIM
         LARR1(1)=HPAINT(III)
         ILARR1=IOR(ILARR1,LOC8(IBIT))
         HPAINT(III)=LARR1(1)
      ELSE
         III=IOFFSET+I1+((I2-1)*3+1)*NXDIM
         LARR1(1)=HPAINT(III)
         ILARR1=IAND(ILARR1,MOC8(IBIT))
         HPAINT(III)=LARR1(1)
      ENDIF
      IF(PL3)THEN
         III=IOFFSET+I1+((I2-1)*3+2)*NXDIM
         LARR1(1)=HPAINT(III)
         ILARR1=IOR(ILARR1,LOC8(IBIT))
         HPAINT(III)=LARR1(1)
      ELSE
         III=IOFFSET+I1+((I2-1)*3+2)*NXDIM
         LARR1(1)=HPAINT(III)
         ILARR1=IAND(ILARR1,MOC8(IBIT))
         HPAINT(III)=LARR1(1)
      ENDIF
#endif
300   CONTINUE
      RETURN

C======================================================================C
C  HP Laserjet 300dpi section follows
C======================================================================C
600   N4=NYDIM      !usually 3000
      N3=NXDIM*8    !usually 282*8=2256

      IDELTAX=IX2-IX1
      IDELTAY=IY2-IY1
      IX=IX1
      IY=IY1
      I2=IX+1
      IF(I2.LT.1.OR.I2.GT.N4)GO TO 650
      I1=IY/8+1
      IF(I1.LT.1.OR.I1.GT.N3)GO TO 650
      IBIT=IY+1-(I1-1)*8
      III=IOFFSET+I1+(I2-1)*NXDIM
#ifdef BEND
      LARR1(2)=HPAINT(III)
#else
      LARR1(1)=HPAINT(III)
#endif
      IF(ILEV.EQ.0)THEN
         ILARR1=IOR(ILARR1,LOC8(IBIT))
      ELSE IF(ILEV.EQ.1)THEN
         ILARR1=IAND(ILARR1,MOC8(IBIT))
      ELSE
         ILARR1=IEOR(ILARR1,LOC8(IBIT))
      ENDIF
#ifdef BEND
      HPAINT(III)=LARR1(2)
#else
      HPAINT(III)=LARR1(1)
#endif
650   DY_GT_DX=IABS(IDELTAY).GT.IABS(IDELTAX)
      IF(DY_GT_DX)THEN
         ITEMP=IDELTAX
         IDELTAX=IDELTAY
         IDELTAY=ITEMP
         ITEMP=IX
         IX=IY
         IY=ITEMP
      ENDIF
      IDX=ISIGN(1,IDELTAX)
      IDY=ISIGN(1,IDELTAY)
      IADELTAX=IABS(IDELTAX)
      IADELTAY=IABS(IDELTAY)
      IERROR=2*IADELTAY-IADELTAX
      DO 700 I=1,IADELTAX
      IF(IERROR.GT.0)THEN
         IY=IY+IDY
         IERROR=IERROR+2*IADELTAY-2*IADELTAX
      ELSE
         IERROR=IERROR+2*IADELTAY
      ENDIF
      IX=IX+IDX
      IXX=IX
      IYY=IY
      IF(DY_GT_DX)THEN
         IXX=IY
         IYY=IX
      ENDIF
      I2=IXX+1
      IF(I2.LT.1.OR.I2.GT.N4)GO TO 700
      I1=IYY/8+1
      IF(I1.LT.1.OR.I1.GT.N3)GO TO 700
      IBIT=IYY+1-(I1-1)*8
      III=IOFFSET+I1+(I2-1)*NXDIM
#ifdef BEND
      LARR1(2)=HPAINT(III)
#else
      LARR1(1)=HPAINT(III)
#endif
      IF(ILEV.EQ.0)THEN
         ILARR1=IOR(ILARR1,LOC8(IBIT))
      ELSE IF(ILEV.EQ.1)THEN
         ILARR1=IAND(ILARR1,MOC8(IBIT))
      ELSE
         ILARR1=IEOR(ILARR1,LOC8(IBIT))
      ENDIF
#ifdef BEND
      HPAINT(III)=LARR1(2)
#else
      HPAINT(III)=LARR1(1)
#endif
700   CONTINUE

      RETURN
      END
