      SUBROUTINE PLOT_POINT(X,Y)
C======================================================================C
C                                                                      C
C   PLOT_POINT: plots a point at the plot coordinates (X,Y) on         C
C               the screen and hardcopy.                               C
C                                                                      C
C   Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.             C
C                                                                      C
C   Input  Parameters: X,Y (R*4).                                      C
C                                                                      C
C   Modified by Alan Carruthers, July 15, 1983                         C
C     -- call to PUT_METAFILE1 added to support metafile               C
C                                                                      C
C     Modified by F.W. Jones, Sept/84, for output to Graphics          C
C     Editor files.  Modified Sept 27/84 to encode colour.             C
C                                                                      C
C     Modified Jan-88 by F. Jones:  line-thickening algorithm added    C
C     for bitmap.  Line width in pixels is set by LWIDTH.              C
C     The "brush" used is a square of LWIDTH x LWIDTH pixels.          C
C                                                                      C
C     Modified Apr-88 by F. Jones:  round brush option added for       C
C     line thickening.  This is enabled by making LWIDTH negative      C
C     and makes a difference only with widths of 4 pixels or more.     C
C     Compared to the square brush, the round brush gives a more       C
C     consistent line width for lines of different angles.             C
C                                                                      C
C     Modified 01-May-91 by F. Jones:  Telidon metafile o/p removed    C
C                                                                      C
C======================================================================C
      COMMON /PLOT_CLEAR/ CLEAR
      LOGICAL CLEAR
      COMMON /PLOTMONITOR/ IMONITOR,IOUTM
      COMMON /MONITORRANGE/ XMINMP,XMAXMP,YMINMP,YMAXMP,XMINM,XMAXM,
     *                       YMINM,YMAXM
      COMMON /PLOTMONITOR2/ IMONITOR2,IOUTM2
      COMMON /MONITOR2RANGE/ XMINMP2,XMAXMP2,YMINMP2,YMAXMP2,
     *                       XMINM2,XMAXM2,YMINM2,YMAXM2
      COMMON /PLOTHARDCOPY/ XLAST,YLAST,N1,N2,HARDCOPY(188,2048)
      LOGICAL*1 HARDCOPY
      COMMON /HARDCOPYRANGE/ XMINHP,XMAXHP,YMINHP,YMAXHP,IORIENTH
      COMMON /PLOT_TO_HARDCOPY/ RMATRIXHP(2,2),SHIFTHP(2)
      COMMON/TO_BIT_OR_NOT/WELL
      LOGICAL WELL
      COMMON/PLOT_HARDCOPY_LINEWIDTH/LWIDTH
C Graphics Editor COMMON:
      COMMON/CDWG/DWGON,DWGTXT,LDWG,LDWT,IRECG,IRECT,STROKE
      LOGICAL DWGON,DWGTXT,STROKE

      LOGICAL EVEN

C Put pen up followed by pen down to drawing file, if enabled:
      IF(DWGON)THEN
        CALL PUT_DWG(X,Y,3,0)
        CALL PUT_DWG(X,Y,2,0)
      ENDIF

      IF(CLEAR)CALL CLEAR_PLOT
      IF(IMONITOR.EQ.0)GO TO 5 ! If only hardcopy device go to 5.
C=================================================================
C   If (X,Y) is in the monitor viewport, then plot a point on 
C   the monitor screen.                                       
C=================================================================
      IF((X-XMINMP)*(XMAXMP-X).GE.0.AND.
     *   (Y-YMINMP)*(YMAXMP-Y).GE.0)
     *   CALL PLOT_MONITOR(X,Y,20)
C=================================================================
C   If (X,Y) is in the monitor 2 viewport, then plot a point on 
C   the monitor screen.                                       
C=================================================================
5     IF(IMONITOR2.EQ.0)GO TO 10
      IF((X-XMINMP2)*(XMAXMP2-X).GE.0.AND.
     *   (Y-YMINMP2)*(YMAXMP2-Y).GE.0)
     *   CALL PLOT_MONITOR2(X,Y,20)
10    IF(.NOT.WELL.OR.IORIENTH.EQ.0)GO TO 30
      XH =   RMATRIXHP(1,1)*X    +RMATRIXHP(1,2)*Y    +SHIFTHP(1)
      YH =   RMATRIXHP(2,1)*X    +RMATRIXHP(2,2)*Y    +SHIFTHP(2)
C=================================================================
C   Plot the point (X,Y) on the hardcopy.                     
C   First convert the plot coordinates to the corresponding 
C   hardcopy coordinates using the matrix RMATRIXHP and the  
C   translation vector SHIFTHP:                               
C                                                             
C       |XH|               |X|                                
C       |  | = RMATRIXHP * | | + SHIFTHP                      
C       |YH|               |Y|                                
C=================================================================
      IXH=XH+SIGN(.5,XH)
      IYH=YH+SIGN(.5,YH)
C=================================================================
C   Plot the point (IXH,IYH) (hardcopy dot coordinates) on the
C   hardcopy bitmap: HARDCOPY(N1,N2).                         
C=================================================================
      LWID=ABS(LWIDTH)
      IF(LWID.LE.1)THEN
        CALL PLOT_HARDCOPY(IXH,IYH,IXH,IYH,HARDCOPY,188,N1,N2)
      ELSE IF(LWIDTH.GE.-3)THEN      !square brush
        LIM2=LWID/2
        LIM1=-LIM2
        IF(MOD(LWID,2).EQ.0)LIM1=LIM1+1
        DO J=LIM1,LIM2
          DO I=LIM1,LIM2
            CALL PLOT_HARDCOPY(IXH+I,IYH+J,IXH+I,IYH+J,
     &        HARDCOPY,188,N1,N2)
          ENDDO
        ENDDO
      ELSE      !circular brush
        LIM2=LWID/2
        LIM1=-LIM2
        EVEN=(MOD(LWID,2).EQ.0)
        IF(EVEN)LIM1=LIM1+1
        DMAX2=(FLOAT(LWID)/2.)**2      !max distance to pixel (squared)
        DO J=LIM1,LIM2
          DO I=LIM1,LIM2
            IF(EVEN)THEN
              D2 = (FLOAT(I)-0.5)**2 + (FLOAT(J)-0.5)**2
            ELSE
              D2 = FLOAT(I)**2 + FLOAT(J)**2
            ENDIF
            IF(D2.LE.DMAX2)THEN
              CALL PLOT_HARDCOPY(IXH+I,IYH+J,IXH+I,IYH+J,
     &          HARDCOPY,188,N1,N2)
            ENDIF
          ENDDO
        ENDDO
      ENDIF
C=================================================================
C   Set (XLAST,YLAST) to the new pen position (X,Y).          
C=================================================================
30    XLAST=X
      YLAST=Y
      RETURN
      END
