C======================================================================C
C                                                                      C
C  POSTSCRIPT plot file driver routines for        F.W. Jones, TRIUMF  C
C  TRIUMF Graphics Library                                             C
C                                                                      C
C  Modified 15-MAY-89 by F. Jones:  routine POSTSCRIPT_SETLINEWIDTH    C
C  added to allow changing line width during plot.  Default linewidth  C
C  reduced to 2, 29-Aug-91.                                            C
C                                                                      C
C  Modified 08-OCT-91 by FWJ:                                          C
C    (1) BoundingBox calculation added, to improve compliance with     C
C        Adobe structuring conventions.                                C
C    (2) Plotting of dots is now done with a macro that uses relative  C
C        coordinates, thus reducing the volume of data.                C
C    (3) The number of points in the current path is now limited       C
C        to 500, to avoid limitchecks on some printers.                C
C                                                                      C
C  Modified 18-NOV-91 by FWJ:                                          C
C    Colour support added via new routine POSTSCRIPT_COLOUR.           C
C    Modified POSTSCRIPT_PLOT to ensure a "moveto" after linewidth     C
C    or colour change.                                                 C
C  Modified 20-July-93  by J Chuma                                     C
C    Support for B,C,D,E size paper added                              C
C  Modified 21-JUN-94 by FWJ:                                          C
C    Re-structured the output routine: the stroke operator is only     C
C    applied to the current path after 500 points are accumulated,     C
C    rather than before each moveto operation, taking advantage of     C
C    the fact that a path can have disjoint sub-paths.  Tests showed   C
C    that this significantly reduces execution time on the printer     C
C    (e.g. 45% reduction for line drawings and 65% reduction for       C
C    scatterplots).  File size is also somewhat reduced.               C
C    An additional modification was made to remove redundant blanks    C
C    from the output, giving a net file size reduction of about 20%    C
C    for line drawings and 30% for scatterplots.                       C
C                                                                      C
C======================================================================C

      SUBROUTINE POSTSCRIPT_PLOT_INIT(LUN)

C  Initialize the POSTSCRIPT driver

      COMMON/POSTSCRIPTPLOT/LUNPS,NEW,IXLL,IYLL,IXUR,IYUR,NPATH,IOFF
      LOGICAL NEW  ! modified by J.Chuma, 19Mar97 for g77
      COMMON /MONITOR2RANGE/ XMINMP,XMAXMP,YMINMP,YMAXMP,XMINM2,XMAXM2,
     *                       YMINM2,YMAXM2
C  PWIDTH is initialized in CLEAR_PLOT to the value 2
      COMMON /POSTSCRIPT_LINEWIDTH/ PWIDTH
      INTEGER*4 PWIDTH

      LUNPS=LUN   !unit for work file

C Determine offset for mapping to PS coordinate system
C Different offset is needed for B size paper
C 3276 = 10.92in (0.08in diff from 11in to centre on the page)
C 3482 = 11.61in (0.08in diff from 29.7cm to centre on the page)
C 5076 = 16.92in (0.08in diff from 17in to centre on the page)

C  modified by JLC Nov 7, 1995  to allow for A4 size paper

      IOFF=3276                        ! A  size up to 3276
      IF(XMAXM2.GT.3276.)IOFF=3482     ! A4 size up to 3482
      IF(XMAXM2.GT.3482.)IOFF=5076     ! B  size up to 5076
      IF(XMAXM2.GT.5076.)IOFF=6600     !  6600 = 22in
      IF(XMAXM2.GT.6600.)IOFF=10200    ! 10200 = 34in
      IF(XMAXM2.GT.10200.)IOFF=13200   ! 13200 = 44in

      CALL POSTSCRIPT_SETLINEWIDTH(PWIDTH)
C Start with pen up at (0,0)
      CALL POSTSCRIPT_PLOT(0.,0.,3)
C Signal start of new plot (for bounding box determination)
      NEW=.TRUE.

      RETURN
      END


      SUBROUTINE POSTSCRIPT_PLOT(X,Y,IPEN)
C======================================================================C
C
C  POSTSCRIPT vector driver
C
C    If IPEN=3, move to (X,Y)
C    If IPEN=2, draw to (X,Y)
C    If IPEN=20, draw a dot at (X,Y)
C
C======================================================================C
      COMMON/POSTSCRIPTPLOT/LUNPS,NEW,IXLL,IYLL,IXUR,IYUR,NPATH,IOFF
      LOGICAL NEW  ! modified by J.Chuma, 19Mar97 for g77
      COMMON/POSTSCRIPT_CURRENT/ICX,ICY

      CHARACTER*5 BUFX,BUFY

      IY=IOFF-NINT(X)
      IX=NINT(Y)
      IF(IX.LT.0 .OR. IY.LT.0)RETURN

C Update bounding box
      IF(NEW)THEN
        IF(IPEN.EQ.2)THEN
          IXLL=ICX
          IYLL=ICY
          IXUR=ICX
          IYUR=ICY
          NEW=.FALSE.
          IXLL=MIN(IX,IXLL)
          IYLL=MIN(IY,IYLL)
          IXUR=MAX(IX,IXUR)
          IYUR=MAX(IY,IYUR)
        ELSE IF(IPEN.EQ.20)THEN
          IXLL=IX
          IYLL=IY
          IXUR=IX
          IYUR=IY
          NEW=.FALSE.
        ENDIF
      ELSE
        IXLL=MIN(IX,IXLL)
        IYLL=MIN(IY,IYLL)
        IXUR=MAX(IX,IXUR)
        IYUR=MAX(IY,IYUR)
      ENDIF        

  500 FORMAT(I5)

      WRITE(BUFX,500,ERR=9999)IX
      WRITE(BUFY,500,ERR=9999)IY
      NX=1
      DO WHILE(BUFX(NX:NX).EQ.' ')
        NX=NX+1
      ENDDO
      NY=1
      DO WHILE(BUFY(NY:NY).EQ.' ')
        NY=NY+1
      ENDDO

 1000 FORMAT(I5,A,I5,A)
 4000 FORMAT(4A)
 5000 FORMAT(5A)
 9000 FORMAT(A)

C Pen down
      IF(IPEN.EQ.2)THEN
        IF(NPATH.EQ.0)THEN      !no preceding pen up
          WRITE(LUNPS,1000)ICX,' ',ICY,' m'
          NPATH=1
        ENDIF
        WRITE(LUNPS,4000,ERR=999)BUFX(NX:),' ',BUFY(NY:),' l'
        NPATH=NPATH+1
C Pen up
      ELSE IF(IPEN.EQ.3)THEN
        WRITE(LUNPS,4000,ERR=999)BUFX(NX:),' ',BUFY(NY:),' m'
        NPATH=NPATH+1
C Dot
      ELSE IF(IPEN.EQ.20)THEN
        WRITE(LUNPS,4000,ERR=999)BUFX(NX:),' ',BUFY(NY:),' d'
        NPATH=NPATH+2
      ENDIF

C Stroke current path after 500 points
      IF(NPATH.GE.500)THEN
        WRITE(LUNPS,9000,ERR=999)'s'
        NPATH=0
      ENDIF

C Record current point:
      ICX=IX
      ICY=IY
      RETURN

999   WRITE(*,*)'Error writing to SYS$SCRATCH PostScript plot file'
      CALL FORMSG
      RETURN

9999  WRITE(*,*)'POSTSCRIPT_PLOT: Error writing coordinate'
      CALL FORMSG
      RETURN

      END


      SUBROUTINE POSTSCRIPT_SETLINEWIDTH(LWIDTH)
C======================================================================C
C  Sets the line width for subsequent plotting.
C======================================================================C
      COMMON/POSTSCRIPTPLOT/LUNPS,NEW,IXLL,IYLL,IXUR,IYUR,NPATH,IOFF
      LOGICAL NEW  ! modified by J.Chuma, 19Mar97 for g77
      COMMON/POSTSCRIPT_CURRENT/ICX,ICY

      INTEGER*4 PWIDTH                      !postscript line thickness  
      COMMON /POSTSCRIPT_LINEWIDTH/ PWIDTH  !initialized in CLEAR_PLOT

      IF(LWIDTH.LE.0.OR.LWIDTH.GT.9999)THEN
        PWIDTH=2
      ELSE
        PWIDTH=LWIDTH
      ENDIF
      IF(NPATH.GT.0)THEN
        WRITE(LUNPS,1000,ERR=999)'s ',PWIDTH,' setlinewidth'
      ELSE
        WRITE(LUNPS,1000,ERR=999)'  ',PWIDTH,' setlinewidth'
      ENDIF
1000  FORMAT(A,I4,A)
      NPATH=0

      RETURN

999   WRITE(*,*)'Error writing to SYS$SCRATCH PostScript plot file'
      CALL FORMSG
      RETURN

      END


      SUBROUTINE POSTSCRIPT_COLOUR(ICOL)
C======================================================================C
C  Sets the colour for subsequent plotting.
C  colour common block added by J.Chuma Apr 30/92
C======================================================================C
      COMMON/POSTSCRIPTPLOT/LUNPS,NEW,IXLL,IYLL,IXUR,IYUR,NPATH,IOFF
      LOGICAL NEW  ! modified by J.Chuma, 19Mar97 for g77
      COMMON/POSTSCRIPT_CURRENT/ICX,ICY
      LOGICAL PSCOLOUR
      COMMON/POSTSCRIPTCOLOUR/ PSCOLOUR

      IF(.NOT.PSCOLOUR)RETURN
C Default colour is black:
      IF(ICOL.LT.0.OR.ICOL.GT.11)THEN
        IC=7
      ELSE
        IC=ICOL
      ENDIF
      IF(NPATH.GT.0)THEN
        WRITE(LUNPS,1000,ERR=999)'s c',ICOL
      ELSE
        WRITE(LUNPS,1000,ERR=999)'c',ICOL
      ENDIF
1000  FORMAT(A,I2.2)
      NPATH=0
      RETURN

999   WRITE(*,*)'Error writing to SYS$SCRATCH PostScript plot file'
      CALL FORMSG
      RETURN

      END
