      SUBROUTINE PSYM(X,Y,HEIGHT,STRING,ANGLE,LENGTH,*)
C     
C  reqd. KOSTL: routines - ASCEBC,EQCMP,EQUC,FINDC,MOVEC,PLOTR
C
C================================================================
C==   PSYM package (Version 2.0)    copyright  1988   R. Lee   ==
C==   Including the following routines:                        ==
C==    PSYM, PALPHA, TRANSF, SPLITE, PSYMLC, PSALPH            ==
C==                                                            ==
C==   This subroutine produces text on a plot. Any character   ==
C==   sets can be used as long as they are set up appropriately.=
C==   Note that this subroutine tries to simulate the 'PSYM' of==
C==   UBC Computer Centre, which is written in ASSEMBLER.      ==
C==   It is hoped that this version is more portable and easier==
C==   to be modified.                                          ==
C==                                                            ==
C==   The following documentation is adapted from UBC PLOT     ==
C==   (April 1981).                                            ==
C==                                                            ==
C==  PURPOSE:                                                  ==
C==                                                            ==
C==     PSYM produces text on a plot. This routine is used for ==
C==     all character sets. See the description of PALPHA  for ==
C==     information on alternative character sets.             ==
C==                                                            ==
C==  HOW TO USE:                                               ==
C==                                                            ==
C==           CALL PSYM(X,Y,HEIGHT,STRING,ANGLE,LENGTH,*RC4)   ==
C==                                                            ==
C==     where:                                                 ==
C==           X,Y     are    the    floating-point    (REAL*4) ==
C==                   coordinates of the first character to be ==
C==                   drawn.   For   most   character    sets, ==
C==                   including  the standard one, this is the ==
C==                   lower-left   corner   of    the    first ==
C==                   character.                               ==
C==                                                            ==
C==           HEIGHT  is the floating-point (REAL*4) height in ==
C==                   user units at which the string is drawn.==
C==                                                            ==
C==           STRING  is the character string to be drawn.     ==
C==                                                            ==
C==           ANGLE   is the floating-point (REAL*4) angle  in ==
C==                   degrees of the character string (using a ==
C==                   positive counterclockwise convention).   ==
C==                                                            ==
C==           LENGTH  is   the   fullword-integer  (INTEGER*4) ==
C==                   number of characters in STRING.          ==
C==                                                            ==
C==           &RC4    is the exit taken  for  an  unsuccessful ==
C==                   return;  STRING is not drawn.  There  is ==
C==                   probably  an  error  in  a  user-defined ==
C==                   character set.                           ==
C==                                                            ==
C==  METHOD:                                                   ==
C==                                                            ==
C==     PSYM draws STRING with the HEIGHT specified, beginning ==
C==     at (X,Y), with the angle ANGLE.                        ==
C==                                                            ==
C==     There   are  six   special  characters  which  produce ==
C==     carriage   returns,   backspaces,   subscripts,    and ==
C==     superscripts. The first character shown for each is    ==
C==     used if ASIS=.TRUE. in the /MODE/ common block, i.e.   ==
C==     if the input STRING is in EBCDIC code (the native      ==
C==     code of the PSYM font structure). The second character ==
C==     shown is used if ASIS=.FALSE. (default) in the /MODE/  ==
C==     common block, i.e. if the input STRING is in ASCII     ==
C==     code. In this case the STRING will be converted to     ==
C==     EBCDIC code by the translation subroutine ASCEBC.      ==
C==                                                            ==
C== Z'15':  Carriage return. This causes an immediate carriage ==
C== Z'0A'   return  as on a  typewriter,  where the  margin is ==
C==         defined  by the  last  previous  carriage  return, ==
C==         or the last explicit X, Y pair.                    ==
C==                                                            ==
C== Z'16':  Backspace.   This  produces  a one-character back- ==
C== Z'08'   space.  If the alphabet currently being  used  has ==
C==         letterspacing  on,  this  may  be farther than one ==
C==         character back.  See the description of PALPHA for ==
C==         details.                                           ==
C==                                                            ==
C== Z'09':  Up.  If encountered while drawing  text  normally, ==
C== Z'09'   succeeding  text  is  drawn  as  superscripts.  If ==
C==         encountered while drawing  superscripts,  text  is ==
C==         drawn  at  the  next higher superscript level.  If ==
C==         encountered while drawing subscripts, drawing con- ==
C==         tinues at the next higher level of subscripts  (or ==
C==         back  to  normal  if  there  was only one level of ==
C==         subscripts).                                       ==
C==                                                            ==
C== Z'38':  Down.  If encountered while drawing text normally, ==
C== Z'01'   succeeding  text  is  drawn  as  subscripts.    If ==
C==         encountered  while  drawing  subscripts,  text  is ==
C==         drawn at  the  next  lower  subscript  level.   If ==
C==         encountered while drawing superscripts, succeeding ==
C==         text  is  drawn  at the next lower level of super- ==
C==         scripts (or back to normal if there was  only  one ==
C==         level of superscripts).                            ==
C==                                                            ==
C== Z'0A':  Up. It is similar to Z'09',  but  the  height   is ==
C== Z'03'   always changed.                                    ==
C==                                                            ==
C== Z'39':  Down. It is similar to Z'38', but the  height   is ==
C== Z'02'   always changed.                                    ==
C==                                                            ==
C==        The  exact  location  and  height of subscripts and ==
C==        superscripts   are  determined  by  the  particular ==
C==        alphabet.   Multiple    levels  of  subscripts  and ==
C==        superscripts are permitted; all  levels  are  drawn ==
C==        with the same height for Z'09' and Z'38',  and they ==
C==        are drawn with different height for Z'0A' and Z'39'.==
C==        When change of size occurs, it is always a fraction ==
C==        of  HEIGHT.  See  the  description  of  PALPHA  for ==
C==        details.                                            ==
C==                                                            ==
C================================================================
C==                                                            ==
C==   WRITTEN BY RICHARD T. LEE,  TRIUMF, UBC.                 ==
C==                               JULY 3, 1981.                ==
C                                                              ========C
C  Modified April 3, 1984 by F.W. Jones to allow output to EDGR        C
C  drawing files.  Modified Sept 27/84 to encode colour.  Modified     C
C  May 15/86 to allow only positive text heights in drawing files.     C
C  Modified 11-DEC-90 by F. Jones: error exit added for ascii to       C
C  ebcdic translation.  Formerly, strings that did not contain legal   C
C  ascii characters were just plotted anyway.                          C
C                                                                      C
C  Modified 28-Nov-91 by F.Jones:  PALPHA, which used INTEGER*4        C
C  arrays to store the font names, is replaced by PFONT using          C
C  character storage.  For backward compatibility, PALPHA is now a     C
C  shell routine calling PFONT.                                        C
C                                                                      C
C======================================================================C
C  modified by J.Chuma, 20Mar97 for g77
C   eliminated EQUC function and the EQCMP function
C  Modified by FWJ 13-NOV-97 for LINUX absoft

      LOGICAL ASIS
      COMMON /MODE/ASIS
      REAL*4 X,Y,HEIGHT,ANGLE
      BYTE STRING(1),STRINGB(256)
      BYTE LINE1(56)
      INTEGER*2 LINE2(256)
      BYTE LINE3(25000)
      INTEGER*2 SIZE,GRID,HSPAC,VSPAC,PSUPX,PSUPY,PSUBX,PSUBY,
     *          REFX,REFY,SWITC,LSPAC
      BYTE NAME(16)
      REAL*4 SHGT,SCAL,SSCAL,ANGL
      EQUIVALENCE (LINE1( 1),    SIZE),
     *            (LINE1( 3),    GRID),
     *            (LINE1( 5),   HSPAC),
     *            (LINE1( 7),   VSPAC),
     *            (LINE1( 9),   PSUPX),
     *            (LINE1(11),   PSUPY),
     *            (LINE1(13),   PSUBX),
     *            (LINE1(15),   PSUBY),
     *            (LINE1(17),    SHGT),
     *            (LINE1(21),    SCAL),
     *            (LINE1(25),   SSCAL),
     *            (LINE1(29),    ANGL),
     *            (LINE1(33),    REFX),
     *            (LINE1(35),    REFY),
     *            (LINE1(37),   SWITC),
     *            (LINE1(39),   LSPAC),
     *            (LINE1(41), NAME(1))
      LOGICAL GRID16,LISPON
      COMMON /FONT/ LINE1,LINE2,LINE3,GRID16,LISPON,MGRID
C================================================================
C==   The following indicates that PALPHA and PSYM have never  ==
C==   been called.                                             ==
C================================================================
      COMMON /CALLED/ PALPCD,PSYMCD,XC,YC
      LOGICAL PALPCD,PSYMCD
      COMMON /LOTRAN/ L11,L21,L31,L12,L22,L32,L13,L23,L33
      REAL L11,L12,L13,L21,L22,L23,L31,L32,L33
      COMMON /GOTRAN/ G11,G21,G31,G12,G22,G32,G13,G23,G33
      COMMON /TOTRAN/ T11,T21,T31,T12,T22,T32,T13,T23,T33
      BYTE LOC(2),LOCL
C  Modified by J.Chuma, 23Apr97 for Absoft f77 -- changed X' to Z'
      INTEGER*2 LOCATN/Z'0000'/
C      LOGICAL EQUC
      EQUIVALENCE (LOC(1),LOCATN)
#ifdef BEND
      EQUIVALENCE (LOC(2),LOCL)
#else
      EQUIVALENCE (LOC(1),LOCL)
#endif
      BYTE LENCHZ(2)
      INTEGER*2 LENCHA/Z'0000'/
      EQUIVALENCE (LENCHZ(1),LENCHA)
      BYTE WIDTHL(2)
      INTEGER*2 WIDTHC/Z'0000'/
      EQUIVALENCE (WIDTHL(1),WIDTHC)
      BYTE CTRL(6)/Z'15',Z'16',Z'09',Z'38',Z'0A',Z'39'/
      BYTE CTRL2(6)/Z'15',Z'16',Z'05',Z'01',Z'03',Z'02'/
      INTEGER NCTRL/6/
      LOGICAL*1 FIRST,MOVETO
      DATA RADE/1.745329E-2/
      DATA ZM0/Z'80000000'/

C Graphics Editor COMMON:
      COMMON/CDWG/DWGON,DWGTXT,LDWG,LDWT,IRECG,IRECT,STROKE
      LOGICAL DWGON,DWGTXT,STROKE

      IF(LENGTH.LE.0)RETURN

C Encode text into drawing file if open:
      IF(DWGON.AND..NOT.STROKE)THEN
        DWGTXT=.TRUE.      !inhibit output from PLOT_R to drawing file
        CALL PSYM_DWG(X,Y,HEIGHT,STRING,ANGLE,LENGTH)
      ENDIF                                                             

3     LENG=MIN(LENGTH,256)
      IF (PSYMCD) GO TO 5
CC      IF (.NOT. PALPCD) CALL PALPHA('STANDARD ',0,*99)
      IF (.NOT. PALPCD) CALL PFONT('STANDARD',0,*99)
      PSYMCD=.TRUE.
C      IF (EQUC(X,ZM0) .OR. EQUC(Y,ZM0)) GO TO 99
    5 CONTINUE
C      IF (EQUC(X,ZM0) .OR. EQUC(Y,ZM0)) GO TO 7
      XC=X
      YC=Y
    7 CONTINUE
c  set the left margin.
      XMARG=XC
      YMARG=YC
      LEVELS=0
      LEVELV=0
      DSUBX=PSUBX-REFX
      DSUBY=PSUBY-REFY
      DSUPX=PSUPX-REFX
      DSUPY=PSUPY-REFY
      SHGTD=1./SHGT
C================================================================
C==   HERE THE GLOBAL TRANSFORMATION IS CALCULATED.            ==
C==                                                            ==
C================================================================
      ANGLER=ANGLE*RADE
      COSA=COS(ANGLER)
      SINA=SIN(ANGLER)
      G11=HEIGHT*COSA
      G12=HEIGHT*SINA
      G21=-G12
      G22=G11
      G13=0.
      G23=0.
      G31=0.
      G32=0.
      G33=1.
      T11=L11*G11
      T12=L11*G12
      T13=0.
      T21=L21*G11+L22*G21
      T22=L21*G12+L22*G22
      T23=0.
      T31=L31*G11+L32*G21
      T32=L31*G12+L32*G22
      T33=1.
C================================================================
C==   EXTRACT INFORMATION FROM 'STRING'.                       ==
C================================================================
C==     ASIS = .FALSE.  FOR CONVERSION.
      CALL MOVEC(LENG,STRING,STRINGB)
      IF (.NOT.ASIS) CALL PASCEBC(STRINGB,STRINGB,LENG,*98)
      DO 500 I=1,LENG
         LOCL=STRINGB(I)
         DO 10 J=1,NCTRL
         IF(ASIS)THEN
            IF( LOCL .EQ. CTRL(J) )GO TO 400  ! J.Chuma 20Mar97
C            IF (EQUC(LOCL,CTRL(J))) GO TO 400
         ELSE
            IF( LOCL .EQ. CTRL2(J) )GO TO 400  ! J.Chuma 20Mar97
C            IF(EQUC(LOCL,CTRL2(J))) GO TO 400
         ENDIF
   10    CONTINUE
         IFIRST=LINE2(LOCATN+1)+1
C         WRITE(6,1313)LOCATN,IFIRST,SIZE
1313     FORMAT(1X,3I10)
         IF (IFIRST .GT. SIZE) GO TO 99
#ifdef BEND
         LENCHZ(2)=LINE3(IFIRST)
         WIDTHL(2)=LINE3(IFIRST+1)
#else
         LENCHZ(1)=LINE3(IFIRST)
         WIDTHL(1)=LINE3(IFIRST+1)
#endif
         LCHARA=LENCHA    
         IF (.NOT. GRID16) LCHARA=LCHARA*2
         LCHARA=LCHARA+2
         FIRST=.TRUE.
         IPT=3
  100    CONTINUE
C================================================================
C==   THE FOLLOWING LOOP PLOTS A COMPLETE CHARACTER.           ==
C================================================================
         CALL SPLITE(LINE3(IFIRST),LCHARA,IPT,INX,INY,MGRID,MOVETO,*110)
         XIN=XC+INX*T11+INY*T21+T31
         YIN=YC+INX*T12+INY*T22+T32
         IF (.NOT. FIRST) GO TO 105
         CALL PLOT_R(XIN,YIN,3)
         FIRST=.FALSE.
         GO TO 100
  105    IF (MOVETO) CALL PLOT_R(XIN,YIN,3)
         IF (.NOT. MOVETO) CALL PLOT_R(XIN,YIN,2)
         GO TO 100
  110    CONTINUE
C================================================================
C==   LETTERSPACING IS CONSIDERED HERE.                        ==
C================================================================
         WIDTHH=HSPAC+GRID
         IF (LISPON) WIDTHH=LSPAC+WIDTHC
         XC=XC+WIDTHH*T11
         YC=YC+WIDTHH*T12
         GO TO 500
  400    CONTINUE
      GO TO (410,420,430,440,450,460), J
      GO TO 500
  410 CONTINUE
C================================================================
C==   CARRIAGE RETURN.                                         ==
C================================================================
      XP=-(VSPAC+GRID)*L21
      YP=-(VSPAC+GRID)*L22
      XC=XMARG+XP*G11+YP*G21
      YC=YMARG+XP*G12+YP*G22
      XMARG=XC
      YMARG=YC
      GO TO 500
  420 CONTINUE
C================================================================
C==   BACKSPACE.                                               ==
C================================================================
      WIDTHH=HSPAC+GRID
      XC=XC-WIDTHH*T11
      YC=YC-WIDTHH*T12
      GO TO 500
  430 CONTINUE
C================================================================
C==   UP.                                                      ==
C================================================================
      LEVELS=LEVELS+1
      IF (LEVELS) 432,434,436
  432 CONTINUE
      XC=XC-(PSUBX*T11+PSUBY*T21)
      YC=YC-(PSUBX*T12+PSUBY*T22)
      GO TO 500
  434 CONTINUE
      XC=XC-(REFX*T11+REFY*T21)
      YC=YC-(REFY*T12+REFY*T22)
      CALL TRANSF(SHGTD)
      XC=XC-(DSUBX*T11+DSUBY*T21)
      YC=YC-(DSUBX*T12+DSUBY*T22)
      GO TO 500
  436 CONTINUE
      XC=XC+(DSUPX*T11+DSUPY*T21)
      YC=YC+(DSUPX*T12+DSUPY*T22)
      IF (LEVELS .EQ. 1) CALL TRANSF(SHGT)
      XC=XC+(REFX*T11+REFY*T21)
      YC=YC+(REFX*T12+REFY*T22)
      GO TO 500
  440 CONTINUE
C================================================================
C==   DOWN.                                                    ==
C================================================================
      LEVELS=LEVELS-1
      IF (LEVELS) 442,444,446
  442 CONTINUE
      XC=XC+(DSUBX*T11+DSUBY*T21)
      YC=YC+(DSUBX*T12+DSUBY*T22)
      IF (LEVELS .EQ. -1) CALL TRANSF(SHGT)
      XC=XC+(REFX*T11+REFY*T21)
      YC=YC+(REFX*T12+REFY*T22)
      GO TO 500
  444 CONTINUE
      XC=XC-(REFX*T11+REFY*T21)
      YC=YC-(REFX*T12+REFY*T22)
      CALL TRANSF(SHGTD)
      XC=XC-(DSUPX*T11+DSUPY*T21)
      YC=YC-(DSUPX*T12+DSUPY*T22)
      GO TO 500
  446 CONTINUE
      XC=XC-(PSUPX*T11+PSUPY*T21)
      YC=YC-(PSUPX*T12+PSUPY*T22)
      GO TO 500
  450 CONTINUE
C================================================================
C==   UP. The size of the character always changes.            ==
C================================================================
      LEVELV=LEVELV+1
      IF (LEVELV) 454,454,456
  454 CONTINUE
      XC=XC-(REFX*T11+REFY*T21)
      YC=YC-(REFY*T12+REFY*T22)
      CALL TRANSF(SHGTD)
      XC=XC-(DSUBX*T11+DSUBY*T21)
      YC=YC-(DSUBX*T12+DSUBY*T22)
      GO TO 500
  456 CONTINUE
      XC=XC+(DSUPX*T11+DSUPY*T21)
      YC=YC+(DSUPX*T12+DSUPY*T22)
      CALL TRANSF(SHGT)
      XC=XC+(REFX*T11+REFY*T21)
      YC=YC+(REFX*T12+REFY*T22)
      GO TO 500
  460 CONTINUE
C================================================================
C==   DOWN. The size of the character always changes.          ==
C================================================================
      LEVELV=LEVELV-1
      IF (LEVELV) 462,464,464
  462 CONTINUE
      XC=XC+(DSUBX*T11+DSUBY*T21)
      YC=YC+(DSUBX*T12+DSUBY*T22)
      CALL TRANSF(SHGT)
      XC=XC+(REFX*T11+REFY*T21)
      YC=YC+(REFX*T12+REFY*T22)
      GO TO 500
  464 CONTINUE
      XC=XC-(REFX*T11+REFY*T21)
      YC=YC-(REFX*T12+REFY*T22)
      CALL TRANSF(SHGTD)
      XC=XC-(DSUPX*T11+DSUPY*T21)
      YC=YC-(DSUPX*T12+DSUPY*T22)
      GO TO 500
  500 CONTINUE
      CALL FLUSH_PLOT

      DWGTXT=.FALSE.      !restore PLOT_R output to drawing file

      RETURN

C Error in ascii-ebc translation
   98 CALL TRANSPARENT_MODE(0)
      WRITE(*,*)'PSYM: ascii string contains illegal character'

   99 RETURN1
      END


      SUBROUTINE TRANSF(FACTOR)
C================================================================
C==   SUBROUTINE TRANSF.                                       ==
C==   THIS SUBROUTINE MULTIPLY THE MATRIX 'T' BY 'FACTOR'.     ==
C================================================================
      REAL T(3,3)
      COMMON /TOTRAN/ T
      DATA NDIM/3/
      DO 50 I=1,NDIM
         DO 40 J=1,NDIM
            T(I,J)=T(I,J)*FACTOR
   40    CONTINUE
   50 CONTINUE
      RETURN
      END


      SUBROUTINE PALPHA(NAME,WHAT,*)
C======================================================================C
C  PALPHA is replaced by PFONT in a separate source file.
C  For backward compatibility, this is a shell routine that calls
C  PFONT.  FWJ-28-NOV-91
C======================================================================C
      BYTE NAME(20)
      INTEGER WHAT

      CHARACTER*20 NAMEC
      CHARACTER*1 C

      NAMEC=' '
      DO I=1,20
        C=CHAR(NAME(I))
        IF(C.EQ.' ')GO TO 10
        NAMEC(I:I)=C
      ENDDO

10    CALL PFONT(NAMEC,WHAT,*99)
      RETURN

99    RETURN 1
      END


      SUBROUTINE SPLITE(CHA,LEN,IPT,INX,INY,MGRID,MOVETO,*)
C================================================================
C==   THIS SUBROUTINE OUTPUTS ONE POINT FROM THE CHAIN CODE,   ==
C==   AND INDICATES IF IT IS CONNECTED TO THE POINT BEFORE IT  ==
C==   OR NOT.                                                  ==
C==   PARAMETERS:                                              ==
C==         CHA   :  THE ARRAY STORING THE CHAIN CODE.         ==
C==         LEN   :  THE NUMBER OF BYTES IN THE CHAIN CODE.    ==
C==         IPT   :  THE INDEX OF THE POINT TO BE FOUND.       ==
C==         INX   :  THE CO-ORDINATES OF THE POINT.            ==
C==         INY   :  THE CO-ORDINATES OF THE POINT.            ==
C==         MGRID :  THE NUMBER OF BYTES FOR EACH POINT.       ==
C==                  =1 OR 2.                                  ==
C==         MOVETO:  = .TRUE. IF THE POINT IS CONNECTED TO ONE ==
C==                           BEFORE IT;                       ==
C==                  = .FALSE. IF IT IS NOT.                   ==
C==         &RC4  :  THE EXIT TAKEN IF THE INDEX 'IPT' IS OUT  ==
C==                  OF RANGE.                                ==
C==                                                            ==
C==   WRITTEN BY    RICHARD LEE,   TRIUMF,  UBC.               ==
C==                                MARCH  1981.                ==
C==                 REVISED ON   JULY 9,  1981.
C================================================================
C      LOGICAL EQUC
      BYTE CHA(1)
      LOGICAL*1 MOVETO
      INTEGER*2 INHEX/0/
      BYTE INHEXL(2),FF
      integer iff/Z'FF'/
      equivalence (ff,iff)
      EQUIVALENCE (INHEX,INHEXL(1))
      BYTE BYTE1,BYTE2
C================================================================
C==   RETURN1 IF 'IPT' IS OUT OF RANGE.                        ==
C================================================================
      IF (IPT .LE. 2 .OR. IPT .GT. LEN) RETURN1
      IF (MGRID .EQ. 2) GO TO 150
C================================================================
C==   GET THE HORIZONTAL AND VERTICAL CO-ORDINATES FROM ONE    ==
C==   BYTE OF INFORMATION.                                     ==
C================================================================
      BYTE1=CHA(IPT)
#ifdef BEND
      INHEXL(2)=BYTE1
#else
      INHEXL(1)=BYTE1
#endif
      INX=INHEX/16
      INY=INHEX-INX*16
      IPT=IPT+1
      MOVETO=.FALSE.
C================================================================
C==   RETURN IF THE CO-ORDINATES HAVE BEEN OBTAINED.           ==
C================================================================
      IF( BYTE1 .NE. FF )RETURN
C      IF (.NOT. (EQUC(BYTE1,FF))) RETURN
      BYTE1=CHA(IPT)
#ifdef BEND
      INHEXL(2)=BYTE1
#else
      INHEXL(1)=BYTE1
#endif
      INX=INHEX/16
      INY=INHEX-INX*16
      IPT=IPT+1
C================================================================
C==   THE CO-ORDINATES OF THE POINT IS (15,15) WHEN RETURN HERE.=
C================================================================
      IF( BYTE1 .EQ. FF )RETURN
      MOVETO=.TRUE.
      RETURN
  150 CONTINUE
C================================================================
C==   GET THE HORIZONTAL AND VERTICAL CO-ORDINATES FROM TWO    ==
C==   BYTES INFORMATION.                                       ==
C================================================================
      BYTE1=CHA(IPT)
#ifdef BEND
      INHEXL(2)=BYTE1
#else
      INHEXL(1)=BYTE1
#endif
      INX=INHEX
      IPT=IPT+1
      BYTE2=CHA(IPT)
#ifdef BEND
      INHEXL(2)=BYTE2
#else
      INHEXL(1)=BYTE2
#endif
      INY=INHEX
      MOVETO=.FALSE.
      IPT=IPT+1
C================================================================
C==   RETURN IF THE CO-ORDINATES HAVE BEEN OBTAINED.           ==
C================================================================
      IF( (BYTE1.NE.FF) .OR. (BYTE2.NE.FF) )RETURN  ! J.Chuma 20Mar97
C      IF (.NOT. (EQUC(BYTE1,FF) .AND. EQUC(BYTE2,FF)))
C     1   RETURN
      BYTE1=CHA(IPT)
#ifdef BEND
      INHEXL(2)=BYTE1
#else
      INHEXL(1)=BYTE1
#endif
      INX=INHEX
      IPT=IPT+1
      BYTE2=CHA(IPT)
#ifdef BEND
      INHEXL(2)=BYTE2
#else
      INHEXL(1)=BYTE2
#endif
      INY=INHEX
      IPT=IPT+1
C================================================================
C==   THE CO-ORDINATES OF THE POINT IS (255,255) WHEN RETURN   ==
C==   HERE.                                                    ==
C================================================================
      IF( (BYTE1.EQ.FF) .AND. (BYTE2.EQ.FF) )RETURN
C      IF (EQUC(BYTE1,FF) .AND. EQUC(BYTE2,FF)) RETURN
      MOVETO=.TRUE.
      RETURN
      END


      FUNCTION PSMLEN(STRING,LENGTH,HEIGHT)
C================================================================
C==   FUNCTION PSMLEN                                          ==
C==                                                            ==
C==  PURPOSE:                                                  ==
C==                                                            ==
C==     PSMLEN   determines the length in  user units  that  a ==
C==     character string would be if plotted by PSYM.          ==
C==                                                            ==
C==  HOW TO USE:                                               ==
C==                                                            ==
C==           SIZE = PSMLEN(STRING,LENGTH,HEIGHT)              ==
C==                                                            ==
C==     where:                                                 ==
C==                                                            ==
C==           STRING  is the character string whose length  is ==
C==                   to be determined.                        ==
C==                                                            ==
C==           LENGTH  is   the   fullword-integer  (INTEGER*4) ==
C==                   number of characters in the string.      ==
C==                                                            ==
C==           HEIGHT  is the floating-point (REAL*4) height in ==
C==                   user units for STRING.                   ==
C==                                                            ==
C==           SIZE    The function result is the length of the ==
C==                   string in user units.                    ==
C==                                                            ==
C==  METHOD:                                                   ==
C==                                                            ==
C==     STRING has the same format as a character string given ==
C==     to PSYM. (The same string could be  passed  to  PSYM.) ==
C==     The length of STRING as it would be plotted by PSYM is ==
C==     determined,  with  the exception that carriage returns ==
C==     in STRING are ignored.                                 ==
C==                                                            ==
C================================================================
C==                                                            ==
C==   Written by  RICHARD T. LEE,  TRIUMF,  UBC,               ==
C==                                July 7, 1981.               ==
C==   Modified 11-DEC-90 by F. Jones: error detection added for==
C==   ascii-to-ebcdic translation.                             ==
C==   Modified 20-FEB-91 by F. Jones, to constrain LENGTH      ==
C==   to be >0 and <=256.                                      ==
C================================================================
      LOGICAL ASIS
      COMMON /MODE/ASIS
C      LOGICAL EQUC
      BYTE STRING(1),STRINGB(256)
      BYTE LINE1(56)
      INTEGER*2 LINE2(256)
      BYTE LINE3(25000)
      INTEGER*2 SIZE,GRID,HSPAC,VSPAC,PSUPX,PSUPY,PSUBX,PSUBY,
     *          REFX,REFY,SWITC,LSPAC
      BYTE NAME(16)
      REAL*4 SHGT,SCAL,SSCAL,ANGL
      EQUIVALENCE (LINE1( 1),    SIZE),
     *            (LINE1( 3),    GRID),
     *            (LINE1( 5),   HSPAC),
     *            (LINE1( 7),   VSPAC),
     *            (LINE1( 9),   PSUPX),
     *            (LINE1(11),   PSUPY),
     *            (LINE1(13),   PSUBX),
     *            (LINE1(15),   PSUBY),
     *            (LINE1(17),    SHGT),
     *            (LINE1(21),    SCAL),
     *            (LINE1(25),   SSCAL),
     *            (LINE1(29),    ANGL),
     *            (LINE1(33),    REFX),
     *            (LINE1(35),    REFY),
     *            (LINE1(37),   SWITC),
     *            (LINE1(39),   LSPAC),
     *            (LINE1(41), NAME(1))
      LOGICAL GRID16,LISPON
      COMMON /FONT/ LINE1,LINE2,LINE3,GRID16,LISPON,MGRID
      REAL L11,L12,L13,L21,L22,L23,L31,L32,L33
      COMMON /LOTRAN/ L11,L21,L31,L12,L22,L32,L13,L23,L33
      BYTE LOC(2),LOCL
      INTEGER*2 LOCATN/Z'0000'/
      EQUIVALENCE (LOC(1),LOCATN)
#ifdef BEND
      EQUIVALENCE (LOC(2),LOCL)
#else
      EQUIVALENCE (LOC(1),LOCL)
#endif
      BYTE WIDTHL(2)
      INTEGER*2 WIDTHC/Z'0000'/
      EQUIVALENCE (WIDTHL(1),WIDTHC)
      BYTE CTRL(6)/Z'15',Z'16',Z'09',Z'38',Z'0A',Z'39'/
      BYTE CTRL2(6)/Z'15',Z'16',Z'05',Z'01',Z'03',Z'02'/
      INTEGER NCTRL/6/
      LOGICAL PALPCD,PSYMCD
      COMMON /CALLED/ PALPCD,PSYMCD,XC,YC

      IF (PALPCD) GO TO 5
      CALL PFONT('STANDARD',0)
    5 CONTINUE
      LEVELS=0
      LEVELV=0
      DSUBX=PSUBX-REFX
      DSUBY=PSUBY-REFY
      DSUPX=PSUPX-REFX
      DSUPY=PSUPY-REFY
      SHGTD=1./SHGT
      SCALEN=L11*HEIGHT
      PSMLEN=0.
C================================================================
C==   EXTRACT INFORMATION FROM 'STRING'.                       ==
C================================================================
C==   ASIS = .FALSE. FOR CONVERSION.                           ==
C================================================================
      IF(LENGTH.LE.0)RETURN      !FWJ 20-FEB-91
      LENG=MIN(LENGTH,256)       !FWJ 20-FEB-91
      CALL MOVEC(LENG,STRING,STRINGB)
      IF (.NOT.ASIS) CALL PASCEBC(STRINGB,STRINGB,LENGTH,*98)
      DO 500 I=1,LENG
         LOCL=STRINGB(I)
         DO 10 J=1,NCTRL
         IF(ASIS)THEN
            IF( LOCL .EQ. CTRL(J) )GO TO 400
C            IF (EQUC(LOCL,CTRL(J))) GO TO 400
         ELSE
            IF( LOCL .EQ. CTRL2(J) )GO TO 400
C            IF(EQUC(LOCL,CTRL2(J))) GO TO 400
         ENDIF
   10    CONTINUE
         IFIRST=LINE2(LOCATN+1)+1
#ifdef BEND
         WIDTHL(2)=LINE3(IFIRST+1)
#else
         WIDTHL(1)=LINE3(IFIRST+1)
#endif
C================================================================
C==   LETTERSPACING IS CONSIDERED HERE.                        ==
C================================================================
         WIDTHH=HSPAC+GRID
         IF (LISPON) WIDTHH=LSPAC+WIDTHC
         PSMLEN=PSMLEN+WIDTHH*SCALEN
         GO TO 500
  400    CONTINUE
      GO TO (410,420,430,440,450,460), J
      GO TO 500
  410 CONTINUE
C================================================================
C==   CARRIAGE RETURN.                                         ==
C================================================================
      GO TO 500
  420 CONTINUE
C================================================================
C==   BACKSPACE.                                               ==
C================================================================
      WIDTHH=HSPAC+GRID
      PSMLEN=PSMLEN-WIDTHH*SCALEN
      GO TO 500
  430 CONTINUE
C================================================================
C==   UP. SUPERSCRIPTS ARE HANDLED HERE.                       ==
C================================================================
      LEVELS=LEVELS+1
      IF (LEVELS) 432,434,436
  432 CONTINUE
      PSMLEN=PSMLEN-PSUBX*SCALEN
      GO TO 500
  434 CONTINUE
      PSMLEN=PSMLEN-REFX*SCALEN
      SCALEN=SCALEN*SHGTD
      PSMLEN=PSMLEN-DSUBX*SCALEN
      GO TO 500
  436 CONTINUE
      PSMLEN=PSMLEN+DSUPX*SCALEN
      IF (LEVELS .EQ. 1) SCALEN=SCALEN*SHGT
      PSMLEN=PSMLEN+REFX*SCALEN
      GO TO 500
  440 CONTINUE
C================================================================
C==   DOWN. SUBSCRIPTS ARE HANDLED HERE.                       ==
C================================================================
      LEVELS=LEVELS-1
      IF (LEVELS) 442,444,446
  442 CONTINUE
      PSMLEN=PSMLEN+DSUBX*SCALEN
      IF (LEVELS .EQ. -1) SCALEN=SCALEN*SHGT
      PSMLEN=PSMLEN+REFX*SCALEN
      GO TO 500
  444 CONTINUE
      PSMLEN=PSMLEN-REFX*SCALEN
      SCALEN=SCALEN*SHGTD
      PSMLEN=PSMLEN-DSUPX*SCALEN
      GO TO 500
  446 CONTINUE
      PSMLEN=PSMLEN-PSUPX*SCALEN
      GO TO 500
  450 CONTINUE
C================================================================
C==   UP. SUPERSCRIPTS ARE HANDLED HERE.                       ==
C================================================================
      LEVELV=LEVELV+1
      IF (LEVELV) 454,454,456
  454 CONTINUE
      PSMLEN=PSMLEN-REFX*SCALEN
      SCALEN=SCALEN*SHGTD
      PSMLEN=PSMLEN-DSUBX*SCALEN
      GO TO 500
  456 CONTINUE
      PSMLEN=PSMLEN+DSUPX*SCALEN
      SCALEN=SCALEN*SHGT
      PSMLEN=PSMLEN+REFX*SCALEN
      GO TO 500
  460 CONTINUE
C================================================================
C==   DOWN. SUBSCRIPTS ARE HANDLED HERE.                       ==
C================================================================
      LEVELV=LEVELV-1
      IF (LEVELV) 462,464,464
  462 CONTINUE
      PSMLEN=PSMLEN+DSUBX*SCALEN
      SCALEN=SCALEN*SHGT
      PSMLEN=PSMLEN+REFX*SCALEN
      GO TO 500
  464 CONTINUE
      PSMLEN=PSMLEN-REFX*SCALEN
      SCALEN=SCALEN*SHGTD
      PSMLEN=PSMLEN-DSUPX*SCALEN
      GO TO 500
  500 CONTINUE
      RETURN

C Error in ascii-ebc translation
   98 CALL TRANSPARENT_MODE(0)
      WRITE(*,*)'PSMLEN: ascii string contains illegal character'

      END


      SUBROUTINE PSYMLC(X,Y)
C================================================================
C==                                                            ==
C==  PURPOSE:                                                  ==
C==                                                            ==
C==     PSYMLC  obtains the coordinates of the end of the last ==
C==     character string drawn by PSYM.                        ==
C==                                                            ==
C==  HOW TO USE:                                               ==
C==                                                            ==
C==           CALL PSYMLC(X,Y)                                 ==
C==                                                            ==
C==     where:                                                 ==
C==                                                            ==
C==           X,Y     are  floating-point  (REAL*4)  variables ==
C==                   set  to  the absolute coordinates of the ==
C==                   point  at   which   PSYM   would   begin ==
C==                   lettering.                               ==
C==                   (hexadecimal 80000000,hexadecimal 80000000).
C==                   is returned if PSYM has never been called==
C==                                                            ==
C================================================================
C==                                                            ==
C==         WRITTEN  BY  RICHARD T. LEE,  TRIUMF,  UBC.        ==
C==                                       July 13, 1981.       ==
C================================================================
      LOGICAL PALPCD,PSYMCD
      COMMON /CALLED/ PALPCD,PSYMCD,XC,YC
      X=XC
      Y=YC
      RETURN
      END


      SUBROUTINE PSALPH(WHAT,VALUE,OLDVAL,*)
C================================================================
C==                                                            ==
C==  PURPOSE:                                                  ==
C==                                                            ==
C==     PSALPH  changes  the  values  of  parameters  for  the ==
C==     current character set.                                 ==
C==                                                            ==
C==  HOW TO USE:                                               ==
C==                                                            ==
C==           CALL PSALPH(WHAT,VALUE,OLDVAL,*RC4)              ==
C==                                                            ==
C==     where:                                                 ==
C==                                                            ==
C==        WHAT       is   the   4-character   name   or   the ==
C==                   fullword-integer number of the parameter ==
C==                   to be changed.                           ==
C==                                                            ==
C==        VALUE      is the new value to be assigned to  that ==
C==                   parameter.  It  is  either  one  or  two ==
C==                   fullword  integers  (INTEGER*4)   or   a ==
C==                   single  floating- point (REAL*4) number, ==
C==                   as appropriate for WHAT.                 ==
C==                                                            ==
C==        OLDVAL     is set on return to the  previous  value ==
C==                   of  the  parameter.  It  should have the ==
C==                   same size and type as VALUE.             ==
C==                                                            ==
C==        &RC4       is a return taken  if  WHAT  was  not  a ==
C==                   parameter,  VALUE  was invalid for WHAT, ==
C==                   or  space  could  not  be  obtained  for ==
C==                   copying the standard alphabet.           ==
C==                                                            ==
C==  METHOD:                                                   ==
C==                                                            ==
C==     The  parameter specified by WHAT has its value changed ==
C==     to VALUE,  and  its  previous  value  is  returned  in ==
C==     OLDVAL. The table below describes the values for WHAT. ==
C==     In  the  "Type"  column,  F  means  a fullword integer ==
C==     (INTEGER*4)  and  E  means   fullword   floating-point ==
C==     (REAL*4).                                              ==
C==                                                            ==
C==                                                            ==
C==             WHAT                                           ==
C==        Name     Number    Type    Parameter Changed        ==
C==                                                            ==
C==        HSPC        1        F        HSPAC                 ==
C==        VSPC        2        F        VSPAC                 ==
C==        SUPS        3       2F        PSUP                  ==
C==        SUBS        4       2F        PSUB                  ==
C==        SHGT        5        E        SHGT                  ==
C==        SCAL        6        E        SCAL                  ==
C==        HSCL        7        E        SSCAL                 ==
C==        ANGL        8        E        ANGL                  ==
C==        LTRS        9        F        SWITCH                ==
C==                                       =0 letterspacing off ==
C==                                        otherwise on        ==
C==        REFP       10       2F         REF                  ==
C==        LSPC       11        F         LSPAC                ==
C==                                                            ==
C==                                                            ==
C==        See  the  description  of PALPHA for an explanation ==
C==        of the parameters.  The  value  restrictions listed ==
C==        there are enforced by PSALPH.                       ==
C================================================================
C==                                                            ==
C==         WRITTEN  BY  RICHARD T. LEE,  TRIUMF,  UBC.        ==
C==                                       July 13, 1981.       ==
C================================================================
C      LOGICAL EQCMP
      BYTE LINE1(56)
      INTEGER*2 LINE2(256)
      BYTE LINE3(25000)
      INTEGER*2 SIZE,GRID,HSPAC,VSPAC,PSUPX,PSUPY,PSUBX,PSUBY,
     *          REFX,REFY,SWITC,LSPAC
      BYTE NAME(16)
      REAL*4 SHGT,SCAL,SSCAL,ANGL
      EQUIVALENCE (LINE1( 1),    SIZE),
     *            (LINE1( 3),    GRID),
     *            (LINE1( 5),   HSPAC),
     *            (LINE1( 7),   VSPAC),
     *            (LINE1( 9),   PSUPX),
     *            (LINE1(11),   PSUPY),
     *            (LINE1(13),   PSUBX),
     *            (LINE1(15),   PSUBY),
     *            (LINE1(17),    SHGT),
     *            (LINE1(21),    SCAL),
     *            (LINE1(25),   SSCAL),
     *            (LINE1(29),    ANGL),
     *            (LINE1(33),    REFX),
     *            (LINE1(35),    REFY),
     *            (LINE1(37),   SWITC),
     *            (LINE1(39),   LSPAC),
     *            (LINE1(41), NAME(1))
      LOGICAL GRID16,LISPON
      COMMON /FONT/ LINE1,LINE2,LINE3,GRID16,LISPON,MGRID
      INTEGER*4 WHAT,VALUE(2),OLDVAL(2)
      INTEGER*4 VAIN(2),OVAIN(2)
      REAL*4 VA,OVA
      EQUIVALENCE (VA,VAIN(1)), (OVA,OVAIN(1))
      
      character*4 namelt1/'HSPC'/, namelt2/'VSPC'/
      character*4 namelt3/'SUPS'/, namelt4/'SUBS'/
      character*4 namelt5/'SHGT'/, namelt6/'SCAL'/
      character*4 namelt7/'HSCL'/, namelt8/'ANGL'/
      character*4 namelt9/'LTRS'/, namelt10/'REFP'/
      character*4 namelt11/'LSPC'/
      integer namelt(11)
      equivalence (namelt(1),namelt1), (namelt(2),namelt2),
     *            (namelt(3),namelt3), (namelt(4),namelt4),
     *            (namelt(5),namelt5), (namelt(6),namelt6),
     *            (namelt(7),namelt7), (namelt(8),namelt8),
     *            (namelt(9),namelt9), (namelt(10),namelt10),
     *            (namelt(11),namelt11)
cc      INTEGER NAMELT(11)/'HSPC','VSPC','SUPS','SUBS','SHGT',
cc     *            'SCAL','HSCL','ANGL','LTRS','REFP','LSPC'/
      DATA NLIST/11/
      LOGICAL PALPCD,PSYMCD
      COMMON /CALLED/ PALPCD,PSYMCD,XC,YC
C================================================================
C==   See if PALPHA has been called or not. If not, set up the ==
C==   STANDARD font.                                           ==
C================================================================
      IF (PALPCD) GO TO 5
CC      CALL PALPHA('STANDARD ',0,*999)
      CALL PFONT('STANDARD',0,*999)
    5 CONTINUE
C================================================================
C==   Here we check if WHAT is an integer parameter number.    ==
C================================================================
      DO 10 I=1,NLIST
         IF (WHAT .EQ. I) GO TO 50
   10 CONTINUE
C================================================================
C==   Here we assume that WHAT is a four-character name.       ==
C================================================================
      DO 20 I=1,NLIST
         IF( WHAT .EQ. NAMELT(I) )GO TO 50
C         IF (EQCMP(4,WHAT,NAMELT(I))) GO TO 50
   20 CONTINUE
      GO TO 999
   50 GO TO (110,120,130,140,150,160,170,180,190,200,210),I
C================================================================
C==   In the following the control parameter specified by WHAT ==
C==   is changed to VALUE and its old value is returned in     ==
C==   OLDVAL, provided that VALUE is valid.                    ==
C================================================================
  110 CONTINUE
      OLDVAL(1)=HSPAC
      IF (VALUE(1) .LE. -GRID) GO TO 999
      HSPAC=VALUE(1)
      GO TO 500
  120 CONTINUE
      OLDVAL(1)=VSPAC
      IF (VALUE(1) .LE. -GRID) GO TO 999
      VSPAC=VALUE(1)
      GO TO 500
  130 CONTINUE
      OLDVAL(1)=PSUPX
      OLDVAL(2)=PSUPY
      PSUPX=VALUE(1)
      PSUPY=VALUE(2)
      GO TO 500
  140 CONTINUE
      OLDVAL(1)=PSUBX
      OLDVAL(2)=PSUBY
      PSUBX=VALUE(1)
      PSUBY=VALUE(2)
      GO TO 500
  150 CONTINUE
      OVA=SHGT
      OLDVAL(1)=OVAIN(1)
      VAIN(1)=VALUE(1)
      SHGT=VA
      GO TO 500
  160 CONTINUE
      OVA=SCAL
      OLDVAL(1)=OVAIN(1)
      VAIN(1)=VALUE(1)
      SCAL=VA
      GO TO 500
  170 CONTINUE
      OVA=SSCAL
      OLDVAL(1)=OVAIN(1)
      VAIN(1)=VALUE(1)
      SSCAL=VA
      GO TO 500
  180 CONTINUE
      OVA=ANGL
      OLDVAL(1)=OVAIN(1)
      VAIN(1)=VALUE(1)
      IF ((VA .LE. -90.) .OR. (VA .GE. 90.)) GO TO 999
      ANGL=VA
      GO TO 500
  190 CONTINUE
      OLDVAL(1)=SWITC
      SWITC=VALUE(1)
      GO TO 500
  200 CONTINUE
      OLDVAL(1)=REFX
      OLDVAL(2)=REFY
      REFX=VALUE(1)
      REFY=VALUE(2)
      GO TO 500
  210 CONTINUE
      OLDVAL(1)=LSPAC
      LSPAC=VALUE(1)
      GO TO 500
  500 CONTINUE
C================================================================
C==   Here LOCTRA, which is an entry point in subroutine       ==
C==   PALPHA, is called to update the local transformation.    ==
C================================================================
      CALL LOCTRA
      RETURN
  999 RETURN1
      END      
