#ifdef g77
      SUBROUTINE READ_PLOT(DEVICE,ARRAY,LEN,ERROR)
      CHARACTER*(*) DEVICE
      BYTE ARRAY(128,480)
      INTEGER LEN(480)
      LOGICAL ERROR
      WRITE(*,*)'*** READ_PLOT not available under LINUX'
      RETURN
      END
      SUBROUTINE WRITE_PLOT(IOUT,ARRAY,LEN)
      INTEGER IOUT
      BYTE ARRAY(128,480)
      INTEGER LEN(480)
      WRITE(*,*)'*** WRITE_PLOT not available under LINUX'
      RETURN
      END
      SUBROUTINE WRITE_VT640_PXPLOT(IOUT,ARRAY,LEN)
      WRITE(*,*)'*** WRITE_VT640_PXPLOT not available under LINUX'
      RETURN
      END
#elif gfortran
      SUBROUTINE READ_PLOT(DEVICE,ARRAY,LEN,ERROR)
      CHARACTER*(*) DEVICE
      BYTE ARRAY(128,480)
      INTEGER LEN(480)
      LOGICAL ERROR
      WRITE(*,*)'*** READ_PLOT not available under LINUX'
      RETURN
      END
      SUBROUTINE WRITE_PLOT(IOUT,ARRAY,LEN)
      INTEGER IOUT
      BYTE ARRAY(128,480)
      INTEGER LEN(480)
      WRITE(*,*)'*** WRITE_PLOT not available under LINUX'
      RETURN
      END
      SUBROUTINE WRITE_VT640_PXPLOT(IOUT,ARRAY,LEN)
      WRITE(*,*)'*** WRITE_VT640_PXPLOT not available under LINUX'
      RETURN
      END
#else
C======================================================================C
C                                                                      C
C  READPLOT.FOR                                                        C
C                                                                      C
C  Support routines for reading from and writing to the VT640          C
C  bitmap, & for dumping the bitmap to the Printronix printer.         C
C  These routines are used by PX, PX650 utilities.                     C
C                                                                      C
C  NOTE: WRITE_BITMAP_PX has been removed to its own source file.      C
C                                                                      C
C======================================================================C

      SUBROUTINE READ_PLOT(DEVICE,ARRAY,LEN,ERROR)
C
C  reqd. KOSTL: routines - BTD,LSWAP.MAR,MOVEC,READNOECH
C  the following are in READNOECH - ASSIGN_DEVICE,DEASSIGN_DEVICE,
C                                 - WRITE_DIRECT
C
C======================================================================
C======================================================================
C==                                                                  ==
C==   READ_PLOT: reads the bitmap from the VT640 terminal which has  ==
C==              the logical name "DEVICE" (eg. 'TT' or '_TTA1:').   ==
C==              The bitmap is stored in the 2-dimensional array:    ==
C==              ARRAY(128,480) as 480 dot lines of 128 5-bit        ==
C==              characters (See the VT640 graphics manual for more  ==
C==              details on how the screen raster image is stored).  ==
C==              LEN(480) is an array of lengths (in bytes) of each  ==
C==              dot line. The first line of ARRAY, ARRAY(128,1)     ==
C==              corresponds to the top dot line on the screen.      ==
C==              If ERROR is returned as .TRUE. then an error has    ==
C==              occured in reading the bitmap from the screen.      ==
C==                                                                  ==
C==   Written by Arthur Haynes, TRIUMF U.B.C., April 8, 1982.        ==
C==                                                                  ==
C==   Input  Parameters: DEVICE (CHARACTER*(*)).                     ==
C==                                                                  ==
C==   Output Parameters: ARRAY(128,480) (L*1); LEN(480) (I*4);       ==
C==                      ERROR (L*4).                                ==
C==                                                                  ==
C======================================================================
C======================================================================
      CHARACTER*(*) DEVICE
      BYTE ARRAY(128,480),ARR(129)
      INTEGER LEN(480)
      LOGICAL ERROR
      BYTE OUT1(13)/'+',X'1B','"','0',';',3*'0',';','1','2','8',
     *                   'c'/
      BYTE GRAPHICS(2)/'+',X'1D'/
      INTEGER*2 CHANNEL
C======================================================================
C==   Assign the DEVICE to the CHANNEL.                              ==
C======================================================================
      CALL ASSIGN_DEVICE(DEVICE,CHANNEL,ERROR)
      IF(ERROR)RETURN
C======================================================================
C==   Write out the control sequence which puts the VT640 in graphics==
C==   mode.                                                          ==
C======================================================================
      CALL WRITE_DIRECT(CHANNEL,GRAPHICS,2,ERROR)
      IF(ERROR)RETURN
      DO 100 L=1,480
      CALL BTD(480-L,OUT1(6),3,NSIG,'0')
C======================================================================
C==   Write out the control sequence which causes the VT640 to send  ==
C==   back to the host computer the L'th dot line from the top of the==
C==   screen.                                                        ==
C======================================================================
      CALL WRITE_DIRECT(CHANNEL,OUT1,13,ERROR)
      IF(ERROR)RETURN
C======================================================================
C==   Read the L'th dot line without echoing it on the terminal.     ==
C======================================================================
      CALL READ_NO_ECHO(CHANNEL,ARR,LEN(L),129,ERROR)
      IF(ERROR)RETURN
C======================================================================
C==   Store the LEN(L) characters of the L'th dot line at the        ==
C==   array location ARRAY(1,L).                                     ==
C======================================================================
      CALL MOVEC(LEN(L),ARR,ARRAY(1,L))
100   CONTINUE
C======================================================================
C==   Deassign the DEVICE from the CHANNEL.                          ==
C======================================================================
      CALL DEASSIGN_DEVICE(CHANNEL,ERROR)
      RETURN
      END
      SUBROUTINE WRITE_PLOT(IOUT,ARRAY,LEN)
C======================================================================
C======================================================================
C==                                                                  ==
C==   WRITE_PLOT: writes the bitmap stored in the 2-dimensional array==
C==               ARRAY(128,480) on FORTRAN output unit IOUT.        ==
C==               The bitmap is stored in the 2-dimensional array:   ==
C==               ARRAY(128,480) as 480 dot lines of 128 5-bit       ==
C==               characters (See the VT640 graphics manual for more ==
C==               details on how the screen raster image is stored). ==
C==               LEN(480) is an array of lengths (in bytes) of each ==
C==               dot line. The first line of ARRAY, ARRAY(128,1)    ==
C==               corresponds to the top dot line on the screen.     ==
C==                                                                  ==
C==   Written by Arthur Haynes, TRIUMF U.B.C., April 8, 1982.        ==
C==                                                                  ==
C==   Input  Parameters: IOUT (I*4); ARRAY(128,480) (L*1);           ==
C==                      LEN(480) (I*4);                             ==
C==                                                                  ==
C======================================================================
C======================================================================
      BYTE ARRAY(128,480)
      INTEGER LEN(480)
      BYTE ADDRESS(3)
C======================================================================
C==   Write out the control sequence which puts the VT640 in graphics==
C==   mode.                                                          ==
C======================================================================
      WRITE(IOUT,10)X'1D'
10    FORMAT('+',255A1)
      DO 100 L=1,480
      CALL BTD(480-L,ADDRESS,3,NSIG,'0')
C======================================================================
C==   Write out the L'th dot line at the L'th address from the top   ==
C==   of the screen.                                                 ==
C======================================================================
      WRITE(IOUT,10)X'1B','"','0',';',ADDRESS,';','a'
      WRITE(IOUT,10)X'1D',X'1B','+',(ARRAY(I,L),I=1,LEN(L)),'#'
100   CONTINUE
      RETURN
      END
      SUBROUTINE WRITE_VT640_PXPLOT(IOUT,ARRAY,LEN)
C======================================================================
C======================================================================
C==                                                                  ==
C==   WRITE_VT640_PXPLOT: writes the bitmap stored in the            ==
C==               2-dimensional array ARRAY(128,480) on FORTRAN unit ==
C==               IOUT in the format required to be printed on the   ==
C==               printronix.                                        ==
C==               The bitmap is stored in the 2-dimensional array:   ==
C==               ARRAY(128,480) as 480 dot lines of 128 5-bit       ==
C==               characters (See the VT640 graphics manual for more ==
C==               details on how the screen raster image is stored). ==
C==               LEN(480) is an array of lengths (in bytes) of each ==
C==               dot line. The first line of ARRAY, ARRAY(128,1)    ==
C==               corresponds to the top dot line on the screen, and ==
C==               will be printed as the first dot line on the       ==
C==               printronix.                                        ==
C==               Note: IOUT can be assigned directly to the         ==
C==               printronix or it can be assigned to a file which   ==
C==               can then be printed on the printonix.              ==
C==                                                                  ==
C==   Written by Arthur Haynes, TRIUMF U.B.C., April 8, 1982.        ==
C==                                                                  ==
C     Modified July 12/83 by F. Jones for unformatted output:         C
C     If IOUT is assigned to a file which is to be printed later,     C
C     processing is speeded up considerably by unformatted writes     C
C     into the file.  To take advantage of this, open unit IOUT       C
C     with FORM='UNFORMATTED' and CARRIAGECONTROL='LIST'.             C
C     The logical variable FMTED in COMMON/SPOOL/ should be           C
C     set to .FALSE. by the calling program.  The default for         C
C     FMTED is .TRUE. (formatted output as before).                   C
C                                                                     C
C==   Input  Parameters: IOUT (I*4); ARRAY(128,480) (L*1);           ==
C==                      LEN(480) (I*4);                             ==
C==                                                                  ==
C======================================================================
C======================================================================
      BYTE ARRAY(128,480),LINE(108),NFIRST,ARR(128)
      INTEGER LEN(480)
      BYTE CTRL_E/X'05'/,LSWAP,LI1,LI2,LI3,LI4,LI5,LI6
      DATA I1,I2,I3,I4,I5,I6/6*0/
      EQUIVALENCE (LI1,I1),(LI2,I2),(LI3,I3),(LI4,I4),(LI5,I5),(LI6,I6)
      LOGICAL FMTED
      COMMON/SPOOL/FMTED
      DO 200 J=1,480
      NARR=0
      L=0
50    L=L+1
      IF(L.GT.LEN(J))GO TO 70
      IF(ARRAY(L,J).EQ.'$')GO TO 60
      NARR=NARR+1
      ARR(NARR)=ARRAY(L,J)
      GO TO 50
60    NZERO=ARRAY(L+1,J)
      NZERO=MOD(NZERO,64)
      DO 65 NA=NARR+1,NARR+NZERO
      ARR(NA)=0
65    CONTINUE
      NARR=NARR+NZERO
      L=L+1
      GO TO 50     
70    DO 100 I=1,21
      IARR=(I-1)*6
      ILIN=(I-1)*5
      LI1=LSWAP(ARR(IARR+1))
      LI2=LSWAP(ARR(IARR+2))
      LI3=LSWAP(ARR(IARR+3))
      LI4=LSWAP(ARR(IARR+4))
      LI5=LSWAP(ARR(IARR+5))
      LI6=LSWAP(ARR(IARR+6))
      I1=I1/8
      I2=I2/8
      I3=I3/8
      I4=I4/8
      I5=I5/8
      I6=I6/8
      LINE(ILIN+1)=I1+32*MOD(I2,2)
      LINE(ILIN+2)=I2/2+16*MOD(I3,4)
      LINE(ILIN+3)=I3/4+8*MOD(I4,8)
      LINE(ILIN+4)=I4/8+4*MOD(I5,16)
      LINE(ILIN+5)=I5/16+2*I6
100   CONTINUE
      I=22
      IARR=(I-1)*6
      ILIN=(I-1)*5
      LI1=LSWAP(ARR(IARR+1))
      LI2=LSWAP(ARR(IARR+2))
      I1=I1/8
      I2=I2/8
      LINE(ILIN+1)=I1+32*MOD(I2,2)
      LINE(ILIN+2)=I2/2
      ILAST=1
      NFIRST=.FALSE.
      DO 150 I=107,1,-1
      IF(LINE(I).EQ.0)GO TO 120
      IF(NFIRST)GO TO 120
      NFIRST=.TRUE.
      ILAST=I+1
120   IF(LINE(I).LT.32)LINE(I)=LINE(I)+64
150   CONTINUE
      LINE(ILAST)=CTRL_E
      IF(FMTED)WRITE(IOUT,160)(LINE(I),I=1,ILAST)
160   FORMAT(1X,255A1)
      IF(.NOT.FMTED)WRITE(IOUT)(LINE(I),I=1,ILAST)
200   CONTINUE
      RETURN
      END
#endif
