C======================================================================C
C                                                                      C
C  Driver routines for the                         F.W. Jones, TRIUMF  C
C  Seiko GR-1105 colour graphics terminal - MONITOR 2                  C
C                                                                      C
C======================================================================C

      SUBROUTINE SEIKO_PLOT2(X,Y,IPEN)
C======================================================================C
C  Execute a move or draw to location (X,Y)
C======================================================================C
      COMMON/SEIKOPLOT2/IXLOP,IXMIP,IXHIP,IYLOP,IYMIP,IYHIP,NCB
      DATA IXLOP/32/,IXMIP/64/,IXHIP/96/,IYLOP/32/,IYMIP/64/,IYHIP/96/
      DATA NCB/5/
      CHARACTER*1 ESC
      ESC = CHAR(27)  ! modified by J.Chuma, 19Mar97 for g77
C
C Convert to 15-bit ASCII format:
      IX=NINT(X)
      IXLO=IBITS(IX,0,5) + 32
      IXMI=IBITS(IX,5,5) + 64
      IXHI=IBITS(IX,10,5) + 96
      IY=NINT(Y)
      IYLO=IBITS(IY,0,5) + 32
      IYMI=IBITS(IY,5,5) + 64
      IYHI=IBITS(IY,10,5) + 96
C
      IF(IPEN.EQ.3)THEN      !pen up
        CALL SEIKO_BUFF2(ESC)
        CALL SEIKO_BUFF2('A')
      ENDIF
C
C Send X bytes:
      IF(IXHI.NE.IXHIP)THEN
        CALL SEIKO_BUFF2(IXHI)
        IXHIP=IXHI
      ENDIF
      IF(IXMI.NE.IXMIP)THEN
        CALL SEIKO_BUFF2(IXMI)
        IXMIP=IXMI
      ENDIF
      CALL SEIKO_BUFF2(IXLO)
      IXLOP=IXLO
C Send Y bytes:
      IF(IYHI.NE.IYHIP)THEN
        CALL SEIKO_BUFF2(IYHI)
        IYHIP=IYHI
      ENDIF
      IF(IYMI.NE.IYMIP)THEN
        CALL SEIKO_BUFF2(IYMI)
        IYMIP=IYMI
      ENDIF
      CALL SEIKO_BUFF2(IYLO)
      IYLOP=IYLO
C
C Time to send the buffer?
      IF(NCB.GE.70)CALL SEIKO_FLUSH2
      RETURN
      END


      SUBROUTINE SEIKO_CLEAR2
C======================================================================C
C  Clear the screen and initialize the buffer
C======================================================================C
      COMMON/PLOTMONITOR2/IMONITOR2,IOUTM2
      CHARACTER*1 ESC
      ESC = CHAR(27)  ! modified by J.Chuma, 19Mar97 for g77
C
      CALL SEIKO_FLUSH2
      WRITE(IOUTM2,1000)ESC,'K',' ',ESC,'#'
1000  FORMAT(1X,5A1)
      RETURN
      END


      SUBROUTINE SEIKO_FLUSH2
C======================================================================C
C  Send the buffer to the terminal and initialize the next buffer.
C======================================================================C
      COMMON/SEIKOPLOT2/IXLOP,IXMIP,IXHIP,IYLOP,IYMIP,IYHIP,NCB
      CHARACTER*1 ESC
      ESC = CHAR(27)  ! modified by J.Chuma, 19Mar97 for g77
C
      CALL SEIKO_SEND2
      CALL SEIKO_BUFF2(IXHIP)
      CALL SEIKO_BUFF2(IXMIP)
      CALL SEIKO_BUFF2(IXLOP)
      CALL SEIKO_BUFF2(IYHIP)
      CALL SEIKO_BUFF2(IYMIP)
      CALL SEIKO_BUFF2(IYLOP)
      RETURN
      END


      SUBROUTINE SEIKO_BUFF2(ICH)
C======================================================================C
C  Buffers output to the Seiko terminal
C======================================================================C
      CHARACTER ICH
      COMMON/SEIKOPLOT2/IXLOP,IXMIP,IXHIP,IYLOP,IYMIP,IYHIP,NCB
      COMMON/PLOTMONITOR2/IMONITOR2,IOUTM2
      CHARACTER BUFF(80)
CC      DATA (BUFF(I),I=1,5)/27,'K',' ',27,'A'/
      CHARACTER ESC

      ESC = CHAR(27)
      BUFF(1) = ESC
      BUFF(2) = 'K'
      BUFF(3) = ' '
      BUFF(4) = ESC
      BUFF(5) = 'A'
C
      NCB=NCB+1
      BUFF(NCB)=ICH
      RETURN
C
      ENTRY SEIKO_SEND2
C
      IF(NCB.GT.5)THEN
        NCB=NCB+1
        BUFF(NCB)=ESC
        WRITE(IOUTM2,1000)(BUFF(I),I=1,NCB)
      ENDIF
1000  FORMAT(1X,80A1)
      NCB=5
      RETURN
      END
