        INTEGER *4 FUNCTION LL$OAD1(FILNAM,NBYTES)
C======================================================================C
C  Highly modified version of LL$OAD.
C
C  The entire block of virtual memory allocated for the first
C  load operation is kept until any second or subsequent load
C  operation, when the space is returned and re-allocated for
C  the new load.  Thus only one module may be loaded at a time.
C  A call to LIB$SIGNAL has been added to diagnose errors.
C
C                               F.W. Jones, TRIUMF.
C  Modified 06-NOV-91 by FWJ: parameter NBYTES added to allow program
C  control of size of memory block.  Replaces static BYTES_AVAILABLE.
C======================================================================C

C. Doc for LL$OAD follows...
C.
C.      reqd. KOSTL: routines - LINK$LOAD, L$INK, L$OAD
C.
C.              Function to allocate virtual memory, dynamically link
C.      the object file(s) specified in FILNAM, and load them into 
C.      the virtual memory.  This is done by:
C.
C.              (1) Calling LIB$GET_VM  to get virtual memory
C.              (2) Calling LINK$LOAD   to link/load the object files
C.              (3) Calling LIB$FREE_VM to free excess memory
C.
C.      Function LL$OAD returns either:
C.
C.              (1) The ADDRESS of the virtual memory allocated
C.                                      ** or **
C.              (2) Zero if error in LINK$LOAD or virtual routines
C.
C.      After calling LL$OAD, the user routine may be invoked by
C.
C.              CALL EXE_CUT(Arg1,Arg2, ...ArgN,%VAL(IADDR))
C.      where:
C.              Arg1    = 1st  Argument to User Subroutine
C.              Arg2    = 2nd  Argument to User Subroutine
C.                              .       .
C.                              .       .
C.              ArgN    = Last Argument to User Subroutine
C.              IADDR   = INTEGER *4 Value returned by LL$OAD
C.
C.              T. Miles, TRIUMF, 18-Mar-1982
C.
C--->   Specification Statements
C.
        IMPLICIT   INTEGER*4 (A-Z)
        CHARACTER  FILNAM*(*)
        EXTERNAL   SS$_NORMAL
        LOGICAL    FIRST/.TRUE./

C--->   Procedure begins...

C--     Free previously-allocated virtual memory:
        IF(.NOT.FIRST.AND.NBYTES_OLD.GT.0)THEN
          STATUS = LIB$FREE_VM(NBYTES_OLD,BASE_ADDRESS_OLD)
          IF (STATUS .NE. %LOC(SS$_NORMAL)) GOTO 999
        ENDIF
        FIRST=.FALSE.

C--     Allocate new Virtual Memory
        STATUS = LIB$GET_VM(NBYTES,BASE_ADDRESS)
        IF (STATUS .NE. %LOC(SS$_NORMAL)) GOTO 999
        NBYTES_OLD=NBYTES
        BASE_ADDRESS_OLD=BASE_ADDRESS

C--     Do the Link/Load
        CALL LINK$LOAD(FILNAM,%VAL(BASE_ADDRESS),&998)

C--     Success Return
        LL$OAD1 = BASE_ADDRESS
        RETURN

C--     Link/Load failed...
998     LL$OAD1=0
        RETURN

C--     Error in Virtual Memory Routines...
999     CALL LIB$SIGNAL(%VAL(STATUS))
        NBYTES_OLD=0
        LL$OAD1 = 0

        RETURN
        END
