         SUBROUTINE PUT_DCL(IFLAGS,*)
C  
C                               Henry Baragar
C                               TRIUMF, UBC
C                               November 29, 1982
C  
C  reqd. KOSTL: routines - LENSIG, GETPRCNAM
C  
C================================================================
C=                                                              =
C= PUTDCL                                                       =
C=                                                              =
C= PUTDCL will put an interactive user into DCL mode without    =
C= unloading the program being run.  It does this by attaching  =
C= the present process to a subprocess (by spawning it if       =
C= nescessary).  To return to the main program, all the user has=
C= to do is:                                                    =
C=              ATTACH <original process name>                  =
C=       or:                                                    =
C=              RESUME                                          =
C=                                                              =
C= NOTES:   1)  If you have a DCL symbol "RESUME", it gets      =
C=              clobbered during the execution of PUTDCL, but   =
C=              is returned to its previous definition after    =
C=              leaving PUT_DCL.                                =
C=          2)  Rewritten in August of 1984 by Henry Baragar    =
C=              to include an exit handler so that the caller   =
C=              does not need to worry about extraneous         =
C=              subprocesses he left after an image exit.       =
C           3)  Added parameter IFLAGS on January 11, 1988 by J.Chuma
C               IFLAGS is not necessary since NARGS is used to determine
C               the number of arguments.  The default, if IFLAGS is not
C               passed as a parameter, is IFLAGS = 0. 
C               See the `Run-Time Library Routines Reference Manual'
C               November, 1984  pages RTL-262, RTL-263
C
C              IFLAGS =  0  ==>     symbols,    logicals,    keypad
C                     =  2  ==>  no symbols,    logicals,    keypad
C                     =  4  ==>     symbols, no logicals,    keypad
C                     =  6  ==>  no symbols, no logicals,    keypad
C                     =  8  ==>     symbols,    logicals, no keypad
C                     = 10  ==>  no symbols,    logicals, no keypad
C                     = 12  ==>     symbols, no logicals, no keypad
C                     = 14  ==>  no symbols, no logicals, no keypad


        IMPLICIT INTEGER*4 (A-Z)
        EXTERNAL SS$_NORMAL
        EXTERNAL PUT_DCL_CLEANUP
        COMMON /PUTDCL/ ISTAT, ID_SUB
        CHARACTER*15 PRC_NAM, GET_PRCNAM
        CHARACTER*255 PREVIOUS_SYM
        INTEGER STATUS /1/
        INTEGER*4 EXIT_BLOCK(7) 
C
        INTEGER*4 VALID(8) 
        DATA NVALID /8/, VALID /0,2,4,6,8,10,12,14/
        IF( NARGS(DUM) .EQ. 1 )THEN
C
C   IFLAGS parameter is present, so test to see if it is a valid number
C
          DO II = 1, NVALID
            IF( IFLAGS .EQ. VALID(II) )GO TO 10
          END DO
          WRITE(*,*)' *** invalid flag passed to PUT_DCL'
          RETURN 1
10        FLAG = IFLAGS
        ELSE
C
C   This is the default:  symbols, logicals, keypad
C
          FLAG = 0
        END IF
C  
C  Try attaching to the process specified by ID_SUB  -- if that 
C  doesn't work, define RESUME, spawn a new subprocess, and set
C  up an EXIT handler to get rid of it when the program exits.
C  NB.  See $DCLEXH and $DELPRC in the VAX/VMS System Services -
C       Reference Manual for full details on exit handlers and 
C       deleting processes.
C  
        IF (LIB$ATTACH(ID_SUB) .NE. %LOC(SS$_NORMAL)) THEN
            PREVIOUS_SYM = ' '
            LENS = 0
            REASON = 1
            CALL LIB$GET_SYMBOL('RESUME',PREVIOUS_SYM,%REF(LENS))
            PRC_NAM = GET_PRCNAM(LEN)
C
C  Modified by J. Chuma, Nov 30/88 
C  put in "'s around PRC_NAM to allow for blanks in process name
C
            CALL 
     #       LIB$SET_SYMBOL('RESUME','ATTACH "'//PRC_NAM(:LEN)//'"')
            ISTAT = LIB$SPAWN(,,,FLAG,,ID_SUB)
            IF (ISTAT .EQ. %LOC(SS$_NORMAL)) THEN
                EXIT_BLOCK(1) = 0
                EXIT_BLOCK(2) = %LOC(PUT_DCL_CLEANUP)
                EXIT_BLOCK(3) = 4
                EXIT_BLOCK(4) = %LOC(REASON)
                EXIT_BLOCK(5) = %LOC(ID_SUB)
                EXIT_BLOCK(6) = %LOC(PREVIOUS_SYM)
                EXIT_BLOCK(7) = %LOC(LENS)
                ISTAT = SYS$DCLEXH(EXIT_BLOCK)
            ENDIF
        ENDIF
        IF (ISTAT .NE. %LOC(SS$_NORMAL)) RETURN 1
        RETURN
        END
C  
C  This is the routine that deletes the created subprocess
C  and undoes the symbol RESUME.
C  
        SUBROUTINE PUT_DCL_CLEANUP(REASON,ID_SUB,PREVIOUS_SYM,LENS)
        IMPLICIT INTEGER (A-Z)
        CHARACTER*(*) PREVIOUS_SYM
        EXTERNAL SS$_NORMAL, SS$_NONEXPR
        ISTAT = SYS$DELPRC (ID_SUB,)
        IF (ISTAT.NE.%LOC(SS$_NORMAL) .AND. ISTAT.NE.%LOC(SS$_NONEXPR))
     +      CALL LIB$SIGNAL(%VAL(ISTAT))
        IF (LENS .EQ. 0) THEN
            CALL LIB$DELETE_SYMBOL('RESUME')
        ELSE
            CALL LIB$SET_SYMBOL('RESUME',PREVIOUS_SYM(:LENS))
        ENDIF
        RETURN
        END
