      SUBROUTINE WRITE_HPJETC(IOUT,ARRAY,ND1,N1,N2,
     &                        SUPPRESS_NULLS,LASER,*)
C======================================================================C
C                                                                      C
C  WRITE_HPJETC                                    F.W. Jones, TRIUMF  C
C                                                  C.J. Kost,  TRIUMF  C
C  Analogue to WRITE_HPJET with run length encoding                    C
C  Writes the Printronix bitmap stored in ARRAY to unit IOUT           C
C  in HP Laserjet or HP Thinkjet format.                               C
C                                                                      C
C  By default, the bitmap is stored in ARRAY in Printronix format,     C
C  with 6 significant bits per byte.  Since the HP printers use        C
C  8 significant bits per byte, each group of 4 bytes from ARRAY       C
C  is compressed into 3 bytes for output to the plot file.             C
C                                                                      C
C  The bitmap in ARRAY consists of N2 lines of N1 bytes, where N1      C
C  is at most 188.  The maximum line length is 188*6=1128 dots.        C
C                                                                      C
C  If SUPPRESS_NULLS is set to .TRUE., any blank dot lines at the      C
C  end of the bitmap will not be sent.                                 C
C                                                                      C
C  Modified June 9/86 by F.W. Jones:  The plot file is now written     C
C  using the IOFAST routines, improving the speed by a factor of 2.    C
C                                                                      C
C  Modified Nov 19/86 by F.W. Jones:  Option added to make bitmap      C
C    file for TeX inclusion, by setting LASER=2.                       C
C  Modified Dec 15/86 by F.W. Jones:  Entry point HPJET_DENSITY added  C
C    to manually set the density (HP Laserjet only).                   C
C  Modified Mar 25/87 by F.W. Jones:  records written to the plot      C
C    file are now variable in length and are automatically truncated   C
C    to remove trailing zeros.  This has been done to reduce the high  C
C    overheads in file space and processing time.  In addition, the    C
C    suppression of trailing blank lines has been made mandatory, and  C
C    the flag SUPPRESS_NULLS is ignored.                               C
C  Modified Jan 19/88 by F. Jones:  This routine has been re-written   C
C    to reflect a change in internal bitmap storage from Printronix    C
C    format (6 significant bits per byte) to HP Laserjet format        C
C    (8 significant bits per byte).                                    C
C  Modified May 15/89 by F.W. Jones:  An additional option LASER=3     C
C    has been added to allow auto-justified TeX output.  Leading       C
C    zeros are suppressed so that the nonzero portion of the image     C
C    starts at the current writing position on the page.  This         C
C    eliminates unwanted margins when placing TeX figures.             C
C  Modified Jan 4/90 by C.Kost to add run-length encoding              C
C                                                                      C
C  Modified 08-MAR-94 by FWJ: removed VMS IOFAST dependency, since     C
C  IOFAST is not available on ALPHA VMS.                               C
C                                                                      C
C  If LASER=0 HP ThinkJet                                              C
C     LASER=1 non-TeX HP LaserJet                                      C
C     LASER=2 TeX inclusion                                            C
C     LASER=3 justified TeX inclusion                                  C
C     LASER=4 non-TeX HP LaserJet appended                             C
C  Modified 1-Feb-95 by J.Chuma:  allow appended plot files            C
C                                                                      C
C======================================================================C
      SAVE

      BYTE ARRAY(ND1,N2)
      LOGICAL SUPPRESS_NULLS

      COMMON /HARDCOPYRANGE2/ XMINH2,XMAXH2,YMINH2,YMAXH2

C   Output buffer:

      BYTE BUFFER(383)   !188*2+7
      CHARACTER*383 CBUFFER
      EQUIVALENCE (BUFFER,CBUFFER)

      BYTE LESC, CW, STAR, SB
      DATA LESC /27/, CW /87/, STAR /42/, SB /98/

      CHARACTER*1 ESC,FF

      CHARACTER*(*) DENS_IN   ! used in entry point

      LOGICAL AUTO_DENSITY
      CHARACTER*3 DENS
      COMMON /BIT_DENS/ AUTO_DENSITY, DENS
CCC
      ESC=CHAR(27)
      FF=CHAR(12)
      IBITS=INT(YMAXH2)+1  ! Find extent of bitmap data
      JBITS=INT(XMAXH2)+1
      IEND_MAX=(IBITS+7)/8
      IEND_MAX=MIN(IEND_MAX,188)      !To avoid buffer overflow
      JEND_MAX=MIN(JBITS,N2)
      DO JEND=JEND_MAX,1,-1
        DO I=1,IEND_MAX
          IF( ARRAY(I,JEND).NE.0 )GO TO 50
        END DO
      END DO
      JEND=1
   50 IBEG=1   ! Normal start of bitmap data
      JBEG=1

      IF( AUTO_DENSITY )THEN
        DENS='100'
        IF( IBITS.GT.750 )DENS='150'
        IF( IBITS.GT.1125 )DENS='300'
      END IF

C Reset, set density, set left margin, start raster graphics, set
C to run-length encoding compression mode

      IF( LASER.EQ.1 )THEN
        WRITE(IOUT,*,ERR=999)ESC//'E'//ESC//'*t'//DENS//'R'//
     &   ESC//'&a4C'//ESC//'*r1A'//ESC//'*b1M'
      ELSE IF( LASER.EQ.2 )THEN  ! TeX output - no reset, no positioning
        WRITE(IOUT,*,ERR=999)ESC//'*t'//DENS//'R'//
     &   ESC//'*r1A'//ESC//'*b1M'
      ELSE IF( LASER.EQ.3 )THEN  ! justified TeX output
        IBEG=IEND_MAX    ! Find additional cropping limits
        JBEG=0
        DO 60 J=1,JEND
          DO I=1,IEND_MAX
            IF( ARRAY(I,J).NE.0 )THEN
              IF( JBEG.EQ.0 )JBEG=J
              IBEG=MIN(IBEG,I)
              GO TO 60
            END IF
          END DO
   60   CONTINUE
        IF(JBEG.EQ.0)JBEG=1
        WRITE(IOUT,*,ERR=999)ESC//'*t'//DENS//'R'//
     &   ESC//'*r1A'//ESC//'*b1M'
      ELSE IF( LASER.EQ.4 )THEN   ! non-TeX appended
        WRITE(IOUT,*,ERR=999)FF//ESC//'*t'//DENS//'R'//
     &   ESC//'&a4C'//ESC//'*r1A'//ESC//'*b1M'
      END IF
      BUFFER(1)=LESC   ! Header for pixel scan-line buffer
      BUFFER(2)=STAR
      BUFFER(3)=SB
      NBYTES=2*IEND_MAX
      DO 100 J=JBEG,JEND
        CALL ZERO_ARRAY(BUFFER(8),NBYTES)    ! leave first 7 bytes alone
        BUFFER(7)=CW                         ! set BUFFER to ESC*bnnnW

C   Load first byte of a pair of bytes with repeat count.
C   A zero means the pattern isn't repeated,
C      that is it occured only once.
C    The second of the byte pairs contains the byte pattern.

        BUFFER(9)=ARRAY(IBEG-1+1,J)
        ILAST=IBEG
        NBYTES=2

C Find number of bytes to get from current scan line:

        DO IEND=IEND_MAX,IBEG,-1
          IF( ARRAY(IEND,J).NE.0 )GO TO 80
        END DO
        IEND=IBEG          ! Empty line
   80   NPUT=IEND-IBEG+1
        DO I=IBEG+1,IEND
          IF( ARRAY(I,J).NE.ARRAY(I-1,J) )THEN ! Pattern changed
            NREPEAT=I-ILAST-1
            ILAST=I
            IF( NREPEAT.LE.255 )THEN
              CBUFFER(NBYTES+6:NBYTES+6)=CHAR(NREPEAT)
              NBYTES=NBYTES+2
            ELSE
              CBUFFER(NBYTES+6:NBYTES+6)=CHAR(255)
              CBUFFER(NBYTES+8:NBYTES+8)=CHAR(NREPEAT-255-1)
              BUFFER(NBYTES+9)=BUFFER(NBYTES+7)
              NBYTES=NBYTES+4
            END IF

C   Load new pattern (into location 11,13,15 etc)

            BUFFER(NBYTES+1+6)=ARRAY(I,J)   
          END IF
        END DO

C   Take care of case where we run out of loop
C   (or exit it because scan line was empty)

        NREPEAT=IEND-ILAST
        IF( NREPEAT.LE.255 )THEN
          CBUFFER(NBYTES+6:NBYTES+6)=CHAR(NREPEAT)
        ELSE
          CBUFFER(NBYTES+6:NBYTES+6)=CHAR(255)
          CBUFFER(NBYTES+8:NBYTES+8)=CHAR(NREPEAT-255-1)
          BUFFER(NBYTES+9)=BUFFER(NBYTES+7)
          NBYTES=NBYTES+2
        END IF

C   Load bytes 4,5,6 of BUFFER with number of data bytes (from NBYTES)

        N100=NBYTES/100               ! number of hundreds
        N10=(NBYTES-N100*100)/10      ! number of tens
        N0=(NBYTES-N100*100-N10*10)   ! number of ones
        BUFFER(4)=N100+48             ! Character 0 is 48 decimal
        BUFFER(5)=N10+48
        BUFFER(6)=N0+48
        WRITE(IOUT,*,ERR=999)CBUFFER(1:NBYTES+7)  !+7 for control bytes
  100 CONTINUE

C End raster graphics, page eject

      WRITE(IOUT,*,ERR=999)ESC//'*b0M'   ! end compression mode
      WRITE(IOUT,*,ERR=999)ESC//'*rB'
      IF( (LASER.EQ.2) .OR. (LASER.EQ.3) )
     & WRITE(IOUT,*,ERR=999)ESC//'*rB' ! fix line-eating bug in DVIHP
      RETURN
  999 WRITE(*,*)'Error writing bitmap file on unit',IOUT
      CALL FORMSG
      RETURN 1

C Entry point to pre-set and inquire about the density

      ENTRY HPJETC_DENSITY( DENS_IN )

      IF( (DENS_IN.EQ.'100') .OR. (DENS_IN.EQ.'150') .OR.
     &    (DENS_IN.EQ.'300') )THEN
        AUTO_DENSITY=.FALSE.
        DENS=DENS_IN
      ELSE IF( DENS_IN.EQ.'AUT' )THEN
        AUTO_DENSITY=.TRUE.
      ELSE IF( DENS_IN.EQ.'INQ' )THEN      !inquire density
        IF( AUTO_DENSITY )THEN
          DENS_IN='AUT'
        ELSE
          DENS_IN=DENS
        END IF
      END IF
      RETURN
      END
