      SUBROUTINE CHECK_BUFFER2
C======================================================================C
C                                                                      C
C    CHECK_BUFFER2: checks to see if the plot buffer is full.          C
C                   If it isn't full yet, and we are in buffer         C
C                   mode (i.e. IMODE = 1) then return.                 C
C                   If it is full or we are in direct mode (i.e.       C
C                   IMODE = 2), then print the plot buffer to          C
C                   the screen and set up the plot buffer to           C
C                   plot a dark (null) vector at the last point        C
C                   plotted on the screen.                             C
C                                                                      C
C     Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.           C
C                                                                      C
C     Modified Oct. 24/83 by F.W. Jones in conjuction with             C
C     modifications to PLOT_MONITOR2 to speed up display.              C
C     see PLOT_MONITOR2 source code for details.                       C
C                                                                      C
C  Modified June 25/84 by F.W. Jones:                                  C
C  Entry point FLUSH_BUFFER2 added.  This is used by FLUSH_PLOT.       C
C                                                                      C
C  Modified August/84 by F.W. Jones to include the VT241.              C
C  Modified Oct 7/85 by F.W. Jones to include the Plessey PT100G.      C
C  Modified Nov/88 by J.Chuma to include the LN03+                     C
C                                                                      C
C======================================================================C
      COMMON /PLOTMONITOR2/ IMONITOR2,IOUTM2
      COMMON /PLOT_BUFFER2/ INDEX,IMODE,BUFFER
      BYTE BUFFER(78)         ! Modified by J.Chuma, 19Mar97 for g77
C                               BUFFER was LOGICAL*1
C Previous TEK codes:
      COMMON/TEK_PREVIOUS2/IYHIP2,IYLOP2,IXHIP2,IXLOP2,IEXTRAP2

      IF(INDEX.LE.64.AND.IMODE.EQ.1)RETURN

C INDEX > 64 (buffer is full) or IMODE = 2 (direct mode)...

      ENTRY FLUSH_BUFFER2

      IF(IMONITOR2.EQ.8)GO TO 100

      CALL PACK_BUFFER2(31)
      CALL PRINT_BUFFER2

C Move with pen up to the last point plotted on the screen.
C We must pack all four bytes for the first vector as the terminal
C may receive other data before the next buffer is printed.

      CALL PACK_BUFFER2(29)   ! GS: Graphics control code.
      CALL PACK_BUFFER2(IYHIP2)
      IF(IMONITOR2.EQ.9.OR.IMONITOR2.EQ.16)CALL PACK_BUFFER2(IEXTRAP2)
      CALL PACK_BUFFER2(IYLOP2)
      CALL PACK_BUFFER2(IXHIP2)
      CALL PACK_BUFFER2(IXLOP2)

      RETURN

C VT241:
100   INDEX_S=INDEX
      CALL PRINT_BUFFER2
      IF(INDEX_S.LT.10)RETURN
C Penup move to last location plotted:
      BUFFER(1)=ichar('P')
      CALL MOVEC(9,BUFFER(INDEX_S-8),BUFFER(2))
      INDEX=10

      END
