      SUBROUTINE CLEAR_PLOT
C======================================================================C
C                                                                      C
C  CLEAR_PLOT: clears monitor 1 if IMONITOR .NE. 0                     C
C              clears monitor 2 if IMONITOR2 .NE. 0                    C
C              clears the bitmap if IORIENTH .NE. 0                    C
C                                                                      C
C  Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.              C
C                                                                      C
C  Modified by Alan Carruthers, March 15, 1983.                        C
C  --Three flags added (CLEAR1, CLEAR2 and CLEARH) to indicate if      C
C    monitor 1, monitor 2 or hardcopy have been cleared since          C
C    application program started executing or since last plot was      C
C    terminated, whichever is more recent.                             C
C  --CLEARUNC flag indicates if monitors and hardcopy (if active) are  C
C    to be cleared regardless of the settings of CLEAR1, CLEAR2, or    C
C    CLEAR3. If CLEARUNC = .FALSE., then monitors and hardcopy will be C
C    cleared only if their respective CLEAR1, CLEAR2 or CLEARH flags   C
C    are .FALSE.                                                       C
C                                                                      C
C  Modified by Alan Carruthers, July 15, 1983.                         C
C    --call to PUT_METAFILE1 added to support metafile                 C
C  Modified by Joe Chuma, December 5, 1983 to include the              C
C    Hewlett-Packard plotter                                           C
C  Modified by Bernard Henin, July 1984, to include the                C
C    TEKTRONIX 4107.                                                   C
C  Modified by F.W. Jones, August/84, to include the VT241.            C
C  Modified by F.W. Jones, Jan 29/85:                                  C
C   To improve plotting performance, flag BITMAP_EMPTY has             C
C   been added to inhibit clearing of the bitmap when nothing          C
C   has been written into it.  BITMAP_EMPTY is initially true,         C
C   and is set true whenever the bitmap is cleared.  It is set         C
C   false when something is written into the bitmap by PLOT_HARDCOPY.  C
C  Modified Dec 4/85 by F. Jones for the QMS Lasergrafix.              C
C  Modified July 21/86 by J. Chuma to open the scratch files on        C
C    SYS$SCRATCH.                                                      C
C  Modified Aug 11/86 by F.W. Jones to include the Houston             C
C    Instruments plotter.                                              C
C  Modified Sept 3/86 by C. Kost to delete .SCRATCH files upon image   C
C    run-down                                                          C
C  Modified Mar 20/87 by F. Jones for Seiko GR-1105 terminal support   C
C  Modified Nov 10/87 by C. Kost to include HPPaintjet bitmap          C
C  Modified Nov 27/87 by F. Jones.  Some terminals home the alpha      C
C    cursor even though the alpha screen is not cleared during a       C
C    graphics clear.  To avoid this, the alpha cursor is saved         C
C    before clearing the graphics screen and then restored to its      C
C    former position.                                                  C
C  Modified Nov 27/87 by F. Jones.  The code has been restructured     C
C    for clarity and easier maintenance.                               C
C  Modified by J.Chuma Nov 14/88   Support LN03+ as device 16          C
C  Modified by J.Chuma May 10/89   generic terminal as device 17       C
C  Modified by F.Jones Sep 05/89   VS DecWindows as device 18          C
C  Modified by F.Jones Nov 09/89   GKS Metafile as device 19           C
C  Modified by F.Jones Dec 05/89   Modified for HP Laserjet 300dpi     C
C    using dynamic bitmap (IBIT=32).  Also fixed a bug: MAXLINES       C
C    should not be set when the dynamic bitmap is being used.          C
C  Modified by J.Chuma Jan 04/90   Modified for HP Laserjet 300dpi     C
C    using dynamic bitmap (IBIT=132) to allow compression.             C
C  Modified by J.Chuma Oct 16/90   Support RD-GLII as device 20        C
C  Modified by J.Chuma May 01/91   Fixed logic for BITMAP_GET_VM       C
C  Modified by F.Jones May 01/91   Telidon Metafile o/p removed        C
C  Modified by F.Jones Mar 23/92   Added PID to UNIX scr file names    C
C  Modified by J.Chuma Jan 04/93   LN03 doesn't need to save and       C
C                                  restore the cursor location         C
C  Modified by J.Chuma Feb 08/93   PID, and LPID set when VMS          C
C  Modified 19-AUG-93 by FWJ: Zeta, QMS and UIS support removed        C
C  Modified 09-MAY-95 by FWJ: changed file open status to 'UNKNOWN'    C
C    to support platforms where DISPOSE='DELETE' is not available.     C
C    This will overwrite an existing file of the same name.            C
C  Modified 23-Oct-96 by JLC: IOUTM2 default value changed from 6 to 7 C
C  Modified 13-NOV-97 by FWJ for LINUX absoft                          C
C                                                                      C
C======================================================================C

      COMMON /PLOTMONITOR/ IMONITOR,IOUTM
      DATA IMONITOR,IOUTM/1,6/
      COMMON /PLOTMONITOR2/ IMONITOR2,IOUTM2
      DATA IMONITOR2,IOUTM2/0,7/
      COMMON/PLOT_INPUT_UNIT/IINS
      DATA IINS/5/
      COMMON/PLOT_OUTPUT_UNIT/IOUTS
      DATA IOUTS/6/

      COMMON /PLOT_COLOURS/ICOLR1,ICOLR2
      DATA ICOLR2/1/
      COMMON /GPLOT_NUMBER_FIRST/FIRSTN
      COMMON /CIT_COLOUR/ICITCOL1,ICITCOL2
      DATA ICITCOL1,ICITCOL2/6,6/
      COMMON /GPLOT_PSALPH/ITALICS, ANGL, ANGL_OLD
      LOGICAL ITALICS
      DATA ITALICS/.FALSE./
      COMMON /GPLOT_BOLDING/BOLD
      LOGICAL BOLD
      DATA BOLD/.FALSE./
      COMMON /GLOT_CONTROLS/CTRL
      CHARACTER*2 CTRL
      DATA CTRL/'<>'/
      COMMON /MONITOR_SIZE/XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE
      DATA XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE/0.,639.,0.,479./
      COMMON /MONITOR2_SIZE/XMINMSIZE2,XMAXMSIZE2,
     *                      YMINMSIZE2,YMAXMSIZE2
      DATA XMINMSIZE2,XMAXMSIZE2,YMINMSIZE2,YMAXMSIZE2
     *     /0.,639.,0.,479./
      COMMON /PLOT_TO_MONITOR/RMATRIXMP(2,2),SHIFTMP(2)
      DATA RMATRIXMP/1.,0.,0.,1./,SHIFTMP/0.,0./
      COMMON /PLOT_TO_MONITOR2/RMATRIXMP2(2,2),SHIFTMP2(2)
      DATA RMATRIXMP2/1.,0.,0.,1./,SHIFTMP2/0.,0./
      COMMON /MONITOR_TO_PLOT/RMATRIXPM(2,2),SHIFTPM(2)
      DATA RMATRIXPM/1.,0.,0.,1./,SHIFTPM/0.,0./
      COMMON /HARDCOPY_TO_MONITOR/RMATRIXMH(2,2),SHIFTMH(2)
      DATA RMATRIXMH/0.,-1.,1.,0./,SHIFTMH/0.,479./
      COMMON /HARDCOPY_TO_MONITOR2/RMATRIXMH2(2,2),SHIFTMH2(2)
      DATA RMATRIXMH2/0.,-1.,1.,0./,SHIFTMH2/0.,479./
      COMMON /CALL_MONITOR_RANGE/MONITOR_RANGE_CALLED
      LOGICAL MONITOR_RANGE_CALLED
      DATA MONITOR_RANGE_CALLED /.FALSE./
      CHARACTER*1 BACKSLASH

      COMMON /PLOT_CLEAR/ CLEAR
      LOGICAL CLEAR/.TRUE./
      COMMON /PLOT_PREVIOUS/ XP,YP,IPENP
      DATA XP,YP,IPENP/0.,0.,0/
      COMMON /PLOT_BUFFER/ INDEX,IMODE,BUFFER(78)
      BYTE BUFFER           ! modified by J.Chuma, 19Mar97 for g77
C                             was LOGICAL*1
      DATA INDEX,IMODE/0,1/
      COMMON /PLOT_BUFFER2/ INDEX2,IMODE2,BUFFER2(78)
      LOGICAL*1 BUFFER2
      DATA INDEX2,IMODE2/0,1/
      COMMON /PLOTHARDCOPY/ XLAST,YLAST,N1,N2,HARDCOPY(188,2048)
      LOGICAL*1 HARDCOPY
      DATA XLAST,YLAST,N1,N2/0.,0.,188,2048/
      COMMON /HARDCOPYRANGE/ XMINHP,XMAXHP,YMINHP,YMAXHP,IORIENTH
      DATA XMINHP,XMAXHP,YMINHP,YMAXHP/0.,639.,0.,479./
      DATA IORIENTH/-1/
      COMMON /HARDCOPYRANGE2/ XMINH2,XMAXH2,YMINH2,YMAXH2
      DATA XMINH2,XMAXH2,YMINH2,YMAXH2/0.,479.,0.,639./

      COMMON /PLOT_TO_HARDCOPY/ RMATRIXHP(2,2),SHIFTHP(2)
      DATA RMATRIXHP/0.,1.,-1.,0./SHIFTHP/479.,0./
      COMMON /MONITORRANGE/XMINMP,XMAXMP,YMINMP,YMAXMP,
     *                      XMINM, XMAXM, YMINM, YMAXM
      DATA XMINMP,XMAXMP,YMINMP,YMAXMP/0.,639.,0.,479./
      DATA XMINM, XMAXM, YMINM, YMAXM /0.,639.,0.,479./
      COMMON /MONITOR2RANGE/XMINMP2,XMAXMP2,YMINMP2,YMAXMP2,
     *                       XMINM2, XMAXM2, YMINM2, YMAXM2
      DATA XMINMP2,XMAXMP2,YMINMP2,YMAXMP2/0.,639.,0.,470./
      DATA XMINM2 ,XMAXM2, YMINM2, YMAXM2 /0.,639.,0.,479./
      COMMON /TEK_PREVIOUS/IYHIP,IYLOP,IXHIP,IXLOP,IEXTRAP
      DATA IYHIP,IYLOP,IXHIP,IXLOP,IEXTRAP/0,0,0,0,0/
      COMMON /TEK_PREVIOUS2/IYHIP2,IYLOP2,IXHIP2,IXLOP2,IEXTRAP2
      DATA IYHIP2,IYLOP2,IXHIP2,IXLOP2,IEXTRAP2/0,0,0,0,0/
      COMMON /GPLOT_CALLED/CALLED_FROM_GPLOT
      LOGICAL CALLED_FROM_GPLOT
      DATA CALLED_FROM_GPLOT/.FALSE./
      COMMON /CALLED/PALPCD,PSYMCD,XC,YC
      LOGICAL PALPCD, PSYMCD
C  Modified by J.Chuma, 23Apr97 for Absoft f77  changed X' to Z'
      DATA PALPCD,PSYMCD,XC,YC/.FALSE.,.FALSE.,
     &                         Z'80000000',Z'80000000'/
      COMMON /PLOT_LEVEL/ILEV
      DATA ILEV/0/
      COMMON /PLOT_LEVEL2/ILEV2
      DATA ILEV2/0/
      COMMON /PLOT_MONITOR_DOPLOT/ MUST_DO_PLOT
      LOGICAL MUST_DO_PLOT
      DATA MUST_DO_PLOT/.FALSE./
      COMMON /MODE/ASIS
      LOGICAL ASIS
      DATA ASIS/.FALSE./
      COMMON /SPOOL/FMTED
      LOGICAL FMTED
      DATA FMTED/.TRUE./
      COMMON /CURSOR_PRESET/CSET
      LOGICAL CSET
      COMMON /CURSOR_PARAMS/XOLD,YOLD,PREV,BUPDATE,FULCUR,ENABLE_VAST
      LOGICAL PREV/.FALSE./,BUPDATE/.FALSE./,FULCUR/.FALSE./
      LOGICAL ENABLE_VAST
C
C  PL_CLEARER added  April 16, 1991
C  Simple flag set true in CLEAR_PLOT and set false in PLOT_R
C  to tell when CLEAR_PLOT has been called
C
      COMMON /PLOT_CLEARED/PL_CLEAR_M, PL_CLEAR_M2, PL_CLEARER
      LOGICAL PL_CLEAR_M/.FALSE./, PL_CLEAR_M2/.FALSE./
      LOGICAL PL_CLEARER/.FALSE./
      COMMON /PLOT_CLEAR_A/CLEAR1, CLEAR2, CLEARH, CLEARUNC
      LOGICAL CLEAR1, CLEAR2, CLEARH, CLEARUNC, NCLEARUNC
      DATA CLEAR1/.FALSE./, CLEAR2/.FALSE./, CLEARH/.FALSE./,
     &     CLEARUNC/.TRUE./

      COMMON/BITMAP_STATUS/BITMAP_EMPTY,MAXLINES
      LOGICAL BITMAP_EMPTY/.TRUE./
      INTEGER MAXLINES/480/
      COMMON/BITMAP_DEVICE/IBIT
      DATA IBIT /0/
      COMMON/GRAPHICS_BITMAP/HPAINT,NBYTES,IOFFSET,NXDIM,NYDIM,MAXY
      LOGICAL*1 HPAINT(4)
      INTEGER IBITOLD/0/, NBYTESOLD /0/
      COMMON/BIT_DENS/AUTO_DENSITY,DENS
      CHARACTER*3 DENS
      LOGICAL AUTO_DENSITY/.TRUE./

      INTEGER*4 LWIDTH    ! bitmap line thickness
      COMMON /PLOT_HARDCOPY_LINEWIDTH/ LWIDTH
      DATA LWIDTH/1/

      INTEGER*4 PWIDTH    ! postscript line thickness
      COMMON /POSTSCRIPT_LINEWIDTH/ PWIDTH
      DATA PWIDTH/2/

      CHARACTER*1 FF,CAN,ESC,GS

      CHARACTER*80 TMP
#ifdef VMS
      CHARACTER*15 PID
      EXTERNAL JPI$_PID
      TMP = 'SYS$SCRATCH:'
      PID = ' '
      LPID = 1
      CALL LIB$GETJPI(%LOC(JPI$_PID),,,,PID,LPID)
#else
      CHARACTER*15 GET_PRCNAM,PID
      CALL GETENV('SYS_SCRATCH',TMP)
      IF(TMP.EQ.' ') THEN
C Workaround for SUNOS bug: can't do system() call if using /tmp!
#ifdef sun
        CALL GETENV('HOME',TMP)
        IF(TMP.EQ.' ')TMP='/tmp'
        TMP = TMP(1:LENSIG(TMP))//'/'
#else
        TMP= '/tmp/'
#endif
      ELSE
        TMP = TMP(1:LENSIG(TMP))//'/'
      END IF
      PID=GET_PRCNAM(LPID)
#endif
      LTMP = LENSIG(TMP)
      FF = CHAR(12)
      CAN = CHAR(24)
      ESC = CHAR(27)
      GS = CHAR(29)

C==================================================================
C==  If IBIT=IBITOLD and is 5,32, or 132 and BITMAP_EMPTY is true
C==  then dont free/get memory. ADDED DEC 18/90 C.J.K.
C==================================================================
      IF(IBIT.EQ.IBITOLD .AND. BITMAP_EMPTY .AND. 
     & ( (IBIT.EQ.5).OR.(IBIT.EQ.32).OR.(IBIT.EQ.132)) .AND.
     & ( NBYTESOLD .EQ. NXDIM*NYDIM )   )
     &  GO TO 10

      IF(NBYTES.NE.0)CALL BITMAP_FREE_VM(ISTAT)
      IF(IBIT.EQ.5 .OR. IBIT.EQ.32 .OR. IBIT.EQ.132)
     & CALL BITMAP_GET_VM(ISTAT)
      IBITOLD=IBIT
      NBYTESOLD = NBYTES

  10  CLEAR = .FALSE.
      NCLEARUNC = .NOT. CLEARUNC
      XP=0.          ! Initialize previous x-coordinate.
      YP=0.          ! Initialize previous y-coordinate.
      IPENP=0        ! Initialize previous pen value.
      INDEX=0        ! Initialize terminal buffer 1
      INDEX2=0       ! Initialize terminal buffer 2

C======================================================================C
C  Clear monitor 1
C======================================================================C
      IF(IMONITOR.EQ.0)GO TO 200
      IF(NCLEARUNC .AND. CLEAR1)GO TO 200
      PL_CLEAR_M = .TRUE.  !flag for telling PLOT_MONITOR that
C                           plot has just been cleared
      CLEAR1 = .TRUE.
      PL_CLEARER = .TRUE.  

C FORMAT modified for Unix compatibility 14-NOV-91 by FWJ
C1000 FORMAT('+',A,$)      !format for terminal clear
 1000 FORMAT(' ',A,$)      !format for terminal clear

      BACKSLASH = CHAR(92)  ! modified by J.Chuma, 19Mar97 for g77
C VT640 & PT100G
      IF(IMONITOR.EQ.1.OR.IMONITOR.EQ.9)THEN
        WRITE(IOUTM,1000)GS//CAN//ESC//'7'//GS//ESC//FF
        CALL SLEEP2(0.5)
        WRITE(IOUTM,1000)GS//CAN//ESC//'8'

C Tek 4010
      ELSE IF(IMONITOR.EQ.2)THEN
        WRITE(IOUTM,1000)GS//ESC//FF
        CALL SLEEP2(0.5)

C HP plotter:
      ELSE IF(IMONITOR .EQ. 5)THEN
#ifdef VMS
         CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=12)
12       OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'HPP.SCR'//PID(1:LPID),
     &     CARRIAGECONTROL='LIST',STATUS='UNKNOWN',DISPOSE='DELETE',
     &     ERR=199)
#elif g77
         CLOSE(UNIT=IOUTM,ERR=12)
12       OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'HPP.SCR'//PID(1:LPID),
     &     STATUS='UNKNOWN',ERR=199)
#elif gfortran
         CLOSE(UNIT=IOUTM,ERR=12)
12       OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'HPP.SCR'//PID(1:LPID),
     &     STATUS='UNKNOWN',ERR=199)
#elif absoft
         CLOSE(UNIT=IOUTM,STATUS='DELETE',ERR=12)
12       OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'HPP.SCR'//PID(1:LPID),
     &     STATUS='UNKNOWN',DISPOSE='DELETE',
     &     ERR=199)
#else
         CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=12)
12       OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'HPP.SCR'//PID(1:LPID),
     &     CARRIAGECONTROL='LIST',STATUS='UNKNOWN',DISPOSE='DELETE',
     &     ERR=199)
#endif
         CALL HP_PLOTS(IOUTM)

C CIT467
      ELSE IF(IMONITOR.EQ.6)THEN
        WRITE(IOUTM,1000)ESC//'2'//ESC//'7'//GS//ESC//FF
        CALL SLEEP2(0.5)
        WRITE(IOUTM,1000)ESC//'2'//ESC//'8'

C Tek 4107
      ELSE IF(IMONITOR.EQ.7)THEN
        WRITE(IOUTM,1000)ESC//'%!1'//ESC//'7'//ESC//'%!0'//ESC//FF
        CALL SLEEP2(0.5)
        WRITE(IOUTM,1000)ESC//'%!1'//ESC//'8'

C VT241:
      ELSE IF(IMONITOR.EQ.8)THEN
C If in transparent mode, home the cursor:
        WRITE(IOUTM,1000)ESC//BACKSLASH//ESC//'[2J'//ESC//'[1;1H'
        CALL REGIS_MODE
        WRITE(IOUTM,1000)'W(F15)'   ! JLC  Nov 28/88

C Houston Instruments plotter:
      ELSE IF(IMONITOR.EQ.11)THEN
#ifdef VMS
        CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=14)
14      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'HOUSTON.SCR'//PID(1:LPID),
     &    CARRIAGECONTROL='LIST',STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=199)
#elif g77
        CLOSE(UNIT=IOUTM,ERR=14)
14      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'HOUSTON.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',ERR=199)
#elif gfortran
        CLOSE(UNIT=IOUTM,ERR=14)
14      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'HOUSTON.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',ERR=199)
#elif absoft
        CLOSE(UNIT=IOUTM,STATUS='DELETE',ERR=14)
14      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'HOUSTON.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=199)
#else
        CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=14)
14      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'HOUSTON.SCR'//PID(1:LPID),
     &    CARRIAGECONTROL='LIST',STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=199)
#endif
        CALL HOUSTON_PLOTS(IOUTM)

C Seiko GR-1105 terminal:
      ELSE IF(IMONITOR.EQ.12)THEN
        CALL SEIKO_CLEAR

C Imagen laser printer (IMPRESS)
      ELSE IF(IMONITOR.EQ.13)THEN
#ifdef VMS
        CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=15)
15      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'IMAGEN.SCR'//PID(1:LPID),
     &    CARRIAGECONTROL='NONE',STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=199)
#elif g77
        CLOSE(UNIT=IOUTM,ERR=15)
15      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'IMAGEN.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',ERR=199)
#elif gfortran
        CLOSE(UNIT=IOUTM,ERR=15)
15      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'IMAGEN.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',ERR=199)
#elif absoft
        CLOSE(UNIT=IOUTM,STATUS='DELETE',ERR=15)
15      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'IMAGEN.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=199)
#else
        CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=15)
15      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'IMAGEN.SCR'//PID(1:LPID),
     &    CARRIAGECONTROL='NONE',STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=199)
#endif
        CALL IMPRESS_PLOT_INIT(IOUTM)

C PostScript
      ELSE IF(IMONITOR.EQ.14)THEN
#ifdef VMS
        CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=16)
16      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'POSTSCRIPT.SCR'//PID(1:LPID),
     &    CARRIAGECONTROL='LIST',STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=199)
#elif g77
        CLOSE(UNIT=IOUTM,ERR=16)
16      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'POSTSCRIPT.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',ERR=199)
#elif gfortran
        CLOSE(UNIT=IOUTM,ERR=16)
16      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'POSTSCRIPT.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',ERR=199)
#elif absoft
        CLOSE(UNIT=IOUTM,STATUS='DELETE',ERR=16)
16      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'POSTSCRIPT.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=199)
#else
        CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=16)
16      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'POSTSCRIPT.SCR'//PID(1:LPID),
     &    CARRIAGECONTROL='LIST',STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=199)
#endif
        CALL POSTSCRIPT_PLOT_INIT(IOUTM)

C LN03+
      ELSE IF( IMONITOR .EQ. 16 )THEN
#ifdef VMS
        CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=17)
17      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'LN03.SCR'//PID(1:LPID),
     &  CARRIAGECONTROL='FORTRAN',STATUS='UNKNOWN',DISPOSE='DELETE',
     &  ERR=199)
#elif g77
        CLOSE(UNIT=IOUTM,ERR=17)
17      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'LN03.SCR'//PID(1:LPID),
     &  STATUS='UNKNOWN',ERR=199)
#elif gfortran
        CLOSE(UNIT=IOUTM,ERR=17)
17      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'LN03.SCR'//PID(1:LPID),
     &  STATUS='UNKNOWN',ERR=199)
#elif absoft
        CLOSE(UNIT=IOUTM,STATUS='DELETE',ERR=17)
17      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'LN03.SCR'//PID(1:LPID),
     &  STATUS='UNKNOWN',DISPOSE='DELETE',
     &  ERR=199)
#else
        CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=17)
17      OPEN(UNIT=IOUTM,FILE=TMP(1:LTMP)//'LN03.SCR'//PID(1:LPID),
     &  CARRIAGECONTROL='FORTRAN',STATUS='UNKNOWN',DISPOSE='DELETE',
     &  ERR=199)
#endif
        WRITE(IOUTM,1000)ESC//'[?38h'          !enter Tek mode
C        WRITE(IOUTM,1000)GS//CAN//ESC//'7'//GS//ESC//FF
C        WRITE(IOUTM,1000)GS//CAN//ESC//'8'

C Generic terminal:
      ELSE IF( IMONITOR .EQ. 17 )THEN
        CALL GENERIC_CLEAR

C X Window display
      ELSE IF(IMONITOR.EQ.18)THEN
        CALL XVST_PLOT_CLEAR
      ENDIF

C======================================================================C
C  Clear monitor 2
C======================================================================C
200   IF(IMONITOR2.EQ.0)GO TO 300
      IF(NCLEARUNC .AND. CLEAR2)GO TO 300
      PL_CLEAR_M2 = .TRUE. !flag for telling PLOT_MONITOR2 that
C                           plot has just been cleared
      CLEAR2 = .TRUE.

C VT640 & PT100G
      IF(IMONITOR2.EQ.1.OR.IMONITOR2.EQ.9)THEN
        WRITE(IOUTM2,1000)GS//CAN//ESC//'7'//GS//ESC//FF
        CALL SLEEP2(0.5)
        WRITE(IOUTM2,1000)GS//CAN//ESC//'8'

C Tek 4010
      ELSE IF(IMONITOR2.EQ.2)THEN
        WRITE(IOUTM2,1000)GS//ESC//FF
        CALL SLEEP2(0.5)

C HP plotter:
      ELSE IF(IMONITOR2 .EQ. 5)THEN
#ifdef VMS
         CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=23)
23       OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'HPP.SCR'//PID(1:LPID),
     &     CARRIAGECONTROL='LIST',STATUS='UNKNOWN',DISPOSE='DELETE',
     &     ERR=299)
#elif g77
         CLOSE(UNIT=IOUTM2,ERR=23)
23       OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'HPP.SCR'//PID(1:LPID),
     &     STATUS='UNKNOWN',ERR=299)
#elif gfortran
         CLOSE(UNIT=IOUTM2,ERR=23)
23       OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'HPP.SCR'//PID(1:LPID),
     &     STATUS='UNKNOWN',ERR=299)
#elif absoft
         CLOSE(UNIT=IOUTM2,STATUS='DELETE',ERR=23)
23       OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'HPP.SCR'//PID(1:LPID),
     &     STATUS='UNKNOWN',DISPOSE='DELETE',
     &     ERR=299)
#else
         CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=23)
23       OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'HPP.SCR'//PID(1:LPID),
     &     CARRIAGECONTROL='LIST',STATUS='UNKNOWN',DISPOSE='DELETE',
     &     ERR=299)
#endif
         CALL HP_PLOTS(IOUTM2)

C CIT467
      ELSE IF(IMONITOR2.EQ.6)THEN
        WRITE(IOUTM2,1000)ESC//'2'//ESC//'7'//GS//ESC//FF
        CALL SLEEP2(0.5)
        WRITE(IOUTM2,1000)ESC//'2'//ESC//'8'

C Tek 4107
      ELSE IF(IMONITOR2.EQ.7)THEN
        WRITE(IOUTM2,1000)ESC//'%!1'//ESC//'7'//ESC//'%!0'//ESC//FF
        CALL SLEEP2(0.5)
        WRITE(IOUTM2,1000)ESC//'%!1'//ESC//'8'

C VT241:
      ELSE IF(IMONITOR2.EQ.8)THEN
C If in transparent mode, home the cursor:
        WRITE(IOUTM2,1000)ESC//BACKSLASH//ESC//'[2J'//ESC//'[1;1H'
        WRITE(IOUTM2,1000)'W(F15)'         ! JLC Nov 28/88

C Houston Instruments plotter:
      ELSE IF(IMONITOR2.EQ.11)THEN
#ifdef VMS
        CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=25)
25      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'HOUSTON.SCR'//PID(1:LPID),
     &    CARRIAGECONTROL='LIST',STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=299)
#elif g77
        CLOSE(UNIT=IOUTM2,ERR=25)
25      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'HOUSTON.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',ERR=299)
#elif gfortran
        CLOSE(UNIT=IOUTM2,ERR=25)
25      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'HOUSTON.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',ERR=299)
#elif absoft
        CLOSE(UNIT=IOUTM2,STATUS='DELETE',ERR=25)
25      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'HOUSTON.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=299)
#else
        CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=25)
25      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'HOUSTON.SCR'//PID(1:LPID),
     &    CARRIAGECONTROL='LIST',STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=299)
#endif
        CALL HOUSTON_PLOTS(IOUTM2)

C Seiko GR-1105 terminal:
      ELSE IF(IMONITOR2.EQ.12)THEN
        CALL SEIKO_CLEAR2

C Imagen laser printer (IMPRESS)
      ELSE IF(IMONITOR2.EQ.13)THEN
#ifdef VMS
        CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=26)
26      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'IMAGEN.SCR'//PID(1:LPID),
     &    CARRIAGECONTROL='NONE',STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=299)
#elif g77
        CLOSE(UNIT=IOUTM2,ERR=26)
26      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'IMAGEN.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',ERR=299)
#elif gfortran
        CLOSE(UNIT=IOUTM2,ERR=26)
26      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'IMAGEN.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',ERR=299)
#elif absoft
        CLOSE(UNIT=IOUTM2,STATUS='DELETE',ERR=26)
26      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'IMAGEN.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=299)
#else
        CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=26)
26      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'IMAGEN.SCR'//PID(1:LPID),
     &    CARRIAGECONTROL='NONE',STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=299)
#endif
        CALL IMPRESS_PLOT_INIT(IOUTM2)

C PostScript
      ELSE IF(IMONITOR2.EQ.14)THEN
#ifdef VMS
        CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=27)
27      OPEN(UNIT=IOUTM2,
     &    FILE=TMP(1:LTMP)//'POSTSCRIPT.SCR'//PID(1:LPID),
     &    CARRIAGECONTROL='LIST',STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=299)
#elif g77
        CLOSE(UNIT=IOUTM2,ERR=27)
27      OPEN(UNIT=IOUTM2,
     &    FILE=TMP(1:LTMP)//'POSTSCRIPT.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',ERR=299)
#elif gfortran
        CLOSE(UNIT=IOUTM2,ERR=27)
27      OPEN(UNIT=IOUTM2,
     &    FILE=TMP(1:LTMP)//'POSTSCRIPT.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',ERR=299)
#elif absoft
        CLOSE(UNIT=IOUTM2,STATUS='DELETE',ERR=27)
27      OPEN(UNIT=IOUTM2,
     &    FILE=TMP(1:LTMP)//'POSTSCRIPT.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=299)
#else
        CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=27)
27      OPEN(UNIT=IOUTM2,
     &    FILE=TMP(1:LTMP)//'POSTSCRIPT.SCR'//PID(1:LPID),
     &    CARRIAGECONTROL='LIST',STATUS='UNKNOWN',DISPOSE='DELETE',
     &    ERR=299)
#endif
        CALL POSTSCRIPT_PLOT_INIT(IOUTM2)

C LN03+
      ELSE IF( IMONITOR2 .EQ. 16 )THEN
#ifdef VMS
        CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=28)
28      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'LN03.SCR'//PID(1:LPID),
     &  CARRIAGECONTROL='FORTRAN',STATUS='UNKNOWN',DISPOSE='DELETE',
     &  ERR=299)
#elif g77
        CLOSE(UNIT=IOUTM2,ERR=28)
28      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'LN03.SCR'//PID(1:LPID),
     &  STATUS='UNKNOWN',ERR=299)
#elif gfortran
        CLOSE(UNIT=IOUTM2,ERR=28)
28      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'LN03.SCR'//PID(1:LPID),
     &  STATUS='UNKNOWN',ERR=299)
#elif absoft
        CLOSE(UNIT=IOUTM2,STATUS='DELETE',ERR=28)
28      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'LN03.SCR'//PID(1:LPID),
     &  STATUS='UNKNOWN',DISPOSE='DELETE',
     &  ERR=299)
#else
        CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=28)
28      OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'LN03.SCR'//PID(1:LPID),
     &  CARRIAGECONTROL='FORTRAN',STATUS='UNKNOWN',DISPOSE='DELETE',
     &  ERR=299)
#endif
        WRITE(IOUTM2,1000)ESC//'[?38h'          !enter Tek mode
C        WRITE(IOUTM2,1000)GS//CAN//ESC//'7'//GS//ESC//FF
C        WRITE(IOUTM2,1000)GS//CAN//ESC//'8'

C GKS Metafile
      ELSE IF(IMONITOR2.EQ.19)THEN
        CALL GKS_CLOSE
#ifdef VMS
        CLOSE(UNIT=IOUTM2,DISPOSE='DELETE')
        OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'GKSMETA.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',DISPOSE='DELETE',ERR=299)
#elif g77
        CLOSE(UNIT=IOUTM2)
        OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'GKSMETA.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',ERR=299)
#elif gfortran
        CLOSE(UNIT=IOUTM2)
        OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'GKSMETA.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',ERR=299)
#elif absoft
        CLOSE(UNIT=IOUTM2,STATUS='DELETE')
        OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'GKSMETA.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',DISPOSE='DELETE',ERR=299)
#else
        CLOSE(UNIT=IOUTM2,DISPOSE='DELETE')
        OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'GKSMETA.SCR'//PID(1:LPID),
     &    STATUS='UNKNOWN',DISPOSE='DELETE',ERR=299)
#endif
        CALL GKS_OPEN(IOUTM2)

C RD-GLII plotter:
      ELSE IF(IMONITOR2 .EQ. 20)THEN
#ifdef VMS
         CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=29)
29       OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'RDGL.SCR'//PID(1:LPID),
     &     CARRIAGECONTROL='LIST',STATUS='UNKNOWN',DISPOSE='DELETE',
     &     ERR=299)
#elif g77
         CLOSE(UNIT=IOUTM2,ERR=29)
29       OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'RDGL.SCR'//PID(1:LPID),
     &     STATUS='UNKNOWN',ERR=299)
#elif gfortran
         CLOSE(UNIT=IOUTM2,ERR=29)
29       OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'RDGL.SCR'//PID(1:LPID),
     &     STATUS='UNKNOWN',ERR=299)
#elif absoft
         CLOSE(UNIT=IOUTM2,STATUS='DELETE',ERR=29)
29       OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'RDGL.SCR'//PID(1:LPID),
     &     STATUS='UNKNOWN',DISPOSE='DELETE',
     &     ERR=299)
#else
         CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=29)
29       OPEN(UNIT=IOUTM2,FILE=TMP(1:LTMP)//'RDGL.SCR'//PID(1:LPID),
     &     CARRIAGECONTROL='LIST',STATUS='UNKNOWN',DISPOSE='DELETE',
     &     ERR=299)
#endif
         CALL RDGL_PLOTS(53,0,IOUTM2)
      END IF

300   CALL PEN_UP(0.,0.)  ! Pen up to location (0,0).

C=================================================================
C  Clear the hardcopy bit map.
C=================================================================
      IF(IORIENTH.EQ.0)GO TO 350
      IF(NCLEARUNC .AND. CLEARH) GO TO 350
      CLEARH = .TRUE.
      IF(BITMAP_EMPTY .OR. IBIT.EQ.5 .OR. IBIT.EQ.32 .OR. IBIT.EQ.132)
     & GO TO 350
      CALL ZERO_ARRAY(HARDCOPY,188*MAXLINES)
      BITMAP_EMPTY=.TRUE.
      MAXLINES=INT(XMAXH2)+1      !reset maximum size

C=========================================================
C  Set the last point plotted on the hardcopy bit map, 
C  given by coordinates (XLAST,YLAST) to zero.         
C=========================================================
350   XLAST=0.
      YLAST=0.
      CLEARUNC =.TRUE. !reset for unconditional clear of monitors 1
C                       and 2 and hardcopy bitmap
      RETURN

C Error opening work file for monitor 1
199   CALL FORMSG
      CALL TRANSPARENT_MODE(0)
      WRITE(*,*)'Error opening monitor 1 scratch file in ',TMP(1:LTMP)
      GO TO 200

C Error opening work file for monitor 2
299   CALL FORMSG
      CALL TRANSPARENT_MODE(0)
      WRITE(*,*)'Error opening monitor 2 scratch file in ',TMP(1:LTMP)
      GO TO 300
      END
