      FUNCTION CPU_LIMIT(DUM)
C======================================================================C
C   Returns the PROCESS CPU time limit in seconds .
C   That is , return how much CPU time this process
C   is allowed before it will abort.
C
C    Refer to C.KOST for any problems. JULY 16 1981
C
C    REFERENCE: PAGE 6-10 OF VAX-11 FORTRAN USER'S GUIDE
C    & PAGE 128 OF VAX SYSTEM SERVICES REFERENCE MANUAL.
C
C   Modified 06-NOV-91 by F. Jones:  UNIX support added.
C
C======================================================================C
#ifdef VMS
C   Set up implicit data types so that the data types indicate sizes
      IMPLICIT INTEGER*2 (W), INTEGER*4 (L)
C   Define the symbolic value of the CPU LIMIT request in the
C   call to GETJPI
      PARAMETER (JPI$_CPULIM  = X'0000040D')
      INTEGER ICPU
C   Initialize all static values in the item list
      DATA W_LEN1,W_LEN2/2*4/
      DATA W_CODE1 /JPI$_CPULIM/
      DATA W_CODE2 /0/
      DATA L_LENADDR1/0/
      INTEGER*4 LCL_VALUE
C   Place the SYS$GETJPI item list in a COMMON block so as to be
C   contiguous.
      COMMON/ITEMLIM/W_LEN1,W_CODE1,L_ADDR1,L_LENADDR1,
     &                W_LEN2,W_CODE2

C   Item fields requiring addresses must be assigned at run time.
      L_ADDR1=%LOC(LCL_VALUE)

C   Perform the system service call
      CALL SYS$GETJPI(,,,W_LEN1,,,)
      ICPU=LCL_VALUE
      CPU_LIMIT=0.01*ICPU
#endif

#ifdef unix
      CALL FGETCPULIMIT(ICPU)
      CPU_LIMIT=ICPU
#endif

      RETURN
      END
