      SUBROUTINE DEL_ARRAY(IOFF,*)
C**********************************************************************
C
C  DEL_ARRAY:  Deallocates a block of virtual memory THAT HAD BEEN
C              ALLOCATED PREVIOUSLY WITH ROUTINE GET_ARRAY.  When
C              GET_ARRAY is called successfully, it records the array
C              in the Master Table (the size and virtual address).
C              This information is necessary to later delete the
C              array.
C
C  INPUT:
C
C  IOFF:       The offset from the base address that was returned
C              by GETSPACE.
C
C  ERROR RETURNS:
C
C  RETURN1:    IOFF is not in Master Table  OR
C              Bad address (according to LIB_FREE_VM)
C
C  Descriptive messages are printed out for error returns.
C  Modified July 17,1991 to declare common block XD by I4D instead
C     of R8D.
C
C      Modified by J. Chuma, March 7, 1997.  Eliminated the "$" from
C      common block and variable names for LINUX g77
C
C**********************************************************************
      COMMON /XD/ I4D
      COMMON /TABLED/ MAXTABLE,NTABLE,IEXIST,IVEC,IADDRESS,IBYTES
      LOGICAL*1 L1D(1)
      INTEGER I4D(1)
      REAL*8 R8D(1)
      EQUIVALENCE (I4D(1),L1D(1),R8D(1))
C**********************************************************************
C  Check Master Table to see if IOFF is entered
C  (Do not look at the "holes"; indicated by a .FALSE. value for the
C  flag of this slot).
C**********************************************************************
      DO 100 I=1,NTABLE
      K=I
      IF(.NOT.(L1D(IEXIST+I)))GOTO 100
      IF(IOFF.EQ.I4D(IVEC+I))GOTO 200
100   CONTINUE
C********************** Can't find the entry
      WRITE(6,150)
150   FORMAT('0*** Error in DEL_ARRAY: this array is not recorded')
      RETURN1
C********************** Found the entry; free the space
200   NADDR=I4D(IADDRESS+K)
      NBYTES=I4D(IBYTES+K)
      CALL FREE_SPACE(NBYTES,NADDR,*900)
C**********************************************************************
C  Empty this entry slot in the Master Table by setting the flag for
C  this slot to .FALSE.
C**********************************************************************
      L1D(IEXIST+K)=.FALSE.
      RETURN
900   RETURN1
      END
