      SUBROUTINE DWG_BATCH(DNAME,IERR)
C======================================================================C
C  DWG_BATCH                                       F.W. Jones, TRIUMF  C
C  This is a non-interactive version of DWG, where the drawing name    C
C  is passed directly rather than being solicited from the user.       C
C  Input:   DNAME    Drawing name for new drawing.                     C
C  Output:  IERR     0: drawing file was successfully opened           C
C                    1: drawing file could not be opened.              C
C======================================================================C
      CHARACTER*(*) DNAME

      COMMON/CDWG/DWGON,DWGTXT,LDWG,LDWT,IRECG,IRECT,STROKE
      LOGICAL DWGON,DWGTXT,STROKE
      COMMON/CDWGNAM/DWGOPEN,DWGNAM
      LOGICAL DWGOPEN
      CHARACTER*80 DWGNAM
      COMMON/DWG_PREVIOUS/XP,YP,IPENP
      COMMON/HARDCOPYRANGE/XMINHP2,XMAXHP2,YMINHP2,YMAXHP2,IORIENTH2

      COMMON/DWG_MX/MXDWG
      LOGICAL MXDWG

      REAL DLINTAB(10,3)
      INTEGER*2 NPAGE2,ILINT2
      LOGICAL ISTAT

#ifdef unix
      LOGICAL*1 FILL(28)
#endif

      CALL DWG_BATCH_CLOSE
      DWGNAM=DNAME
#ifdef unix
      IF(MXDWG)THEN      ! If files exist, rename & make new versions
        CALL DWG_OPEN(DWGNAM,'NEW',LDWG,LDWT,ISTAT)
      ELSE
        CALL DWG_OPEN(DWGNAM,'NEW+',LDWG,LDWT,ISTAT)
      ENDIF
#else
      CALL DWG_OPEN(DWGNAM,'NEW+',LDWG,LDWT,ISTAT)
#endif
      IF(.NOT.ISTAT)THEN
        IERR=1
        RETURN
      ENDIF

C Write the limits of the drawing coordinate system into the
C first two records of the file:
      WRITE(LDWG,REC=1)XMINHP2,YMINHP2,0
      NPAGE2=0
      ILINT2=1
      WRITE(LDWG,REC=2)XMAXHP2,YMAXHP2,NPAGE2,ILINT2
C Get the line table and record it in the DWT file:
      DO LTYP=1,10
        CALL DLINESET(-LTYP,P1,P2,P3)
        DLINTAB(LTYP,1)=P1
        DLINTAB(LTYP,2)=P2
        DLINTAB(LTYP,3)=P3
      ENDDO
#ifdef VMS
      WRITE(LDWT,REC=1)DLINTAB
#endif
#ifdef unix
      WRITE(LDWT,REC=1)DLINTAB,FILL
#endif

C Set starting record numbers and flags
      IRECG=3
      IRECT=2
      DWGOPEN=.TRUE.
      DWGON=.TRUE.
      IPENP=0
      XP=0.
      YP=0.
      IERR=0

      RETURN
      END
