        SUBROUTINE FNICE(XMIN,XMAX,XINC,NWID,NDEC,IPOW)
C
C                                          Henry Baragar
C                                          TRIUMF, UBC 
C                                          June 24, 1982
C
C      reqd. routines - NONE
C
C======================================================================
C==    FNICE                                                         ==
C==                                                                  ==
C==   Purpose  - calculates exactly the number of digits (NWID)      ==
C==     required to display "XMIN" and "XMAX" such that they can be  ==
C==     displayed in F-format, and such that they include enough     ==
C==     decimal places so that the effect of the first two (one if   ==
C==     it has only one) significant digits of "XINC" can be         ==
C==     observed.                                                    ==
C==            - If NDEC < 0, the "." is suppressed (ie. NDEC=-1)    ==
C==                 although NWID still includes a position for it.  ==
C==            - If NWID < 0 then FNICE will try to fit XMIN and     ==
C==                 XMAX into ABS(NWID) --without loosing the        ==
C==                 significance from XINC-- by returning a factor   ==
C==                 (10**IPOW) by which XMIN and XMAX should be      ==
C==                  multiplied.                                     ==
C==            - Primarily used for labelling axis on plots nicely.  ==
C==                                                                  ==
C==   Arguments - XMIN & XMAX   (R*4) -- (I) ends of range;          ==
C==             - XINC          (R*4) -- (I) increment;              ==
C==             - NWID          (I*4) -- (I) < 0 --> fit in XMIN &   ==
C==                                          XMAX into ABS(NWID)by   ==
C==                                          returning IPOW;         ==
C==                                   -- (R) width of field includes ==
C==                                          "." (& "-" if needed);  ==
C==             - NDEC          (I*4) -- (I) < 0 --> if inc is an    ==
C==                                          integer then supress "."==
C==                                          >= 0 --> include ".";   ==
C==                                   -- (R) #no. of digs after "."; ==
C==             - IPOW          (I*4) -- (R) 10**IPOW is a multipli- ==
C==                                          cation factor used to   ==
C==                                          XMIN & XMAX into -NWID. ==
C==   Note 1 - NWID ALWAYS INCLUDES the "."                          ==
C==   Note 2 - the numbers are rounded off before the calculations   ==
C==     are carried out so that there are always enough digits       ==
C==     included.                                                    ==
C==   Example -                                                      ==
C==         CALL FNICE(-12.0135,5.,.15,NWID,NDEC,IPOW)               == 
C==     returns                                                      ==
C==         NWID=6                                                   ==
C==         NDEC=2                                                   ==
C==         IPOW=0                                                   ==
C==   Examples (cont) -                                              ==
C======================================================================
C==                INPUT                        |       OUTPUT       ==
C==---------------------------------------------+--------------------==
C==   XMIN     XMAX     XINC     NWID     NDEC  |  NWID  NDEC  IPOW  ==
C==  -12.0135   5.        .15      0        0   |    6     2     0   ==
C==    9.9      9.99      .01      0        0   |    4     2     0   ==
C==    1.0      9.9      1.0       0        0   |    3     0     0   ==
C==    1.0      9.9      1.0       0       -1   |    3    -1     0   ==
C==    2.5    122.5     12.5       0        0   |    4     0     0   ==
C==  100.1    100.6       .1      -5        0   |    5     1     0   ==
C==  100.1    100.6       .1      -1        0   |    5     1     0   ==
C== 1000.    5000.     100.       -5        0   |    5     0     0   ==
C== 1000.    5000.     100.       -3        0   |    3    -1     2   ==
C== 1000.    5000.     100.       -4        0   |    3    -1     2   ==
C==     .1234    .1239    .00015  -3        0   |    6     5     0   ==
C==     .115     .145     .015    -3        0   |    4     3     0   ==
C==     .0045    .0090    .0015   -3        0   |    3    -1    -4   ==
C======================================================================
        YMIN = ABS(XMIN)
        YMAX = ABS(XMAX)
        YINC = ABS(XINC)
        IF(YINC.EQ.0.)YINC=1.
        NWIDOR = NWID                                   ! NWID ORiginal
        NDECOR = NDEC                                   ! NDEC ORiginal
        NDEC = 0
        IPOW = 0
C
C       Shift the decimal place left or right until we get
C       10 <= YINC < 100, and keep track of the number of shifts
C       so that we know how many decimal places we need
C
C       Section for shifting decimal right for everything.
C
        DO WHILE (YINC.LT.10.)
           YMIN=YMIN*10.
           YMAX=YMAX*10.
           YINC=YINC*10.
           NDEC=NDEC+1
        END DO
C
C       Section for shifting decimal left for everything.
C
2       DO WHILE (YINC.GE.100.)
           YMIN=YMIN/10.
           YMAX=YMAX/10.
           YINC=YINC/10.
           NDEC=NDEC-1
        END DO
C
        YINC=IFIX(YINC+.5)
        IF(YINC.GE.100.)GO TO 2
        IF(MOD(YINC,10.).EQ.0..AND.MOD(IFIX(YMIN+.5),10).EQ.0
     *     .AND.MOD(IFIX(YMAX+.5),10).EQ.0)THEN
           YMIN=YMIN/10.
           YMAX=YMAX/10.
           YINC=YINC/10.
           NDEC=NDEC-1
        ENDIF
C
C Determine number of significant digits of XMIN 
C
	YMIN=IFIX(YMIN+.5)
	IF (YMIN.LT.1.) THEN
	   NSIGMIN=1
	ELSE
	   NSIGMIN=ALOG10(YMIN)+1
	ENDIF
C
C Determine NWIDMIN (NWID for XMIN) and include a position for the 
C decimal '.'.
C
	IF (NDEC.GT.NSIGMIN) THEN
	   NWIDMIN=NDEC+1
	ELSE IF (NDEC.LE.0) THEN
	   NWIDMIN=NSIGMIN-NDEC+1
	ELSE
	   NWIDMIN=NSIGMIN+1
	ENDIF
        IF(XMIN.LT.0.)NWIDMIN=NWIDMIN+1 		! Include '-'
C
C Determine number of significant digits of XMAX 
C
	YMAX=IFIX(YMAX+.5)
	IF (YMAX.LT.1.) THEN
	   NSIGMAX=1
	ELSE
	   NSIGMAX=ALOG10(YMAX)+1
	ENDIF
C
C Determine NWIDMAX (NWID for XMAX) and include a position for the decimal '.'.
C
	IF (NDEC.GT.NSIGMAX) THEN
	   NWIDMAX=NDEC+1
	ELSE IF (NDEC.LE.0) THEN
	   NWIDMAX=NSIGMAX-NDEC+1
	ELSE
	   NWIDMAX=NSIGMAX+1
	ENDIF
        IF(XMAX.LT.0.)NWIDMAX=NWIDMAX+1 		! Include '-'
C
C       NWID is the larger of the NWIDMIN and NWIDMAX
C
        NWID = MAX (NWIDMIN, NWIDMAX)
        IF(NDECOR.LT.0.AND.NDEC.LE.0)NWID=NWID-1
        IF (NWIDOR.GE.0  .OR.  NWID.LE.-NWIDOR)  THEN
	   IF (NDEC .GT. 0) RETURN
	   NDEC=0
	   IF (NDECOR .LT. 0) NDEC=-1
	   RETURN
	ENDIF
C
C       If we RETURNed above, then there was nothing to check for
C       problems fitting NWID, but if we continue on
C       to here, we find that we must use IPOW to fit NWID.  We also
C       check to make sure that the new NWID is really an improvement
C       over the old NWID.
C
        IF(XMIN.LT.0.)NSIGMIN=NSIGMIN+1 		! Include '-'
        IF(XMAX.LT.0.)NSIGMAX=NSIGMAX+1 		! Include '-'
	NWIDTEMP = MAX(NSIGMIN,NSIGMAX)
	IF (NWID .LE. NWIDTEMP) THEN
	   IF (NDEC .GT. 0) RETURN
	   NDEC=0
	   IF (NDECOR .LT. 0) NDEC=-1
           RETURN       				! not improved
        ENDIF
	NWID = NWIDTEMP                      		! improvement
	IPOW = -NDEC
	NDEC = -1
        RETURN
        END
