      SUBROUTINE HATCH_DRAW(XPOL,YPOL,NVERT,IHATCH)
C
C  HATCH_DRAW                                      J.L. Chuma
C                                                  August, 1986
C
C  Fills a polygonal area with a "hatching" pattern.
C
C  Input:
C
C  XPOL,YPOL:  Arrays containing the X and Y coordinates of the
C              vertices of the polygon
C
C  NVERT:      The number of vertices (maximum 1000)
C
C  IHATCH:     The hatch patter number to use (1 to 10)
C
C  The hatch patterns are predefined to be in terms of a 640 x 380
C  coordinate system
C
      REAL*4  XPOL(NVERT), YPOL(NVERT), SPACE(10)
     &       ,HATCH_SPACE(0:11,1:10)

      COMMON /HATCH_SPACE/ HATCH_SPACE
      COMMON /PLOT_OUTPUT_UNIT/ IOUTS

      DATA HATCH_SPACE
     &/1.0,  1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0,
     & 1.0,  1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 90.0,
     & 1.0,  5.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0,
     & 1.0,  5.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 90.0,
     & 1.0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0,
     & 1.0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 90.0,
     & 1.0, 20.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 45.0,
     & 1.0, 20.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,-45.0,
     & 2.0, 20.0,10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 45.0,
     & 2.0, 20.0,10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,-45.0 /
C
      IF( IHATCH .GT. 10 )THEN
        WRITE(IOUTS,10)'*** ERROR in HATCH_DRAW:  IHATCH > 10'
      ELSE IF( IHATCH .LT. 1 )THEN
        WRITE(IOUTS,10)'*** ERROR in HATCH_DRAW:  IHATCH < 1'
      ELSE IF( NVERT .GT. 1000 )THEN
        WRITE(IOUTS,10)'*** ERROR in HATCH_DRAW:  NVERT > 1000'
      ELSE IF( NVERT .LT. 1 )THEN
        WRITE(IOUTS,10)'*** ERROR in HATCH_DRAW:  NVERT < 1'
      ELSE
        NSPACE = IFIX(HATCH_SPACE(0,IHATCH))
        DO I = 1, NSPACE
          SPACE(I) = HATCH_SPACE(I,IHATCH)
        END DO
        ANGLE = HATCH_SPACE(11,IHATCH)
        CALL HATCH(XPOL,YPOL,NVERT,SPACE,NSPACE,ANGLE)
      END IF
      RETURN
10    FORMAT(' ',A)
      END
C
      SUBROUTINE HATCH(XPOL,YPOL,NVERT,SPACE,NSPACE,ANGLE)
C======================================================================C
C                                                                      C
C  HATCH                                           F.W. Jones, TRIUMF  C
C                                                                      C
C  Fills a polygonal area with a "hatching" pattern.                   C
C                                                                      C
C  Input:                                                              C
C                                                                      C
C  XPOL,YPOL:  Arrays containing the X and Y coordinates of the        C
C              vertices of the polygon.                                C
C                                                                      C
C  NVERT:      The number of vertices (maximum 1000).                  C
C                                                                      C
C  SPACE:      Array or variable containing the spacing(s) between     C
C              hatch lines.                                            C
C                                                                      C
C  NSPACE:     The number of spacings specified in SPACE.              C
C              If NSPACE > 1 the hatch lines are spaced in cycles      C
C              from SPACE(1) to SPACE(NSPACE).                         C
C                                                                      C
C  ANGLE:      The angle in degrees of the hatch lines (relative       C
C              to the positive X axis).                                C
C                                                                      C
C  Modified June 17/86 by F.W. Jones:  the algorithm has been          C
C  improved to resolve problems caused by the intersection of hatch    C
C  lines with vertices, and some checks for invalid data have been     C
C  added.                                                              C

      REAL XPOL(NVERT),YPOL(NVERT),SPACE(NSPACE)

C Working arrays:
      REAL XPW(1001),YPW(1001),XINT(1000),YINT(1000)
      LOGICAL FINT

      LOGICAL SEGMENT_CROSSH

C  Modified by J.L.Chuma, 08-Apr-1997 to elimate SIND, COSD for g77
      REAL*4 DTOR /0.017453292519943/
CCC
      IF(NVERT.GT.1000)RETURN
C Load the vertices into the working arrays:
      DO I=1,NVERT
        XPW(I)=XPOL(I)
        YPW(I)=YPOL(I)
      ENDDO
      NSP=NVERT
C Add closing vertex if needed
      IF(XPW(NSP).NE.XPW(1).OR.YPW(NSP).NE.YPW(1))THEN
        NSP=NSP+1
        XPW(NSP)=XPW(1)
        YPW(NSP)=YPW(1)
      ENDIF
      IF(NSP.LT.3)RETURN
C
C Coefficients for rotations:
      SP=SIN(ANGLE*DTOR)
      CP=COS(ANGLE*DTOR)
      SM=SIN(-ANGLE*DTOR)
      CM=COS(-ANGLE*DTOR)
C
C Find the extent of the polygon and a center for rotation:
      CALL MINMAX(XPW,NSP,XMIN,XMAX)
      CALL MINMAX(YPW,NSP,YMIN,YMAX)
      XCENT=(XMIN+XMAX)/2.
      YCENT=(YMIN+YMAX)/2.
C
C If ANGLE=0, bypass rotation
      IF( ANGLE .EQ. 0. )GO TO 79
C
C Rotate the polygon by -ANGLE and find its new extent:
      DO I=1,NSP
        X=XPW(I)
        Y=YPW(I)
        XPW(I)=XCENT+(X-XCENT)*CM-(Y-YCENT)*SM
        YPW(I)=YCENT+(X-XCENT)*SM+(Y-YCENT)*CM
      ENDDO
      CALL MINMAX(XPW,NSP,XMIN,XMAX)
      CALL MINMAX(YPW,NSP,YMIN,YMAX)
79    IF(XMIN.EQ.XMAX.OR.YMIN.EQ.YMAX)RETURN
C
      DO I=1,NSPACE
        S=ABS(SPACE(I))
        IF(YMIN+S.EQ.YMIN)RETURN      !spacing too small
      ENDDO
C
C Initial coordinates of hatch line:
      DX=(XMAX-XMIN)/2.
      X1=XMIN-DX
      X2=XMAX+DX
      YH=YMIN+ABS(SPACE(1))
      ISPACE=1
C
C Find the intersections of the shading segment with the polygon edges:
20    NINT=0
      DO 77 I=1,NSP-1

        IF( (YH-YPW(I))*(YH-YPW(I+1)) .GT. 0. )GO TO 77

        FINT=SEGMENT_CROSSH(XPW(I),YPW(I),XPW(I+1),YPW(I+1),
     &      X1,X2,YH,XC,YC)
        IF(.NOT.FINT)GO TO 77
C
         IF (XC.NE.XPW(I)  .OR. YC.NE.YPW(I) ) GO TO 60
CC        IF(SC.GT.0.)GO TO 60
C Hatch line intersects beginning point of segment;
C    check previous segments to determine configuration:
        K=I
50      K=K-1
        IF(K.LT.1)K=K+NSP-1
        TEST=(YH-YPW(K))*(YH-YPW(I+1))
        IF(TEST.LT.0.)GO TO 77
        IF(TEST.GT.0.)GO TO 60
        GO TO 50
C
C Record the intersection:
60      NINT=NINT+1
        XINT(NINT)=XC
        YINT(NINT)=YH
77    CONTINUE
C
      IF(NINT.EQ.0)GO TO 100
C Sanity check: NINT should be even
      IF(MOD(NINT,2).NE.0)GO TO 100
C
C Bubble sort the intersections into ascending order in X:
      DO IEND=NINT-1,1,-1
        DO I=1,IEND
          IF(XINT(I).GT.XINT(I+1))THEN
            XSAVE=XINT(I+1)
            XINT(I+1)=XINT(I)
            XINT(I)=XSAVE
          ENDIF
        ENDDO
      ENDDO
C
C If ANGLE=0, bypass rotation
      IF( ANGLE .EQ. 0. )GO TO 81
C
C Rotate the intersections to the correct hatching angle:
      YDIST=YH-YCENT
      DO I=1,NINT
        X=XINT(I)
        XINT(I)=XCENT+(X-XCENT)*CP-(YDIST)*SP
        YINT(I)=YCENT+(X-XCENT)*SP+(YDIST)*CP
      ENDDO        
C
C Draw portions of hatch line that are "inside" the polygon:
81    DO I=1,NINT-1,2
        IF(XINT(I) .NE. XINT(I+1) .OR. YINT(I).NE.YINT(I+1))THEN
          CALL PLOT_R(XINT(I),YINT(I),3)
          CALL PLOT_R(XINT(I+1),YINT(I+1),2)
        ENDIF
      ENDDO
C
C Get next hatch line:
100   YH=YH+ABS(SPACE(ISPACE))
      IF(YH.GE.YMAX)GO TO 999
      ISPACE=ISPACE+1
      IF(ISPACE.GT.NSPACE)ISPACE=1
      GO TO 20
C
C Exit:
CC 999   CALL FLUSH_PLOT     ! deleted Feb 14/89  J.Chuma
999   RETURN
      END
C      
      SUBROUTINE HATCH_SCALE(IHATCH,SF)
C
      REAL*4  HATCH_SPACE(0:11,1:10)
C
      COMMON /HATCH_SPACE/ HATCH_SPACE
      COMMON /PLOT_OUTPUT_UNIT/ IOUTS
C
C
      IF( IHATCH .GT. 10 )THEN
        WRITE(IOUTS,10)'*** ERROR in HATCH_SCALE:  IHATCH > 10'
      ELSE IF( IHATCH .LT. 0 )THEN
        WRITE(IOUTS,10)'*** ERROR in HATCH_SCALE:  IHATCH < 0'
      ELSE
        IF( IHATCH .EQ. 0 )THEN
          L1 =  1
          L2 = 10
        ELSE
          L1 = IHATCH
          L2 = IHATCH
        END IF
        DO J = L1, L2
          DO I = 1, IFIX(HATCH_SPACE(0,J))
            HATCH_SPACE(I,J) = SF * HATCH_SPACE(I,J)
          END DO
        END DO
      END IF
      RETURN
10    FORMAT(' ',A)
      END
C
      SUBROUTINE HATCH_SET(IHATCH,SPACE,NSPACE,ANGLE)
C
      REAL*4  SPACE(NSPACE), HATCH_SPACE(0:11,1:10)
C
      COMMON /HATCH_SPACE/ HATCH_SPACE
      COMMON /PLOT_OUTPUT_UNIT/ IOUTS
C
C
      IF( NSPACE .GT. 10 )THEN
        WRITE(IOUTS,10)'*** ERROR in HATCH_SET:  NSPACE > 10'
      ELSE IF( NSPACE .LT. 1 )THEN
        WRITE(IOUTS,10)'*** ERROR in HATCH_SET:  NSPACE < 1'
      ELSE IF( IHATCH .GT. 10 )THEN
        WRITE(IOUTS,10)'*** ERROR in HATCH_SET:  IHATCH > 10'
      ELSE IF( IHATCH .LT. 1)THEN
        WRITE(IOUTS,10)'*** ERROR in HATCH_SET:  IHATCH < 1'
      ELSE
        HATCH_SPACE(0,IHATCH) = FLOAT(NSPACE)
        DO I = 1, NSPACE
          HATCH_SPACE(I,IHATCH) = SPACE(I)
        END DO
        HATCH_SPACE(11,IHATCH) = ANGLE
      END IF
      RETURN
10    FORMAT(' ',A)
      END
C
      SUBROUTINE HATCH_GET(IHATCH,SPACE,NSPACE,ANGLE)
C
      REAL*4  SPACE(10), HATCH_SPACE(0:11,1:10)
C
      COMMON /HATCH_SPACE/ HATCH_SPACE
      COMMON /PLOT_OUTPUT_UNIT/ IOUTS
C
C
      IF( IHATCH .GT. 10 )THEN
        WRITE(IOUTS,10)'*** ERROR in HATCH_GET:  IHATCH > 10'
      ELSE IF( IHATCH .LT. 1)THEN
        WRITE(IOUTS,10)'*** ERROR in HATCH_GET:  IHATCH < 1'
      ELSE
        NSPACE = IFIX(HATCH_SPACE(0,IHATCH))
        DO I = 1, 10
          SPACE(I) = HATCH_SPACE(I,IHATCH)
        END DO
        ANGLE = HATCH_SPACE(11,IHATCH)
      END IF
      RETURN
10    FORMAT(' ',A)
      END
