        SUBROUTINE LINE_THICKNESS( ITHICK )
C
C  Sets the line thickness for subsequent graphics on these devices:
C
C    bitmap devices, PostScript 
C
C  Inputs:
C            ITHICK = line thickness
C
C  The line thickness defaults to 1
C
C  Line-thickening algorithm for bitmaps only:
C     line width in pixels is set by ITHICK.  The "brush" used is a 
C     square of ITHICK x ITHICK pixels.  Round brush option is enabled
C     by making ITHICK negative and makes a difference only with widths
C     of 4 pixels or more.  Compared to the square brush, the round
C     brush gives a more consistent line width for lines of different
C     angles.
C
C  J.Chuma,  November 17, 1989
C
      INTEGER*4 ITHICK
C
      INTEGER*4 IMONITOR, IOUTM
      COMMON /PLOTMONITOR/ IMONITOR, IOUTM
      INTEGER*4 IMONITOR2, IOUTM2
      COMMON /PLOTMONITOR2/ IMONITOR2, IOUTM2
C
      INTEGER*4 LWIDTH
      COMMON /PLOT_HARDCOPY_LINEWIDTH/ LWIDTH
C
C  PostScript
C
      ITHA = ABS( ITHICK )
      IF( (IMONITOR .EQ. 14) .OR. (IMONITOR2 .EQ. 14) )
     &  CALL POSTSCRIPT_SETLINEWIDTH( ITHA )
C
C  Bitmap
C
      LWIDTH = ITHICK
C
      RETURN
      END
