      CHARACTER*(*) FUNCTION LOWER_CASE(LINE)
C  
C     reqd. routines - NONE
C================================================================
C================================================================
C==                                                            ==
C==   LOWER_CASE: Converts upper case ASCII characters in      ==
C==               "LINE" into lower case ASCII characters. All ==
C==               other characters remain the same. The result ==
C==               is returned in "LOWER_CASE".                 ==
C==                    Both "LINE" and "LOWER_CASE"            ==
C==               are variable length character strings, i.e.  ==
C==               their length attribute is determined in the  ==
C==               calling routine. The lengths of "LINE" and   ==
C==               "LOWER_CASE" need not be the same. If "LINE" ==
C==               is longer than "LOWER_CASE" then "LINE" will ==
C==               be truncated and stored in "LOWER_CASE"; if  ==
C==               "LOWER_CASE" is longer than "LINE" then it   ==
C==               will be padded with blanks.                  ==
C==                                                            ==
C==   Written by Alan Carruthers, TRIUMF U.B.C., Nov. 9, 1982. ==
C==   (Simple modification of UPPER_CASE routine written by    ==
C==   Arthur Haynes.)                                          ==
C==                                                            ==
C==   Input  Parameters: LINE (CHARACTER*(*)).                 ==
C==                                                            ==
C==   Output Parameters: LOWER_CASE (CHARACTER*(*)).           ==
C==                                                            ==
C================================================================
C================================================================
      CHARACTER*(*) LINE
      CHARACTER TABLE(0:255)
      LOGICAL*1 NFIRST/.FALSE./
C
C
      IF(NFIRST)GO TO 100
C================================================================
C==   First time through this subroutine.                      ==
C==   Set up the character translation table to translate all  ==
C==   upper case ASCII characters to lower case.               ==
C================================================================
      NFIRST=.TRUE.
      DO 10 I=0,255
      TABLE(I)=CHAR(I)            ! Most characters are unchanged.
10    CONTINUE
      DO 20 I=65,90
      TABLE(I)=CHAR(I+32)         ! 0 parity upper case --> lower case.
      TABLE(I+128)=CHAR(I+128+32) ! 1 parity upper case --> lower case.
20    CONTINUE
C
C
100   LEN1=LEN(LINE)
      LEN2=LEN(LOWER_CASE)
      DO 30 I=1,MIN(LEN1,LEN2)
      LOWER_CASE(I:I)=TABLE(ICHAR(LINE(I:I))) ! Translate line.
30    CONTINUE
      IF(LEN2.GT.LEN1)LOWER_CASE(LEN1+1:LEN2)=' '
      RETURN
      END
