      FUNCTION LSWAP(A)
C======================================================================C
C                                                                      C
C  LSWAP                                           F.W. Jones, TRIUMF  C
C                                                                      C
C  Reverses the bit order of byte A.                                   C
C                                                                      C
C  This is a portable replacement for the VMS routine LSWAP.MAR,       C
C  with support for little-endian (VAX, DECStation) and big-endian     C
C  (SGI, MIPS) architectures.  Set the EXPAND flag "BEND" for the      C
C  latter machines.                                                    C
C                                                                      C
C======================================================================C
      BYTE LSWAP,A

      BYTE B1(4),B2(4)
      INTEGER IB1,IB2
      EQUIVALENCE(B1,IB1)
      EQUIVALENCE(B2,IB2)

#ifdef BEND
C Big-endian
      B1(4)=A
      B2(4)=0
#else
C Little-endian
      B1(1)=A
      B2(1)=0
#endif

      DO I=0,7
        IF(BTEST(IB1,I))IB2=IBSET(IB2,7-I)
      ENDDO

#ifdef BEND
      LSWAP=B2(4)
#else
      LSWAP=B2(1)
#endif

      RETURN
      END
