      FUNCTION NODE_NAME(Name)
C
C   Return the NODE NAME of the current CPU
C
#ifdef VMS
C    REFERENCE: PAGE 6-10 OF VAX-11 FORTRAN USER'S GUIDE
C    APR/82 EDITION, OR PAGE 3-10 OF SEPT/84 EDITION.
C    & PAGE SYS-272 OF VAX SYSTEM SERVICES REFERENCE MANUAL.
C    APRIL/1986 EDITION.
C  
C    reqd. routines - NONE
C
C	Modifications:
C
C	Who		When		What
C	===		====		====
C	Y.N. Miles	25-May-1988	Original
C
C	Y.N. Miles	29-Jul-1988	Passed EFN to GETSYIW by %Val
C					instead of (default) reference!
C    
C   set up implicit data types so that the data types indicate sizes
C
	IMPLICIT INTEGER*4 (A-Z)
	INTEGER*2 Iosb(4)		! I/O status quadword
	INTEGER*2 Itmlst_W(8)		! Item List (halfwords)
	INTEGER*4 Itmlst_L(4)		! Item List (longwords)
	CHARACTER*(*) Name		! Name of node
	CHARACTER Null/0/
C
	EQUIVALENCE (Itmlst_W(1),Itmlst_L(1))
C
	PARAMETER EFN=01		! Local Event Flag
C
C   Define the symbolic value of the NODE NAME request in the
C   call to GETSYIW
C
	INCLUDE '($SYIDEF)'
C
C   Initialize all items in ITMLST array
C
	Itmlst_W(1)=LEN(Name)		! Buffer Length
	Itmlst_W(2)=SYI$_NODENAME	! Item code
	Itmlst_L(2)=%Loc(Name)		! Buffer Address
	Itmlst_L(3)=0			! No return length
	Itmlst_L(4)=0			! List Terminator
C
C   Perform the system service call
C
	status=SYS$GETSYIW(%Val(EFN),,,Itmlst_W(1),Iosb(1),,,)
C
	IF (.NOT.status)    CALL LIB$STOP(%Val(status))
	IF (.NOT.Iosb(1))   CALL LIB$STOP(%Val(iosb(1)))
C
	Length=INDEX(Name,Null)-1		! Replace null pad
	IF (Length.GT.1) Name=Name(1:Length)	!  ...with blanks
        NODE_NAME=1
C
        RETURN
#endif
#ifdef unix
	CHARACTER*(*) NAME		! Name of node
        NAME=' '
        NODE_NAME=1
        CALL SYSTEM('hostname  > /tmp/hostname')
        CALL FIND_UNIT(LUNIT)
#ifdef _AIX
        OPEN(UNIT=LUNIT,FILE='/tmp/hostname',
     &      STATUS='OLD',ERR=99)
#elif g77
        OPEN(UNIT=LUNIT,FILE='/tmp/hostname',
     &      STATUS='OLD',ERR=99)
#elif gfortran
        OPEN(UNIT=LUNIT,FILE='/tmp/hostname',
     &      STATUS='OLD',ERR=99)
#else
        OPEN(UNIT=LUNIT,FILE='/tmp/hostname',READONLY,SHARED,
     &      STATUS='OLD',ERR=99)
#endif
        READ(LUNIT,100)NAME
 100    FORMAT(A)
        RETURN
  99    WRITE(6,200)
 200    FORMAT(' Unable to get hostname')
        RETURN
#endif
	END
