      SUBROUTINE PLOT_MONITOR2(X,Y,IPEN)
C======================================================================C
C                                                                      C
C  PLOT_MONITOR2                                                       C
C                                                                      C
C  Generates graphics output for monitor 2:                            C
C    IPEN=2:   move to location (X,Y)                                  C
C    IPEN=3:   draw to location (X,Y)                                  C
C    IPEN=20:  plot a point at location (X,Y)                          C
C                                                                      C
C  If IMONITOR2 = 0 then PLOT_MONITOR2 simply returns.                 C
C                                                                      C
C   Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.             C
C                                                                      C
C   Input  Parameters: X,Y (R*4); IPEN (I*4).                          C
C                                                                      C
C   Modified by Alan Carruthers, TRIUMF, March 3, 1983                 C
C   No graphics primitives are sent to monitor types 1, 2 or 3 if:     C
C        a) The same pixel as on the previous call to                  C
C           PLOT_MONITOR2 is referenced; and                           C
C        b) The plot level (pixels turned on, turned off, or           C
C           complemented) has not changed; and                         C
C        c) The plot has not just been cleared; and                    C
C        d) IPEN is the same as on the previous call; and              C
C        e) MUST_DO_PLOT is .FALSE. (May 4, 1983 -- see                C
C           following modification).                                   C
C                                                                      C
C  Modified by Alan Carruthers, TRIUMF, May 4, 1983:                   C
C  Graphics primitives can be forced to be sent if logical variable    C
C  MUST_DO_PLOT in common block /PLOT_MONITOR_DOPLOT/ is set to .TRUE. C
C  MUST_DO_PLOT defaults to .FALSE.  This modification was made to let C
C  PLOT_ALPHA_R force PLOT_MONITOR2 (and PLOT_MONITOR) to send         C
C  output. (PLOT_ALPHA_R moves the graphics cursor.)                   C
C                                                                      C
C  Modified by F.W. Jones, Oct 24/83.                                  C
C  To speed up display on Tektronix-compatible terminals, only the     C
C  necessary bytes of coordinate information are sent to these         C
C  devices.  The bytes normally sent are HI Y, LO Y, HI X, LO X, in    C
C  that order.  The terminal identifies the LO Y and LO X bytes by     C
C  their range.  The HI Y and HI X bytes have the same range, but the  C
C  HI X byte is identified by a preceding LO Y.  The LO X byte         C
C  initiates the drawing of the vector.  In general, after the         C
C  transmission of the first four bytes, only those bytes that change  C
C  need be sent, with the exceptions that:                             C
C                                                                      C
C   1) If the HI X byte is sent, a preceding LO Y byte must            C
C      be sent.                                                        C
C   2) The LO X byte must always be sent, to draw the vector.          C
C                                                                      C
C  In a typical plot, there are often one or more bytes that do not    C
C  change one vector to the next, so more vectors can be packed into   C
C  the buffer, the number of I/O operations decreases, and the display C
C  speed is increased.  For a typical plotting example (PLOTEX3),      C
C  display time is reduced by about 30% and CPU time usage is reduced  C
C  by about 15%.                                                       C
C                                                                      C
C  Associated routines modified: CHECK_BUFFER2, PLOT_MONITOR,          C
C                                CHECK_BUFFER.                         C
C                                                                      C
C  Modified by Joe Chuma, December 5, 1983 to include the HP           C
C    plotter as a monitor                                              C
C  Modified by Bernard Henin, U.VIC, July 1984, to support the         C
C    TEKTRONIX-4107.                                                   C
C  Modified by F.W. Jones, August 84, to include the VT241.            C
C                                                                      C
C  Modified by F.W. Jones, Oct 4/85:                                   C
C                                                                      C
C    PLESSEY PT100 terminal support added (IMONITOR2=9).               C
C    This terminal stores Tek 4014 coordinates at full precision       C
C    for true zoom and replay.  Address range is 4096 instead of       C
C    1024 ... this means there are an extra 2 bits of precision        C
C    in X and Y.  These bits are sent in an extra byte (IEXTRA)        C
C    following the HI Y byte.  The IEXTRA byte need be sent only if    C
C    its value has changed.  If the IEXTRA byte is sent, it must       C
C    be followed by the LO Y byte.  Routine CHECK_BUFFER2 has also     C
C    been modified to handle the extra byte.                           C
C                                                                      C
C    The code has been substantially rearranged and comments have      C
C    been revised to improve the logical structure and make the        C
C    code easier to read and maintain.  The Tektronix-compatible       C
C    section (IMONITOR2=1,2,6,7,9) is now at the beginning of the      C
C    executable code, and sections for the other monitors follow       C
C    in numerical order.                                               C
C                                                                      C
C  Modified Dec 5/85 by F.W. Jones, for the QMS Lasergrafix.           C
C  Modified Aug 11/86 by F.W. Jones for the Houston Instruments        C
C    plotter.                                                          C
C  Modified Jan 30/87 by J.Chuma for the TEK-4107, to get the correct  C
C    scaling numbers. (used [KOST.LIBRARY.EXAMPLES]TK4107.FOR)         C
C  Modified Mar 20/87 by F. Jones for the Seiko GR-1105 terminal       C
C  Modified Jul 6/87 by F. Jones:  when going from point plot mode     C
C    to vector mode (pen up) a US is now sent, followed by the GS      C
C    to go into vector mode.  The GS resets point mode on the VT640    C
C    but not on the other Tektronix emulators.  When using point       C
C    mode, the FS code (enter point mode), which was formerly sent     C
C    for every point, is now sent only if the terminal is not in       C
C    point mode or if a new buffer has just been started.              C
C  Modified by J. Chuma, November 14, 1988 to include the LN03+        C
C  Modified by F. Jones, Nov 09/89, for GKS Metafile output.           C
C  Modified by Joe Chuma, Oct 16, 1990 to include the RD-GLII          C
C  Modified by F.Jones 02-MAY-91: VS11 removed                         C
C  Modified 19-AUG-93 by FWJ: Zeta and QMS removed                     C
C                                                                      C
C======================================================================C

      COMMON /PLOTMONITOR2/ IMONITOR2, IOUTM2
      COMMON /PLOT_BUFFER2/ INDEX,IMODE,BUFFER
      BYTE BUFFER(78)   ! modified by J.Chuma, 19Mar97 for g77
C                          was LOGICAL*1
      COMMON /MONITOR2_SIZE/ XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE
      COMMON /PLOT_TO_MONITOR2/ RMATRIXMP(2,2),SHIFTMP(2)
      COMMON /PLOT_LEVEL2/ ILEV2      !FWJ Nov28/85
      COMMON /PLOT_CLEARED/PL_CLEAR_M, PL_CLEAR_M2, PL_CLEARER
      LOGICAL PL_CLEAR_M, PL_CLEAR_M2, PL_CLEARER
C======================================================================
C  MUST_DO_PLOT is a logical variable that can be set to .true. to 
C  force PLOT_MONITOR (and PLOT_MONITOR2) to send graphics primitives 
C  to Monitor 1 (and Monitor 2).  This is useful if, for example, 
C  alphanumeric text is sent to the monitor between two identical
C  calls to PLOT_MONITOR (or PLOT_MONITOR2). In this example, the 
C  alphanumeric text would change the location of the graphics cursor 
C  but PLOT_MONITOR wouldn't realize this.                           
C======================================================================
      COMMON /PLOT_MONITOR_DOPLOT/ MUST_DO_PLOT
      LOGICAL MUST_DO_PLOT
C Previous TEK codes:
      COMMON/TEK_PREVIOUS2/IYHIP2,IYLOP2,IXHIP2,IXLOP2,IEXTRAP2

C Flag for point plot mode.
      LOGICAL POINT_MODE/.FALSE./

      INTEGER IXPIXEL, IYPIXEL     !pixel last referenced
      LOGICAL FIRST/.TRUE./
      INTEGER IPENPREV/0/  !saves IPEN value from previous call
      LOGICAL DONT_PLOT
      SAVE IXPIXEL,IYPIXEL,FIRST,ILEVPREV,IPENPREV

C=======================================================================
C  Procedure begins.                                                  ==
C=======================================================================
      IF(IMONITOR2.EQ.0)RETURN
      DONT_PLOT = .NOT. (FIRST .OR. (ILEVPREV .NE. ILEV2)
     >                   .OR. PL_CLEAR_M2 .OR.
     >                   (IPENPREV .NE. IPEN) .OR.
     >                   MUST_DO_PLOT)
      FIRST = .FALSE.
      PL_CLEAR_M2 = .FALSE.
      ILEVPREV = ILEV2
      IPENOLD=IPENPREV      !for VT241
      IPENPREV = IPEN
C=================================================================
C    Determine the monitor coordinates (XM,YM) which correspond
C    to the plot coordinates (X,Y):
C
C        |XM|               |X|
C        |  | = RMATRIXMP * | | + SHIFTMP
C        |YM|               |Y|
C=================================================================  
      XM=RMATRIXMP(1,1)*X+RMATRIXMP(1,2)*Y+SHIFTMP(1)
      YM=RMATRIXMP(2,1)*X+RMATRIXMP(2,2)*Y+SHIFTMP(2)
      XM=MAX(MIN(XM,XMAXMSIZE),XMINMSIZE)
      YM=MAX(MIN(YM,YMAXMSIZE),YMINMSIZE)

C======================================================================C
C  Identify Tektronix-compatible terminals
C  IMONITOR2=1: VT640     IMONITOR2=2: Tek4010     IMONITOR2=6: CIT467
C  IMONITOR2=7: Tek4107   IMONITOR2=9: PT100G      IMONITOR2=16: LN03+
C  and convert to Tektronix coordinates.
C======================================================================C
C VT640:
      IF(IMONITOR2.EQ.1)THEN
        IXM=XM*1024./640. + SIGN(.5,XM) !Scale from VT640 to 4010
        IYM=YM*780./480. + SIGN(.5,YM)
C Tek4010:
      ELSE IF(IMONITOR2.EQ.2)THEN
        IXM=XM+SIGN(.5,XM)
        IYM=YM+SIGN(.5,YM)
C CIT467:
      ELSE IF(IMONITOR2.EQ.6)THEN
        IXM=XM*1023.77/572. !Scale from CIT to 4010
        IYM=YM*785.87/479.   
C TEK4107:
      ELSE IF(IMONITOR2.EQ.7)THEN
        IXM=MIN(1023.,XM*(1023.8/639.)+0.5)
        IYM=YM*(782.515/479.)+0.2
C PT100G (stores Tek4014 coordinates):
      ELSE IF(IMONITOR2.EQ.9)THEN
        IXM=XM*4096./640. + SIGN(.5,XM) !Scale from VT640 to 4014
        IYM=YM*3120./480. + SIGN(.5,YM)
C LN03+ (stores Tek4014 coordinates):
      ELSE IF(IMONITOR2.EQ.16)THEN
        IXM=XM*4096./640. + SIGN(.5,XM) !Scale from VT640 to 4014
        IYM=YM*3120./480. + SIGN(.5,YM)
C Non-Tektronix compatible:
      ELSE
        GO TO 1000      
      ENDIF

      IF(DONT_PLOT)DONT_PLOT=(IXM .EQ. IXPIXEL).AND.(IYM .EQ. IYPIXEL)
      IXPIXEL = IXM
      IYPIXEL = IYM
      IF(DONT_PLOT) RETURN

C============================================================C
C  Encode coordinates in Tektronix format:
C============================================================C
C Get extra byte for 4014:
      IF( (IMONITOR2.EQ.9) .OR. (IMONITOR2.EQ.16) )THEN
        IEXTRA=96+4*(MOD(IYM,4))+MOD(IXM,4)
        IXM=IXM/4
        IYM=IYM/4
      ENDIF
      IYHI=32+IYM/32
      IYLO=96+MOD(IYM,32)
      IXHI=32+IXM/32
      IXLO=64+MOD(IXM,32)

C============================================================C
C  Prepare the plot buffer for the coordinate codes.
C============================================================C
C==================================================
C   IPEN = 2: Plot with pen down.
C  If in point mode, must exit by doing penup
C  to last plotted location.
C==================================================
      IF(IPEN.EQ.2.AND.POINT_MODE)THEN
        CALL PACK_BUFFER2(29) !GS: Pen up.
        CALL PACK_BUFFER2(IYHIP2)
        IF( (IMONITOR2.EQ.9) .OR. (IMONITOR2.EQ.16) )
     &   CALL PACK_BUFFER2(IEXTRAP2)
        CALL PACK_BUFFER2(IYLOP2)
        CALL PACK_BUFFER2(IXHIP2)
        CALL PACK_BUFFER2(IXLOP2)
        CALL CHECK_BUFFER2 !Check to see if buffer is full.
        POINT_MODE=.FALSE.
C==================================================
C      IPEN = 3: Plot with pen up.
C==================================================
      ELSE IF(IPEN.EQ.3)THEN
        IF(POINT_MODE)THEN
          CALL PACK_BUFFER2(31)
          POINT_MODE=.FALSE.
        ENDIF
        CALL PACK_BUFFER2(29)  !Pen up: pack a GS character.
C==================================================
C      IPEN = 20: Plot a point at (X,Y).
C  Enter point mode if available (all except Tek4010).
C  For Tek4010, must do penup followed by pendown.
C==================================================
      ELSE IF(IPEN.EQ.20)THEN
        IF(IMONITOR2.NE.2)THEN
          IF(.NOT.POINT_MODE.OR.INDEX.LE.6)CALL PACK_BUFFER2(28)
          POINT_MODE=.TRUE.
        ELSE
          CALL PACK_BUFFER2(29) !Penup (GS)
          POINT_MODE=.FALSE.
        ENDIF
      ENDIF

C============================================================C
C  Put the coordinate codes in the buffer.
C============================================================C
C The first vector sequence in the buffer must always have all
C the bytes:
      IF(INDEX.LE.1)THEN
        CALL PACK_BUFFER2(IYHI)
        IF( (IMONITOR2.EQ.9) .OR. (IMONITOR2.EQ.16) )
     &   CALL PACK_BUFFER2(IEXTRA)
        CALL PACK_BUFFER2(IYLO)
        CALL PACK_BUFFER2(IXHI)
        IYHIP2=IYHI
        IEXTRAP2=IEXTRA
        IYLOP2=IYLO
        IXHIP2=IXHI
        GO TO 80      !Finish with XLO
      ENDIF

C Pack only the necessary bytes in the buffer:
      IF(IYHI.NE.IYHIP2)THEN      !Pack YHI?
         CALL PACK_BUFFER2(IYHI)
         IYHIP2=IYHI
      ENDIF
      IF( ((IMONITOR2.EQ.9) .OR. (IMONITOR2.EQ.16)) .AND.
     &    (IEXTRA.NE.IEXTRAP2) )THEN    !Pack EXTRA?
         CALL PACK_BUFFER2(IEXTRA)
         CALL PACK_BUFFER2(IYLO)      !Must also pack YLO
         IEXTRAP2=IEXTRA
         IYLOP2=IYLO
         IF(IXHI.NE.IXHIP2)THEN       !Maybe XHI too
            CALL PACK_BUFFER2(IXHI)
            IXHIP2=IXHI
         ENDIF
         GO TO 80
      ENDIF
      IF(IXHI.NE.IXHIP2)THEN      !Pack XHI (& therefore YLO)?
         CALL PACK_BUFFER2(IYLO)
         CALL PACK_BUFFER2(IXHI)
         IXHIP2=IXHI
         IYLOP2=IYLO
         GO TO 80
      ENDIF
      IF(IYLO.NE.IYLOP2)THEN      !Pack YLO?
         CALL PACK_BUFFER2(IYLO)
         IYLOP2=IYLO
      ENDIF
80    CALL PACK_BUFFER2(IXLO)     !Always pack XLO
      IXLOP2=IXLO

C Tek4010: must follow penup with pendown to plot a point:
      IF(IPEN.EQ.20.AND.IMONITOR2.EQ.2)CALL PACK_BUFFER2(IXLO)
C
      CALL CHECK_BUFFER2 !Check to see if buffer is full.
C
      RETURN
C======================================================================C
C  End of Tektronix-compatible section ... other monitors follow.
C======================================================================C

C======================================================================C
C  IMONITOR2 = 5: HP plotter
C======================================================================C
1000  IF(IMONITOR2.EQ.5)THEN
C Plot with pen down or pen up:
         IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THEN
            CALL HP_PLOT(XM,YM,IPEN)
C Plot a point:
         ELSE
            CALL HP_PLOT(XM,YM,3)
            CALL HP_PLOT(XM,YM,2)
         ENDIF

C======================================================================C
C  IMONITOR2=8:  VT241
C======================================================================C
      ELSE IF(IMONITOR2.EQ.8)THEN
        IXM=NINT(XM)
        IYM=NINT(YM)
        IYM=ABS(IYM-479)
C Pen up:
        IF(IPEN.EQ.3)CALL PACK_BUFFER2(80)
C Pen down:
        IF(IPEN.EQ.2)THEN
C VT241 quirk: the first pixel of a vector is missing if the previous
C  move was a pen up.  Fix this by doing a pen down to the previous
C  location:
          IF(IPENOLD.EQ.3)THEN
            CALL PACK_BUFFER2(86)
            CALL PACK_BUFFER2(91)
            CALL PACK_BUFFER2(93)
          ENDIF
          CALL PACK_BUFFER2(86)
        ENDIF
        CALL PACK_BUFFER2(91)
        ICH1=IXM/100
        IT=IXM/10
        ICH2=IT - 10*ICH1
        ICH3=IXM - 10*IT
        CALL PACK_BUFFER2(ICH1+48)
        CALL PACK_BUFFER2(ICH2+48)
        CALL PACK_BUFFER2(ICH3+48)
        CALL PACK_BUFFER2(44)
        ICH1=IYM/100
        IT=IYM/10
        ICH2=IT - 10*ICH1
        ICH3=IYM - 10*IT
        CALL PACK_BUFFER2(ICH1+48)
        CALL PACK_BUFFER2(ICH2+48)
        CALL PACK_BUFFER2(ICH3+48)
        CALL PACK_BUFFER2(93)
        CALL CHECK_BUFFER2

C======================================================================C
C  IMONITOR2=11:  Houston Instruments plotter
C======================================================================C
      ELSE IF(IMONITOR2.EQ.11)THEN
C Plot with pen down or pen up:
         IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THEN
            CALL HOUSTON_PLOT(XM,YM,IPEN)
C Plot a point:
         ELSE
            CALL HOUSTON_PLOT(XM,YM,3)
            CALL HOUSTON_PLOT(XM,YM,2)
         ENDIF

C======================================================================C
C  IMONITOR2=12:  Seiko GR-1105-40
C======================================================================C
      ELSE IF(IMONITOR2.EQ.12)THEN
C Plot with pen down or pen up:
         IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THEN
            CALL SEIKO_PLOT2(XM,YM,IPEN)
C Plot a point:
         ELSE
            CALL SEIKO_PLOT2(XM,YM,3)
            CALL SEIKO_PLOT2(XM,YM,2)
         ENDIF

C======================================================================C
C  IMONITOR2=13:  Imagen IMPRESS
C======================================================================C
      ELSE IF(IMONITOR2.EQ.13)THEN
C Plot with pen down or pen up:
         IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THEN
            CALL IMPRESS_PLOT(XM,YM,IPEN)
C Plot a point:
         ELSE
            CALL IMPRESS_PLOT(XM,YM,3)
            CALL IMPRESS_PLOT(XM,YM,2)
         ENDIF

C======================================================================C
C  IMONITOR2=14:  PostScript
C======================================================================C
      ELSE IF(IMONITOR2.EQ.14)THEN
        CALL POSTSCRIPT_PLOT(XM,YM,IPEN)

C======================================================================C
C  IMONITOR2=19:  GKS Metafile
C======================================================================C
      ELSE IF(IMONITOR2.EQ.19)THEN
        CALL GKS_PLOT(XM,YM,IPEN)

C======================================================================C
C  IMONITOR2 = 20: RD-GLII plotter
C======================================================================C
      ELSE IF(IMONITOR2.EQ.20)THEN
C Plot with pen down or pen up:
         IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THEN
            CALL RDGL_PLOT(XM,YM,IPEN)
C Plot a point:
         ELSE
            CALL RDGL_PLOT(XM,YM,3)
            CALL RDGL_PLOT(XM,YM,2)
         ENDIF
      ENDIF

      RETURN
      END
