      SUBROUTINE PSYMBOLD(X,Y,HEIGHT,STRING,ANGLE,LENGTH,*)
C
C   This subroutine is exactly the same as KOSTL:PSYM except
C   characters will be filled in if bolding is on.
C
C   Modified by J. Chuma, March 7, 1997.  Eliminated the "$" from
C   common block and variable names for LINUX g77
C      
C   modified by J.Chuma, 20Mar97 for g77
C     eliminated the EQUC function
C  Modified by J.Chuma, 23Apr97 for Absoft f77 -- changed X' to Z'
C  Modified 13-NOV-97 FWJ for LINUX absoft

      LOGICAL ASIS, DRAW
      COMMON /MODE/ ASIS
      COMMON /PSYM_HATCHING/ NHATCH 
      INTEGER NHATCH(2)
      REAL*4  XBOLD(1000), YBOLD(1000)
      REAL*4  X,Y,HEIGHT,ANGLE
C      LOGICAL EQUC
      BYTE STRING(1),STRINGB(256)
      LOGICAL*1 LINE1(56)
      INTEGER*2 LINE2(256)
      LOGICAL*1 LINE3(25000)
      INTEGER*2 SIZE,GRID,HSPAC,VSPAC,PSUPX,PSUPY,PSUBX,PSUBY,
     &          REFX,REFY,SWITC,LSPAC
      LOGICAL*1 NAME(16)
      REAL*4 SHGT,SCAL,SSCAL,ANGL
      LOGICAL GRID16,LISPON
      COMMON /FONT/ LINE1,LINE2,LINE3,GRID16,LISPON,MGRID

C   The following indicates that PALPHA and PSYM have never been called

      LOGICAL PALPCD,PSYMCD
      COMMON /CALLED/ PALPCD,PSYMCD,XC,YC
      REAL L11,L12,L13,L21,L22,L23,L31,L32,L33
      COMMON /LOTRAN/ L11,L21,L31,L12,L22,L32,L13,L23,L33
      COMMON /GOTRAN/ G11,G21,G31,G12,G22,G32,G13,G23,G33
      COMMON /TOTRAN/ T11,T21,T31,T12,T22,T32,T13,T23,T33
      BYTE LOC(2),LOCL

      INTEGER*2 LOCATN
      LOGICAL*1 LENCHZ(2)
      INTEGER*2 LENCHA
      LOGICAL*1 WIDTHL(2)
      INTEGER*2 WIDTHC
      BYTE CTRL(6)
      BYTE CTRL2(6)
      INTEGER NCTRL
      LOGICAL*1 FIRST,MOVETO

C Graphics Editor COMMON:
      COMMON/CDWG/DWGON,DWGTXT,LDWG,LDWT,IRECG,IRECT,STROKE
      LOGICAL DWGON,DWGTXT,STROKE

      LOGICAL CTRLC_CALLED, CTRLC_FLAG
      COMMON /CTRLC/ CTRLC_FLAG

      LOGICAL TEST
      LOGICAL*1 FILL, DITH, ERASE

      EQUIVALENCE (LINE1( 1),    SIZE),
     &            (LINE1( 3),    GRID),
     &            (LINE1( 5),   HSPAC),
     &            (LINE1( 7),   VSPAC),
     &            (LINE1( 9),   PSUPX),
     &            (LINE1(11),   PSUPY),
     &            (LINE1(13),   PSUBX),
     &            (LINE1(15),   PSUBY),
     &            (LINE1(17),    SHGT),
     &            (LINE1(21),    SCAL),
     &            (LINE1(25),   SSCAL),
     &            (LINE1(29),    ANGL),
     &            (LINE1(33),    REFX),
     &            (LINE1(35),    REFY),
     &            (LINE1(37),   SWITC)
      EQUIVALENCE (LINE1(39),   LSPAC),
     &            (LINE1(41), NAME(1))
      EQUIVALENCE (LOC(1),LOCATN)
#ifdef BEND
      EQUIVALENCE (LOC(2),LOCL)
#else
      EQUIVALENCE (LOC(1),LOCL)
#endif
      EQUIVALENCE (LENCHZ(1),LENCHA)
      EQUIVALENCE (WIDTHL(1),WIDTHC)

      DATA WIDTHC /Z'0000'/
      DATA CTRL /Z'15',Z'16',Z'09',Z'38',Z'0A',Z'39'/
      DATA CTRL2 /Z'15',Z'16',Z'05',Z'01',Z'03',Z'02'/
      DATA NCTRL /6/
      DATA LOCATN /Z'0000'/
      DATA LENCHA /Z'0000'/
      DATA NHATCH / 0,0 /
      DATA RADE /1.745329E-2/
      DATA ZM0 /Z'80000000'/
CCC
      IF( CTRLC_FLAG )RETURN
      CALL CTRLC_TRAP( CTRLC_CALLED )

      IF( LENGTH .LE. 0 )RETURN

C   NHATCH(1) = 0            means no filling 
C   If 1 >= NHATCH(1) >= 10  then fill with hatch pattern
C                            NHATCH(2) can be a second hatch pattern
C   NHATCH(2) >= 1           then fill with second hatch pattern
C   If NHATCH(1) > 10        then fill with dithering pattern 
C                            NHATCH(2) is ignored

      DRAW = .TRUE.  ! if true then draw outline of character
      DITH = .FALSE.
      ERASE = .FALSE.
      FILL = .FALSE.
      NHATCH(2) = ABS(NHATCH(2))
      IF( NHATCH(1) .LT. 0 )THEN
        DRAW = .FALSE.
        NHATCH(1) = ABS(NHATCH(1))
      END IF
      IF( (NHATCH(1).GE.1) .AND. (NHATCH(1).LE.10) )FILL = .TRUE.
      IF( NHATCH(1) .GE. 11 )THEN
        DITH = .TRUE.
        IDX = NHATCH(1)/10
        IDY = NHATCH(1) - IDX*10
      END IF

C Encode text into drawing file if open:
      IF( DWGON .AND. .NOT.STROKE )THEN
        DWGTXT = .TRUE.      !inhibit output from PLOT_R to drawing file
        CALL PSYM_DWG(X,Y,HEIGHT,STRING,ANGLE,LENGTH)
      ENDIF                                                             

      LENG = MIN(LENGTH,256)
      IF( .NOT.PSYMCD )THEN
CC        IF( .NOT.PALPCD )CALL PALPHA('STANDARD ',0,*99)
        IF( .NOT.PALPCD )CALL PFONT('STANDARD',0,*99)
        PSYMCD = .TRUE.
      END IF
      XC = X
      YC = Y
C
C  set the left margin
C
      XMARG = XC
      YMARG = YC
      LEVELS = 0
      LEVELV = 0
      DSUBX = PSUBX - REFX
      DSUBY = PSUBY - REFY
      DSUPX = PSUPX - REFX
      DSUPY = PSUPY - REFY
      SHGTD = 1. / SHGT
C
C   Here the global transformation is calculated
C
      ANGLER = ANGLE * RADE
      COSA = COS(ANGLER)
      SINA = SIN(ANGLER)
      G11 = HEIGHT*COSA
      G12 = HEIGHT*SINA
      G21 = -G12
      G22 = G11
      G13 = 0.
      G23 = 0.
      G31 = 0.
      G32 = 0.
      G33 = 1.
      T11 = L11 * G11
      T12 = L11 * G12
      T13 = 0.
      T21 = L21 * G11 + L22 * G21
      T22 = L21 * G12 + L22 * G22
      T23 = 0.
      T31 = L31 * G11 + L32 * G21
      T32 = L31 * G12 + L32 * G22
      T33 = 1.
C
C   Extract information from 'STRING'
C
C   ASIS = .FALSE.  for conversion
C
      CALL MOVEC(LENG,STRING,STRINGB)
      IF( .NOT.ASIS )CALL PASCEBC(STRINGB,STRINGB,LENG)
      DO 500 I = 1, LENG
        IF( CTRLC_FLAG )GO TO 98
C
C  TEST is used to determine if the character is `%' which is composed
C  of three parts, which makes filling difficult, so must be handled
C  as a special case
C
        TEST = .FALSE.
        IF( FILL .OR. DITH )THEN
          IF( ASIS )THEN
            IF( STRING(I) .EQ. ICHAR(char(Z'6C')) )TEST = .TRUE.
          ELSE
            IF( STRING(I) .EQ. ICHAR('%') )TEST = .TRUE.
          END IF
          IMOV = 0
        END IF
        LOCL = STRINGB(I)
        DO J = 1, NCTRL
          IF( ASIS )THEN
            IF( LOCL .EQ. CTRL(J) )GO TO 400
C            IF( EQUC(LOCL,CTRL(J)) )GO TO 400
          ELSE
            IF( LOCL .EQ. CTRL2(J) )GO TO 400
C            IF( EQUC(LOCL,CTRL2(J)) )GO TO 400
          END IF
        END DO
        IFIRST=LINE2(LOCATN+1)+1
        IF( IFIRST .GT. SIZE )GO TO 99
#ifdef BEND
        LENCHZ(2) = LINE3(IFIRST)
        WIDTHL(2) = LINE3(IFIRST+1)
#else
        LENCHZ(1) = LINE3(IFIRST)
        WIDTHL(1) = LINE3(IFIRST+1)
#endif
        LCHARA = LENCHA    
        IF( .NOT.GRID16 )LCHARA = LCHARA * 2
        LCHARA = LCHARA + 2
        FIRST = .TRUE.
        IPT = 3
        IBOLD = 0
100     CONTINUE
C
C   The following loop plots a complete character
C
        CALL SPLITE(LINE3(IFIRST),LCHARA,IPT,INX,INY,MGRID,MOVETO,*110)
        XIN = XC + INX * T11 + INY * T21 + T31
        YIN = YC + INX * T12 + INY * T22 + T32
        IF( FIRST )THEN
          FIRST = .FALSE.
          IF( DRAW )CALL PLOT_R(XIN,YIN,3)
          IF( FILL .OR. DITH )THEN
            XBOLD(1) = XIN
            YBOLD(1) = YIN
            IBOLD    = 1
          END IF
          GO TO 100
        END IF
        IF( TEST )THEN
          IF( MOVETO )THEN
            IF( FILL .OR. DITH )THEN
              IMOV = IMOV + 1
              IF( (IMOV .EQ. 1) .OR. (IMOV .EQ. 4) )GO TO 101

              DWGTXT = .FALSE.

              IF( IBOLD .NE. 0 )THEN
                IF( FILL )THEN
                  CALL HATCH_DRAW(XBOLD,YBOLD,IBOLD,NHATCH(1))
                  IF( NHATCH(2) .GE. 1 )
     &             CALL HATCH_DRAW(XBOLD,YBOLD,IBOLD,NHATCH(2))
                END IF
                IF( DITH )CALL DITHER(XBOLD,YBOLD,IBOLD,IDX,IDY,ERASE)
              END IF

              DWGTXT = .TRUE.

              IBOLD = 0
            END IF
          END IF
        END IF
101     IF( DRAW )THEN
          IF( MOVETO )THEN
            CALL PLOT_R(XIN,YIN,3)
          ELSE 
            CALL PLOT_R(XIN,YIN,2)
          END IF
        END IF
        IF( FILL .OR. DITH )THEN
          XBOLD(IBOLD+1) = XIN
          YBOLD(IBOLD+1) = YIN
          IBOLD = IBOLD + 1
        END IF
        GO TO 100
110     CONTINUE
        IF( FILL .OR. DITH )THEN

          DWGTXT = .FALSE.

          IF( IBOLD .NE. 0 )THEN
            IF( FILL )THEN
              CALL HATCH_DRAW(XBOLD,YBOLD,IBOLD,NHATCH(1))
              IF( NHATCH(2) .GE. 1 )
     &         CALL HATCH_DRAW(XBOLD,YBOLD,IBOLD,NHATCH(2))
            END IF
            IF( DITH )CALL DITHER(XBOLD,YBOLD,IBOLD,IDX,IDY,ERASE)
          END IF

          DWGTXT = .TRUE.

        END IF
C
C   Letterspacing is considered here
C
         WIDTHH=HSPAC+GRID
         IF (LISPON) WIDTHH=LSPAC+WIDTHC
         XC=XC+WIDTHH*T11
         YC=YC+WIDTHH*T12
         GO TO 500
  400    CONTINUE
      GO TO (410,420,430,440,450,460), J
      GO TO 500
  410 CONTINUE
C
C   Carriage return
C
      XP=-(VSPAC+GRID)*L21
      YP=-(VSPAC+GRID)*L22
      XC=XMARG+XP*G11+YP*G21
      YC=YMARG+XP*G12+YP*G22
      XMARG=XC
      YMARG=YC
      GO TO 500
  420 CONTINUE
C
C   Backspace
C
      WIDTHH=HSPAC+GRID
      XC=XC-WIDTHH*T11
      YC=YC-WIDTHH*T12
      GO TO 500
  430 CONTINUE
C
C   Up
C
      LEVELS=LEVELS+1
      IF (LEVELS) 432,434,436
  432 CONTINUE
      XC=XC-(PSUBX*T11+PSUBY*T21)
      YC=YC-(PSUBX*T12+PSUBY*T22)
      GO TO 500
  434 CONTINUE
      XC=XC-(REFX*T11+REFY*T21)
      YC=YC-(REFY*T12+REFY*T22)
      CALL TRANSF(SHGTD)
      XC=XC-(DSUBX*T11+DSUBY*T21)
      YC=YC-(DSUBX*T12+DSUBY*T22)
      GO TO 500
  436 CONTINUE
      XC=XC+(DSUPX*T11+DSUPY*T21)
      YC=YC+(DSUPX*T12+DSUPY*T22)
      IF (LEVELS .EQ. 1) CALL TRANSF(SHGT)
      XC=XC+(REFX*T11+REFY*T21)
      YC=YC+(REFX*T12+REFY*T22)
      GO TO 500
  440 CONTINUE
C
C   Down
C
      LEVELS=LEVELS-1
      IF (LEVELS) 442,444,446
  442 CONTINUE
      XC=XC+(DSUBX*T11+DSUBY*T21)
      YC=YC+(DSUBX*T12+DSUBY*T22)
      IF (LEVELS .EQ. -1) CALL TRANSF(SHGT)
      XC=XC+(REFX*T11+REFY*T21)
      YC=YC+(REFX*T12+REFY*T22)
      GO TO 500
  444 CONTINUE
      XC=XC-(REFX*T11+REFY*T21)
      YC=YC-(REFX*T12+REFY*T22)
      CALL TRANSF(SHGTD)
      XC=XC-(DSUPX*T11+DSUPY*T21)
      YC=YC-(DSUPX*T12+DSUPY*T22)
      GO TO 500
  446 CONTINUE
      XC=XC-(PSUPX*T11+PSUPY*T21)
      YC=YC-(PSUPX*T12+PSUPY*T22)
      GO TO 500
  450 CONTINUE
C
C   UP    The size of the character always changes
C
      LEVELV=LEVELV+1
      IF (LEVELV) 454,454,456
  454 CONTINUE
      XC=XC-(REFX*T11+REFY*T21)
      YC=YC-(REFY*T12+REFY*T22)
      CALL TRANSF(SHGTD)
      XC=XC-(DSUBX*T11+DSUBY*T21)
      YC=YC-(DSUBX*T12+DSUBY*T22)
      GO TO 500
  456 CONTINUE
      XC=XC+(DSUPX*T11+DSUPY*T21)
      YC=YC+(DSUPX*T12+DSUPY*T22)
      CALL TRANSF(SHGT)
      XC=XC+(REFX*T11+REFY*T21)
      YC=YC+(REFX*T12+REFY*T22)
      GO TO 500
  460 CONTINUE
C
C  DOWN. The size of the character always changes
C
      LEVELV=LEVELV-1
      IF (LEVELV) 462,464,464
  462 CONTINUE
      XC=XC+(DSUBX*T11+DSUBY*T21)
      YC=YC+(DSUBX*T12+DSUBY*T22)
      CALL TRANSF(SHGT)
      XC=XC+(REFX*T11+REFY*T21)
      YC=YC+(REFX*T12+REFY*T22)
      GO TO 500
  464 CONTINUE
      XC=XC-(REFX*T11+REFY*T21)
      YC=YC-(REFX*T12+REFY*T22)
      CALL TRANSF(SHGTD)
      XC=XC-(DSUPX*T11+DSUPY*T21)
      YC=YC-(DSUPX*T12+DSUPY*T22)
      GO TO 500
  500 CONTINUE

   98 DWGTXT=.FALSE.      !enable PLOT_R output

      RETURN

   99 DWGTXT=.FALSE.      !enable PLOT_R output

      RETURN 1
      END
