      SUBROUTINE READLINE(LINE,STRINGS,REALS,ITYPE,NFIELD)
C***********************************************************************
C                                                                      *
C    Reqd. [KOST.LIBRARY] routines - IGC, FINDC, CHREAL                *
C                                                                      *
C    This PLOTDATA routine scans an input LINE and determines the type *
C    and number of fields in that line; returning strings in STRINGS,  *
C    reals in REALS, and types in ITYPE. ITYPE(i) is 1 if field i is a *
C    string, ITYPE(i) is 2 if field i is a real number, and ITYPE(i)   *
C    0 if field i is a null.  The maximum number of fields that    *
C    will be scanned for in LINE is the NFIELD that is passed.         *
C    NFIELD should not be passed as a constant, as it will be changed  *
C    if the number of fields in the line is less than the NFIELD that  *
C    is passed.                                                        *
C                                                                      *
C   modified by J.Chuma, 19Mar97 for g77
C     alternate returns changed from & to *
C***********************************************************************
      REAL*4        REALS(1)
      CHARACTER*(*) LINE
      CHARACTER*255 BUFFER
      CHARACTER*60  STRINGS(1)
      CHARACTER*1   BLANK, COMMA, SQT, DQT
      INTEGER*4     ITYPE(1)
      LOGICAL    NULL
      BLANK = ' '
      COMMA = ','
      SQT = CHAR(39)
      DQT = CHAR(34)
      IF(NFIELD .LE. 0)GO TO 600
      NFMAX = NFIELD
      DO I = 1, NFMAX
         REALS(I)   = 0.0
         ITYPE(I)   = 0
         STRINGS(I) = ' '
      END DO
      NFIELD = 0
      IFIND = 0
      NULL = .TRUE.
      LENGTH = LENSIG(LINE)
      IF(LENGTH .EQ. 0)GO TO 600
C                                                                      *
C    Detab the line                                                    *
C                                                                      *
      DO I = 1, LENGTH
        IF(ICHAR(LINE(I:I)) .EQ. 9)LINE = LINE(:I-1)//BLANK//LINE(I+1:)
      END DO
10    ISTART = IFIND + 1
      IF(ISTART .GT. LENGTH)GO TO 500
C                                                                      *
C    Scan line for non-blank character                                 *
C                                                                      *
#ifdef VMS
      CALL IGC(%REF(LINE),LENGTH,' ',1,ISTART,IFIND,*400)
#else
      CALL IGC(LINE,LENGTH,' ',1,ISTART,IFIND,*400)
#endif
      IF(LINE(IFIND:IFIND) .EQ. COMMA)THEN
        IF(NULL)THEN
          NFIELD = NFIELD + 1
          ITYPE(NFIELD) = 0
        ELSE
          NULL = .TRUE.
        END IF
      ELSE                                    ! Field entry found
        NULL = .FALSE.                        ! Field is not null
        NFIELD = NFIELD + 1
        IF(LINE(IFIND:IFIND) .EQ. SQT)THEN
          IFIND2 = INDEX(LINE(IFIND+1:),SQT(1:1))+IFIND
20        IF(LINE(IFIND2+1:IFIND2+1) .EQ. SQT)THEN
            LENGTH = LENGTH - 1
            DO II = IFIND2, LENGTH
              LINE(II:II) = LINE(II+1:II+1)
            END DO
            IFIND2 = INDEX(LINE(IFIND2+1:),SQT)+IFIND2
            IF(IFIND2 .EQ. LENGTH)GO TO 200
            GO TO 20
          END IF
          IF(IFIND2 .EQ. 0)IFIND2 = LENGTH
          GO TO 200
        ELSE IF(LINE(IFIND:IFIND) .EQ. DQT)THEN
          IFIND2 = INDEX(LINE(IFIND+1:),DQT(1:1))+IFIND
30        IF(LINE(IFIND2+1:IFIND2+1) .EQ. DQT)THEN
            LENGTH = LENGTH - 1
            DO II = IFIND2, LENGTH
              LINE(II:II) = LINE(II+1:II+1)
            END DO
            IFIND2 = INDEX(LINE(IFIND2+1:),DQT)+IFIND2
            IF(IFIND2 .EQ. LENGTH)GO TO 200
            GO TO 30
          END IF
          IF(IFIND2 .EQ. 0)IFIND2 = LENGTH
          GO TO 200
        END IF
C***********************************************************************
C                                                                      *
C    Now scan for delimiter of current field                           *
C                                                                      *
C***********************************************************************
#ifdef VMS
        CALL FINDC(%REF(LINE),LENGTH,' ,',2,IFIND,IFIND2,ICH)
#else
        CALL FINDC(LINE,LENGTH,' ,',2,IFIND,IFIND2,ICH)
#endif
        IF(IFIND2 .EQ. 0)IFIND2 = LENGTH+1   ! Entry runs to end of LINE
C***********************************************************************
C                                                                      *
C    Move string in current field into buffer                          *
C                                                                      *
C***********************************************************************
        BUFFER(1:IFIND2-IFIND) = LINE(IFIND:IFIND2-1)
C***********************************************************************
C                                                                      *
C    Analyze buffer                                                    *
C                                                                      *
C***********************************************************************
C                                                                      *
C    Call CHREAL to try to interpret string as floating point number   *
C                                                                      *
C***********************************************************************
        NREAL = 1
#ifdef VMS
        CALL CHREAL(%REF(BUFFER),IFIND2-IFIND,FPOINT,NREAL,*200)
#else
        CALL CHREAL(BUFFER,IFIND2-IFIND,FPOINT,NREAL,*200)
#endif
        REALS(NFIELD) = FPOINT
        ITYPE(NFIELD) = 2
        GO TO 300
C***********************************************************************
C                                                                      *
C    Interpret as a string                                             *
C                                                                      *
C***********************************************************************
200     NCHAR = IFIND2 - IFIND
        IF(NCHAR .GT. 60)NCHAR = 60
        STRINGS(NFIELD) = ' '
        IF(LINE(IFIND:IFIND) .EQ. SQT .OR.
     &     LINE(IFIND:IFIND) .EQ. DQT)THEN
          NCHAR = NCHAR - 1
          IFIND2 = IFIND2 + 1
          IFIND  = IFIND + 1
        END IF
        STRINGS(NFIELD)(1:) = LINE(IFIND:NCHAR+IFIND-1)
        ITYPE(NFIELD) = 1
300     IFIND = IFIND2 - 1
      END IF
      IF(NFIELD .EQ. NFMAX)GO TO 600
      GO TO 10
400   IF(ISTART .EQ. 1)GO TO 600               ! LINE is entirely blank
C***********************************************************************
C                                                                      *
C    LINE has been completely scanned                                  *
C                                                                      *
C***********************************************************************
500   IF(NULL)THEN
         NFIELD = NFIELD + 1
         ITYPE(NFIELD) = 0
      END IF
600   RETURN
      END

