      SUBROUTINE REALCH(REAL,NREAL,IPOW,NPOS,NDEC,CH)
C
C     LIBRARY-ROUTINE
C
C                                                29/JULY/1980
C                                                C.J. KOST SIN
C  
C     reqd. KOSTL: routines - DEXP10,EQUC
C
C================================================================
C================================================================
C==                                                            ==
C==   REALCH: CONVERTS THE REAL NUMBER REAL INTO A CHARACTER   ==
C==   STRING CH WITH FORMAT F(NPOS).(NDEC) SUCH THAT:          ==
C==   REAL = CH*(10**IPOW), AND THE CHARACTER STRING CH IS     ==
C==   RIGHT-JUSTIFIED IN THE FIELD WIDTH OF NPOS CHARACTERS.   ==
C==   IF |NREAL|=1 THEN REAL IS REAL*4, IF |NREAL|=2 THEN REAL ==
C==   IS A REAL*8 NUMBER. IF NREAL > 0 THEN THE POWER IPOW WILL==
C==   BE ACCEPTED AS INPUT AND REALCH WILL CONVERT THE SCALED  ==
C==   NUMBER REAL/10**IPOW INTO THE CHARACTER STRING: CH.      ==
C==   IF NREAL < 0 THEN THE POWER IPOW WILL BE DETEMINED BY    ==
C==   REALCH SO THAT THE NUMBER REAL/10**IPOW WILL FIT EXACTLY ==
C==   INTO THE FIELD WIDTH OF NPOS CHARACTERS, I.E. REALCH WILL==
C==   SCALE REAL SO THAT IT WILL FIT INTO THE F(NPOS).(NDEC)   ==
C==   FORMAT WITH A MAXIMUM NUMBER OF SIGNIFICANT DIGITS. THE  ==
C==   POWER IPOW USED WILL BE RETURNED.                        ==
C==   IF THE NUMBER OF DECIMAL PLACES NDEC IS LESS THAN ZERO   ==
C==   THEN THE DECIMAL POINT IN THE CHARACTER REPRESENTATION OF==
C==   REAL WILL BE SUPPRESSED (I.E. IT IS ASSUMED TO BE ON THE ==
C==   FAR RIGHT OF THE NPOS CHARACTERS OF THE CH ARRAY).       ==
C==                                                            ==
C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., MARCH 5, 1979.  ==
C==   (NOTE: THIS IS A REVISION OF THE FORMER ROUTINE: NUMCON. ==
C==          REALCH IS THE INVERSE OF THE ROUTINE CHREAL, WHICH==
C==          CONVERTS A CHARACTER STRING INTO A REAL NUMBER).  ==
C==                                                            ==
C==   INPUT  PARAMETERS: REAL, (R*4: |NREAL|=1, R*8: |NREAL|=2)==
C==                      NREAL,IPOW,NPOS,NDEC (I*4).           ==
C==                                                            ==
C==   OUTPUT PARAMETERS: CH, (LOGICAL*1).                      ==
C==                                                            ==
C   modified by J.Chuma, 20Mar97 for g77
C    eliminated the EQUC function
C  Modified by F.W. Jones 22-Jan-2004
C    Made DEXP10 external since it is an intrinsic for some
C    compilers (e.g. Intel).
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL REAL(2),REAL4(2)
      REAL*8 REAL8
      EQUIVALENCE (REAL4(1),REAL8)
      CHARACTER CH(NPOS)
      CHARACTER DIGIT(10)
      CHARACTER MINUS,DEC,BLANK,STAR
      DATA DIGIT/'0','1','2','3','4','5','6','7','8','9'/,
     * MINUS/'-'/,DEC/'.'/,BLANK/' '/,STAR/'*'/
C      LOGICAL EQUC
      EXTERNAL DEXP10

      IF(NPOS.LE.0)RETURN
C================================================================
C==   STORE THE REAL NUMBER: REAL (R*4,R*8) INTO REAL8 (R*8).  ==
C================================================================
      REAL8=0.D0
      REAL4(1)=REAL(1)
      IF(IABS(NREAL).EQ.2)REAL4(2)=REAL(2)
#ifdef unix
      IF(IABS(NREAL).EQ.1)REAL8=REAL(1)
#endif
C================================================================
C==   DETERMINE NINT, THE NUMBER OF DIGITS TO THE LEFT OF THE  ==
C==   DECIMAL POINT, AND NDEC2, THE NUMBER OF DECIMAL PLACES,  ==
C==   ALLOWED BY THE FORMAT SPECIFICATION AND THE SIGN OF REAL8.=
C==   NDIG=NDEC2+NINT = NUMBER OF DIGITS ALLOWED BY THE FORMAT.==
C==   IF NINT < 0 OR NDIG <= 0 THEN AN FORMAT OVERFLOW         ==
C==   HAS OCCURED, HENCE GO TO 100 AND PUT "*"S IN THE CH      ==
C==   FIELD.                                                   ==
C================================================================
      NDEC1=MAX0(NDEC,-1)
      NDEC2=MAX0(NDEC,0)
      NINT=NPOS-NDEC1-1
      IF(REAL8.LT.0.D0)NINT=NINT-1
      IF(NINT.LT.0)GO TO 100
      IF(NINT+NDEC2.LE.0)GO TO 100
C================================================================
C==   IF NREAL > 0 SCALE REALA=|REAL8| DOWN BY 10**IPOW.       ==
C==   IF NREAL < 0 DETERMINE IPOW SO THAT CH=REAL8/10**IPOW    ==
C==   WILL FIT EXACTLY IN THE FORMAT SPECIFICATION (EVEN WHEN  ==
C==   THE NUMBER IS ROUNDED).                                  ==
C================================================================
      POWDEC=10.D0**NDEC2
      REALA=DABS(REAL8)
      IF(NREAL.LT.0)GO TO 10
C================================================================
C==   DEXP10(REALA,IPOW)=REALA/10.D0**IPOW                     ==
C==   DEXP10 IS USED INSTEAD OF "**" BECAUSE |IPOW| MAY BE TOO ==
C==   LARGE.                                                   ==
C==   EXAMPLE: IF REALA=1.E-70 AND IPOW=-100 THEN              ==
C==   10.D0**IPOW IS UNDEFINED (UNDERFLOW) BUT                 ==
C==   REALA/10.D0**IPOW = 1.E-70/10**-100 = 1.E30 IS DEFINED,  ==
C==   AND THIS IS THE RESULT DEXP10(REALA,IPOW) WILL RETURN.   ==
C================================================================
      REALA=DEXP10(REALA,IPOW)
      GO TO 20
C================================================================
C==   NREAL < 0: DETERMINE IPOW.                               ==
C================================================================
10    IPOW=0
      IF(REALA.EQ.0.D0)GO TO 20
      IPOW=IDINT(DLOG10(REALA)+100.D0)-99-NINT
C================================================================
C==   DEXP10(REALA,IPOW)=REALA/10.D0**IPOW                     ==
C================================================================
      REALA=DEXP10(REALA,IPOW)
C================================================================
C==   CHECK THAT THE NUMBER CH=REALA=REAL8/10**IPOW WILL FIT   ==
C==   INTO THE FORMAT SPECIFICATION EVEN WHEN IT IS ROUNDED OFF==
C================================================================
      REALN=POWDEC*REALA+.5D0
      RNMAX=POWDEC*10.D0**NINT
      IF(REALN.GE.RNMAX)IPOW=IPOW+1
      IF(REALN.GE.RNMAX)REALA=REALA/10.D0
C================================================================
C==   EXTRACT THE REQUIRED NUMBER OF DIGITS FROM THE REAL      ==
C==   NUMBER REALA, AND CONVERT THEM TO CHARACTERS IN CH.      ==
C================================================================
20    REALN=POWDEC*REALA+.5D0
      DO 40 I=1,NPOS
      IF(I.NE.NDEC2+1)GO TO 30
      IF(NDEC1.LT.0)GO TO 30
      CH(NPOS-I+1)=DEC
      GO TO 40
30    INDEX=DMOD(REALN,10.D0)+1.D0
      IF(INDEX.LT.1.OR.INDEX.GT.10)INDEX=1
      CH(NPOS-I+1)=DIGIT(INDEX)
      REALN=REALN/10.D0
40    CONTINUE
C================================================================
C==   IF REALN => 1, THEN REALN HAS OVERFLOWED THE CH FORMAT,  ==
C==   BECAUSE THERE ARE STILL NON-ZERO LEADING DIGITS WHICH DO ==
C==   NOT FIT INTO THE NPOS POSITIONS OF CH.                   ==
C================================================================
      IF(REALN.GE.1.D0)GO TO 100
C================================================================
C==   DETERMINE THE FIRST NON-ZERO CHARACTER OF CH.            ==
C================================================================
      DO 50 I=1,NPOS
      IF( CH(I) .NE. '0' )GO TO 60
C      IF(.NOT.EQUC(CH(I),'0'))GO TO 60
      CH(I)=BLANK
50    CONTINUE
      CH(NPOS)=DIGIT(1)
      I=NPOS
60    IF(REAL8.LT.0.D0)GO TO 70
C================================================================
C==   REAL8 > 0:                                               ==
C==   IF THE DECIMAL POINT IS THE FIRST NON-ZERO CHARACTER IN  ==
C==   CH, THEN PUT A LEADING ZERO IN FRONT IF THERE IS ROOM.   ==
C================================================================
      IF( CH(I) .NE. '.' )RETURN
C      IF(.NOT.EQUC(CH(I),'.'))RETURN
      IF(I.GT.1)CH(I-1)=DIGIT(1)
      RETURN
C================================================================
C==   REAL8 < 0: PUT A MINUS SIGN IN CH.                       ==
C================================================================
70    IF(I.EQ.1)GO TO 100
      IF( CH(I) .EQ. '.' )GO TO 80
C      IF(EQUC(CH(I),'.'))GO TO 80
      CH(I-1)=MINUS
      RETURN
80    IF(I.GT.2)GO TO 90
      CH(I-1)=MINUS
      RETURN
90    CH(I-1)=DIGIT(1)
      CH(I-2)=MINUS
      RETURN
C================================================================
C==   CH FORMAT HAS OVERFLOWED: FILL CH WITH "*"'S.            ==
C================================================================
100   DO 110 I=1,NPOS
      CH(I)=STAR
110   CONTINUE
      RETURN
      END
