      SUBROUTINE SCALE2(XMIN,XMAX,N,XMINS,XMAXS,DIST,SVAL,NVAL)
C  
C     LIBRARY-ROUTINE
C
C                                                29/JULY/1980
C                                                C.J. KOST SIN
C  
C     reqd. routines - NONE
C
C================================================================
C================================================================
C==                                                            ==
C==   SCALE2: GIVEN XMIN AND XMAX (XMIN <= XMAX) AND N > 1, THE==
C==          DESIRED RANGE AND NUMBER OF INTERVALS OF THE SCALE,=
C==          SCALE2 DETERMINES XMINS, XMAXS, AND DIST THE NEW  ==
C==          RANGE AND INTERVAL OF THE SCALE. XMINS, XMAXS,    ==
C==          AND DIST HAVE THE FOLLOWING PROPERTIES:           ==
C==                                                            ==
C==          1) XMINS <= XMIN <= XMAX <= XMAXS = XMINS+N*DIST. ==
C==          2) XMINS AND XMAXS ARE INTEGRAL MULTIPLES OF DIST.==
C==          3) DIST = SVAL(I)*10**M FOR SOME EXPONENT M, WHERE==
C==             1 <= I <= NVAL, AND SVAL(I) IS A NICE NUMBER   ==
C==             BETWEEN 1 AND 10 (1. <= SVAL(I) < 10.).        ==
C==             (SEE BELOW FOR MORE ABOUT SVAL.)               ==
C==                                                            ==
C==   ALGORITHM USED FOR SCALING IS FROM: PAGE 640 OF          ==
C==   COMMUNICATIONS OF THE ACM, OCT. 1973, VOL. 16, NUMBER 10.==
C==                                                            ==
C==   REWRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., SEPT 19, 1978.==
C==                                                            ==
C==   INPUT  PARAMETERS: XMIN,XMAX,N,SVAL,NVAL.                ==
C==                                                            ==
C==   OUTPUT PARAMETERS: XMINS,XMAXS,DIST.                     ==
C==                                                            ==
C==   XMIN  : (R*4) MINIMUM X-VALUE OF THE DESIRED RANGE OF THE==
C==                 SCALE.                                     ==
C==   XMAX  : (R*4) MAXIMUM X-VALUE OF THE DESIRED RANGE OF THE==
C==                 SCALE.                                     ==
C==   N     : (I*4) NUMBER OF SCALE INTERVALS, (N > 1).        ==
C==   XMINS : (R*4) MINIMUM X-VALUE OF THE NEW SCALE.          ==
C==   XMAXS : (R*4) MAXIMUM X-VALUE OF THE NEW SCALE.          ==
C==   DIST  : (R*4) INTERVAL SIZE OF THE NEW SCALE (DIST > 0). ==
C==   SVAL  : (R*4) ARRAY OF NVAL                              ==
C==                 "NICE" SCALE VALUES BETWEEN 1 & 10 IN      ==
C==                 ASCENDING ORDER (1 <= SVAL(I) < 10,        ==
C==                 SVAL(I) < SVAL(I+1)).                      ==
C==   NVAL  : (I*4) NUMBER OF "NICE" SCALE                     ==
C==                 VALUES IN SVAL. IF NVAL <= 0 THEN SCALE    ==
C==                 USES ITS OWN DEFAULT SET OF "NICE" VALUES: ==
C==                 1, 1.2, 1.5, 2, 2.5, 3, 4, 5, 6, 8.        ==
C==                                                            ==
C================================================================
C================================================================
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      DIMENSION SVAL(1),SVALUE(10)
      DATA SVALUE/1.0,1.2,1.5,2.0,2.5,3.0,4.0,5.0,6.0,8.0/
      DATA NVALUE/10/
      IF(XMIN.LE.XMAX.AND.N.GT.1) GO TO 30
      WRITE(6,25)
25    FORMAT(' ***ERROR*** IN CALL TO SCALE2: XMIN MUST BE <= XMAX'
     *      ,' & N MUST BE > 1.')
      RETURN
C================================================================
C==   FIND APPROXIMATE INTERVAL SIZE A.                        ==
C================================================================
30    XMAXX=XMAX
      IF(XMAXX.EQ.XMIN)XMAXX=XMIN+N*ABS(XMIN)
      IF(XMAXX.EQ.XMIN)XMAXX=XMIN+N
      A=(XMAXX-XMIN)/N
      NAL=ALOG10(A)
      IF (A.LT.1.) NAL=NAL-1
C================================================================
C==   SCALE A INTO A VARIABLE B BETWEEN 1 AND 10 (1 <= B <= 10)==
C================================================================
      B=A/10.**NAL
C================================================================
C==   FIND THE CLOSEST "NICE" VALUE => B.                      ==
C================================================================
      DEL=.00002
      IF(NVAL.GT.0)GO TO 50
      DO 40 I=1,NVALUE
      IF(B.LE.SVALUE(I)+DEL)GO TO 60
40    CONTINUE
      GO TO 55
50    DO 52 I=1,NVAL
      IF(B.LE.SVAL(I)+DEL)GO TO 60
52    CONTINUE
55    I=1
      NAL=NAL+1
C================================================================
C==   COMPUTE THE INTERVAL SIZE: DIST.                         ==
C================================================================
60    IF(NVAL.GT.0)GO TO 65
      DIST=SVALUE(I)*10.**NAL
      GO TO 68
65    DIST=SVAL(I)*10.**NAL
C================================================================
C==   FIND THE NEW MAXIMUM AND MINIMUM SCALE LIMITS:           ==
C==   XMINS AND XMAXS.                                         ==
C================================================================
68    FMIN=XMIN/DIST
      MIN=FMIN
      IF(FMIN.LT.0.)MIN=MIN-1
      IF(ABS(MIN+1.-FMIN).LE.DEL)MIN=MIN+1
      XMINS=MIN*DIST
      FMAX=XMAXX/DIST
      MAX=FMAX
      IF(FMAX.GT.0.)MAX=MAX+1
      IF(ABS(MAX-1.-FMAX).LE.DEL)MAX=MAX-1
      XMAXS=MAX*DIST
C================================================================
C==   CHECK WHETHER ANOTHER PASS IS REQUIRED                   ==
C================================================================
      NS=MAX-MIN
      IF(NS.LE.N)GO TO 80
      I=I+1
      IF(NVAL.GT.0)GO TO 70
      IF(I.LE.NVALUE)GO TO 60
      GO TO 55
70    IF(I.LE.NVAL)GO TO 60
      GO TO 55
80    ND=(N-NS)/2
      XMINS=XMINS-ND*DIST
      IF(XMIN.GE.0.)XMINS=AMAX1(XMINS,0.)
      XMAXS=XMINS+N*DIST
      IF(XMAXX.LE.0.)XMAXS=AMIN1(XMAXS,0.)
      XMINS=XMAXS-N*DIST
C================================================================
C==   ADJUST LIMITS TO ACCOUNT FOR ROUND-OFF IF NECESSARY.     ==
C================================================================
      IF(XMINS.GT.XMIN)XMINS=XMIN
      IF(XMAXS.LT.XMAXX)XMAXS=XMAXX
      RETURN
      END
