      LOGICAL FUNCTION TT_INPUT(DUM)
C======================================================================C
C
C  Tries to determine if the input stream is a terminal.
C  If it is, returns TRUE, otherwise FALSE.
C
C  Modified 11-JUL-91 by FWJ: to handle the case of
C     CREATE/TERMINAL command_string, where
C     SYS$COMMAND = __node$TWAxx but SYS$INPUT = _TWAxx
C  Modified 05-AUG-93 by FWJ: UNIX variant added using ISATTY.
C  Modified 19-JUL-93 by FWJ: UNIX: added check for uninitialized
C     unit number, which could happen if CLEAR_PLOT is not loaded.
C
C======================================================================C

      COMMON /PLOT_INPUT_UNIT/ IINS

#ifdef VMS
      CHARACTER*256 SYSCOM,SYSINP       

      IF(IBATCH())THEN
        TT_INPUT=.FALSE.
        RETURN
      ENDIF

      ISTAT = LIB$SYS_TRNLOG('SYS$COMMAND',,SYSCOM)
      ISTAT = LIB$SYS_TRNLOG('SYS$INPUT',,SYSINP)
      TT_INPUT = (INDEX(SYSCOM,SYSINP(2:LENSIG(SYSINP))).NE.0)
C     TT_INPUT = .NOT.IBATCH() .AND. (SYSINP .EQ. SYSCOM)
#endif
#ifdef unix
      LOGICAL ISATTY

      IF(IINS.GT.0)THEN
        TT_INPUT=ISATTY(IINS)
      ELSE
        TT_INPUT=ISATTY(5)
      ENDIF
#endif
      RETURN
      END
