      SUBROUTINE UPRCASEL(IN,OUT,LEN)
C================================================================
C==                                                            ==
C==   UPPER_CASEL: Converts lower case ASCII characters in     ==
C==               IN into UPPER CASE ASCII characters in OUT All=
C==               other characters remain the same.            ==
C==               The lengths of IN and OUT are given by LEN   ==
C==               in bytes.                                    ==
C==   Written by Corrie Kost, TRIUMF, U.B.C., DEc. 12, 1984.   ==
C==                                                            ==
C==   Input  Parameters: IN  (LOGICAL*1(LEN)).                 ==
C==                      LEN                                   ==
C==   Output Parameters: OUT (LOGICAL*1(LEN)).                 ==
C==                                                            ==
C================================================================
      BYTE IN(LEN),OUT(LEN) ! modified by J.Chuma, 19Mar97 for g77
      INTEGER*2 TABLE(0:255)
      LOGICAL NFIRST/.FALSE./

      IF(NFIRST)GO TO 100
C================================================================
C==   First time through this subroutine.                      ==
C==   Set up the character translation table to translate all  ==
C==   lower case ASCII characters to upper case.               ==
C================================================================
      NFIRST=.TRUE.
      DO 10 I=0,127
      TABLE(I)=I                  ! Most characters are unchanged.
10    CONTINUE
      DO 20 I=97,122
      TABLE(I)=I-32               ! 0 parity lower case --> upper case.
!      TABLE(I+128)=I+128-32       ! 1 parity lower case --> upper case.
20    CONTINUE

100   DO 30 I=1,LEN
      OUT(I)=TABLE(IN(I))        ! Translate line.
30    CONTINUE
      RETURN
      END
