      SUBROUTINE VHELP(LIBRARY,UTOPIC)
C======================================================================C
C                                                                      C
C  VHELP                                           F.W. Jones, TRIUMF  C
C                                                                      C
C  *** ON VMS MUST BE COMPILED /NOOPTIMIZE ***                         C
C                                                                      C
C  A help library interface for UNIX systems.                          C
C  Emulates the VAX/VMS HELP facility.                                 C
C                                                                      C
C  Input: CHARACTER*(*) LIBRARY, UTOPIC                                C
C                                                                      C
C  Parameter LIBRARY gives the library name.  Two files must be        C
C  present:                                                            C
C     LIBRARY.hlp    VMS help library source file                      C
C     LIBRARY.hli    index file made from hlp file                     C
C                                                                      C
C  The index file can be made by typing:                               C
C                                                                      C
C    /usr/local/bin/vhelpindex LIBRARY                                 C
C                                                                      C
C  Parameter UTOPIC is an optional caller-supplied topic which can     C
C  be of the following forms:                                          C
C                                                                      C
C    UTOPIC=' '                                                        C
C    Prompts the user for topics                                       C
C                                                                      C
C    UTOPIC='topic-word'                                               C
C    Prints the help text for the topic and returns                    C
C                                                                      C
C    UTOPIC='topic-word &'                                             C
C    Prints the help text for the topic and prompts for more topics    C
C                                                                      C
C  Restrictions:                                                       C
C    Topic names are limited to 20 characters.                         C
C    Retrieval of multiple topics via wildcards is not supported.      C
C                                                                      C
C  Modified 28-APR-92 by FWJ: now checks what carriage control is in   C
C    effect on the output stream and uses appropriate formats.         C
C                                                                      C
C  Modified 24-NOV-92 by FWJ: added hooks for external help dialog.    C
C  The user must set MXHELP=.TRUE. and supply the following routines:  C
C                                                                      C
C     MXHELP_START:   opens the external help dialog                   C
C     MXHELP_PROMPT:  displays the help prompt                         C
C     MXHELP_TEXT:    displays a line of help text                     C
C                                                                      C
C  After calling MXHELP_START and MXHELP_PROMPT, this routine returns. C
C  An entry point VHELP1 is provided to search for the topic supplied  C
C  as MXTOPIC in common VHELP_MX, and display any help text or topics  C
C  via calls to MXHELP_TEXT.                                           C
C                                                                      C
C  Modified 26-NOV-93 by FWJ: added option to continue interactive     C
C  browsing after displaying the help text for an initially-supplied   C
C  topic.  This is specified by appending ' &' to the topic.           C
C                                                                      C
C======================================================================C

      CHARACTER*(*) LIBRARY,UTOPIC

      COMMON/VHELP_MX/MXHELP,MXTOPIC
      LOGICAL MXHELP/.FALSE./
      CHARACTER*20 MXTOPIC

      CHARACTER*20 TOPIC(9),CTOPIC,TOPIC_IN,UPPER_CASE
      CHARACTER*22 SBUFF
      CHARACTER*80 MBUFF
      CHARACTER*1 SCHAR
      INTEGER MARK(9)
      LOGICAL STSCAN
      LOGICAL NFIRST
      LOGICAL FORCC
      CHARACTER*10 CCTYPE

      CHARACTER*80 MXPROMPT
      LOGICAL ONETOPIC

      CHARACTER*255 STRING   ! modified by J.Chuma, 19Mar97 for g77

      IF(NFIRST)GO TO 5

C Open the index file
      LSL=LENSIG(LIBRARY)
      STRING = LIBRARY(1:LSL)//'.hli'
#ifdef VMS
      OPEN(UNIT=1,FILE=STRING(1:LSL+4),STATUS='OLD',
     &  READONLY,SHARED,IOSTAT=ISTAT)
#elif _AIX
      OPEN(UNIT=1,FILE=STRING(1:LSL+4),STATUS='OLD',
     &  ACTION='READ',IOSTAT=ISTAT)
#elif g77
      OPEN(UNIT=1,FILE=STRING(1:LSL+4),STATUS='OLD',IOSTAT=ISTAT)
#elif gfortran
      OPEN(UNIT=1,FILE=STRING(1:LSL+4),STATUS='OLD',IOSTAT=ISTAT)
#else
      OPEN(UNIT=1,FILE=STRING(1:LSL+4),STATUS='OLD',
     &  READONLY,SHARED,IOSTAT=ISTAT)
#endif
      IF(ISTAT.NE.0)THEN
        WRITE(6,*)'Error opening help library index file ',
     &    LIBRARY(1:LSL),'.hli'
        CALL FORMSG
        RETURN
      ENDIF

C Open the help file
      STRING = LIBRARY(1:LSL)//'.hlp'
#ifdef VMS
      OPEN(UNIT=2,FILE=STRING(1:LSL+4),STATUS='OLD',
     &  READONLY,SHARED,IOSTAT=ISTAT)
#elif _AIX
      OPEN(UNIT=2,FILE=STRING(1:LSL+4),STATUS='OLD',
     &  ACTION='READ',IOSTAT=ISTAT)
#elif g77
      OPEN(UNIT=2,FILE=STRING(1:LSL+4),STATUS='OLD',IOSTAT=ISTAT)
#elif gfortran
      OPEN(UNIT=2,FILE=STRING(1:LSL+4),STATUS='OLD',IOSTAT=ISTAT)
#else
      OPEN(UNIT=2,FILE=STRING(1:LSL+4),STATUS='OLD',
     &  READONLY,SHARED,IOSTAT=ISTAT)
#endif
      IF(ISTAT.NE.0)THEN
        WRITE(6,*)'Error opening help library file ',
     &    LIBRARY(1:LSL),'.hlp'
        CALL FORMSG
        RETURN
      ENDIF

C Find the type of carriage control on the output stream

#ifdef VMS
      INQUIRE(UNIT=6,CARRIAGECONTROL=CCTYPE)
#elif g77
      CCTYPE = ' '
#elif gfortran
      CCTYPE = ' '
#elif absoft
      CCTYPE = ' '
#else
      INQUIRE(UNIT=6,CARRIAGECONTROL=CCTYPE)
#endif
CC     WRITE(6,*)'CARRIAGE CONTROL IS: ',CCTYPE
      FORCC=(CCTYPE.EQ.'FORTRAN')

      NFIRST=.TRUE.

 5    REWIND(UNIT=2)
      IRECL=0                   !pointer to last record read in help file
      LEVEL=1
      STSCAN=.FALSE.

C Check if initial topic is supplied
      LSU=LENSIG(UTOPIC)
C Prepare initial topic if present
      IF(LSU.GT.0)THEN
        ISTART=1
        DO WHILE(UTOPIC(ISTART:ISTART).EQ.' ')
          ISTART=ISTART+1
        ENDDO
        ONETOPIC=.TRUE.         !return after initial topic
        IF(LSU.GE.ISTART+2.AND.UTOPIC(LSU-1:LSU).EQ.' &')THEN
          ONETOPIC=.FALSE.      !continue after initial topic
          LSU=LSU-2
        ENDIF
        CTOPIC=UTOPIC(ISTART:LSU)
        CTOPIC=UPPER_CASE(CTOPIC)
C Otherwise, do scan of available 1-level topics
      ELSE
        ONETOPIC=.FALSE.        !continue after initial topic
        CTOPIC='?'
      ENDIF
C Load the stack
      TOPIC(1)=CTOPIC
C Motif: map the dialog
      IF(MXHELP)THEN
        CALL MXHELP_START
C Allow additional topic entry after single-topic help:
        ONETOPIC=.FALSE.
      ENDIF
      GO TO 15

C Prompt for topic

 10   IF(ONETOPIC)RETURN      !not if user-supplied topic

      IF(LEVEL.EQ.1)THEN
        IF(MXHELP)THEN
          MXPROMPT='Topic?'
        ELSE
          WRITE(6,500)
        ENDIF
 500    FORMAT(/' Topic? ',$)
      ELSE
        IF(MXHELP)THEN
          MXPROMPT=' '
        ELSE
          WRITE(6,*)
        ENDIF
        DO I=1,LEVEL-1
          IF(MXHELP)THEN
            MXPROMPT(LENSIG(MXPROMPT)+2:)=TOPIC(I)(1:LENSIG(TOPIC(I)))
          ELSE
            IF(FORCC)THEN
              WRITE(6,600)TOPIC(I)(1:LENSIG(TOPIC(I)))
            ELSE
              WRITE(6,601)TOPIC(I)(1:LENSIG(TOPIC(I)))
            ENDIF
          ENDIF
        ENDDO
        IF(MXHELP)THEN
          MXPROMPT(LENSIG(MXPROMPT)+2:)='Subtopic?'
        ELSE
          IF(FORCC)THEN
            WRITE(6,600)' Subtopic?'
          ELSE
            WRITE(6,601)' Subtopic?'
          ENDIF
        ENDIF
 600    FORMAT(1X,A,' ',$)
 601    FORMAT(   A,' ',$)
      ENDIF

      IF(MXHELP)THEN
        CALL MXHELP_PROMPT(MXPROMPT(1:LENSIG(MXPROMPT))//CHAR(0))
        RETURN
      ENDIF

      READ(5,1000,IOSTAT=ISTAT)CTOPIC
 1000 FORMAT(A)
      IF(ISTAT.GT.0)GO TO 10     !error
      IF(ISTAT.LT.0)THEN         !end of file
        WRITE(6,*)
        RETURN
      ENDIF

C RE-ENTRY point for Motif:
      ENTRY VHELP1
C Pad topic with trailing blanks
      IF(MXHELP)CTOPIC=MXTOPIC(1:LENSIG(MXTOPIC))

      IF(LENSIG(CTOPIC).EQ.0)THEN
        IF(LEVEL.EQ.1)RETURN
        LEVEL=LEVEL-1
        GO TO 10
      ENDIF

C Prepare the search topic and put it on the stack
      DO WHILE(CTOPIC(1:1).EQ.' ')
        CTOPIC=CTOPIC(2:)
      ENDDO
      CTOPIC=UPPER_CASE(CTOPIC)
      TOPIC(LEVEL)=CTOPIC

 15   IF(CTOPIC.EQ.'?')THEN
        NFOUND=0      !number of topics found
        CALL VBUFF_INIT
      ENDIF

      REWIND(UNIT=1)
      IREC=0
      IF(LEVEL.GT.1)THEN
        DO I=1,MARK(LEVEL-1)
          READ(1,*,ERR=998)
        ENDDO
        IREC=MARK(LEVEL-1)
      ENDIF
      SCHAR=CHAR(ICHAR('0')+LEVEL)
CC     WRITE(6,*)'SEARCH CHARACTER IS ',SCHAR
CC     WRITE(6,*)'STARTING SEARCH AT RECORD',IREC+1

      LSC=LENSIG(CTOPIC)

C Look for topic

 20   READ(1,1001,END=98,ERR=998)SBUFF,IREC1,IREC2
 1001 FORMAT(A22,2I6)
      IREC=IREC+1

C Reached end of index file
      IF(SBUFF(1:1).EQ.'E')THEN
C Successful wildcard search
        IF(CTOPIC.EQ.'?'.AND.NFOUND.GT.0)THEN
          CALL VBUFF_END(FORCC)
          STSCAN=.FALSE.
          GO TO 10
        ENDIF
C Unsuccessful search:
        IF(STSCAN)THEN
          LEVEL=LEVEL-1
          STSCAN=.FALSE.
        ELSE
          IF(MXHELP)THEN

            CALL MXHELP_TEXT('Sorry, no documentation on '//
     &                       CTOPIC//CHAR(0))
          ELSE
            WRITE(6,*)'Sorry, no documentation on ',CTOPIC
          ENDIF
        ENDIF
        GO TO 10
      ENDIF

C Topic entry found, but not current level:

      IF(SBUFF(1:1).NE.SCHAR)THEN
        LEVEL_IN=ICHAR(SBUFF(1:1))-ICHAR('0')
C Deeper level, continue searching
        IF(LEVEL_IN.GT.LEVEL)GO TO 20
C Otherwise, search is over
C Successful wildcard search:
        IF(CTOPIC.EQ.'?'.AND.NFOUND.GT.0)THEN
          CALL VBUFF_END(FORCC)
          STSCAN=.FALSE.      !end of subtopic scan, if any
          GO TO 10
        ENDIF
C Unsuccessful search
        IF(STSCAN)THEN
          LEVEL=LEVEL-1
          STSCAN=.FALSE.
        ELSE
          IF(MXHELP)THEN
            CALL MXHELP_TEXT(CHAR(0))
            CALL MXHELP_TEXT('Sorry, no documentation on '//
     &                       CTOPIC//CHAR(0))
          ELSE
            WRITE(6,*)'Sorry, no documentation on ',CTOPIC
          ENDIF
        ENDIF
        GO TO 10
      ENDIF

C Topic entry at current level found

      TOPIC_IN=SBUFF(3:)
      DO WHILE(TOPIC_IN(1:1).EQ.' ')
        TOPIC_IN=TOPIC_IN(2:)
      ENDDO
C Listing all topics at current level:
      IF(CTOPIC.EQ.'?')THEN
        NFOUND=NFOUND+1
        IF(NFOUND.EQ.1)THEN
          IF(.NOT.MXHELP)WRITE(6,*)
          IF(LEVEL.EQ.1)THEN
            IF(MXHELP)THEN
              CALL MXHELP_TEXT(CHAR(0))
              CALL MXHELP_TEXT('Information available:'//CHAR(0))
            ELSE
              WRITE(6,*)'Information available:'
            ENDIF
          ELSE
            IF(MXHELP)THEN
              IF(.NOT.STSCAN)CALL MXHELP_TEXT(CHAR(0))
              CALL MXHELP_TEXT('Additional information available:'//
     &                         CHAR(0))
            ELSE
              WRITE(6,*)'Additional information available:'
            ENDIF
          ENDIF
          IF(MXHELP)THEN
            CALL MXHELP_TEXT(' '//CHAR(0))
          ELSE
            WRITE(6,*)
          ENDIF
        ENDIF
        CALL VBUFF(TOPIC_IN,FORCC)
        GO TO 20
      ENDIF

C Test incoming topic for match
      IF(INDEX(UPPER_CASE(TOPIC_IN),CTOPIC(1:LSC)).NE.1)GO TO 20

C Topic found!
      TOPIC(LEVEL)=UPPER_CASE(TOPIC_IN)      ! for subtopic prompt
      IF(MXHELP)THEN
        CALL MXHELP_TEXT(CHAR(0))          ! clear text region
        CALL MXHELP_TEXT(TOPIC_IN//CHAR(0))
        CALL MXHELP_TEXT(' '//CHAR(0))
      ELSE
        WRITE(6,*)
        WRITE(6,*)TOPIC_IN
        WRITE(6,*)
      ENDIF

C Display help text

C Advance to beginning of text
      IF(IRECL.LT.IREC1)THEN
        DO I=IRECL+1,IREC1
          READ(2,*,ERR=999)
        ENDDO
      ELSE
        REWIND(UNIT=2)
        DO I=1,IREC1
          READ(2,*,ERR=999)
        ENDDO
      ENDIF
      DO I=IREC1+1,IREC2
        READ(2,2000,END=99,ERR=999)MBUFF
 2000   FORMAT(A)
        NCHAR = LENSIG(MBUFF)  ! modified by J.Chuma, 19Mar97 for g77
C        READ(2,2000,END=99,ERR=999)NCHAR,MBUFF
C 2000   FORMAT(Q,A)
C        NCHAR=MIN(NCHAR,80)      !truncate to 80 characters
        IF(NCHAR.GT.0)THEN
          IF(MXHELP)THEN
            CALL MXHELP_TEXT(MBUFF(1:NCHAR)//CHAR(0))
          ELSE
            IF( FORCC )THEN
              WRITE(6,2001)MBUFF(1:NCHAR)
            ELSE
              WRITE(6,2002)MBUFF(1:NCHAR)
            END IF
 2001       FORMAT(1X,A)
 2002       FORMAT(   A)
          ENDIF
        ELSE
          IF(MXHELP)THEN
            CALL MXHELP_TEXT(' '//CHAR(0))
          ELSE
            WRITE(6,*)
          ENDIF
        ENDIF
      ENDDO
      IRECL=IREC2

C End of help text
      IF(ONETOPIC)RETURN
      IF(LEVEL.GE.9)GO TO 10
      MARK(LEVEL)=IREC
CC     WRITE(6,*)'MARKING CURRENT TOPIC AT RECORD',IREC
CC     WRITE(6,*)'SCANNING FOR SUB-TOPICS'
      LEVEL=LEVEL+1
      CTOPIC='?'
      STSCAN=.TRUE.
      GO TO 15

C End of file during search

 98   WRITE(6,*)'Unexpected end of file reading index file'
      WRITE(6,*)'EOF record not found'
      RETURN

 99   WRITE(6,*)'Unexpected end of file reading help file'
      RETURN

 998  WRITE(6,*)'Error reading index file'
      CALL FORMSG
      RETURN

 999  WRITE(6,*)'Error reading help file'
      CALL FORMSG
      RETURN

      END
